/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server;

import br.com.gertec.tc.server.ApplicationSettings;
import br.com.gertec.tc.server.DbMode;
import br.com.gertec.tc.server.dao.AbstractJdbcProductDao;
import br.com.gertec.tc.server.dao.Exhibition;
import br.com.gertec.tc.server.dao.ExhibitionParam;
import br.com.gertec.tc.server.dao.Product;
import br.com.gertec.tc.server.dao.ProductExhibition;
import br.com.gertec.tc.server.dao.TextDbProductDao;
import br.com.gertec.tc.server.gui.MainApplicationWindow;
import br.com.gertec.tc.server.http.TcHttpServer;
import br.com.gertec.tc.server.log.ConsoleLogStream;
import br.com.gertec.tc.server.log.DbLogStream;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.ServerManager;
import br.com.gertec.tc.server.protocol.sc501.listener.Sc501ServerListenerImpl;
import br.com.gertec.tc.server.protocol.sc504.listener.Sc504ServerListenerImpl;
import br.com.gertec.tc.server.util.Environment;
import br.com.gertec.tc.server.util.FileUtilities;
import br.com.gertec.tc.server.util.Resources;
import br.com.gertec.tc.server.util.jdbc.JdbcConnection;
import br.com.gertec.tc.server.util.jdbc.JdbcException;
import br.com.gertec.tc.server.util.version.VersionsWithAudio;
import br.org.reconcavo.event.EventLoop;
import br.org.reconcavo.j18n.J18N;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.DriverManager;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class Application {
    private static final boolean TRY_NATIVE_LAF = false;
    public static final long PRODUCT_DB_CONNECTION_TIMEOUT = 3000L;
    public static final String APP_NAME;
    public static final String VERSION;
    public static final boolean DEBUG_ENABLED;
    public static final File APP_DIR;
    public static final File INTERNAL_PRODUCT_DB_FILE;
    public static final ApplicationSettings SETTINGS;
    public static final String LOG_FOLDER;
    public static final File CWD;
    private static final String TRANSLATION_FOLDER = "/res/languages/";
    private static final String TRANSLATION_PTBR = "pt-br.properties";
    private static final String TRANSLATION_ES = "es.properties";
    private static final String TRANSLATION_EN = "en.properties";
    public static final String NOT_FOUND_PRODUCT_MSG = "Produto n\u00e3o encontrado";
    public static final String LOCALE_ENGLISH = "en";
    public static final String LOCALE_SPANISH = "es";
    public static final String LOCALE_PORTUGUESE = "pt-BR";
    public static final String HELP_DOCUMENT_NAME = "Gertec_Manual_Do_Usuario_v1.9.pdf";
    public static final String HELP_DOCUMENT_PATH = "/res/Gertec_Manual_Do_Usuario_v1.9.pdf";
    public static final EventLoop EVENT_LOOP;
    public static final ServerManager SERVER_MANAGER;
    public static final String LOG_TAG_APP = "APP";
    public static final String LOG_TAG_QUERY = "QUERY";
    public static final String LOG_TAG_DB = "DB";
    public static final VersionsWithAudio versionsWithAudio;
    private static DbLogStream dbLogStream;
    private static MainApplicationWindow mainApplicationWindow;

    public static DbLogStream getDbLogStream() {
        return dbLogStream;
    }

    public static void logQuery(InetAddress client, Product product, String barcode) {
        if (product != null) {
            Log.infoTag(LOG_TAG_QUERY, String.format("%s: %s", client.getHostAddress(), product.getBarcode()), new Object[0]);
        } else {
            Log.warningTag(LOG_TAG_QUERY, J18N.tr("%s: %s (NOT FOUND)", client.getHostAddress(), barcode), new Object[0]);
        }
    }

    public static boolean checkDataMatrix(String barcode) {
        if (barcode.contains("\u001d")) {
            try {
                String[] dataMatrix = barcode.split("\u001d");
                boolean gtin = dataMatrix[0].substring(0, 2).equals("01");
                boolean anvisa = dataMatrix[0].substring(16, 19).equals("713");
                boolean serial = dataMatrix[1].substring(0, 2).equals("21");
                boolean validade = dataMatrix[2].substring(0, 2).equals("17");
                return gtin && anvisa && serial && validade;
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
        }
        return false;
    }

    private static void initListeners() {
        J18N.registerListener(new J18N.LocaleChangeListener(){

            @Override
            public void onLocaleChange(Locale newLocale) {
                SETTINGS.setProperty("LOCALE", newLocale.toLanguageTag());
                Log.info(J18N.tr("Locale changed to %s", newLocale.toLanguageTag()), new Object[0]);
            }
        });
        SERVER_MANAGER.registerHttpServerListener(new TcHttpServer.HttpServerListener.HttpServerAdapter(){

            @Override
            public void onBarcodeQuery(TcHttpServer server, InetAddress client, String barcode, Product product) {
                Application.logQuery(client, product, barcode);
            }

            @Override
            public void onStart(TcHttpServer server) {
                Log.info(J18N.tr("HTTP server is running on port %d", server.getRunningPort()), new Object[0]);
                SETTINGS.setProperty("LAST_PORT_HTTP", server.getRunningPort());
            }

            @Override
            public void onStop(TcHttpServer server) {
                Log.warning(J18N.tr("HTTP server stopped", new Object[0]), new Object[0]);
            }

            @Override
            public void onError(TcHttpServer server, Throwable t) {
                Log.error("HTTP server error: %s", t.getMessage());
            }
        });
        SERVER_MANAGER.register501Listener(new Sc501ServerListenerImpl());
        SERVER_MANAGER.register504Listener(new Sc504ServerListenerImpl());
    }

    private static void initI18n() {
        try {
            J18N.registerLocale(LOCALE_SPANISH, "/res/languages/es.properties");
            J18N.registerLocale(LOCALE_PORTUGUESE, "/res/languages/pt-br.properties");
            J18N.registerLocale(LOCALE_ENGLISH, "/res/languages/en.properties");
            J18N.setCurrentLocale(SETTINGS.getProperty("LOCALE", LOCALE_PORTUGUESE));
        }
        catch (Throwable ex) {
            Log.error(J18N.tr("Error intializing internationalization system. Check console output for details", new Object[0]), new Object[0]);
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private static void initLog() {
        try {
            Log.enableQueue(true);
            Log.setDefaultTag(LOG_TAG_APP);
            Log.setDebugEnabled(DEBUG_ENABLED);
            Log.registerStream(ConsoleLogStream.getInstance());
            dbLogStream = new DbLogStream(new File(APP_DIR, "log"));
            Log.registerStream(dbLogStream);
        }
        catch (Throwable ex) {
            Log.error(J18N.tr("Error intializing internationalization system. Check console output for details", new Object[0]), new Object[0]);
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public static void initExhibitionDao() {
        try {
            File exhibDbFile = new File(APP_DIR, "exhibition");
            String exhibDbUri = String.format("jdbc:h2:%s", exhibDbFile.getCanonicalPath());
            Class.forName("org.h2.Driver");
            JdbcConnection exhibConnection = JdbcConnection.getConnection(exhibDbUri, "", "", 0L);
            ExhibitionParam.setCurrentDao(new ExhibitionParam.H2ExhibitionParamDao(exhibConnection));
            Exhibition.setCurrentDao(new Exhibition.H2ExhibitionDao(exhibConnection));
            ProductExhibition.setCurrentDao(new ProductExhibition.H2ProductExhibitionDao(exhibConnection));
        }
        catch (JdbcException | IOException | ClassNotFoundException ex) {
            Log.error(J18N.tr("Error intializing internationalization system. Check console output for details", new Object[0]), new Object[0]);
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private static void initProductDao() {
        DriverManager.setLoginTimeout(10);
        DbMode dbMode = DbMode.loadFromConfig();
        try {
            Product.AbstractProductDao dao;
            switch (dbMode) {
                default: {
                    dao = new AbstractJdbcProductDao.InternalJdbcProductDao(INTERNAL_PRODUCT_DB_FILE);
                    break;
                }
                case EXTERNAL_JDBC: {
                    File jarFile = new File(SETTINGS.getProperty("DB_PATH_JAR"));
                    String driverClassName = SETTINGS.getProperty("DB_DRIVER");
                    String url = SETTINGS.getProperty("DB_URL");
                    String username = SETTINGS.getEncryptedProperty("DB_USER");
                    String password = SETTINGS.getEncryptedProperty("DB_PASSWORD");
                    JdbcConnection connection = JdbcConnection.getConnection(jarFile, driverClassName, url, username, password, 3000L);
                    Product.ProductTableDefinition tableDef = Product.ProductTableDefinition.loadFromConfig();
                    dao = new AbstractJdbcProductDao.ExternalJdbcProductDao(connection, tableDef);
                    break;
                }
                case EXTERNAL_TXT: {
                    dao = new TextDbProductDao(EVENT_LOOP, new File(SETTINGS.getProperty("PATH_FILE_PRODUCT")), Long.parseLong(SETTINGS.getProperty("TXT_DB_RELOAD_INTERVAL_MIN")) * 60000L){

                        @Override
                        protected void onAutoReload() {
                            super.onAutoReload();
                            Log.infoTag(Application.LOG_TAG_DB, "DB was automatically reloaded", new Object[0]);
                        }
                    };
                }
            }
            Product.setCurrentDao(dao);
        }
        catch (Throwable e) {
            Log.errorTag(LOG_TAG_DB, "Product DAO error (switching to internal DB mode): %s", e.getMessage());
            Log.error(J18N.tr("Error connecting to database. Switching to internal db.\n\nReason: %s", e.getMessage()), new Object[0]);
            try {
                AbstractJdbcProductDao.InternalJdbcProductDao dao = new AbstractJdbcProductDao.InternalJdbcProductDao(INTERNAL_PRODUCT_DB_FILE);
                Product.setCurrentDao(dao);
            }
            catch (Exception exception) {
                Log.error(J18N.tr("Application error. Check console output for details. Application will be terminated.", new Object[0]), new Object[0]);
                exception.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static void initServers() {
        boolean startSc501 = SETTINGS.getBoolean("AUTO_INIT_501");
        boolean startSc504 = SETTINGS.getBoolean("AUTO_INIT_504");
        boolean startHttp = SETTINGS.getBoolean("AUTO_INIT_HTTP");
        int sc501Port = Integer.parseInt(SETTINGS.getProperty("LAST_PORT_501"));
        int sc504Port = Integer.parseInt(SETTINGS.getProperty("LAST_PORT_504"));
        int httpPort = Integer.parseInt(SETTINGS.getProperty("LAST_PORT_HTTP"));
        if (startSc501) {
            SERVER_MANAGER.startSc501Server(sc501Port);
        }
        if (startSc504) {
            SERVER_MANAGER.startSc504Server(sc504Port);
        }
        if (startHttp) {
            SERVER_MANAGER.startHttpServer(httpPort);
        }
    }

    public static MainApplicationWindow getMainWindow() {
        return mainApplicationWindow;
    }

    private static void initGui() {
        if (Environment.isWindows() || Environment.isMac()) {
            // empty if block
        }
        mainApplicationWindow = new MainApplicationWindow();
        mainApplicationWindow.setIconImage(Resources.getImage("/res/app-icon.png"));
        mainApplicationWindow.setLocationRelativeTo(null);
        mainApplicationWindow.setTitle(APP_NAME);
        mainApplicationWindow.setVisible(true);
    }

    private static void init() {
        Application.initI18n();
        Application.initLog();
        Application.initExhibitionDao();
        Application.initProductDao();
        Application.initListeners();
        Application.exportCsvListener();
        Application.initServers();
        Application.initGui();
        Application.deleteAudioFiles();
    }

    public static void main(String[] args) {
        EVENT_LOOP.invokeLater(new Runnable(){

            @Override
            public void run() {
                Application.init();
            }
        });
        EVENT_LOOP.start();
    }

    private static void exportCsvListener() {
        ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor();
        exec.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    if (SETTINGS.getBoolean("EXPORT_CSV_ENABLED")) {
                        String actualTime = Application.getActualTime();
                        String configurationTime = Application.getTimeFromFile();
                        if (configurationTime.equals(actualTime)) {
                            Application.onExportCsv();
                            Thread.sleep(60000L);
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }, 0L, 20L, TimeUnit.SECONDS);
    }

    private static String getActualTime() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat timeOnly = new SimpleDateFormat("HH:mm");
        String horaAtual = timeOnly.format(cal.getTime());
        return horaAtual;
    }

    public static String getTimeFromFile() throws FileNotFoundException {
        Scanner scanner = new Scanner(new File(APP_DIR, "config.properties"));
        String horarioConfig = null;
        while (scanner.hasNextLine()) {
            String nextLine = scanner.nextLine();
            if (!nextLine.contains("EXPORT_CSV_TIME")) continue;
            String tempo = nextLine.substring(16);
            String horas = tempo.substring(0, 2);
            String minutos = tempo.substring(tempo.length() - 3);
            horarioConfig = horas + minutos;
        }
        scanner.close();
        return horarioConfig;
    }

    public static String getDaysFromFile() throws FileNotFoundException {
        Scanner scanner = new Scanner(new File(APP_DIR, "config.properties"));
        String dias = null;
        while (scanner.hasNextLine()) {
            String nextLine = scanner.nextLine();
            if (!nextLine.contains("EXPORT_CSV_ERASE_DAYS")) continue;
            dias = nextLine.substring(22);
        }
        scanner.close();
        return dias;
    }

    public static void onExportCsv() {
        Application.deleteCsv();
        try {
            int i;
            File directory = new File(LOG_FOLDER);
            if (!directory.exists()) {
                directory.mkdir();
            }
            File file = new File(LOG_FOLDER + "/" + Application.getDate(-1) + ".csv");
            FileWriter csv = new FileWriter(file);
            List<DbLogStream.LogEntry> model = dbLogStream.getEntries(Application.getDate(-1));
            String[] columns = new String[]{J18N.tr("Tag", new Object[0]), J18N.tr("Timestamp", new Object[0]), J18N.tr("Level", new Object[0]), J18N.tr("Message", new Object[0])};
            for (i = 0; i < columns.length; ++i) {
                csv.write(columns[i] + ";");
            }
            csv.write("\n");
            for (i = 0; i < model.size(); ++i) {
                csv.append(model.get((int)i).tag + ";");
                csv.append(String.valueOf(model.get((int)i).timestamp) + ";");
                csv.append(model.get((int)i).level.toString() + ";");
                csv.append(model.get((int)i).msg);
                csv.write("\n");
            }
            System.out.println("Arquivo csv gerado");
            csv.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void deleteCsv() {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Calendar cal = Calendar.getInstance();
            Calendar calToCompare = Calendar.getInstance();
            int days = Integer.parseInt(Application.getDaysFromFile());
            calToCompare.add(5, -days);
            File directory = new File(LOG_FOLDER);
            if (directory.isDirectory()) {
                String[] list;
                for (String s : list = directory.list()) {
                    String date = s.split("[.]")[0];
                    cal.setTime(dateFormat.parse(date));
                    if (!cal.before(calToCompare)) continue;
                    Files.deleteIfExists(Paths.get(LOG_FOLDER + "/" + s, new String[0]));
                }
            }
        }
        catch (IOException | NumberFormatException | ParseException e) {
            e.printStackTrace();
        }
    }

    private static void deleteAudioFiles() {
        try {
            FileUtilities tempFile = new FileUtilities();
            File tempAudioDir = tempFile.getTemporaryAudio();
            if (tempAudioDir.isDirectory()) {
                String[] list;
                for (String s : list = tempAudioDir.list()) {
                    Files.deleteIfExists(Paths.get(tempAudioDir + "/" + s, new String[0]));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getDate(int day) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        Calendar calReturn = Calendar.getInstance();
        String date = dateFormat.format(cal.getTime());
        calReturn.add(5, day);
        date = dateFormat.format(calReturn.getTime());
        return date;
    }

    static {
        RuntimeException ex;
        LOG_FOLDER = System.getProperty("user.home") + "/.tc-server/relatorios";
        CWD = new File(System.getProperty("user.dir"));
        Properties appProperties = new Properties();
        try (InputStream is = Application.class.getResourceAsStream("/app/app.properties");){
            appProperties.load(is);
        }
        catch (IOException ex2) {
            throw new RuntimeException(ex2);
        }
        APP_NAME = appProperties.getProperty("app.name");
        VERSION = appProperties.getProperty("app.version");
        DEBUG_ENABLED = Boolean.parseBoolean(appProperties.getProperty("app.debugEnabled"));
        File appDir = new File(System.getProperty("user.home"), ".tc-server");
        if (appDir.exists() && appDir.isFile()) {
            ex = new RuntimeException("Cannot access application directory: " + appDir.getAbsolutePath());
            ex.printStackTrace();
            System.exit(1);
        }
        if (!appDir.exists()) {
            if (!appDir.mkdirs()) {
                ex = new RuntimeException("Cannot create application directory: " + appDir.getAbsolutePath());
                ex.printStackTrace();
                System.exit(1);
            } else if (Environment.isWindows()) {
                try {
                    Runtime.getRuntime().exec(String.format("attrib +H %s", appDir.getAbsolutePath()));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        APP_DIR = appDir;
        INTERNAL_PRODUCT_DB_FILE = new File(APP_DIR, "products");
        SETTINGS = ApplicationSettings.getInstance();
        EVENT_LOOP = new EventLoop(){

            @Override
            protected void processRunnable(Runnable runnable) {
                SwingUtilities.invokeLater(runnable);
            }

            @Override
            protected boolean onUncaughtError(Throwable ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(null, String.format("Uncaught application error.\nCheck console output for details.\n\nERROR: %s", ex.getMessage()), APP_NAME, 0);
                System.exit(1);
                return false;
            }
        };
        SERVER_MANAGER = new ServerManager(EVENT_LOOP);
        versionsWithAudio = new VersionsWithAudio();
        dbLogStream = null;
        mainApplicationWindow = null;
    }
}

