/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.DbMode;
import br.com.gertec.tc.server.bean.TerminalGroup;
import br.com.gertec.tc.server.customer.audio.online.util.Paths;
import br.com.gertec.tc.server.dao.Exhibition;
import br.com.gertec.tc.server.dao.ExhibitionParam;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.GenericTc;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.tts.GenerateAudioImpl;
import br.com.gertec.tc.server.util.CryptoUtil;
import br.com.gertec.tc.server.util.NamedColor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ApplicationSettings {
    private static final String GROUP_PREFIX = "Group";
    private static final String MAC_DELIMITER = "#@#";
    private static final String VALUE_BOOL_TRUE = "1";
    private static final String VALUE_BOOL_FALSE = "0";
    public static final File CONFIG_FILE;
    public static final int TIME_QUERY_STANDARD_G2 = 5;
    public static final int TIME_QUERY_STANDARD_TC_506_S = 5;
    public static final int TIME_QUERY_STANDARD_TC_506_E = 5;
    public static final int TIME_QUERY_STANDARD_G2_E = 5;
    public static final String KEY_PASSWORD = "PASSWORD";
    public static final String KEY_LOCALE = "LOCALE";
    public static final String KEY_MINIMIZE_TO_TRAY = "MINIMIZE_TO_TRAY";
    public static final String KEY_LOCK_ON_MINIMIZE = "LOCK_ON_MINIMIZE";
    public static final String DEFAULT_PASSWORD = "gertec";
    public static final String DEFAULT_LOCALE = "pt-BR";
    public static final String DEFAULT_MINIMIZE_TO_TRAY = "1";
    public static final String DEFAULT_LOCK_ON_MINIMIZE = "0";
    public static final String KEY_AUTO_INIT_501 = "AUTO_INIT_501";
    public static final String KEY_AUTO_INIT_504 = "AUTO_INIT_504";
    public static final String KEY_AUTO_INIT_HTTP = "AUTO_INIT_HTTP";
    public static final String DEFAULT_AUTO_INIT_501 = "1";
    public static final String DEFAULT_AUTO_INIT_504 = "1";
    public static final String DEFAULT_AUTO_INIT_HTTP = "1";
    public static final String KEY_LAST_PORT_501 = "LAST_PORT_501";
    public static final String KEY_LAST_PORT_504 = "LAST_PORT_504";
    public static final String KEY_LAST_PORT_HTTP = "LAST_PORT_HTTP";
    public static final String DEFAULT_LAST_PORT_501 = "6500";
    public static final String DEFAULT_LAST_PORT_504 = "16510";
    public static final String DEFAULT_LAST_PORT_HTTP = "8080";
    public static final String KEY_DB_MODE = "DB_MODE";
    public static final DbMode DEFAULT_DB_MODE;
    public static final String KEY_PATH_PRODUCT_TXT_DB = "PATH_FILE_PRODUCT";
    public static final String KEY_TXT_DB_RELOAD_INTERVAL_MIN = "TXT_DB_RELOAD_INTERVAL_MIN";
    public static final String DEFAULT_TXT_DB_RELOAD_INTERVAL_MIN = "10";
    public static final String KEY_DB_PATH_JAR = "DB_PATH_JAR";
    public static final String KEY_DB_DRIVER = "DB_DRIVER";
    public static final String KEY_DB_URL = "DB_URL";
    public static final String KEY_DB_USER = "DB_USER";
    public static final String KEY_DB_PASSWORD = "DB_PASSWORD";
    public static final String KEY_DB_PRODUCT_TABLE_NAME = "DB_PRODUCT_TABLE_NAME";
    public static final String KEY_DB_COL_BARCODE = "DB_COL_BARCODE";
    public static final String KEY_DB_COL_DESCRIPITION = "DB_COL_DESCRIPITION";
    public static final String KEY_DB_COL_PRICE1 = "DB_COL_PRICE1";
    public static final String KEY_DB_COL_PRICE2 = "DB_COL_PRICE2";
    public static final String DEFAULT_DB_PRODUCT_TABLE_NAME = "PRODUCTS";
    public static final String DEFAULT_DB_COL_BARCODE = "BARCODE";
    public static final String DEFAULT_DB_COL_DESCRIPTION = "DESCRIPTION";
    public static final String DEFAULT_DB_COL_PRICE1 = "PRICE_1";
    public static final String DEFAULT_DB_COL_PRICE2 = "PRICE_2";
    public static final String KEY_EXPORT_CSV_ENABLED = "EXPORT_CSV_ENABLED";
    public static final String KEY_EXPORT_CSV_TIME = "EXPORT_CSV_TIME";
    public static final String KEY_EXPORT_CSV_ERASE_DAYS = "EXPORT_CSV_ERASE_DAYS";
    public static final String DEFAULT_EXPORT_CSV_ENABLED = "0";
    public static final String DEFAULT_EXPORT_CSV_TIME = "00:05";
    public static final String DEFAULT_EXPORT_CSV_ERASE_DAYS = "60";
    public static final String KEY_DEFAULT_EXHIB_TC504 = "DEFAULT_EXHIB_TC504";
    public static final String KEY_DEFAULT_EXHIB_TC506M = "DEFAULT_EXHIB_TC506M";
    public static final String KEY_DEFAULT_EXHIB_TC508 = "DEFAULT_EXHIB_TC508";
    public static final String KEY_DEFAULT_EXHIB_TC406 = "DEFAULT_EXHIB_TC406";
    public static final String KEY_DEFAULT_EXHIB_TC505 = "DEFAULT_EXHIB_TC505";
    public static final String KEY_DEFAULT_EXHIB_TC507 = "DEFAULT_EXHIB_TC507";
    public static final String KEY_DEFAULT_EXHIB_GB600 = "DEFAULT_EXHIB_GB600";
    public static final String KEY_DEFAULT_EXHIB_GB601 = "DEFAULT_EXHIB_GB601";
    public static final String KEY_DEFAULT_EXHIB_TC506S = "DEFAULT_EXHIB_TC506S";
    public static final String KEY_DEFAULT_EXHIB_TC506E = "DEFAULT_EXHIB_TC506E";
    public static final String KEY_DEFAULT_EXHIB_TC406E = "DEFAULT_EXHIB_TC406E";
    public static final String KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC504 = "DEFAULT_EXHIB_PARAM_NOT_FOUND_TC504";
    public static final String KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506M = "DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506M";
    public static final String KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC508 = "DEFAULT_EXHIB_PARAM_NOT_FOUND_TC508";
    public static final String KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC406 = "DEFAULT_EXHIB_PARAM_NOT_FOUND_TC406";
    public static final String KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_GB600 = "DEFAULT_EXHIB_PARAM_NOT_FOUND_GB600";
    public static final String KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_GB601 = "DEFAULT_EXHIB_PARAM_NOT_FOUND_GB601";
    public static final String KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC505 = "DEFAULT_EXHIB_PARAM_NOT_FOUND_TC505";
    public static final String KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC507 = "DEFAULT_EXHIB_PARAM_NOT_FOUND_TC507";
    public static final String KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506S = "DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506S";
    public static final String KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506E = "DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506E";
    public static final String KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC406E = "DEFAULT_EXHIB_PARAM_NOT_FOUND_TC406E";
    public static final String KEY_DEFAULT_EXHIB_PARAM_DATAMATRIX_TC506M = "DEFAULT_EXHIB_PARAM_DATAMATRIX_TC506M";
    public static final Exhibition DEFAULT_EXHIBITION_DATAMATRIX_TC506M;
    public static final Exhibition DEFAULT_EXHIBITION_TC504;
    public static final Exhibition DEFAULT_EXHIBITION_TC506M;
    public static final Exhibition DEFAULT_EXHIBITION_TC508;
    public static final Exhibition DEFAULT_EXHIBITION_TC406;
    public static final Exhibition DEFAULT_EXHIBITION_TC505;
    public static final Exhibition DEFAULT_EXHIBITION_TC507;
    public static final Exhibition DEFAULT_EXHIBITION_GB600;
    public static final Exhibition DEFAULT_EXHIBITION_GB601;
    public static final Exhibition DEFAULT_EXHIBITION_TC506S;
    public static final Exhibition DEFAULT_EXHIBITION_TC506E;
    public static final Exhibition DEFAULT_EXHIBITION_TC406E;
    public static final ExhibitionParam DEFAULT_EXHIB_PARAM_NOT_FOUND_TC504;
    public static final ExhibitionParam DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506M;
    public static final ExhibitionParam DEFAULT_EXHIB_PARAM_NOT_FOUND_TC508;
    public static final ExhibitionParam DEFAULT_EXHIB_PARAM_NOT_FOUND_TC406;
    public static final ExhibitionParam DEFAULT_EXHIB_PARAM_NOT_FOUND_TC505;
    public static final ExhibitionParam DEFAULT_EXHIB_PARAM_NOT_FOUND_TC507;
    public static final ExhibitionParam DEFAULT_EXHIB_PARAM_NOT_FOUND_GB600;
    public static final ExhibitionParam DEFAULT_EXHIB_PARAM_NOT_FOUND_GB601;
    public static final ExhibitionParam DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506S;
    public static final ExhibitionParam DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506E;
    public static final ExhibitionParam DEFAULT_EXHIB_PARAM_NOT_FOUND_TC406E;
    public static final String KEY_LABEL1 = "LABEL1";
    public static final String KEY_LABEL2 = "LABEL2";
    public static final String KEY_LABEL_NOT_FOUND = "LABEL_NOT_FOUND";
    public static final String KEY_CURRENCY = "CURRENCY";
    public static final String DEFAULT_LABEL1 = "Price";
    public static final String DEFAULT_NULL_LABEL1 = "";
    public static final String DEFAULT_LABEL2 = "Custom price";
    public static final String DEFAULT_LABEL_NOT_FOUND = "Not found";
    public static final String DEFAULT_CURRENCY = "";
    public static final String KEY_SHOW_TERMINAL_TYPE = "SHOW_TERMINAL_TYPE";
    public static final String KEY_SHOW_TERMINAL_NAME = "SHOW_TERMINAL_NAME";
    public static final String DEFAULT_SHOW_TERMINAL_TYPE = "1";
    public static final String DEFAULT_SHOW_TERMINAL_NAME = "1";
    private static final boolean AUTO_SAVE = true;
    private static ApplicationSettings singleton;
    private final Properties properties = new Properties();

    private static Exhibition getDefaultValueExhibition(TerminalType terminalType) {
        switch (terminalType) {
            case TC_504: {
                return DEFAULT_EXHIBITION_TC504;
            }
            case TC_506_MIDIA: {
                return DEFAULT_EXHIBITION_TC506M;
            }
            case TC_508: {
                return DEFAULT_EXHIBITION_TC508;
            }
            case TC_406: {
                return DEFAULT_EXHIBITION_TC406;
            }
            case TC_505: {
                return DEFAULT_EXHIBITION_TC505;
            }
            case TC_507: {
                return DEFAULT_EXHIBITION_TC507;
            }
            case GB_600: {
                return DEFAULT_EXHIBITION_GB600;
            }
            case GB_601: {
                return DEFAULT_EXHIBITION_GB601;
            }
            case TC_506_S: {
                return DEFAULT_EXHIBITION_TC506S;
            }
            case TC_506_E: {
                return DEFAULT_EXHIBITION_TC506E;
            }
            case TC_406_E: {
                return DEFAULT_EXHIBITION_TC406E;
            }
        }
        return null;
    }

    private static Exhibition getDefaultDataMatrixValue() {
        return DEFAULT_EXHIBITION_DATAMATRIX_TC506M;
    }

    private static ExhibitionParam getNotFoundValueExhibitionParam(TerminalType terminalType) {
        switch (terminalType) {
            case TC_504: {
                return DEFAULT_EXHIB_PARAM_NOT_FOUND_TC504;
            }
            case TC_506_MIDIA: {
                return DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506M;
            }
            case TC_508: {
                return DEFAULT_EXHIB_PARAM_NOT_FOUND_TC508;
            }
            case TC_406: {
                return DEFAULT_EXHIB_PARAM_NOT_FOUND_TC406;
            }
            case TC_505: {
                return DEFAULT_EXHIB_PARAM_NOT_FOUND_TC505;
            }
            case TC_507: {
                return DEFAULT_EXHIB_PARAM_NOT_FOUND_TC507;
            }
            case GB_600: {
                return DEFAULT_EXHIB_PARAM_NOT_FOUND_GB600;
            }
            case GB_601: {
                return DEFAULT_EXHIB_PARAM_NOT_FOUND_GB601;
            }
            case TC_506_S: {
                return DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506S;
            }
            case TC_506_E: {
                return DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506E;
            }
            case TC_406_E: {
                return DEFAULT_EXHIB_PARAM_NOT_FOUND_TC406E;
            }
        }
        return null;
    }

    private static void setProperty(Properties properties, String key, String value, boolean replaceExisting) {
        if (replaceExisting || !properties.containsKey(key)) {
            properties.setProperty(key, value);
        }
    }

    private static String encrypt(char[] value) {
        return CryptoUtil.encrypt(value);
    }

    private static String encrypt(String value) {
        return CryptoUtil.encrypt(value);
    }

    private static String decrypt(String value) {
        return CryptoUtil.decrypt(value);
    }

    public static ApplicationSettings getInstance() {
        if (singleton == null) {
            singleton = new ApplicationSettings();
        }
        return singleton;
    }

    private ApplicationSettings() {
        this.load(true);
    }

    private void load(boolean skipAutoSaveCheck) {
        block18: {
            if (!skipAutoSaveCheck) {
                throw new IllegalStateException("AUTO_SAVE is enabled");
            }
            this.properties.clear();
            File configFile = CONFIG_FILE;
            if (configFile.exists()) {
                try {
                    Log.debug("Loading application settings %s", configFile.getCanonicalPath());
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                try (FileInputStream fis = new FileInputStream(CONFIG_FILE);){
                    this.properties.load(fis);
                    this.putDefaults(false);
                    break block18;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.putDefaults(true);
        }
    }

    private void putDefaults(boolean save) {
        this.setProperty(KEY_PASSWORD, ApplicationSettings.encrypt(DEFAULT_PASSWORD), false, save);
        this.setProperty(KEY_LOCALE, DEFAULT_LOCALE, false, save);
        this.setProperty(KEY_MINIMIZE_TO_TRAY, "1", false, save);
        this.setProperty(KEY_LOCK_ON_MINIMIZE, "0", false, save);
        this.setProperty(KEY_AUTO_INIT_501, "1", false, save);
        this.setProperty(KEY_AUTO_INIT_504, "1", false, save);
        this.setProperty(KEY_AUTO_INIT_HTTP, "1", false, save);
        this.setProperty(KEY_LAST_PORT_501, DEFAULT_LAST_PORT_501, false, save);
        this.setProperty(KEY_LAST_PORT_504, DEFAULT_LAST_PORT_504, false, save);
        this.setProperty(KEY_LAST_PORT_HTTP, DEFAULT_LAST_PORT_HTTP, false, save);
        this.setProperty(KEY_DB_MODE, DEFAULT_DB_MODE.getConfigValue(), false, save);
        this.setProperty(KEY_TXT_DB_RELOAD_INTERVAL_MIN, DEFAULT_TXT_DB_RELOAD_INTERVAL_MIN, false, save);
        this.setProperty(KEY_DB_PRODUCT_TABLE_NAME, DEFAULT_DB_PRODUCT_TABLE_NAME, false, save);
        this.setProperty(KEY_DB_COL_BARCODE, DEFAULT_DB_COL_BARCODE, false, save);
        this.setProperty(KEY_DB_COL_DESCRIPITION, DEFAULT_DB_COL_DESCRIPTION, false, save);
        this.setProperty(KEY_DB_COL_PRICE1, DEFAULT_DB_COL_PRICE1, false, save);
        this.setProperty(KEY_DB_COL_PRICE2, DEFAULT_DB_COL_PRICE2, false, save);
        this.setProperty(KEY_DEFAULT_EXHIB_TC504, DEFAULT_EXHIBITION_TC504.getPropertyString(), false, save);
        this.setProperty(KEY_DEFAULT_EXHIB_TC506M, DEFAULT_EXHIBITION_TC506M.getPropertyString(), false, save);
        this.setProperty(KEY_DEFAULT_EXHIB_TC406, DEFAULT_EXHIBITION_TC406.getPropertyString(), false, save);
        this.setProperty(KEY_DEFAULT_EXHIB_TC505, DEFAULT_EXHIBITION_TC505.getPropertyString(), false, save);
        this.setProperty(KEY_DEFAULT_EXHIB_TC507, DEFAULT_EXHIBITION_TC507.getPropertyString(), false, save);
        this.setProperty(KEY_DEFAULT_EXHIB_TC508, DEFAULT_EXHIBITION_TC508.getPropertyString(), false, save);
        this.setProperty(KEY_DEFAULT_EXHIB_GB600, DEFAULT_EXHIBITION_GB600.getPropertyString(), false, save);
        this.setProperty(KEY_DEFAULT_EXHIB_GB601, DEFAULT_EXHIBITION_GB601.getPropertyString(), false, save);
        this.setProperty(KEY_DEFAULT_EXHIB_TC506S, DEFAULT_EXHIBITION_TC506S.getPropertyString(), false, save);
        this.setProperty(KEY_DEFAULT_EXHIB_TC506E, DEFAULT_EXHIBITION_TC506E.getPropertyString(), false, save);
        this.setProperty(KEY_DEFAULT_EXHIB_TC406E, DEFAULT_EXHIBITION_TC406E.getPropertyString(), false, save);
        this.setProperty(KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC504, DEFAULT_EXHIB_PARAM_NOT_FOUND_TC504.getPropertyString(), false, save);
        this.setProperty(KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506M, DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506M.getPropertyString(), false, save);
        this.setProperty(KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC406, DEFAULT_EXHIB_PARAM_NOT_FOUND_TC406.getPropertyString(), false, save);
        this.setProperty(KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC505, DEFAULT_EXHIB_PARAM_NOT_FOUND_TC505.getPropertyString(), false, save);
        this.setProperty(KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC507, DEFAULT_EXHIB_PARAM_NOT_FOUND_TC507.getPropertyString(), false, save);
        this.setProperty(KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC508, DEFAULT_EXHIB_PARAM_NOT_FOUND_TC508.getPropertyString(), false, save);
        this.setProperty(KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_GB600, DEFAULT_EXHIB_PARAM_NOT_FOUND_GB600.getPropertyString(), false, save);
        this.setProperty(KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_GB601, DEFAULT_EXHIB_PARAM_NOT_FOUND_GB601.getPropertyString(), false, save);
        this.setProperty(KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506S, DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506S.getPropertyString(), false, save);
        this.setProperty(KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506E, DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506E.getPropertyString(), false, save);
        this.setProperty(KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC406E, DEFAULT_EXHIB_PARAM_NOT_FOUND_TC406E.getPropertyString(), false, save);
        this.setProperty(KEY_LABEL1, DEFAULT_LABEL1, false, save);
        this.setProperty(KEY_LABEL2, DEFAULT_LABEL2, false, save);
        this.setProperty(KEY_LABEL_NOT_FOUND, DEFAULT_LABEL_NOT_FOUND, false, save);
        this.setProperty(KEY_CURRENCY, "", false, save);
        this.setProperty(KEY_SHOW_TERMINAL_NAME, "1", false, save);
        this.setProperty(KEY_SHOW_TERMINAL_TYPE, "1", false, save);
        this.setProperty(KEY_SHOW_TERMINAL_TYPE, "1", false, save);
        this.setProperty(KEY_EXPORT_CSV_ENABLED, "0", false, save);
        this.setProperty(KEY_EXPORT_CSV_TIME, DEFAULT_EXPORT_CSV_TIME, false, save);
        this.setProperty(KEY_EXPORT_CSV_ERASE_DAYS, DEFAULT_EXPORT_CSV_ERASE_DAYS, false, save);
    }

    private void setProperty(String key, String value, boolean replaceExisting, boolean save) {
        ApplicationSettings.setProperty(this.properties, key, value, replaceExisting);
        if (save) {
            this.save(true);
        }
    }

    private void save(boolean skipAutoSaveCheck) {
        if (!skipAutoSaveCheck) {
            throw new IllegalStateException("AUTO_SAVE is enabled");
        }
        try (FileOutputStream fos = new FileOutputStream(CONFIG_FILE);){
            this.properties.store(fos, null);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void load() {
        this.load(false);
    }

    public void save() {
        this.save(false);
    }

    public void setProperty(String key, String value) {
        this.setProperty(key, value, true, true);
    }

    public void setProperty(String key, int value) {
        this.setProperty(key, "" + value);
    }

    public void setProperty(String key, boolean value) {
        this.setProperty(key, value ? "1" : "0");
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value;
        switch (value = this.getProperty(key, defaultValue ? "1" : "0")) {
            case "1": {
                return true;
            }
            case "0": {
                return false;
            }
        }
        throw new RuntimeException(String.format("Invalid boolean property: %s => %s", key, value));
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public Integer getInt(String key, Integer defaultValue) {
        String strVal = this.getProperty(key);
        if (strVal == null) {
            return defaultValue;
        }
        return Integer.parseInt(strVal);
    }

    private Exhibition getDefaultValueExhibition(String key, Exhibition defaultValue) {
        String property = this.getProperty(key, null);
        if (property == null) {
            return defaultValue;
        }
        return new Exhibition(property);
    }

    public Exhibition getDefaultExhibition(TerminalType terminalType) {
        Exhibition defaultValue = ApplicationSettings.getDefaultValueExhibition(terminalType);
        switch (terminalType) {
            case TC_504: {
                return this.getDefaultValueExhibition(KEY_DEFAULT_EXHIB_TC504, defaultValue);
            }
            case TC_506_MIDIA: {
                return this.getDefaultValueExhibition(KEY_DEFAULT_EXHIB_TC506M, defaultValue);
            }
            case TC_508: {
                return this.getDefaultValueExhibition(KEY_DEFAULT_EXHIB_TC508, defaultValue);
            }
            case TC_406: {
                return this.getDefaultValueExhibition(KEY_DEFAULT_EXHIB_TC406, defaultValue);
            }
            case TC_505: {
                return this.getDefaultValueExhibition(KEY_DEFAULT_EXHIB_TC505, defaultValue);
            }
            case TC_507: {
                return this.getDefaultValueExhibition(KEY_DEFAULT_EXHIB_TC507, defaultValue);
            }
            case GB_600: {
                return this.getDefaultValueExhibition(KEY_DEFAULT_EXHIB_GB600, defaultValue);
            }
            case GB_601: {
                return this.getDefaultValueExhibition(KEY_DEFAULT_EXHIB_GB601, defaultValue);
            }
            case TC_506_S: {
                return this.getDefaultValueExhibition(KEY_DEFAULT_EXHIB_TC506S, defaultValue);
            }
            case TC_506_E: {
                return this.getDefaultValueExhibition(KEY_DEFAULT_EXHIB_TC506E, defaultValue);
            }
            case TC_406_E: {
                return this.getDefaultValueExhibition(KEY_DEFAULT_EXHIB_TC406E, defaultValue);
            }
        }
        return null;
    }

    public Exhibition getDataMatrixExhibition() {
        Exhibition defaultValue = ApplicationSettings.getDefaultDataMatrixValue();
        return this.getDefaultValueExhibition(KEY_DEFAULT_EXHIB_PARAM_DATAMATRIX_TC506M, defaultValue);
    }

    private ExhibitionParam getNotFoundValueExhibitionParam(String key, ExhibitionParam defaultValue) {
        String property = this.getProperty(key, null);
        if (property == null) {
            return defaultValue;
        }
        return new ExhibitionParam(property);
    }

    public ExhibitionParam getNotFoundExhibitionParam(TerminalType terminalType) {
        ExhibitionParam defaultValue = ApplicationSettings.getNotFoundValueExhibitionParam(terminalType);
        switch (terminalType) {
            case TC_504: {
                return this.getNotFoundValueExhibitionParam(KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC504, defaultValue);
            }
            case TC_506_MIDIA: {
                return this.getNotFoundValueExhibitionParam(KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506M, defaultValue);
            }
            case TC_508: {
                return this.getNotFoundValueExhibitionParam(KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC508, defaultValue);
            }
            case TC_406: {
                return this.getNotFoundValueExhibitionParam(KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC406, defaultValue);
            }
            case TC_505: {
                return this.getNotFoundValueExhibitionParam(KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC505, defaultValue);
            }
            case TC_507: {
                return this.getNotFoundValueExhibitionParam(KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC507, defaultValue);
            }
            case GB_600: {
                return this.getNotFoundValueExhibitionParam(KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_GB600, defaultValue);
            }
            case GB_601: {
                return this.getNotFoundValueExhibitionParam(KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_GB601, defaultValue);
            }
            case TC_506_S: {
                return this.getNotFoundValueExhibitionParam(KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506S, defaultValue);
            }
            case TC_506_E: {
                return this.getNotFoundValueExhibitionParam(KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506E, defaultValue);
            }
            case TC_406_E: {
                return this.getNotFoundValueExhibitionParam(KEY_DEFAULT_EXHIB_PARAM_NOT_FOUND_TC406E, defaultValue);
            }
        }
        return null;
    }

    public void setEncryptedProperty(String key, char[] value) {
        this.setProperty(key, ApplicationSettings.encrypt(value));
    }

    public void setEncryptedProperty(String key, String value) {
        this.setProperty(key, CryptoUtil.encrypt(value));
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String getEncryptedProperty(String key, String defaultValue) {
        String property = this.getProperty(key, null);
        if (property == null) {
            return defaultValue;
        }
        return ApplicationSettings.decrypt(property);
    }

    public final String getEncryptedProperty(String key) {
        return this.getEncryptedProperty(key, null);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
        this.save(true);
    }

    public void removeTerminalGroup(String groupName) {
        this.removeProperty(GROUP_PREFIX + groupName);
    }

    public TerminalGroup getTerminalGroup(String groupName) {
        String[] macList;
        String key = GROUP_PREFIX + groupName;
        String value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        TerminalGroup group = new TerminalGroup();
        group.setName(groupName);
        for (String mac : macList = value.split(MAC_DELIMITER)) {
            if (mac.isEmpty()) continue;
            GenericTc tc = new GenericTc();
            tc.setMacAddress(mac);
            group.addTerminal(tc);
        }
        return group;
    }

    public List<TerminalGroup> getTerminalGroups() {
        LinkedList<TerminalGroup> groupList = new LinkedList<TerminalGroup>();
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(GROUP_PREFIX)) continue;
            String groupName = key.replace(GROUP_PREFIX, "");
            groupList.add(this.getTerminalGroup(groupName));
        }
        return groupList;
    }

    public void addTerminalGroup(TerminalGroup group) {
        StringBuilder valueBuilder = new StringBuilder();
        int i = 0;
        for (GenericTc tc : group.getTerminals()) {
            if (i > 0) {
                valueBuilder.append(MAC_DELIMITER);
            }
            valueBuilder.append(tc.getMacAddress());
            ++i;
        }
        this.setProperty(GROUP_PREFIX + group.getName(), valueBuilder.toString());
    }

    public boolean verifyHasGroup(String mac) {
        List<TerminalGroup> groupList = this.getTerminalGroups();
        for (TerminalGroup terminalGroup : groupList) {
            for (GenericTc terminal : terminalGroup.getTerminals()) {
                if (!terminal.getMacAddress().equalsIgnoreCase(mac)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFromGroup(String nameGroup, String mac) {
        List<TerminalGroup> groupList = this.getTerminalGroups();
        for (TerminalGroup terminalGroup : groupList) {
            if (!terminalGroup.getName().equalsIgnoreCase(nameGroup)) continue;
            for (GenericTc terminal : terminalGroup.getTerminals()) {
                if (!terminal.getMacAddress().equalsIgnoreCase(mac)) continue;
                return true;
            }
        }
        return false;
    }

    public static void generateVersionFile() {
        if (!new File(Application.APP_DIR, "version.txt").exists()) {
            try {
                BufferedWriter fr = new BufferedWriter(new FileWriter(new File(Application.APP_DIR, "version.txt")));
                Application.initExhibitionDao();
                Exhibition.H2ExhibitionDao ex = Exhibition.getCurrentDao();
                fr.write(Application.VERSION);
                ex.alterTableToCascade();
                fr.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        File configFile = new File(Application.APP_DIR, "config.properties");
        if (configFile.exists() && !configFile.isFile()) {
            RuntimeException ex = new RuntimeException(String.format("Cannot access config file: %s", configFile.getAbsolutePath()));
            ex.printStackTrace();
            System.exit(1);
        }
        CONFIG_FILE = configFile;
        try {
            int length4;
            int length;
            ApplicationSettings.generateVersionFile();
            InputStream inStream = Class.class.getResourceAsStream("/Gertec_Manual_Do_Usuario_v1.9.pdf");
            File manualFileNew = new File(Application.APP_DIR.getAbsolutePath() + File.separator + "Gertec_Manual_Do_Usuario_v1.9.pdf");
            FileOutputStream outStream = new FileOutputStream(manualFileNew);
            byte[] buffer = new byte[1024];
            while ((length = inStream.read(buffer)) > 0) {
                outStream.write(buffer, 0, length);
            }
            inStream.close();
            outStream.close();
            GenerateAudioImpl.init();
            InputStream inStream4 = Class.class.getResourceAsStream("/ffmpeg.exe");
            File ffmpeg = new File(Paths.LOCAL_FFMPEG);
            FileOutputStream outStream4 = new FileOutputStream(ffmpeg);
            byte[] buffer4 = new byte[1024];
            while ((length4 = inStream4.read(buffer4)) > 0) {
                outStream4.write(buffer4, 0, length4);
            }
            inStream4.close();
            outStream4.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DEFAULT_DB_MODE = DbMode.INTERNAL;
        DEFAULT_EXHIBITION_TC504 = new Exhibition(NamedColor.NAVY, Exhibition.MediaType.NONE, "", new ExhibitionParam(25, 60, "DejaVu Sans", 25, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(25, 25, "DejaVu Sans", 16, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(25, 170, "DejaVu Sans Bold", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(170, 170, "DejaVu Sans Bold", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(25, 115, "DejaVu Sans", 18, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(170, 115, "DejaVu Sans", 18, NamedColor.GREY, NamedColor.TRANSPARENT));
        DEFAULT_EXHIBITION_TC506M = new Exhibition(NamedColor.NAVY, Exhibition.MediaType.NONE, "", new ExhibitionParam(30, 40, "DejaVuSans.ttf", 25, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 75, "DejaVuSans.ttf", 16, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 170, "DejaVuSans-Bold.ttf", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(250, 170, "DejaVuSans-Bold.ttf", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 145, "DejaVuSans.ttf", 18, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(245, 145, "DejaVuSans.ttf", 18, NamedColor.GREY, NamedColor.TRANSPARENT));
        DEFAULT_EXHIBITION_TC406 = new Exhibition(NamedColor.NAVY, Exhibition.MediaType.NONE, "", new ExhibitionParam(30, 40, "DejaVuSans.ttf", 25, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 75, "", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 115, "", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(180, 115, "", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 80, "", 18, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(180, 80, "", 18, NamedColor.GREY, NamedColor.TRANSPARENT));
        DEFAULT_EXHIBITION_TC505 = new Exhibition(NamedColor.NAVY, Exhibition.MediaType.NONE, "", new ExhibitionParam(30, 40, "DejaVuSans.ttf", 25, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 75, "", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 75, "", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 110, "", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(1, 1, "", 1, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(2, 2, "", 2, NamedColor.GREY, NamedColor.TRANSPARENT));
        DEFAULT_EXHIBITION_TC507 = new Exhibition(NamedColor.NAVY, Exhibition.MediaType.NONE, "", new ExhibitionParam(30, 40, "DejaVuSans.ttf", 25, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 75, "", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 75, "", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 110, "", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(1, 1, "", 1, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(2, 2, "", 2, NamedColor.GREY, NamedColor.TRANSPARENT));
        DEFAULT_EXHIBITION_GB600 = new Exhibition(NamedColor.NAVY, Exhibition.MediaType.SERVER_IMAGE, "", new ExhibitionParam(30, 40, "DejaVuSans.ttf", 25, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 75, "DejaVuSans.ttf", 16, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 205, "DejaVuSans-Bold.ttf", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(250, 205, "DejaVuSans-Bold.ttf", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 145, "DejaVuSans.ttf", 18, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(250, 145, "DejaVuSans.ttf", 18, NamedColor.GREY, NamedColor.TRANSPARENT));
        DEFAULT_EXHIBITION_GB601 = new Exhibition(NamedColor.NAVY, Exhibition.MediaType.TERMINAL_IMAGE, "", new ExhibitionParam(30, 40, "DejaVuSans.ttf", 25, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 75, "DejaVuSans.ttf", 16, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 205, "DejaVuSans-Bold.ttf", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(250, 205, "DejaVuSans-Bold.ttf", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 145, "DejaVuSans.ttf", 18, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(250, 145, "DejaVuSans.ttf", 18, NamedColor.GREY, NamedColor.TRANSPARENT));
        DEFAULT_EXHIBITION_TC506S = new Exhibition(NamedColor.NAVY, Exhibition.MediaType.NONE, "", new ExhibitionParam(30, 40, "DejaVuSans.ttf", 25, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 75, "", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 115, "", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(180, 115, "", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 80, "", 18, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(180, 80, "", 18, NamedColor.GREY, NamedColor.TRANSPARENT));
        DEFAULT_EXHIBITION_TC506E = new Exhibition(NamedColor.NAVY, Exhibition.MediaType.NONE, "", new ExhibitionParam(30, 40, "DejaVuSans.ttf", 25, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 75, "", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 115, "", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(180, 115, "", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 80, "", 18, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(180, 80, "", 18, NamedColor.GREY, NamedColor.TRANSPARENT));
        DEFAULT_EXHIBITION_TC406E = new Exhibition(NamedColor.NAVY, Exhibition.MediaType.NONE, "", new ExhibitionParam(30, 40, "DejaVuSans.ttf", 25, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 75, "", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 115, "", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(180, 115, "", 30, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(30, 80, "", 18, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(180, 80, "", 18, NamedColor.GREY, NamedColor.TRANSPARENT));
        String defaultAndroidFond = "Roboto";
        DEFAULT_EXHIBITION_TC508 = DEFAULT_EXHIBITION_TC506M.clone();
        DEFAULT_EXHIBITION_TC508.getDescription().setFont(defaultAndroidFond);
        DEFAULT_EXHIBITION_TC508.getBarcode().setFont(defaultAndroidFond);
        DEFAULT_EXHIBITION_TC508.getPrice1().setFont(defaultAndroidFond);
        DEFAULT_EXHIBITION_TC508.getPrice2().setFont(defaultAndroidFond);
        DEFAULT_EXHIBITION_TC508.getLabel1().setFont(defaultAndroidFond);
        DEFAULT_EXHIBITION_TC508.getLabel2().setFont(defaultAndroidFond);
        DEFAULT_EXHIB_PARAM_NOT_FOUND_TC504 = new ExhibitionParam(-1, -1, "DejaVu Sans Bold", 30, NamedColor.GREY, NamedColor.TRANSPARENT);
        DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506M = new ExhibitionParam(-1, 30, "DejaVuSans-Bold.ttf", 30, NamedColor.GREY, NamedColor.TRANSPARENT);
        DEFAULT_EXHIB_PARAM_NOT_FOUND_TC406 = new ExhibitionParam(-1, 35, "DejaVuSans-Bold.ttf", 30, NamedColor.GREY, NamedColor.TRANSPARENT);
        DEFAULT_EXHIB_PARAM_NOT_FOUND_TC505 = new ExhibitionParam(-1, 35, "DejaVuSans-Bold.ttf", 30, NamedColor.GREY, NamedColor.TRANSPARENT);
        DEFAULT_EXHIB_PARAM_NOT_FOUND_TC507 = new ExhibitionParam(-1, 35, "DejaVuSans-Bold.ttf", 30, NamedColor.GREY, NamedColor.TRANSPARENT);
        DEFAULT_EXHIB_PARAM_NOT_FOUND_TC508 = DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506M.clone();
        DEFAULT_EXHIB_PARAM_NOT_FOUND_TC508.setFont(defaultAndroidFond);
        DEFAULT_EXHIB_PARAM_NOT_FOUND_GB600 = new ExhibitionParam(-1, 30, "DejaVuSans-Bold.ttf", 30, NamedColor.GREY, NamedColor.TRANSPARENT);
        DEFAULT_EXHIB_PARAM_NOT_FOUND_GB601 = new ExhibitionParam(-1, 30, "DejaVuSans-Bold.ttf", 30, NamedColor.GREY, NamedColor.TRANSPARENT);
        DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506S = new ExhibitionParam(-1, 35, "DejaVuSans-Bold.ttf", 30, NamedColor.GREY, NamedColor.TRANSPARENT);
        DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506E = new ExhibitionParam(-1, 35, "DejaVuSans-Bold.ttf", 30, NamedColor.GREY, NamedColor.TRANSPARENT);
        DEFAULT_EXHIB_PARAM_NOT_FOUND_TC406E = new ExhibitionParam(-1, 35, "DejaVuSans-Bold.ttf", 30, NamedColor.GREY, NamedColor.TRANSPARENT);
        DEFAULT_EXHIBITION_DATAMATRIX_TC506M = new Exhibition(NamedColor.WHITE, new ExhibitionParam(0, 0, "DejaVuSans.ttf", 32, NamedColor.BLACK, NamedColor.TRANSPARENT), new ExhibitionParam(0, 70, "DejaVuSans-Bold.ttf", 34, NamedColor.BLACK, NamedColor.TRANSPARENT), new ExhibitionParam(230, 70, "DejaVuSans-Bold.ttf", 34, NamedColor.BLACK, NamedColor.TRANSPARENT), new ExhibitionParam(0, 115, "DejaVuSans.ttf", 18, NamedColor.METALLIC, NamedColor.TRANSPARENT), new ExhibitionParam(0, 140, "DejaVuSans.ttf", 16, NamedColor.BLACK, NamedColor.TRANSPARENT), new ExhibitionParam(0, 165, "DejaVuSans.ttf", 18, NamedColor.METALLIC, NamedColor.TRANSPARENT), new ExhibitionParam(0, 190, "DejaVuSans.ttf", 16, NamedColor.BLACK, NamedColor.TRANSPARENT), new ExhibitionParam(240, 165, "DejaVuSans.ttf", 18, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(240, 190, "DejaVuSans.ttf", 16, NamedColor.BLACK, NamedColor.TRANSPARENT), new ExhibitionParam(0, 215, "DejaVuSans.ttf", 18, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(0, 240, "DejaVuSans.ttf", 16, NamedColor.BLACK, NamedColor.TRANSPARENT), new ExhibitionParam(240, 215, "DejaVuSans.ttf", 18, NamedColor.GREY, NamedColor.TRANSPARENT), new ExhibitionParam(240, 240, "DejaVuSans.ttf", 16, NamedColor.BLACK, NamedColor.TRANSPARENT));
        singleton = null;
    }
}

