/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server;

import br.com.gertec.tc.server.ApplicationSettings;

public enum DbMode {
    INTERNAL,
    EXTERNAL_JDBC,
    EXTERNAL_TXT;

    public static final String CFG_EXTERNAL_JDBC = "1";
    public static final String CFG_EXTERNAL_TXT = "2";
    public static final String CFG_INTERNAL = "3";
    private String configValue;

    public static DbMode loadFromConfig() {
        DbMode mode = DbMode.fromConfigValue(ApplicationSettings.getInstance().getProperty("DB_MODE"));
        if (mode == null) {
            mode = ApplicationSettings.DEFAULT_DB_MODE;
        }
        return mode;
    }

    public static DbMode fromConfigValue(String configValue) {
        switch (configValue) {
            case "3": {
                return INTERNAL;
            }
            case "1": {
                return EXTERNAL_JDBC;
            }
            case "2": {
                return EXTERNAL_TXT;
            }
        }
        return null;
    }

    public String getConfigValue() {
        return this.configValue;
    }

    static {
        DbMode.INTERNAL.configValue = CFG_INTERNAL;
        DbMode.EXTERNAL_JDBC.configValue = CFG_EXTERNAL_JDBC;
        DbMode.EXTERNAL_TXT.configValue = CFG_EXTERNAL_TXT;
    }
}

