/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.bean;

import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.GenericTc;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class TerminalGroup
implements Iterable<GenericTc> {
    private String name;
    private final List<GenericTc> list = new LinkedList<GenericTc>();
    private final List<GenericTc> readOnlyList = Collections.unmodifiableList(this.list);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void add(GenericTc tc) {
        if (!this.list.contains(tc)) {
            this.list.add(tc);
        }
    }

    public void remove(GenericTc tc) {
        this.list.remove(tc);
    }

    public void addTerminal(GenericTc terminal) {
        if (terminal == null) {
            throw new IllegalArgumentException("Null terminal");
        }
        this.list.add(terminal);
    }

    public List<GenericTc> getTerminals() {
        return this.readOnlyList;
    }

    public String toString() {
        return this.getName();
    }

    public boolean contains(GenericTc tc) {
        return this.readOnlyList.contains(tc);
    }

    public GenericTc getByMac(String mac) {
        for (GenericTc tc : this.readOnlyList) {
            String tmpMac = tc.getMacAddress();
            if (tmpMac != null) {
                tmpMac = tmpMac.toLowerCase();
            }
            if (!Objects.equals(tmpMac, mac.toLowerCase())) continue;
            return tc;
        }
        return null;
    }

    public GenericTc getByIp(InetAddress ip) {
        for (GenericTc tc : this.readOnlyList) {
            InetAddress tmpIp = tc.getIpAddress();
            if (!Objects.equals(tmpIp, ip)) continue;
            return tc;
        }
        return null;
    }

    @Override
    public Iterator<GenericTc> iterator() {
        return this.readOnlyList.iterator();
    }

    public boolean contains(AbstractTcConnection connection) {
        for (GenericTc terminal : this.getTerminals()) {
            if (!terminal.getMacAddress().equalsIgnoreCase(connection.getTerminal().getMacAddress())) continue;
            return true;
        }
        return false;
    }
}

