/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.customer.audio.online.google;

import br.com.gertec.tc.server.util.FileUtilities;
import com.darkprograms.speech.synthesiser.SynthesiserV2;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class GenerateAudio {
    private static SynthesiserV2 synthesizer = new SynthesiserV2("AIzaSyBOti4mM-6x9WDnZIjIeyEU21OpBXqWBgw");
    private static FileUtilities tempFile = new FileUtilities();
    private static File baseDir = tempFile.getTemporaryAudio();
    private static String srcFile = "/Audio.mp3";
    private static String srcQueryFile = "/queryAudio.wav";
    public static String fileUnavailable = "Descri\u00e7\u00e3o de \u00e1udio indispon\u00edvel.";
    static double pitch;
    static double speed;

    public static File getAudioQuery(String description, String price1) throws UnsupportedAudioFileException {
        String text = description + " " + price1;
        String newTexto = (text = text.replaceAll("\\.", "")).replaceAll(" ", "");
        int len = newTexto.length();
        if (len > 80) {
            text = fileUnavailable;
        }
        try {
            InputStream a = synthesizer.getMP3Data(text);
            File file = new File(baseDir, srcFile);
            GenerateAudio.copyInputStreamToFile(a, file);
            System.out.println("Successfully got back synthesizer data");
            GenerateAudio.mp3ToWav(file);
            File fileWav = new File(baseDir, srcQueryFile);
            return fileWav;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static File getAudioNotFound(String msgNotFound) throws UnsupportedAudioFileException {
        try {
            InputStream a = synthesizer.getMP3Data(msgNotFound);
            File file = new File(baseDir, srcFile);
            GenerateAudio.copyInputStreamToFile(a, file);
            System.out.println("Successfully got back synthesizer data");
            GenerateAudio.mp3ToWav(file);
            File fileWav = new File(baseDir, srcQueryFile);
            return fileWav;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getPath() {
        return srcQueryFile;
    }

    private static void copyInputStreamToFile(InputStream inputStream, File file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            int read;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
        }
    }

    public static byte[] getBytes(File file) {
        int len = (int)file.length();
        byte[] sendBuf = new byte[len];
        FileInputStream inFile = null;
        try {
            inFile = new FileInputStream(file);
            inFile.read(sendBuf, 0, len);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sendBuf;
    }

    public static void mp3ToWav(File mp3Data) throws UnsupportedAudioFileException, IOException {
        AudioInputStream mp3Stream = AudioSystem.getAudioInputStream(mp3Data);
        AudioFormat sourceFormat = mp3Stream.getFormat();
        AudioFormat convertFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 24600.0f, 16, sourceFormat.getChannels(), sourceFormat.getChannels() * 2, 24600.0f, false);
        AudioInputStream converted = AudioSystem.getAudioInputStream(convertFormat, mp3Stream);
        AudioSystem.write(converted, AudioFileFormat.Type.WAVE, new File(baseDir + srcQueryFile));
    }
}

