/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.dao;

import br.com.gertec.tc.server.dao.Product;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.util.jdbc.JdbcConnection;
import br.com.gertec.tc.server.util.jdbc.JdbcResultSet;
import br.com.gertec.tc.server.util.jdbc.JdbcStatment;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingWorker;

public abstract class AbstractJdbcProductDao
extends Product.AbstractProductDao {
    private final Map<String, Product> map = new LinkedHashMap<String, Product>();
    private final List<Product> list = new LinkedList<Product>();
    private final List<Product> readOnlyList = Collections.unmodifiableList(this.list);
    private final JdbcConnection connection;
    private final Product.ProductTableDefinition tableDef;
    private final Timer scheduleTimer = new Timer(true);
    private boolean scheduleFlag = false;
    volatile boolean initialized = false;

    private static String generateSafeUpdateSql(String tableName, String idCol, String ... cols) {
        if (cols.length == 0) {
            throw new IllegalArgumentException("Missing columns");
        }
        StringBuilder sql = new StringBuilder("UPDATE ").append(tableName).append(" SET ");
        int i = 0;
        for (String col : cols) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(col).append(" = ?");
            ++i;
        }
        sql.append(" WHERE ").append(idCol).append(" = ?");
        return sql.toString();
    }

    public AbstractJdbcProductDao(JdbcConnection connection, Product.ProductTableDefinition tableDef) {
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        this.connection = connection;
        if (tableDef == null) {
            throw new IllegalArgumentException("Table definition cannot be null");
        }
        this.tableDef = tableDef;
    }

    public final JdbcConnection getConnection() {
        return this.connection;
    }

    @Override
    public final Product.ProductTableDefinition getTableDefinition() {
        return this.tableDef;
    }

    @Override
    public Product get(String barcode) {
        barcode = barcode.trim();
        String sql = String.format("SELECT * FROM %s WHERE %s = '%s'", this.tableDef.getName(), this.tableDef.getColBarcode(), barcode);
        JdbcStatment stmt = this.getConnection().prepareStatement(sql);
        JdbcResultSet rs = stmt.executeQuery();
        Product p = null;
        if (rs.next()) {
            p = this.getProduct(this.tableDef, rs);
        }
        if (p == null) {
            this.list.remove(this.map.remove(barcode));
        }
        if (p != null) {
            if (this.map.containsKey(p.getBarcode())) {
                this.map.get(p.getBarcode()).clone(p);
            } else {
                this.map.put(p.getBarcode(), p);
                this.list.add(p);
            }
        }
        return p;
    }

    @Override
    public List<Product> getAll() {
        return this.readOnlyList;
    }

    protected Product getProduct(Product.ProductTableDefinition tableDef, JdbcResultSet rs) {
        return new Product(tableDef, rs);
    }

    protected abstract void doDelete(Product var1);

    protected abstract void create(Product var1);

    protected abstract void update(Product var1);

    @Override
    public final void save(Product product) {
        if (product.isLinked()) {
            this.update(product);
            this.map.remove(product.getOriginalBarcode());
            this.map.put(product.getBarcode(), product);
            product.setOriginalBarcode(product.getBarcode());
        } else {
            this.create(product);
            this.map.put(product.getBarcode(), product);
            this.list.add(product);
        }
    }

    @Override
    public final void delete(Product product) {
        if (!product.isLinked()) {
            throw new IllegalArgumentException("Product is not linked to DB");
        }
        this.doDelete(product);
        this.map.remove(product.getBarcode());
        this.list.remove(product);
    }

    @Override
    public synchronized void close() {
        this.map.clear();
        this.list.clear();
        this.getConnection().close();
    }

    @Override
    public void reload() {
        this.init(true);
        Log.debug("Refresh autom\u00e1tico do banco", new Object[0]);
    }

    void init(final boolean force) {
        SwingWorker<Void, Void> sw = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                if (force || !AbstractJdbcProductDao.this.initialized) {
                    AbstractJdbcProductDao.this.map.clear();
                    AbstractJdbcProductDao.this.list.clear();
                    Product.ProductTableDefinition tableDef = AbstractJdbcProductDao.this.getTableDefinition();
                    String sql = String.format("SELECT * FROM %s", tableDef.getName());
                    JdbcStatment stmt = AbstractJdbcProductDao.this.getConnection().prepareStatement(sql);
                    JdbcResultSet rs = stmt.executeQuery();
                    while (rs.next()) {
                        Product p = AbstractJdbcProductDao.this.getProduct(tableDef, rs);
                        AbstractJdbcProductDao.this.map.put(p.getBarcode(), p);
                        AbstractJdbcProductDao.this.list.add(p);
                    }
                    rs.close();
                    stmt.close();
                    AbstractJdbcProductDao.this.initialized = true;
                    if (!AbstractJdbcProductDao.this.scheduleFlag) {
                        AbstractJdbcProductDao.this.taskScheduler();
                        AbstractJdbcProductDao.this.scheduleFlag = true;
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                AbstractJdbcProductDao.this.notifyLoadedData();
            }
        };
        sw.execute();
    }

    @Override
    public void init() {
        this.init(false);
    }

    private void taskScheduler() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (AbstractJdbcProductDao.this.getConnection().isOpen()) {
                    AbstractJdbcProductDao.this.reload();
                }
            }
        };
        this.scheduleTimer.scheduleAtFixedRate(task, 0L, 3600000L);
    }

    public static class ExternalJdbcProductDao
    extends AbstractJdbcProductDao {
        public ExternalJdbcProductDao(JdbcConnection connection, Product.ProductTableDefinition tableDef) {
            super(connection, tableDef);
        }

        @Override
        protected void create(Product product) {
            throw new UnsupportedOperationException("DAO is read-only");
        }

        @Override
        protected void update(Product product) {
            throw new UnsupportedOperationException("DAO is read-only");
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        protected void doDelete(Product product) {
            throw new UnsupportedOperationException("DAO is read-only");
        }
    }

    public static class InternalJdbcProductDao
    extends AbstractJdbcProductDao {
        private static final String COL_ID = "PROD_ID";
        private static final Product.ProductTableDefinition DEFAULT_TABLE_DEFINITION = new Product.ProductTableDefinition();

        @Override
        protected Product getProduct(Product.ProductTableDefinition tableDef, JdbcResultSet rs) {
            Product product = super.getProduct(tableDef, rs);
            product.setId(rs.getInt(COL_ID));
            return product;
        }

        private static JdbcConnection getConnectionForEmbeddedDb(File dbFile) {
            try {
                String uri = String.format("jdbc:h2:%s", dbFile.getCanonicalPath());
                return JdbcConnection.getConnection(uri, "", "", 0L);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public InternalJdbcProductDao(File dbFile) {
            super(InternalJdbcProductDao.getConnectionForEmbeddedDb(dbFile), DEFAULT_TABLE_DEFINITION);
        }

        @Override
        public void doDelete(Product product) {
            if (!product.isLinked()) {
                throw new IllegalArgumentException("Product is not linked to DB");
            }
            Product.ProductTableDefinition ptd = this.getTableDefinition();
            String sql = String.format("DELETE FROM %s WHERE %s = ?", ptd.getName(), COL_ID);
            JdbcStatment stmt = this.getConnection().prepareStatement(sql);
            stmt.set(1, product.getId());
            stmt.execute();
            product.setId(null);
            product.setLinked(false);
            product.setModified(true);
            stmt.close();
        }

        @Override
        protected void create(Product product) {
            Product.ProductTableDefinition ptd = this.getTableDefinition();
            String sql = String.format("INSERT INTO %s (%s, %s, %s, %s) VALUES (?, ?, ?, ?)", ptd.getName(), ptd.getColBarcode(), ptd.getColDescription(), ptd.getColPrice1(), ptd.getColPrice2());
            JdbcStatment stmt = this.getConnection().prepareStatement(sql);
            stmt.set(1, product.getBarcode());
            stmt.set(2, product.getDescription());
            stmt.set(3, product.getPrice1());
            stmt.set(4, product.getPrice2());
            stmt.execute();
            JdbcResultSet keyRs = stmt.getGeneratedKeys();
            keyRs.next();
            Integer generatedId = keyRs.getInt(1);
            keyRs.close();
            stmt.close();
            product.setId(generatedId);
            product.setModified(false);
            product.setLinked(true);
        }

        @Override
        protected void update(Product product) {
            Product.ProductTableDefinition ptd = this.getTableDefinition();
            String sql = AbstractJdbcProductDao.generateSafeUpdateSql(ptd.getName(), COL_ID, new String[]{ptd.getColBarcode(), ptd.getColDescription(), ptd.getColPrice1(), ptd.getColPrice2()});
            JdbcStatment stmt = this.getConnection().prepareStatement(sql);
            stmt.set(1, product.getBarcode());
            stmt.set(2, product.getDescription());
            stmt.set(3, product.getPrice1());
            stmt.set(4, product.getPrice2());
            stmt.set(5, product.getId());
            stmt.execute();
            product.setModified(false);
        }

        @Override
        void init(boolean force) {
            if (force || !this.initialized) {
                Product.ProductTableDefinition tableDef = this.getTableDefinition();
                if (!this.getConnection().getTableNames().contains(tableDef.getName())) {
                    StringBuilder sqlFormat = new StringBuilder("CREATE TABLE %s (").append("%s INT PRIMARY KEY AUTO_INCREMENT, ").append("%s VARCHAR(100) UNIQUE, ").append("%s VARCHAR(128), ").append("%s VARCHAR(100), ").append("%s VARCHAR(100) ) ");
                    String sql = String.format(sqlFormat.toString(), tableDef.getName(), COL_ID, tableDef.getColBarcode(), tableDef.getColDescription(), tableDef.getColPrice1(), tableDef.getColPrice2());
                    JdbcStatment stmt = this.getConnection().prepareStatement(sql);
                    stmt.execute();
                    stmt.close();
                }
                super.init(force);
            }
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }
    }
}

