/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.dao;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.dao.Exhibition;
import br.com.gertec.tc.server.dao.ProductExhibition;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.util.jdbc.JdbcResultSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Product {
    private static AbstractProductDao currentDao = null;
    private boolean modified;
    private boolean linked;
    private String originalBarcode = null;
    private volatile Boolean hasCustomExhibition;
    private Integer id;
    private String barcode;
    private String description;
    private String price1;
    private String price2;

    public static synchronized AbstractProductDao getCurrentDao() {
        if (currentDao == null) {
            throw new IllegalStateException("There is no DAO");
        }
        return currentDao;
    }

    public static synchronized void setCurrentDao(AbstractProductDao dao) {
        if (dao == null) {
            throw new IllegalArgumentException("DAO cannot be null");
        }
        if (!Objects.equals(currentDao, dao)) {
            if (currentDao != null) {
                currentDao.close();
            }
            currentDao = dao;
            currentDao.init();
        }
    }

    public static synchronized Product get(String barcode) {
        return Product.getCurrentDao().get(barcode);
    }

    public static synchronized List<Product> getAll() {
        return Product.getCurrentDao().getAll();
    }

    private String readStrColumn(JdbcResultSet rs, String colName) {
        if (colName == null) {
            return null;
        }
        return rs.getString(colName);
    }

    public Product() {
        this.setLinked(false);
        this.setModified(true);
    }

    Product(ProductTableDefinition tableDef, JdbcResultSet rs) {
        this.barcode = this.readStrColumn(rs, tableDef.getColBarcode());
        this.description = this.readStrColumn(rs, tableDef.getColDescription());
        this.price1 = this.readStrColumn(rs, tableDef.getColPrice1());
        this.price2 = this.readStrColumn(rs, tableDef.getColPrice2());
        this.setLinked(true);
        this.setModified(false);
    }

    private String fix(String str) {
        if (str == null) {
            return null;
        }
        if (str.trim().isEmpty()) {
            return null;
        }
        return str.trim();
    }

    public boolean isModified() {
        return this.modified;
    }

    void setModified(boolean modified) {
        this.modified = modified;
    }

    public boolean isLinked() {
        return this.linked;
    }

    void setLinked(boolean linked) {
        this.linked = linked;
    }

    public Integer getId() {
        return this.id;
    }

    void setId(Integer id) {
        this.id = id;
    }

    String getOriginalBarcode() {
        if (this.id != null && this.originalBarcode == null) {
            this.originalBarcode = this.barcode;
        }
        return this.originalBarcode;
    }

    Product setOriginalBarcode(String originalBarcode) {
        this.originalBarcode = originalBarcode;
        return this;
    }

    public String getBarcode() {
        return this.barcode;
    }

    public Product setBarcode(String barcode) {
        if (!Objects.equals(this.barcode, barcode = this.fix(barcode))) {
            if (this.id != null && this.originalBarcode == null) {
                this.originalBarcode = this.barcode;
            }
            this.barcode = barcode;
            this.setModified(true);
        }
        return this;
    }

    public String getDescription() {
        if (this.description == null) {
            return "";
        }
        return this.description;
    }

    public Product setDescription(String description) {
        if (!Objects.equals(this.description, description = this.fix(description))) {
            this.description = description;
            this.setModified(true);
        }
        return this;
    }

    public String getPrice1() {
        if (this.price1 == null) {
            return "";
        }
        return this.price1;
    }

    public Product setPrice1(String price1) {
        if (!Objects.equals(this.price1, price1 = this.fix(price1))) {
            this.price1 = price1;
            this.setModified(true);
        }
        return this;
    }

    public String getPrice2() {
        if (this.price2 == null) {
            return "";
        }
        return this.price2;
    }

    public Product setPrice2(String price2) {
        if (!Objects.equals(this.price2, price2 = this.fix(price2))) {
            this.price2 = price2;
            this.setModified(true);
        }
        return this;
    }

    public boolean hasCustomExhibition() {
        if (this.getBarcode() == null) {
            throw new IllegalStateException("Product does not have a barcode");
        }
        if (this.hasCustomExhibition != null) {
            return this.hasCustomExhibition;
        }
        if (!this.isLinked()) {
            throw new IllegalStateException("Instance is not linked");
        }
        this.hasCustomExhibition = ProductExhibition.hasCustomExhibition(this.getBarcode());
        return this.hasCustomExhibition;
    }

    public Map<TerminalType, Exhibition> getExhibitions() {
        return ProductExhibition.getExhibitions(this.getBarcode());
    }

    public Exhibition getExhibition(TerminalType terminalType) {
        return ProductExhibition.get(this.getBarcode(), terminalType);
    }

    public Product setExhibition(Exhibition exhibition, TerminalType terminalType) {
        if (exhibition == null) {
            ProductExhibition.delete(this.getBarcode(), terminalType);
        } else {
            Exhibition existingExhib = this.getExhibition(terminalType);
            if (existingExhib != null) {
                ProductExhibition.delete(this.getBarcode(), terminalType);
            }
            ProductExhibition.save(this.getBarcode(), terminalType, exhibition);
        }
        return this;
    }

    void clone(Product other) {
        this.modified = other.modified;
        this.linked = other.linked;
        this.originalBarcode = other.originalBarcode;
        this.id = other.id;
        this.barcode = other.barcode;
        this.description = other.description;
        this.price1 = other.price1;
        this.price2 = other.price2;
    }

    public boolean equals(Object obj) {
        try {
            Product other = (Product)obj;
            return Objects.equals(other.getBarcode(), this.getBarcode());
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public void save() {
        Product.getCurrentDao().save(this);
    }

    public void delete() {
        if (this.isLinked()) {
            Product.getCurrentDao().delete(this);
        }
    }

    public String toString() {
        return String.format("[%s:%s]", this.getBarcode(), this.getDescription());
    }

    public static interface LoadedDataListener {
        public void onLoadedData();
    }

    public static abstract class AbstractProductDao {
        private LoadedDataListener loadedDataListener;

        public abstract ProductTableDefinition getTableDefinition();

        public abstract Product get(String var1);

        public abstract List<Product> getAll();

        public abstract void delete(Product var1);

        public abstract void save(Product var1);

        public abstract void reload();

        public abstract void init();

        public abstract void close();

        public abstract boolean isReadOnly();

        public void setLoadedDataListener(LoadedDataListener loadedDataListener) {
            this.loadedDataListener = loadedDataListener;
        }

        public void notifyLoadedData() {
            if (this.loadedDataListener != null) {
                this.loadedDataListener.onLoadedData();
            }
        }
    }

    public static class ProductTableDefinition {
        public static final String DEFAULT_TABLE_PRODUCTS = "PRODUCTS";
        public static final String DEFAULT_COL_BARCODE = "BARCODE";
        public static final String DEFAULT_COL_DESCRIPTION = "DESCRIPTION";
        public static final String DEFAULT_COL_PRICE1 = "PRICE_1";
        public static final String DEFAULT_COL_PRICE2 = "PRICE_2";
        private String name = "PRODUCTS";
        private String colBarcode = "BARCODE";
        private String colDescription = "DESCRIPTION";
        private String colPrice1 = "PRICE_1";
        private String colPrice2 = "PRICE_2";

        public static ProductTableDefinition loadFromConfig() {
            ProductTableDefinition tableDef = new ProductTableDefinition();
            tableDef.setName(Application.SETTINGS.getProperty("DB_PRODUCT_TABLE_NAME"));
            tableDef.setColBarcode(Application.SETTINGS.getProperty("DB_COL_BARCODE"));
            tableDef.setColDescription(Application.SETTINGS.getProperty("DB_COL_DESCRIPITION"));
            tableDef.setColPrice1(Application.SETTINGS.getProperty("DB_COL_PRICE1"));
            tableDef.setColPrice2(Application.SETTINGS.getProperty("DB_COL_PRICE2"));
            return tableDef;
        }

        private String fixColName(String name) {
            if (name == null) {
                return null;
            }
            if (name.trim().isEmpty()) {
                return null;
            }
            return name.trim();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            if (name == null || name.trim().isEmpty()) {
                throw new IllegalArgumentException("Table name cannot be null/empty");
            }
            this.name = name;
        }

        public String getColBarcode() {
            return this.colBarcode;
        }

        public void setColBarcode(String colBarcode) {
            this.colBarcode = this.fixColName(colBarcode);
        }

        public String getColDescription() {
            return this.colDescription;
        }

        public void setColDescription(String colDescription) {
            this.colDescription = this.fixColName(colDescription);
        }

        public String getColPrice1() {
            return this.colPrice1;
        }

        public void setColPrice1(String colPrice1) {
            this.colPrice1 = this.fixColName(colPrice1);
        }

        public String getColPrice2() {
            return this.colPrice2;
        }

        public void setColPrice2(String colPrice2) {
            this.colPrice2 = this.fixColName(colPrice2);
        }

        public ProductTableDefinition copy() {
            ProductTableDefinition copy = new ProductTableDefinition();
            copy.setName(this.getName());
            copy.setColBarcode(this.getColBarcode());
            copy.setColDescription(this.getColDescription());
            copy.setColPrice1(this.getColPrice1());
            copy.setColPrice2(this.getColPrice2());
            return copy;
        }
    }
}

