/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.customer.PassParameter;
import br.com.gertec.tc.server.gui.Sc501EMediaValidation;
import br.com.gertec.tc.server.gui.Sc504MediaPanel;
import br.com.gertec.tc.server.gui.SwingUtils;
import br.com.gertec.tc.server.gui.util.EnumCombo;
import br.com.gertec.tc.server.gui.util.GuiPanel;
import br.com.gertec.tc.server.gui.util.GuiTcDialog;
import br.com.gertec.tc.server.gui.util.GuiUtils;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.CommandListener;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc501.Sc501Connection;
import br.com.gertec.tc.server.protocol.sc501.commands.GetListMediasQ;
import br.com.gertec.tc.server.protocol.sc501.commands.Gif;
import br.com.gertec.tc.server.protocol.sc501.commands.Img;
import br.com.gertec.tc.server.protocol.sc501.commands.Media;
import br.com.gertec.tc.server.protocol.sc501.commands.MediaError;
import br.com.gertec.tc.server.protocol.sc504.Sc504Connection;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvSendFile;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.event.comm.DataBuffer;
import br.org.reconcavo.j18n.J18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;

public class AddMediaDialog
extends GuiTcDialog {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_DURATION = 1;
    private static final int DEFAULT_REPETITIONS = 0;
    private static final String FILE_DELIMITER = "; ";
    private int mediasToSend;
    private int okCounter = 0;
    private Object syncObject = new Object();
    private boolean isSocketOpen = true;
    private static File lastDir = new File(System.getProperty("user.home"));
    private static final String[] DEFAULT_MEDIA_SUFFIXES = new String[]{"jpg", "png", "bmp", "mp4", "gif", "avi"};
    private static final String[] DEFAULT_505_MEDIA_SUFFIXES = new String[]{"bmp", "gif"};
    private static final String[] DEFAULT_506M_MEDIA_SUFFIXES = new String[]{"jpg", "png", "bmp", "gif", "avi"};
    private static final String[] TC_406_MEDIA_SUFFIXES = new String[]{"gif"};
    private static final String[] TC_506_S_MEDIA_SUFFIXES = new String[]{"gif"};
    private static final String[] TC_506_E_MEDIA_SUFFIXES = new String[]{"jpg", "bmp"};
    private static final String[] TC_406_E_MEDIA_SUFFIXES = new String[]{"jpg", "bmp"};
    private static final String[] GB_600_MEDIA_SUFFIXES = new String[]{"3gp", "mp4", "ts", "mkv", "bmp", "gif", "jpg"};
    private static final String[] DEFAULT_IMAGE_SUFFIXES = new String[]{"jpg", "png", "bmp", "gif"};
    private static final String[] DEFAULT_VIDEO_SUFFIXES = new String[]{"avi", "mp4"};
    private final JPanel contentPanel = new GuiPanel();
    private final JPanel fileChooserPanel;
    private final JLabel lblFile;
    private final JLabel lblObs;
    private final JTextField txtFile;
    private final JButton btnBrowse;
    private final JButton btnOk;
    private final JPanel storagePanel;
    private final ButtonGroup btnGroup;
    private final JRadioButton rdbtnInternal;
    private final JRadioButton rdbtnExternal;
    private final JPanel exhibOptionsPanel;
    private final JLabel lblRepetitions;
    private final JLabel lblDuration;
    private final JLabel lblExhibMode;
    private final JSpinner repetitionSpinner;
    private final JSpinner durationSpinner;
    private final EnumCombo<Gif.ExhibitionMode> cmbExhibMode;
    private int numberFileInTerminal;
    private Sc501EMediaValidation sc501EMediaValidation;
    private final JPanel buttonPane;
    private final JProgressBar progressBar;
    private List<File> selectedFiles = new LinkedList<File>();
    private boolean temVideos = false;
    private boolean videosEFotos = false;
    int videoCont = 0;
    int imageCont = 0;
    String filePath;
    String fileName;

    public AddMediaDialog(final AbstractTcConnection connection) {
        super(connection);
        if (connection == null) {
            this.init();
        }
        this.setModal(true);
        this.setResizable(false);
        this.setTitle(J18N.tr("Add Media - %s (%s)", connection.getInetAddress().getHostAddress(), connection.getTerminal().getTcName()));
        this.getContentPane().setLayout(new BorderLayout());
        GridBagLayout gblContentPanel = new GridBagLayout();
        gblContentPanel.rowWeights = new double[]{1.0, 1.0, 1.0};
        gblContentPanel.columnWeights = new double[]{1.0};
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPanel.setLayout(gblContentPanel);
        this.btnGroup = new ButtonGroup();
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.fileChooserPanel = new GuiPanel();
        this.fileChooserPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagConstraints gbcFileChooserPanel = new GridBagConstraints();
        gbcFileChooserPanel.fill = 1;
        gbcFileChooserPanel.gridx = 0;
        gbcFileChooserPanel.gridy = 0;
        this.contentPanel.add((Component)this.fileChooserPanel, gbcFileChooserPanel);
        GridBagLayout gblFileChooserPanel = new GridBagLayout();
        gblFileChooserPanel.columnWeights = new double[]{0.0, 1.0, 0.0};
        gblFileChooserPanel.rowWeights = new double[]{0.0};
        this.fileChooserPanel.setLayout(gblFileChooserPanel);
        this.lblFile = new JLabel(J18N.tr("File", new Object[0]) + ":");
        GridBagConstraints gbcLblFile = new GridBagConstraints();
        gbcLblFile.anchor = 17;
        gbcLblFile.gridx = 0;
        gbcLblFile.gridy = 0;
        this.fileChooserPanel.add((Component)this.lblFile, gbcLblFile);
        this.txtFile = new JTextField();
        this.txtFile.setEditable(false);
        this.txtFile.setColumns(25);
        GridBagConstraints gbcTxtFile = new GridBagConstraints();
        gbcTxtFile.fill = 2;
        gbcTxtFile.insets = new Insets(0, 5, 0, 0);
        gbcTxtFile.gridx = 1;
        gbcTxtFile.gridy = 0;
        this.fileChooserPanel.add((Component)this.txtFile, gbcTxtFile);
        this.btnBrowse = new JButton(J18N.tr("Browse", new Object[0]) + "...");
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result;
                this.setLanguageFileChooser();
                JFileChooser fileChooser = new JFileChooser();
                JList list = SwingUtils.getDescendantOfType(JList.class, fileChooser, "Enabled", true);
                JPopupMenu popup = list.getComponentPopupMenu();
                popup.remove(0);
                this.disableComponent(fileChooser);
                fileChooser.setCurrentDirectory(lastDir);
                fileChooser.setMultiSelectionEnabled(true);
                if (null == AddMediaDialog.this.getConnection().getTerminalType()) {
                    fileChooser.setFileFilter(new FileNameExtensionFilter(J18N.tr("Supported media files", new Object[0]), DEFAULT_MEDIA_SUFFIXES));
                } else {
                    switch (AddMediaDialog.this.getConnection().getTerminalType()) {
                        case TC_506_MIDIA: {
                            fileChooser.setFileFilter(new FileNameExtensionFilter(J18N.tr("Supported media files", new Object[0]), DEFAULT_506M_MEDIA_SUFFIXES));
                            break;
                        }
                        case TC_506_E: {
                            fileChooser.setFileFilter(new FileNameExtensionFilter(J18N.tr("Supported media files", new Object[0]) + " (.bmp, .jpg)", TC_506_E_MEDIA_SUFFIXES));
                            break;
                        }
                        case TC_406_E: {
                            fileChooser.setFileFilter(new FileNameExtensionFilter(J18N.tr("Supported media files", new Object[0]) + " (.bmp, .jpg)", TC_406_E_MEDIA_SUFFIXES));
                            break;
                        }
                        case TC_406: {
                            fileChooser.setFileFilter(new FileNameExtensionFilter(J18N.tr("Supported media files", new Object[0]) + " (.gif)", TC_406_MEDIA_SUFFIXES));
                        }
                        case TC_506_S: {
                            fileChooser.setFileFilter(new FileNameExtensionFilter(J18N.tr("Supported media files", new Object[0]) + " (.gif)", TC_506_S_MEDIA_SUFFIXES));
                            break;
                        }
                        case TC_505: {
                            fileChooser.setFileFilter(new FileNameExtensionFilter(J18N.tr("Supported media files", new Object[0]) + " (.bmp, .gif)", DEFAULT_505_MEDIA_SUFFIXES));
                            break;
                        }
                        case TC_507: {
                            fileChooser.setFileFilter(new FileNameExtensionFilter(J18N.tr("Supported media files", new Object[0]) + " (.bmp, .gif)", DEFAULT_505_MEDIA_SUFFIXES));
                            break;
                        }
                        default: {
                            fileChooser.setFileFilter(new FileNameExtensionFilter(J18N.tr("Supported media files", new Object[0]), DEFAULT_MEDIA_SUFFIXES));
                        }
                    }
                }
                TerminalType terminalType = AddMediaDialog.this.getConnection().getTerminalType();
                if (Sc501EMediaValidation.isTc406EOrTC506E(terminalType)) {
                    AddMediaDialog.this.sc501EMediaValidation = new Sc501EMediaValidation();
                    connection.writeCommand(new GetListMediasQ());
                }
                if ((result = fileChooser.showOpenDialog(AddMediaDialog.this)) == 0) {
                    AddMediaDialog.this.selectedFiles.clear();
                    List<Object> selectedFiles = new ArrayList();
                    selectedFiles = Arrays.asList(fileChooser.getSelectedFiles());
                    if (Sc501EMediaValidation.isTc406EOrTC506E(terminalType) && AddMediaDialog.this.sc501EMediaValidation.isNumberOfImagesExceeded(selectedFiles.size())) {
                        selectedFiles = new ArrayList();
                        JOptionPane.showMessageDialog(null, J18N.tr("The limit of 10 media files for this terminal has been reached. To copy a new media, please remove any previously added files and repeat this operation.", new Object[0]));
                    }
                    StringBuilder filePaths = new StringBuilder();
                    for (int i = 0; i < selectedFiles.size(); ++i) {
                        File file = (File)selectedFiles.get(i);
                        if (Sc501EMediaValidation.isTc406EOrTC506E(terminalType) && AddMediaDialog.this.sc501EMediaValidation.IsfilesExceeded(file, terminalType)) continue;
                        if (i == 0) {
                            lastDir = ((File)selectedFiles.get(i)).getParentFile();
                        }
                        if (i > 0) {
                            filePaths.append(AddMediaDialog.FILE_DELIMITER);
                        }
                        filePaths.append(file.getAbsolutePath());
                        AddMediaDialog.this.verificaTiposDeMidia(filePaths);
                        AddMediaDialog.this.selectedFiles.add(file);
                    }
                    if (Sc501EMediaValidation.isTc406EOrTC506E(terminalType)) {
                        AddMediaDialog.this.sc501EMediaValidation.logGenerator();
                    }
                    AddMediaDialog.this.alteraConfigsDeDuracao();
                    AddMediaDialog.this.txtFile.setText(filePaths.toString());
                    AddMediaDialog.this.filePath = fileChooser.getSelectedFile().getPath();
                    AddMediaDialog.this.fileName = fileChooser.getSelectedFile().getName();
                    PassParameter param = new PassParameter();
                    param.setFileName(AddMediaDialog.this.fileName);
                    param.setFilePath(AddMediaDialog.this.filePath);
                }
            }

            public void disableComponent(Container c) {
                int len = c.getComponentCount();
                for (int i = 0; i < len; ++i) {
                    Component comp = c.getComponent(i);
                    if (comp instanceof JToggleButton) {
                        comp.setEnabled(false);
                        continue;
                    }
                    if (!(comp instanceof Container)) continue;
                    this.disableComponent((Container)comp);
                }
            }

            private void setLanguageFileChooser() {
                UIManager.put("FileChooser.openDialogTitleText", J18N.tr("Open", new Object[0]));
                UIManager.put("FileChooser.lookInLabelText", J18N.tr("Look in:", new Object[0]));
                UIManager.put("FileChooser.fileNameLabelText", J18N.tr("File Name:", new Object[0]));
                UIManager.put("FileChooser.filesOfTypeLabelText", J18N.tr("Files of Type:", new Object[0]));
                UIManager.put("FileChooser.openButtonText", J18N.tr("Open", new Object[0]));
                UIManager.put("FileChooser.cancelButtonText", J18N.tr("Cancel", new Object[0]));
                UIManager.put("FileChooser.upFolderToolTipText", J18N.tr("Up One Level", new Object[0]));
                UIManager.put("FileChooser.newFolderToolTipText", J18N.tr("Create New Folder", new Object[0]));
                UIManager.put("FileChooser.listViewButtonToolTipText", J18N.tr("List", new Object[0]));
                UIManager.put("FileChooser.detailsViewButtonToolTipText", J18N.tr("Details", new Object[0]));
                UIManager.put("FileChooser.openButtonToolTipText", J18N.tr("Open selected file", new Object[0]));
                UIManager.put("FileChooser.cancelButtonToolTipText", J18N.tr("Abort file chooser dialog", new Object[0]));
                UIManager.put("FileChooser.newFolderErrorText", J18N.tr("Error creating new folder", new Object[0]));
                UIManager.put("FileChooser.viewMenuLabelText", J18N.tr("View", new Object[0]));
                UIManager.put("FileChooser.refreshActionLabelText", J18N.tr("Refresh", new Object[0]));
                UIManager.put("FileChooser.newFolderActionLabelText", J18N.tr("New Folder", new Object[0]));
                UIManager.put("FileChooser.detailsViewActionLabelText", J18N.tr("Details", new Object[0]));
                UIManager.put("FileChooser.listViewActionLabelText", J18N.tr("List", new Object[0]));
                UIManager.put("FileChooser.acceptAllFileFilterText", J18N.tr("All Files", new Object[0]));
            }
        });
        GridBagConstraints gbcBtnBrowse = new GridBagConstraints();
        gbcBtnBrowse.insets = new Insets(0, 5, 0, 0);
        gbcBtnBrowse.fill = 2;
        gbcBtnBrowse.gridx = 2;
        gbcBtnBrowse.gridy = 0;
        this.fileChooserPanel.add((Component)this.btnBrowse, gbcBtnBrowse);
        if (connection.getTerminalType() == TerminalType.TC_406 || connection.getTerminalType() == TerminalType.TC_506_S) {
            this.lblObs = new JLabel(J18N.tr("Size", new Object[0]) + " : 32 - 192 KBytes   |   " + J18N.tr("Resolution", new Object[0]) + " : 320x240 pixels", 0);
        } else if (connection.getTerminalType() == TerminalType.TC_406_E || connection.getTerminalType() == TerminalType.TC_506_E) {
            this.lblObs = new JLabel(J18N.tr("Size", new Object[0]) + " : 0 - 45 KBytes   |   " + J18N.tr("Resolution", new Object[0]) + " : 320x240 pixels", 0);
        } else if (connection.getTerminalType() == TerminalType.GB_600 || connection.getTerminalType() == TerminalType.GB_601) {
            this.lblObs = new JLabel(J18N.tr("Resolution", new Object[0]) + " : " + TerminalType.GB_600.getDisplayWidth() + "x " + TerminalType.GB_600.getDisplayHeight() + " pixels", 0);
        } else if (connection.getTerminalType() == TerminalType.TC_507 || connection.getTerminalType() == TerminalType.TC_505) {
            this.lblObs = new JLabel(J18N.tr("Resolution", new Object[0]) + " : 128x64 pixels", 0);
        } else {
            String resolucao = connection.getTerminalType() == TerminalType.TC_504 ? "320x240 pixels" : "480x272 pixels";
            this.lblObs = new JLabel(J18N.tr("Resolution", new Object[0]) + " : " + resolucao, 0);
        }
        this.lblObs.setBorder(null);
        this.lblObs.setHorizontalTextPosition(0);
        this.lblObs.setVerticalTextPosition(3);
        GridBagConstraints gbcLabel = new GridBagConstraints();
        gbcLabel.fill = 1;
        gbcLabel.gridx = 1;
        gbcLabel.gridy = 2;
        this.fileChooserPanel.add((Component)this.lblObs, gbcLabel);
        this.storagePanel = new GuiPanel();
        this.storagePanel.setBorder(new TitledBorder(null, J18N.tr("Storage", new Object[0]), 4, 2, null, null));
        GridBagConstraints gbcStoragePanel = new GridBagConstraints();
        gbcStoragePanel.insets = new Insets(5, 0, 0, 0);
        gbcStoragePanel.fill = 1;
        gbcStoragePanel.gridx = 0;
        gbcStoragePanel.gridy = 1;
        this.contentPanel.add((Component)this.storagePanel, gbcStoragePanel);
        this.storagePanel.setLayout(new GridLayout(2, 1, 5, 5));
        this.rdbtnInternal = new JRadioButton(J18N.tr("Internal", new Object[0]));
        this.storagePanel.add(this.rdbtnInternal);
        this.btnGroup.add(this.rdbtnInternal);
        this.rdbtnExternal = new JRadioButton(J18N.tr("External", new Object[0]));
        this.storagePanel.add(this.rdbtnExternal);
        this.btnGroup.add(this.rdbtnExternal);
        if (connection.getTerminalType() == TerminalType.TC_504) {
            this.rdbtnInternal.setText(J18N.tr("Advertising", new Object[0]));
            this.rdbtnExternal.setText(J18N.tr("PreImage", new Object[0]));
            this.rdbtnExternal.setEnabled(false);
        } else if (connection.getTerminalType() == TerminalType.GB_600 || connection.getTerminalType() == TerminalType.GB_601) {
            this.rdbtnExternal.setEnabled(false);
        }
        this.rdbtnInternal.setSelected(true);
        this.exhibOptionsPanel = new GuiPanel();
        this.exhibOptionsPanel.setBorder(new TitledBorder(null, J18N.tr("Exhibition options", new Object[0]), 4, 2, null, null));
        GridBagConstraints gbcExhibOptionsPanel = new GridBagConstraints();
        gbcExhibOptionsPanel.insets = new Insets(5, 0, 0, 0);
        gbcExhibOptionsPanel.fill = 1;
        gbcExhibOptionsPanel.gridx = 0;
        gbcExhibOptionsPanel.gridy = 2;
        this.contentPanel.add((Component)this.exhibOptionsPanel, gbcExhibOptionsPanel);
        GridBagLayout gblExhibOptionsPanel = new GridBagLayout();
        gblExhibOptionsPanel.columnWeights = new double[]{0.0, 0.0, 1.0};
        gblExhibOptionsPanel.rowWeights = new double[]{1.0, 1.0};
        this.exhibOptionsPanel.setLayout(gblExhibOptionsPanel);
        this.lblDuration = new JLabel(J18N.tr("Duration", new Object[0]) + ":");
        GridBagConstraints gbcLblDuration = new GridBagConstraints();
        gbcLblDuration.insets = new Insets(5, 5, 0, 0);
        gbcLblDuration.anchor = 18;
        gbcLblDuration.gridx = 0;
        gbcLblDuration.gridy = 0;
        this.exhibOptionsPanel.add((Component)this.lblDuration, gbcLblDuration);
        this.durationSpinner = new JSpinner();
        this.durationSpinner.setModel(new SpinnerNumberModel(1, 1, 9, 1));
        GridBagConstraints gbcDurationSpinner = new GridBagConstraints();
        gbcDurationSpinner.insets = new Insets(5, 5, 0, 0);
        gbcDurationSpinner.fill = 2;
        gbcDurationSpinner.gridx = 1;
        gbcDurationSpinner.gridy = 0;
        this.exhibOptionsPanel.add((Component)this.durationSpinner, gbcDurationSpinner);
        Component horizontalStrut = Box.createHorizontalStrut(20);
        GridBagConstraints gbcHorizontalStrut = new GridBagConstraints();
        gbcHorizontalStrut.fill = 2;
        gbcHorizontalStrut.insets = new Insets(5, 5, 0, 5);
        gbcHorizontalStrut.gridx = 2;
        gbcHorizontalStrut.gridy = 0;
        this.exhibOptionsPanel.add(horizontalStrut, gbcHorizontalStrut);
        this.lblRepetitions = new JLabel(J18N.tr("Repetitions", new Object[0]) + ":");
        GridBagConstraints gbcLblRepetitions = new GridBagConstraints();
        gbcLblRepetitions.anchor = 17;
        gbcLblRepetitions.insets = new Insets(5, 5, 5, 0);
        gbcLblRepetitions.gridx = 0;
        gbcLblRepetitions.gridy = 1;
        this.exhibOptionsPanel.add((Component)this.lblRepetitions, gbcLblRepetitions);
        this.repetitionSpinner = new JSpinner();
        this.repetitionSpinner.setModel(new SpinnerNumberModel(0, 0, 60, 1));
        GridBagConstraints gbcRepetitionSpinner = new GridBagConstraints();
        gbcRepetitionSpinner.fill = 2;
        gbcRepetitionSpinner.insets = new Insets(5, 5, 5, 0);
        gbcRepetitionSpinner.gridx = 1;
        gbcRepetitionSpinner.gridy = 1;
        this.exhibOptionsPanel.add((Component)this.repetitionSpinner, gbcRepetitionSpinner);
        this.lblExhibMode = new JLabel(J18N.tr("Exhibition Mode", new Object[0]) + ":");
        GridBagConstraints gbcLblExhibMode = new GridBagConstraints();
        gbcLblExhibMode.anchor = 13;
        gbcLblExhibMode.insets = new Insets(5, 5, 0, 5);
        gbcLblExhibMode.gridx = 2;
        gbcLblExhibMode.gridy = 0;
        this.exhibOptionsPanel.add((Component)this.lblExhibMode, gbcLblExhibMode);
        this.cmbExhibMode = new EnumCombo<Gif.ExhibitionMode>(Gif.ExhibitionMode.class);
        this.cmbExhibMode.removeItem((Object)Gif.ExhibitionMode.QUERY);
        this.cmbExhibMode.setSelectedItem((Object)Gif.ExhibitionMode.IMMEDIATELY);
        GridBagConstraints gbcCmbExhibMode = new GridBagConstraints();
        gbcCmbExhibMode.insets = new Insets(0, 0, 0, 0);
        gbcCmbExhibMode.fill = 17;
        gbcCmbExhibMode.gridx = 3;
        gbcCmbExhibMode.gridy = 0;
        this.exhibOptionsPanel.add(this.cmbExhibMode, gbcCmbExhibMode);
        if (connection.isSc504() || connection.getTerminalType() == TerminalType.TC_406_E || connection.getTerminalType() == TerminalType.TC_506_E) {
            this.lblExhibMode.setVisible(false);
            this.cmbExhibMode.setVisible(false);
        }
        GridBagConstraints gbcLblStatus = new GridBagConstraints();
        gbcLblStatus.insets = new Insets(5, 0, 0, 0);
        gbcLblStatus.fill = 2;
        this.progressBar = new JProgressBar();
        this.progressBar.setVisible(false);
        gbcLblStatus.gridx = 0;
        gbcLblStatus.gridy = 3;
        gbcLblStatus.weightx = 0.0;
        this.contentPanel.add((Component)this.progressBar, gbcLblStatus);
        this.buttonPane = new GuiPanel();
        this.buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)this.buttonPane, "South");
        JLabel lblInfo = new JLabel(J18N.tr("Verify if or propaganda module is enabled not query terminal.", new Object[0]));
        GridBagConstraints gbcLblInfo = new GridBagConstraints();
        gbcLblInfo.anchor = 17;
        gbcLblInfo.insets = new Insets(5, 5, 5, 0);
        gbcLblInfo.gridx = 0;
        gbcLblInfo.gridy = 0;
        this.buttonPane.add((Component)lblInfo, gbcLblInfo);
        this.btnOk = new JButton(J18N.tr("Save", new Object[0]));
        GridBagConstraints gbcBtnOk = new GridBagConstraints();
        gbcBtnOk.anchor = 17;
        gbcBtnOk.insets = new Insets(5, 5, 5, 0);
        gbcBtnOk.gridx = 0;
        gbcBtnOk.gridy = 1;
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (connection.getTerminalType() == TerminalType.TC_504) {
                    AddMediaDialog.this.doOkTC504();
                } else {
                    AddMediaDialog.this.doOk();
                }
            }
        });
        if (connection.getTerminalType() == TerminalType.TC_504) {
            this.btnOk.setText(J18N.tr("Add", new Object[0]));
        }
        this.buttonPane.add((Component)this.btnOk, gbcBtnOk);
        JButton btnCancel = new JButton(J18N.tr("Cancel", new Object[0]));
        GridBagConstraints gbcBtnCancel = new GridBagConstraints();
        gbcBtnCancel.anchor = 17;
        gbcBtnCancel.insets = new Insets(5, 5, 5, 0);
        gbcBtnCancel.gridx = 1;
        gbcBtnCancel.gridy = 1;
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddMediaDialog.this.dispose();
            }
        });
        this.buttonPane.add((Component)btnCancel, gbcBtnCancel);
        this.setDefaultButton(this.btnOk);
        this.setCancelButton(btnCancel);
        this.init();
    }

    public void addSaveListener(ActionListener saveListener) {
        this.btnOk.addActionListener(saveListener);
    }

    private void init() {
        TerminalType terminalType = this.getConnection().getTerminal().getType();
        switch (terminalType) {
            case TC_506_S: {
                break;
            }
            case TC_506_E: {
                break;
            }
            case TC_406_E: {
                break;
            }
            case TC_406: {
                break;
            }
            case TC_505: {
                break;
            }
            case TC_507: {
                break;
            }
            case TC_504: {
                break;
            }
            case TC_506_MIDIA: {
                break;
            }
            case TC_508: {
                break;
            }
            case GB_600: {
                break;
            }
            case GB_601: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported terminal type: " + terminalType.name());
            }
        }
        boolean showStorageOptions = terminalType == TerminalType.TC_504 || terminalType == TerminalType.TC_506_MIDIA || terminalType == TerminalType.TC_508;
        this.storagePanel.setVisible(showStorageOptions);
        this.exhibOptionsPanel.setVisible(!showStorageOptions);
        this.registerListener();
        this.pack();
    }

    private void doOk() {
        AbstractTcConnection connection = this.getConnection();
        if (connection instanceof Sc504Connection) {
            PassParameter.setInternalMemory(this.rdbtnInternal.isSelected());
            this.doOkSc504();
        } else if (connection instanceof Sc501Connection) {
            if (connection.getTerminalType().equals((Object)TerminalType.TC_406) || connection.getTerminalType().equals((Object)TerminalType.TC_506_S)) {
                this.doSendGifTc406();
            } else if (connection.getTerminalType().equals((Object)TerminalType.TC_406_E) || connection.getTerminalType().equals((Object)TerminalType.TC_506_E)) {
                this.doSendImageTc406();
            } else {
                this.doOkSc501();
            }
        } else {
            throw new UnsupportedOperationException("Unsupported connection type: " + connection.getClass().getName());
        }
    }

    private void doSendImageTc406() {
        Sc501Connection connection = (Sc501Connection)this.getConnection();
        this.contentPanel.setEnabled(false);
        this.btnOk.setEnabled(false);
        if (this.selectedFiles == null || this.selectedFiles.size() == 0) {
            GuiUtils.showErrorMessage(this, J18N.tr("Select a image first", new Object[0]));
            this.contentPanel.setEnabled(true);
            this.btnOk.setEnabled(true);
        } else {
            connection.enableLiveTimer(false);
            try {
                this.mediasToSend = this.selectedFiles.size();
                for (int i = 0; i < this.selectedFiles.size(); ++i) {
                    SendMediaThread sendMediaThread = new SendMediaThread(connection, this.selectedFiles.get(i));
                    sendMediaThread.start();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        connection.enableLiveTimer(true);
    }

    private void doSendGifTc406() {
        Sc501Connection connection = (Sc501Connection)this.getConnection();
        Gif.ExhibitionMode selectedMode = (Gif.ExhibitionMode)((Object)this.cmbExhibMode.getSelectedItem());
        if (!(this.selectedFiles != null && this.selectedFiles.size() != 0 || selectedMode.toString().equals("RESET"))) {
            GuiUtils.showErrorMessage(this, J18N.tr("Select a gif first", new Object[0]));
        } else {
            try {
                this.repetitionSpinner.commitEdit();
                int repetitions = (Integer)this.repetitionSpinner.getValue();
                this.durationSpinner.commitEdit();
                int duration = (Integer)this.durationSpinner.getValue();
                if (selectedMode.toString().equals("RESET")) {
                    Log.debug(J18N.tr("[File: %s; Repetitions: %d; Duration: %d; Mode: %s]", new Object[]{"NULL", repetitions, duration, selectedMode}), new Object[0]);
                    DataBuffer dataBuffer = new DataBuffer();
                    String header = new String();
                    header = header + "#gif";
                    header = header + String.format("%02X", 255);
                    header = header + String.format("%02X", 0);
                    header = header + String.format("%02X", 0);
                    header = header + String.format("%06X", 0);
                    header = header + String.format("%04X", 0);
                    dataBuffer.putString(header);
                    dataBuffer.put((byte)23);
                    connection.write(dataBuffer.readBytes());
                } else {
                    Log.debug(J18N.tr("[File: %s; Repetitions: %d; Duration: %d; Mode: %s]", new Object[]{this.selectedFiles.get(0), repetitions, duration, selectedMode}), new Object[0]);
                    Gif gifCommand = new Gif(this.selectedFiles.get(0), selectedMode, repetitions, duration);
                    connection.writeCommand(gifCommand);
                }
            }
            catch (ParseException ex) {
                Logger.getLogger(AddMediaDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void doOkSc501() {
        Gif.ExhibitionMode selectedMode = (Gif.ExhibitionMode)((Object)this.cmbExhibMode.getSelectedItem());
        if (!(this.selectedFiles != null && this.selectedFiles.size() != 0 || selectedMode.toString().equals("RESET"))) {
            GuiUtils.showErrorMessage(this, J18N.tr("Select a image first", new Object[0]));
        } else {
            try {
                boolean reset = false;
                this.repetitionSpinner.commitEdit();
                int repetitions = (Integer)this.repetitionSpinner.getValue();
                this.durationSpinner.commitEdit();
                int duration = (Integer)this.durationSpinner.getValue();
                if (selectedMode.toString().equals("RESET")) {
                    Log.debug(J18N.tr("[File: %s; Repetitions: %d; Duration: %d; Mode: %s]", new Object[]{"NULL", repetitions, duration, selectedMode}), new Object[0]);
                } else {
                    Log.debug(J18N.tr("[File: %s; Repetitions: %d; Duration: %d; Mode: %s]", new Object[]{this.selectedFiles.get(0), repetitions, duration, selectedMode}), new Object[0]);
                }
                Sc501Connection connection = (Sc501Connection)this.getConnection();
                LinkedList<Img> gifCmdList = new LinkedList<Img>();
                switch (this.cmbExhibMode.getSelectedItem().toString()) {
                    case "IMMEDIATELY": {
                        gifCmdList.add(new Img(this.selectedFiles.get(0), Img.ExhibitionModeImg.IMMEDIATELY, repetitions, duration));
                        break;
                    }
                    case "LOOP": {
                        gifCmdList.add(new Img(this.selectedFiles.get(0), Img.ExhibitionModeImg.LOOP, repetitions, duration));
                        break;
                    }
                    case "RESET": {
                        DataBuffer dataBuffer = new DataBuffer();
                        String header = new String();
                        header = header + "#img";
                        header = header + String.format("%02X", 255);
                        header = header + String.format("%02X", 0);
                        header = header + String.format("%02X", 0);
                        header = header + String.format("%02X", 0);
                        header = header + String.format("%04X", 0);
                        header = header + String.format("%04X", 0);
                        dataBuffer.putString(header);
                        dataBuffer.put((byte)23);
                        connection.write(dataBuffer.readBytes());
                        reset = true;
                        break;
                    }
                    default: {
                        gifCmdList.add(new Img(this.selectedFiles.get(0), Img.ExhibitionModeImg.IMMEDIATELY, repetitions, duration));
                    }
                }
                if (!reset) {
                    for (Img img : gifCmdList) {
                        connection.writeCommand(img);
                    }
                }
            }
            catch (ParseException ex) {
                Logger.getLogger(AddMediaDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void doOkTC504() {
        if (this.selectedFiles == null || this.selectedFiles.size() == 0) {
            GuiUtils.showErrorMessage(this, J18N.tr("Select one or more files first", new Object[0]));
        } else {
            long totalSize = 0L;
            for (File file : this.selectedFiles) {
                totalSize += file.length();
            }
            final long fTotalSize = totalSize;
            class MyFileSendListener
            implements Sc504Connection.FileSendListener {
                double currentFileOverallProgress = 0.0;
                double totalOverallProgress = 0.0;
                int sentFileCount = 0;
                boolean hasError = false;

                MyFileSendListener() {
                }

                @Override
                public void onSendProgress(Sc504Connection connection, String destPath, File srcFile, double progress, int filesize) {
                    this.currentFileOverallProgress = (double)filesize / (double)fTotalSize * progress;
                    double tmpTotalOverallProgress = this.totalOverallProgress + this.currentFileOverallProgress;
                    AddMediaDialog.this.progressBar.setVisible(true);
                    AddMediaDialog.this.progressBar.setValue((int)(tmpTotalOverallProgress * 100.0));
                }

                @Override
                public void onSendComplete(Sc504Connection connection, String destPath, File srcFile) {
                    ++this.sentFileCount;
                    this.totalOverallProgress += this.currentFileOverallProgress;
                    if (this.sentFileCount == AddMediaDialog.this.selectedFiles.size()) {
                        AddMediaDialog.this.dispose(true);
                    }
                    Log.debug(J18N.tr("Command sent to %s: IDvSendFile(%s, %s)", connection.getInetAddress().getHostAddress(), destPath, srcFile.getAbsolutePath()), new Object[0]);
                    Log.info(J18N.tr("Sent file \"%s\" to %s (%s)", srcFile.getName(), connection.getInetAddress().getHostAddress(), connection.getTerminalType().name()), new Object[0]);
                }

                @Override
                public void onError(Sc504Connection connection, String destPath, File srcFile, Throwable t) {
                    GuiUtils.showErrorMessage(AddMediaDialog.this, J18N.tr("Error sendind data: %s", t.getMessage()));
                    AddMediaDialog.this.dispose(true);
                    this.hasError = true;
                }

                public boolean hasError() {
                    return this.hasError;
                }
            }
            MyFileSendListener fileSendListener = new MyFileSendListener();
            for (File file : this.selectedFiles) {
                if (fileSendListener.hasError()) break;
                DataBuffer dataBuffer = new DataBuffer();
                if (this.rdbtnInternal.isSelected()) {
                    dataBuffer.putString("IMAGES/" + file.getName(), 128);
                    continue;
                }
                dataBuffer.putString("PREIMAGE/" + file.getName(), 128);
            }
            this.contentPanel.setEnabled(false);
            this.buttonPane.setEnabled(false);
        }
        this.dispose();
    }

    private void doOkSc504() {
        Sc504Connection sc504Connection = (Sc504Connection)this.getConnection();
        if (this.selectedFiles == null || this.selectedFiles.size() == 0) {
            GuiUtils.showErrorMessage(this, J18N.tr("Select one or more files first", new Object[0]));
        } else {
            long totalSize = 0L;
            for (File file : this.selectedFiles) {
                totalSize += file.length();
            }
            final long fTotalSize = totalSize;
            class MyFileSendListener
            implements Sc504Connection.FileSendListener {
                double currentFileOverallProgress = 0.0;
                double totalOverallProgress = 0.0;
                int sentFileCount = 0;
                boolean hasError = false;

                MyFileSendListener() {
                }

                @Override
                public void onSendProgress(Sc504Connection connection, String destPath, File srcFile, double progress, int filesize) {
                    this.currentFileOverallProgress = (double)filesize / (double)fTotalSize * progress;
                    double tmpTotalOverallProgress = this.totalOverallProgress + this.currentFileOverallProgress;
                    AddMediaDialog.this.progressBar.setVisible(true);
                    AddMediaDialog.this.progressBar.setValue((int)(tmpTotalOverallProgress * 100.0));
                }

                @Override
                public void onSendComplete(Sc504Connection connection, String destPath, File srcFile) {
                    ++this.sentFileCount;
                    this.totalOverallProgress += this.currentFileOverallProgress;
                    if (this.sentFileCount == AddMediaDialog.this.selectedFiles.size()) {
                        AddMediaDialog.this.dispose(true);
                    }
                    Log.debug(J18N.tr("Command sent to %s: IDvSendFile(%s, %s)", connection.getInetAddress().getHostAddress(), destPath, srcFile.getAbsolutePath()), new Object[0]);
                    Log.info(J18N.tr("Sent file \"%s\" to %s (%s)", srcFile.getName(), connection.getInetAddress().getHostAddress(), connection.getTerminalType().name()), new Object[0]);
                }

                @Override
                public void onError(Sc504Connection connection, String destPath, File srcFile, Throwable t) {
                    GuiUtils.showErrorMessage(AddMediaDialog.this, J18N.tr("Error sendind data: %s", t.getMessage()));
                    AddMediaDialog.this.dispose(true);
                    this.hasError = true;
                }

                public boolean hasError() {
                    return this.hasError;
                }
            }
            MyFileSendListener fileSendListener = new MyFileSendListener();
            for (File file : this.selectedFiles) {
                if (fileSendListener.hasError()) break;
                DataBuffer dataBuffer = new DataBuffer();
                if (sc504Connection.getTerminalType() == TerminalType.TC_504) {
                    dataBuffer.putString("IMAGES/" + file.getName(), 128);
                    Sc504MediaPanel edit = new Sc504MediaPanel(sc504Connection);
                    edit.addNewMedia(file.getPath(), file.getName());
                } else if (this.rdbtnExternal.isSelected()) {
                    dataBuffer.putString("SDCARD1/" + file.getName(), 128);
                } else {
                    dataBuffer.putString("INT_MEM/" + file.getName(), 128);
                }
                String filePath = dataBuffer.readString();
                sc504Connection.sendFile(new IDvSendFile(filePath, file), fileSendListener);
            }
            this.contentPanel.setEnabled(false);
            this.buttonPane.setEnabled(false);
        }
    }

    private void verificaTiposDeMidia(StringBuilder filePaths) {
        for (int j = 0; j < DEFAULT_IMAGE_SUFFIXES.length; ++j) {
            for (int k = 0; k < DEFAULT_VIDEO_SUFFIXES.length; ++k) {
                if (!filePaths.toString().contains(DEFAULT_VIDEO_SUFFIXES[k])) continue;
                ++this.videoCont;
            }
            if (filePaths.toString().contains(DEFAULT_IMAGE_SUFFIXES[j])) {
                ++this.imageCont;
            }
            if (this.videoCont > 0 && this.imageCont > 0) {
                this.temVideos = false;
                this.videosEFotos = true;
                continue;
            }
            if (this.videoCont > 0 && this.imageCont == 0) {
                this.temVideos = true;
                continue;
            }
            if (this.videoCont != 0 || this.imageCont <= 0) continue;
            this.temVideos = false;
        }
        this.videoCont = 0;
        this.imageCont = 0;
    }

    private void alteraConfigsDeDuracao() {
        if (this.temVideos) {
            this.lblDuration.setVisible(false);
            this.durationSpinner.setVisible(false);
        } else if (this.videosEFotos || !this.temVideos) {
            this.lblDuration.setVisible(true);
            this.durationSpinner.setVisible(true);
        }
    }

    private void registerListener() {
        this.registerSc501CommandListener("#sendmedia_ok\u0000", new CommandListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                Object object = AddMediaDialog.this.syncObject;
                synchronized (object) {
                    AddMediaDialog.this.okCounter++;
                    AddMediaDialog.this.isSocketOpen = true;
                    AddMediaDialog.this.syncObject.notify();
                    if (AddMediaDialog.this.okCounter == AddMediaDialog.this.mediasToSend) {
                        AddMediaDialog.this.getConnection().writeCommand(new GetListMediasQ());
                        AddMediaDialog.this.contentPanel.setEnabled(true);
                        AddMediaDialog.this.btnOk.setEnabled(true);
                        AddMediaDialog.this.dispose();
                    }
                }
            }
        });
        this.registerSc501CommandListener("#sendmedia_error", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                MediaError mediaError = (MediaError)command;
                Log.error(mediaError.toString(), new Object[0]);
            }
        });
    }

    public class SendMediaThread
    extends Thread {
        private AbstractTcConnection connection;
        private File file;

        public SendMediaThread(AbstractTcConnection connection, File file) {
            this.connection = connection;
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMedia() {
            try {
                Object object = AddMediaDialog.this.syncObject;
                synchronized (object) {
                    while (!AddMediaDialog.this.isSocketOpen) {
                        AddMediaDialog.this.syncObject.wait();
                    }
                    Media mediaCommand = new Media(this.file);
                    this.connection.writeCommand(mediaCommand);
                    AddMediaDialog.this.isSocketOpen = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            this.sendMedia();
        }
    }
}

