/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.gui.util.GuiPanel;
import br.com.gertec.tc.server.gui.util.GuiUtils;
import br.com.gertec.tc.server.gui.util.LogView;
import br.com.gertec.tc.server.log.DbLogStream;
import br.com.gertec.tc.server.log.DbLogStreamTableModel;
import br.com.gertec.tc.server.log.HtmlLogExporter;
import br.com.gertec.tc.server.log.Log;
import br.org.reconcavo.j18n.J18N;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class ApplicationLogDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final long LOG_MAX_AGE_DAYS = 30L;
    private static File lastExportDir = new File(System.getProperty("user.home"));
    private final JPanel contentPanel = new JPanel();
    private final DbLogStream dbLogStream;
    private final LogLevelCheckBox chkInfo;
    private final LogLevelCheckBox chkDebug;
    private final LogLevelCheckBox chkWarning;
    private final LogLevelCheckBox chkError;
    private final JTable logTable;
    private final DbLogStreamTableModel logModel;
    private final JButton btnExport;
    private final JButton btnExportCSV;
    private final JComboBox<TagEntry> cmbTag;
    private JButton btnClearOld;
    private JButton btnClear;
    private JCheckBox chckbxAutomaticCsv;

    public ApplicationLogDialog(DbLogStream dbLogStream) {
        this.dbLogStream = dbLogStream;
        this.setModal(true);
        this.setTitle(J18N.tr("Application log", new Object[0]));
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        GridBagLayout gblContentPanel = new GridBagLayout();
        gblContentPanel.rowWeights = new double[]{0.0, 0.0, 1.0, 1.0};
        gblContentPanel.columnWeights = new double[]{1.0, 1.0, 0.0, 0.0, 0.0};
        this.contentPanel.setLayout(gblContentPanel);
        ActionListener updateFilterListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationLogDialog.this.updateFilters();
            }
        };
        GuiPanel filterPanel = new GuiPanel();
        GridBagConstraints gbcFilterPanel = new GridBagConstraints();
        gbcFilterPanel.insets = new Insets(0, 0, 5, 5);
        gbcFilterPanel.fill = 1;
        gbcFilterPanel.gridx = 0;
        gbcFilterPanel.gridy = 0;
        this.contentPanel.add((Component)filterPanel, gbcFilterPanel);
        GridBagLayout gblFilterPanel = new GridBagLayout();
        gblFilterPanel.columnWidths = new int[]{0, 0, 0};
        gblFilterPanel.rowHeights = new int[]{0, 0};
        gblFilterPanel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gblFilterPanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        filterPanel.setLayout(gblFilterPanel);
        JLabel lblTag = new JLabel(J18N.tr("Tag", new Object[0]));
        GridBagConstraints gbcLblTag = new GridBagConstraints();
        gbcLblTag.insets = new Insets(0, 0, 0, 5);
        gbcLblTag.gridx = 0;
        gbcLblTag.gridy = 0;
        ((Container)filterPanel).add((Component)lblTag, gbcLblTag);
        List<String> tagList = Application.getDbLogStream().getTags();
        TagEntry[] tags = new TagEntry[tagList.size() + 1];
        tags[0] = new TagEntry(String.format("(%s)", J18N.tr("All", new Object[0])), null);
        int i = 1;
        for (String strTag : tagList) {
            tags[i] = new TagEntry(strTag);
            ++i;
        }
        this.cmbTag = new JComboBox();
        this.cmbTag.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel component = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                TagEntry tagEntry = (TagEntry)value;
                if (tagEntry == null) {
                    component.setText("");
                } else {
                    component.setText(tagEntry.title);
                }
                return component;
            }
        });
        this.cmbTag.setModel(new DefaultComboBoxModel<TagEntry>(tags));
        this.cmbTag.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ApplicationLogDialog.this.updateFilters();
                }
            }
        });
        GridBagConstraints gbcCmbTag = new GridBagConstraints();
        gbcCmbTag.fill = 2;
        gbcCmbTag.gridx = 1;
        gbcCmbTag.gridy = 0;
        ((Container)filterPanel).add(this.cmbTag, gbcCmbTag);
        JPanel checkBoxPanel = new JPanel();
        GridBagConstraints gbcCheckBoxPanel = new GridBagConstraints();
        gbcCheckBoxPanel.fill = 1;
        gbcCheckBoxPanel.insets = new Insets(0, 5, 5, 5);
        gbcCheckBoxPanel.gridx = 1;
        gbcCheckBoxPanel.gridy = 0;
        this.contentPanel.add((Component)checkBoxPanel, gbcCheckBoxPanel);
        GridBagLayout gblCheckBoxPanel = new GridBagLayout();
        gblCheckBoxPanel.columnWidths = new int[]{0, 0, 0, 0, 0};
        gblCheckBoxPanel.rowHeights = new int[]{0, 0};
        gblCheckBoxPanel.columnWeights = new double[]{1.0, 1.0, 1.0, 1.0, Double.MIN_VALUE};
        gblCheckBoxPanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        checkBoxPanel.setLayout(gblCheckBoxPanel);
        this.chkInfo = new LogLevelCheckBox(J18N.tr("INFO", new Object[0]), Log.LogLevel.INFO);
        this.chkInfo.setSelected(true);
        this.chkInfo.addActionListener(updateFilterListener);
        GridBagConstraints gbcChkInfo = new GridBagConstraints();
        gbcChkInfo.anchor = 17;
        gbcChkInfo.insets = new Insets(0, 0, 0, 5);
        gbcChkInfo.gridx = 0;
        gbcChkInfo.gridy = 0;
        checkBoxPanel.add((Component)this.chkInfo, gbcChkInfo);
        this.chkDebug = new LogLevelCheckBox(J18N.tr("DEBUG", new Object[0]), Log.LogLevel.DEBUG);
        this.chkDebug.setSelected(Application.DEBUG_ENABLED);
        this.chkDebug.addActionListener(updateFilterListener);
        this.chkDebug.setVisible(Application.DEBUG_ENABLED);
        GridBagConstraints gbcChkDebug = new GridBagConstraints();
        gbcChkDebug.anchor = 17;
        gbcChkDebug.insets = new Insets(0, 0, 0, 5);
        gbcChkDebug.gridx = 1;
        gbcChkDebug.gridy = 0;
        checkBoxPanel.add((Component)this.chkDebug, gbcChkDebug);
        this.chkWarning = new LogLevelCheckBox(J18N.tr("WARNING", new Object[0]), Log.LogLevel.WARNING);
        this.chkWarning.setSelected(true);
        this.chkWarning.addActionListener(updateFilterListener);
        GridBagConstraints gbcChkWarning = new GridBagConstraints();
        gbcChkWarning.anchor = 17;
        gbcChkWarning.insets = new Insets(0, 0, 0, 5);
        gbcChkWarning.gridx = 2;
        gbcChkWarning.gridy = 0;
        checkBoxPanel.add((Component)this.chkWarning, gbcChkWarning);
        this.chkError = new LogLevelCheckBox(J18N.tr("ERROR", new Object[0]), Log.LogLevel.ERROR);
        this.chkError.setSelected(true);
        this.chkError.addActionListener(updateFilterListener);
        GridBagConstraints gbcChkError = new GridBagConstraints();
        gbcChkError.anchor = 17;
        gbcChkError.gridx = 3;
        gbcChkError.gridy = 0;
        checkBoxPanel.add((Component)this.chkError, gbcChkError);
        this.btnExport = new JButton(J18N.tr("Export HTML", new Object[0]) + "...");
        this.btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void approveSelection() {
                        File f = this.getSelectedFile();
                        if (f.exists()) {
                            int result = JOptionPane.showConfirmDialog(this, J18N.tr("The file exists, overwrite?", new Object[0]), J18N.tr("Confirm overwrite", new Object[0]), 1, 2);
                            switch (result) {
                                case 0: {
                                    super.approveSelection();
                                    return;
                                }
                                case 2: {
                                    this.cancelSelection();
                                    return;
                                }
                            }
                            return;
                        }
                        super.approveSelection();
                    }
                };
                fileChooser.setCurrentDirectory(lastExportDir);
                fileChooser.setFileFilter(new FileNameExtensionFilter(J18N.tr("HTML file", new Object[0]), "html"));
                int result = fileChooser.showSaveDialog(ApplicationLogDialog.this);
                if (result == 0) {
                    File outputFile = fileChooser.getSelectedFile();
                    lastExportDir = outputFile.getParentFile();
                    HtmlLogExporter logExporter = HtmlLogExporter.getInstance();
                    List<? extends Log.LogEntry> logEntries = ApplicationLogDialog.this.logModel.getLogEntries();
                    ApplicationLogDialog.this.exportProgress(logExporter, logEntries, outputFile);
                }
            }
        });
        GridBagConstraints gbcBtnExport = new GridBagConstraints();
        gbcBtnExport.insets = new Insets(0, 5, 5, 5);
        gbcBtnExport.fill = 2;
        gbcBtnExport.gridx = 2;
        gbcBtnExport.gridy = 0;
        this.contentPanel.add((Component)this.btnExport, gbcBtnExport);
        this.logModel = new DbLogStreamTableModel(dbLogStream);
        this.logTable = new JTable();
        this.logTable.setModel(this.logModel);
        this.logTable.setFillsViewportHeight(true);
        this.logTable.setDefaultRenderer(DbLogStreamTableModel.LogTag.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                label.setHorizontalAlignment(0);
                DbLogStreamTableModel.LogTag logTag = (DbLogStreamTableModel.LogTag)value;
                if (logTag.toString() == null) {
                    label.setText(String.format("(%s)", J18N.tr("none", new Object[0])));
                    label.setForeground(Color.GRAY);
                } else {
                    label.setText(logTag.toString());
                    label.setForeground(UIManager.getColor("Button.foreground"));
                }
                return label;
            }
        });
        this.logTable.setDefaultRenderer(Date.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;
            private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                label.setHorizontalAlignment(0);
                Date date = (Date)value;
                label.setText(this.sdf.format(date));
                return label;
            }
        });
        this.logTable.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value == null) {
                    label.setText(String.format("(%s)", J18N.tr("none", new Object[0])));
                    label.setForeground(Color.GRAY);
                } else {
                    label.setForeground(UIManager.getColor("Button.foreground"));
                }
                return label;
            }
        });
        this.logTable.setDefaultRenderer(Log.LogLevel.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                label.setHorizontalAlignment(0);
                if (value == null) {
                    label.setText(String.format("(%s)", J18N.tr("none", new Object[0])));
                    label.setForeground(Color.GRAY);
                } else {
                    Color fg;
                    Log.LogLevel level = (Log.LogLevel)((Object)value);
                    switch (level) {
                        case DEBUG: {
                            fg = LogView.FG_DEBUG;
                            break;
                        }
                        case INFO: {
                            fg = LogView.FG_INFO;
                            break;
                        }
                        case WARNING: {
                            fg = LogView.FG_WARNING;
                            break;
                        }
                        case ERROR: {
                            fg = LogView.FG_ERROR;
                            break;
                        }
                        default: {
                            fg = LogView.FG_COLOR;
                        }
                    }
                    label.setText(level.getLabel());
                    label.setForeground(fg);
                }
                return label;
            }
        });
        this.btnExportCSV = new JButton(J18N.tr("Export CSV", new Object[0]) + "...");
        this.btnExportCSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void approveSelection() {
                        File f = this.getSelectedFile();
                        if (f.exists()) {
                            int result = JOptionPane.showConfirmDialog(this, J18N.tr("The file exists, overwrite?", new Object[0]), J18N.tr("Confirm overwrite", new Object[0]), 1, 2);
                            switch (result) {
                                case 0: {
                                    super.approveSelection();
                                    return;
                                }
                                case 2: {
                                    this.cancelSelection();
                                    return;
                                }
                            }
                            return;
                        }
                        super.approveSelection();
                    }
                };
                fileChooser.setCurrentDirectory(lastExportDir);
                fileChooser.setFileFilter(new FileNameExtensionFilter(J18N.tr("CSV Files", new Object[0]), "csv"));
                int result = fileChooser.showSaveDialog(ApplicationLogDialog.this);
                if (result == 0) {
                    File outputFile = fileChooser.getSelectedFile();
                    lastExportDir = outputFile.getParentFile();
                    System.out.println(outputFile.getAbsolutePath());
                    ApplicationLogDialog.this.exportToCSV(ApplicationLogDialog.this.logTable, outputFile.getAbsolutePath());
                }
            }
        });
        GridBagConstraints gbcBtnExportCSV = new GridBagConstraints();
        gbcBtnExportCSV.fill = 2;
        gbcBtnExportCSV.insets = new Insets(0, 5, 5, 5);
        gbcBtnExportCSV.gridx = 3;
        gbcBtnExportCSV.gridy = 0;
        this.contentPanel.add((Component)this.btnExportCSV, gbcBtnExportCSV);
        this.btnClearOld = new JButton(J18N.tr("Clear old entries", new Object[0]) + "...");
        this.btnClearOld.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = JOptionPane.showConfirmDialog(ApplicationLogDialog.this, J18N.tr("Log entries older than %d days will be deleted. Proceed?", 30L), Application.APP_NAME, 0, 2);
                if (result == 0) {
                    long minDateTimestamp = new Date().getTime() - 2592000000L;
                    Date minDate = new Date(minDateTimestamp);
                    ApplicationLogDialog.this.getDbLogStream().deleteEntriesOlderThan(minDate);
                    ApplicationLogDialog.this.logModel.reload();
                }
            }
        });
        GridBagConstraints gbcBtnClearold = new GridBagConstraints();
        gbcBtnClearold.fill = 2;
        gbcBtnClearold.insets = new Insets(0, 6, 5, 0);
        gbcBtnClearold.gridx = 4;
        gbcBtnClearold.gridy = 0;
        this.contentPanel.add((Component)this.btnClearOld, gbcBtnClearold);
        this.btnClear = new JButton(J18N.tr("Clear all", new Object[0]) + "...");
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = JOptionPane.showConfirmDialog(ApplicationLogDialog.this, J18N.tr("All log entries will be deleted. Proceed?", new Object[0]), Application.APP_NAME, 0, 2);
                if (result == 0) {
                    ApplicationLogDialog.this.getDbLogStream().deleteEntriesOlderThan(new Date());
                    ApplicationLogDialog.this.logModel.reload();
                }
            }
        });
        this.btnClear.setVisible(Application.DEBUG_ENABLED);
        GridBagConstraints gbcBtnClear = new GridBagConstraints();
        gbcBtnClear.insets = new Insets(0, 5, 5, 0);
        gbcBtnClear.gridx = 4;
        gbcBtnClear.gridy = 0;
        this.contentPanel.add((Component)this.btnClear, gbcBtnClear);
        this.chckbxAutomaticCsv = new JCheckBox(J18N.tr("Automatic CSV Export", new Object[0]));
        GridBagConstraints gbc_chckbxNewCheckBox_1 = new GridBagConstraints();
        gbc_chckbxNewCheckBox_1.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxNewCheckBox_1.gridx = 1;
        gbc_chckbxNewCheckBox_1.gridy = 1;
        this.contentPanel.add((Component)this.chckbxAutomaticCsv, gbc_chckbxNewCheckBox_1);
        this.chckbxAutomaticCsv.setSelected(Application.SETTINGS.getBoolean("EXPORT_CSV_ENABLED"));
        this.chckbxAutomaticCsv.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enableExport = e.getStateChange() == 1;
                try {
                    String configurationTime = Application.getTimeFromFile();
                    String configurationDays = Application.getDaysFromFile();
                    Application.SETTINGS.setProperty("EXPORT_CSV_TIME", configurationTime);
                    Application.SETTINGS.setProperty("EXPORT_CSV_ERASE_DAYS", configurationDays);
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                Application.SETTINGS.setProperty("EXPORT_CSV_ENABLED", enableExport);
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.logTable);
        GridBagConstraints gbcScrollPane = new GridBagConstraints();
        gbcScrollPane.insets = new Insets(5, 0, 0, 0);
        gbcScrollPane.fill = 1;
        gbcScrollPane.weightx = 1.0;
        gbcScrollPane.weighty = 1.0;
        gbcScrollPane.gridx = 0;
        gbcScrollPane.gridy = 2;
        gbcScrollPane.gridwidth = 5;
        this.contentPanel.add((Component)scrollPane, gbcScrollPane);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationLogDialog.this.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.updateFilters();
        this.pack();
    }

    public final DbLogStream getDbLogStream() {
        return this.dbLogStream;
    }

    private Log.LogLevel[] getFilter(boolean selected, LogLevelCheckBox ... checkboxes) {
        LinkedList<Log.LogLevel> logLevelList = new LinkedList<Log.LogLevel>();
        for (LogLevelCheckBox checkBox : checkboxes) {
            if (checkBox.isSelected() != selected) continue;
            logLevelList.add(checkBox.getLogLevel());
        }
        Log.LogLevel[] filter = new Log.LogLevel[logLevelList.size()];
        return logLevelList.toArray(filter);
    }

    private void updateFilters() {
        TagEntry tagEntry = (TagEntry)this.cmbTag.getSelectedItem();
        this.logModel.setTag(tagEntry.tag);
        this.logModel.setShownLevels(this.getFilter(true, this.chkDebug, this.chkInfo, this.chkWarning, this.chkError));
        this.logModel.setHiddenLevels(this.getFilter(false, this.chkDebug, this.chkInfo, this.chkWarning, this.chkError));
        this.createProgress();
    }

    private void createProgress() {
        final JDialog dlg = new JDialog(this, J18N.tr("Loading log", new Object[0]), true);
        final JProgressBar dpb = new JProgressBar();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Application.EVENT_LOOP.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            dpb.setIndeterminate(true);
                            dlg.getContentPane().add("Center", dpb);
                            dlg.setDefaultCloseOperation(0);
                            dlg.setSize(300, 50);
                            dlg.setLocationRelativeTo(ApplicationLogDialog.this);
                            dlg.setVisible(true);
                        }
                    });
                    ApplicationLogDialog.this.logModel.reload(false);
                    Thread.sleep(1000L);
                    Application.EVENT_LOOP.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ApplicationLogDialog.this.logModel.fireTableStructureChanged();
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                finally {
                    dlg.setVisible(false);
                }
            }
        };
        Thread fetchThread = new Thread(runnable);
        fetchThread.setName("log-fetch-thread");
        fetchThread.start();
    }

    private void exportProgress(final HtmlLogExporter logExporter, final List<? extends Log.LogEntry> logEntries, final File outputFile) {
        final JDialog dlg = new JDialog(this, "Exportando Log", true);
        final JProgressBar dpb = new JProgressBar();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Application.EVENT_LOOP.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            dpb.setIndeterminate(true);
                            dlg.getContentPane().add("Center", dpb);
                            dlg.setDefaultCloseOperation(0);
                            dlg.setSize(300, 50);
                            dlg.setLocationRelativeTo(ApplicationLogDialog.this);
                            dlg.setVisible(true);
                        }
                    });
                    logExporter.export(logEntries, outputFile);
                    Application.EVENT_LOOP.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane optionPane = new JOptionPane(J18N.tr("Log successfully exported to %s", outputFile.getAbsolutePath()));
                            JDialog myDialog = optionPane.createDialog(ApplicationLogDialog.this, J18N.tr("Message", new Object[0]));
                            myDialog.setModal(true);
                            myDialog.setVisible(true);
                        }
                    });
                    Thread.sleep(1000L);
                    Application.EVENT_LOOP.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ApplicationLogDialog.this.logModel.fireTableStructureChanged();
                        }
                    });
                }
                catch (IOException ex) {
                    Application.EVENT_LOOP.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GuiUtils.showErrorMessage(ApplicationLogDialog.this, J18N.tr("Failure exporting log: %s", ex.getMessage()));
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                finally {
                    dlg.setVisible(false);
                }
            }
        };
        Thread fetchThread = new Thread(runnable);
        fetchThread.start();
    }

    public void exportToCSV(final JTable tableToExport, final String pathToExportTo) {
        final JDialog dlg = new JDialog(this, "Exportando Log", true);
        final JProgressBar dpb = new JProgressBar();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int i;
                    Application.EVENT_LOOP.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            dpb.setIndeterminate(true);
                            dlg.getContentPane().add("Center", dpb);
                            dlg.setDefaultCloseOperation(0);
                            dlg.setSize(300, 50);
                            dlg.setLocationRelativeTo(ApplicationLogDialog.this);
                            dlg.setVisible(true);
                        }
                    });
                    TableModel model = tableToExport.getModel();
                    FileWriter csv = new FileWriter(new File(pathToExportTo) + ".csv");
                    for (i = 0; i < model.getColumnCount(); ++i) {
                        csv.write(model.getColumnName(i) + ";");
                    }
                    csv.write("\n");
                    for (i = 0; i < model.getRowCount(); ++i) {
                        for (int j = 0; j < model.getColumnCount(); ++j) {
                            csv.write(model.getValueAt(i, j).toString() + ";");
                        }
                        csv.write("\n");
                    }
                    System.out.println("sucesso");
                    csv.close();
                    Application.EVENT_LOOP.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane optionPane = new JOptionPane(J18N.tr("Log successfully exported to %s", pathToExportTo));
                            JDialog myDialog = optionPane.createDialog(ApplicationLogDialog.this, J18N.tr("Message", new Object[0]));
                            myDialog.setModal(true);
                            myDialog.setVisible(true);
                        }
                    });
                    Thread.sleep(1000L);
                    Application.EVENT_LOOP.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ApplicationLogDialog.this.logModel.fireTableStructureChanged();
                        }
                    });
                }
                catch (IOException ex) {
                    Application.EVENT_LOOP.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GuiUtils.showErrorMessage(ApplicationLogDialog.this, J18N.tr("Failure exporting log: %s", ex.getMessage()));
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                finally {
                    dlg.setVisible(false);
                }
            }
        };
        Thread fetchThread = new Thread(runnable);
        fetchThread.start();
    }

    private static class TagEntry {
        public final String title;
        public final String tag;

        public TagEntry(String title, String tag) {
            this.title = title;
            this.tag = tag;
        }

        public TagEntry(String tag) {
            this(tag, tag);
        }
    }

    private static class LogLevelCheckBox
    extends JCheckBox {
        private static final long serialVersionUID = 1L;
        private final Log.LogLevel logLevel;

        public LogLevelCheckBox(String text, Log.LogLevel logLevel) {
            super(text);
            this.logLevel = logLevel;
        }

        public Log.LogLevel getLogLevel() {
            return this.logLevel;
        }
    }
}

