/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.ApplicationSettings;
import br.com.gertec.tc.server.gui.util.GuiDialog;
import br.com.gertec.tc.server.gui.util.GuiUtils;
import br.org.reconcavo.j18n.J18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

public class ChangePasswordDialog
extends GuiDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private final JLabel lblOldPassword;
    private final JPasswordField pwdOld;
    private final JLabel lblNewPassword;
    private final JPasswordField pwdNew;
    private final JLabel lblConfirmation;
    private final JPasswordField pwdConfirm;
    private final JButton btnOk;
    private final JButton btnCancel;

    public ChangePasswordDialog() {
        this.setResizable(false);
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagLayout gblContentPanel = new GridBagLayout();
        gblContentPanel.columnWidths = new int[]{252, 0};
        gblContentPanel.rowHeights = new int[]{67, 19, 0};
        gblContentPanel.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gblContentPanel.rowWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        this.contentPanel.setLayout(gblContentPanel);
        JPanel pwdFieldsPanel = new JPanel();
        GridBagConstraints gbcPwdFieldsPanel = new GridBagConstraints();
        gbcPwdFieldsPanel.fill = 1;
        gbcPwdFieldsPanel.insets = new Insets(0, 0, 5, 0);
        gbcPwdFieldsPanel.gridx = 0;
        gbcPwdFieldsPanel.gridy = 0;
        this.contentPanel.add((Component)pwdFieldsPanel, gbcPwdFieldsPanel);
        GridBagLayout gblPwdFieldsPanel = new GridBagLayout();
        gblPwdFieldsPanel.columnWidths = new int[]{0, 0, 0};
        gblPwdFieldsPanel.rowHeights = new int[]{0, 0, 0, 0};
        gblPwdFieldsPanel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gblPwdFieldsPanel.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        pwdFieldsPanel.setLayout(gblPwdFieldsPanel);
        this.lblOldPassword = new JLabel();
        GridBagConstraints gbcLblOldPassword = new GridBagConstraints();
        gbcLblOldPassword.anchor = 17;
        gbcLblOldPassword.gridx = 0;
        gbcLblOldPassword.gridy = 0;
        pwdFieldsPanel.add((Component)this.lblOldPassword, gbcLblOldPassword);
        this.pwdOld = new JPasswordField(15);
        GridBagConstraints gbcPwdOld = new GridBagConstraints();
        gbcPwdOld.fill = 2;
        gbcPwdOld.insets = new Insets(0, 5, 0, 0);
        gbcPwdOld.gridx = 1;
        gbcPwdOld.gridy = 0;
        pwdFieldsPanel.add((Component)this.pwdOld, gbcPwdOld);
        this.lblNewPassword = new JLabel();
        GridBagConstraints gbcLblNewPassword = new GridBagConstraints();
        gbcLblNewPassword.anchor = 17;
        gbcLblNewPassword.insets = new Insets(5, 0, 0, 0);
        gbcLblNewPassword.gridx = 0;
        gbcLblNewPassword.gridy = 1;
        pwdFieldsPanel.add((Component)this.lblNewPassword, gbcLblNewPassword);
        this.pwdNew = new JPasswordField(15);
        GridBagConstraints gbcPwdNew = new GridBagConstraints();
        gbcPwdNew.fill = 2;
        gbcPwdNew.insets = new Insets(5, 5, 0, 0);
        gbcPwdNew.gridx = 1;
        gbcPwdNew.gridy = 1;
        pwdFieldsPanel.add((Component)this.pwdNew, gbcPwdNew);
        this.lblConfirmation = new JLabel();
        GridBagConstraints gbcLblConfirmation = new GridBagConstraints();
        gbcLblConfirmation.anchor = 17;
        gbcLblConfirmation.insets = new Insets(5, 0, 0, 0);
        gbcLblConfirmation.gridx = 0;
        gbcLblConfirmation.gridy = 2;
        pwdFieldsPanel.add((Component)this.lblConfirmation, gbcLblConfirmation);
        this.pwdConfirm = new JPasswordField(15);
        GridBagConstraints gbcPwdConfirm = new GridBagConstraints();
        gbcPwdConfirm.insets = new Insets(5, 5, 0, 0);
        gbcPwdConfirm.fill = 2;
        gbcPwdConfirm.gridx = 1;
        gbcPwdConfirm.gridy = 2;
        pwdFieldsPanel.add((Component)this.pwdConfirm, gbcPwdConfirm);
        JPanel panel1 = new JPanel();
        GridBagConstraints gbcPanel1 = new GridBagConstraints();
        gbcPanel1.fill = 1;
        gbcPanel1.gridx = 0;
        gbcPanel1.gridy = 1;
        this.contentPanel.add((Component)panel1, gbcPanel1);
        panel1.setLayout(new GridLayout(0, 2, 5, 0));
        this.btnOk = new JButton();
        panel1.add(this.btnOk);
        this.btnCancel = new JButton();
        panel1.add(this.btnCancel);
        ActionListener okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangePasswordDialog.this.changePassword();
            }
        };
        ActionListener cancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangePasswordDialog.this.dispose();
            }
        };
        this.btnCancel.addActionListener(cancelListener);
        this.btnOk.addActionListener(okListener);
        this.getRootPane().setDefaultButton(this.btnOk);
        this.getRootPane().registerKeyboardAction(cancelListener, KeyStroke.getKeyStroke(27, 0), 2);
        this.retranslateUi();
    }

    private void retranslateUi() {
        this.lblOldPassword.setText(J18N.tr("Old Password", new Object[0]) + ":");
        this.lblNewPassword.setText(J18N.tr("New Password", new Object[0]) + ":");
        this.lblConfirmation.setText(J18N.tr("Confirmation", new Object[0]) + ":");
        this.btnOk.setText(J18N.tr("OK", new Object[0]));
        this.btnCancel.setText(J18N.tr("Cancel", new Object[0]));
        this.pack();
    }

    private void changePassword() {
        char[] passwordNew = this.pwdNew.getPassword();
        char[] passwordConfirmation = this.pwdConfirm.getPassword();
        if (!this.isPasswordValid(this.pwdOld.getPassword())) {
            GuiUtils.showWarningMessage(this, J18N.tr("Invalid password", new Object[0]));
            return;
        }
        if (!Arrays.equals(passwordNew, passwordConfirmation)) {
            GuiUtils.showWarningMessage(this, J18N.tr("Entered passwords do not match", new Object[0]));
            return;
        }
        ApplicationSettings.getInstance().setEncryptedProperty("PASSWORD", passwordNew);
        GuiUtils.showInfoMessage(this, J18N.tr("Password successfully changed", new Object[0]));
        this.dispose(true);
    }

    private boolean isPasswordValid(char[] password) {
        ApplicationSettings settings = ApplicationSettings.getInstance();
        return Objects.equals(settings.getEncryptedProperty("PASSWORD"), String.valueOf(password));
    }
}

