/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.gui.util.GuiPanel;
import br.com.gertec.tc.server.gui.util.GuiTcDialog;
import br.com.gertec.tc.server.gui.util.GuiUtils;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.CommandListener;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc501.commands.ParamConfig;
import br.com.gertec.tc.server.protocol.sc501.commands.ParamConfigQ;
import br.com.gertec.tc.server.protocol.sc501.commands.RParamConfig;
import br.com.gertec.tc.server.protocol.sc501.commands.RParamConfigCompatG2;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.j18n.J18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class ConfigIpDinamicDialog
extends GuiTcDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new GuiPanel();
    private final JRadioButton rbFixed;
    private final JRadioButton rbDynamic;
    private final GuiPanel ipModePanel;
    private final TitledBorder ipModeTitledBoder;
    private final JButton btnOk;
    private final JButton btnCancel;

    public ConfigIpDinamicDialog(AbstractTcConnection connection) {
        super(connection);
        this.setTitle(J18N.tr("DHCP - %s (%s)", connection.getInetAddress().getHostAddress(), connection.getTerminal().getTcName()));
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        GridBagLayout gblContentPanel = new GridBagLayout();
        gblContentPanel.columnWeights = new double[]{1.0};
        gblContentPanel.rowWeights = new double[]{0.0, 1.0};
        gblContentPanel.rowHeights = new int[]{0, 0};
        this.contentPanel.setLayout(gblContentPanel);
        ButtonGroup group = new ButtonGroup();
        ActionListener radioActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigIpDinamicDialog.this.onUiChange();
                ConfigIpDinamicDialog.this.pack();
            }
        };
        this.ipModePanel = new GuiPanel();
        this.ipModeTitledBoder = new TitledBorder(null, J18N.tr("IP mode", new Object[0]), 4, 2, null, null);
        this.ipModePanel.setBorder(this.ipModeTitledBoder);
        GridBagConstraints gbcIpModePanel = new GridBagConstraints();
        gbcIpModePanel.fill = 1;
        gbcIpModePanel.gridx = 0;
        gbcIpModePanel.gridy = 0;
        this.contentPanel.add((Component)this.ipModePanel, gbcIpModePanel);
        GridBagLayout gblIpModePanel = new GridBagLayout();
        gblIpModePanel.columnWidths = new int[]{0, 0};
        gblIpModePanel.rowHeights = new int[]{0, 0, 0};
        gblIpModePanel.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gblIpModePanel.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.ipModePanel.setLayout(gblIpModePanel);
        this.rbDynamic = new JRadioButton(J18N.tr("Dynamic IP", new Object[0]));
        this.rbDynamic.addActionListener(radioActionListener);
        GridBagConstraints gbcRbDynamic = new GridBagConstraints();
        gbcRbDynamic.anchor = 17;
        gbcRbDynamic.insets = new Insets(5, 5, 0, 5);
        gbcRbDynamic.gridx = 0;
        gbcRbDynamic.gridy = 0;
        this.ipModePanel.add((Component)this.rbDynamic, gbcRbDynamic);
        group.add(this.rbDynamic);
        this.rbFixed = new JRadioButton(J18N.tr("Fixed IP", new Object[0]));
        this.rbFixed.addActionListener(radioActionListener);
        GridBagConstraints gbcRbFixed = new GridBagConstraints();
        gbcRbFixed.insets = new Insets(5, 5, 5, 5);
        gbcRbFixed.anchor = 17;
        gbcRbFixed.gridx = 0;
        gbcRbFixed.gridy = 1;
        this.ipModePanel.add((Component)this.rbFixed, gbcRbFixed);
        group.add(this.rbFixed);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.btnOk = new JButton(J18N.tr("Save", new Object[0]));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigIpDinamicDialog.this.save();
            }
        });
        buttonPane.add(this.btnOk);
        this.btnCancel = new JButton(J18N.tr("Cancel", new Object[0]));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigIpDinamicDialog.this.dispose();
            }
        });
        buttonPane.add(this.btnCancel);
        this.setDefaultButton(this.btnOk);
        this.setCancelButton(this.btnCancel);
        this.init();
    }

    private void init() {
        this.registerListeners();
        this.requestTerminalInfo();
        this.onUiChange();
        this.contentPanel.setEnabled(false);
        this.btnOk.setEnabled(false);
        this.pack();
    }

    private void registerListeners() {
        this.registerSc501CommandListener("#paramconfig", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                ConfigIpDinamicDialog.this.contentPanel.setEnabled(true);
                ConfigIpDinamicDialog.this.btnOk.setEnabled(true);
                ParamConfig response = (ParamConfig)command;
                if (response.isDhcpEnabled()) {
                    ConfigIpDinamicDialog.this.rbDynamic.setSelected(true);
                    ConfigIpDinamicDialog.this.rbDynamic.doClick();
                } else {
                    ConfigIpDinamicDialog.this.rbFixed.setSelected(true);
                    ConfigIpDinamicDialog.this.rbFixed.doClick();
                }
                ConfigIpDinamicDialog.this.onUiChange();
            }
        });
        this.registerSc501CommandListener("#rparamconfig_ok\u0000", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                ConfigIpDinamicDialog.this.dispose();
            }
        });
        this.registerSc501CommandListener("#rparamconfig_error\u0000", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                Log.error(J18N.tr("Error in extra settings of Network Parameters", new Object[0]), new Object[0]);
            }
        });
    }

    public void requestTerminalInfo() {
        AbstractTcConnection connection = this.getConnection();
        if (!connection.getTerminal().isSc501()) {
            throw new UnsupportedOperationException();
        }
        connection.writeCommand(new ParamConfigQ());
    }

    private void save() {
        this.contentPanel.setEnabled(false);
        this.btnOk.setEnabled(false);
        this.btnCancel.setEnabled(false);
        AbstractTcConnection connection = this.getConnection();
        if (connection.isSc501()) {
            if (connection.getTerminalType().equals((Object)TerminalType.TC_406)) {
                RParamConfigCompatG2 params1 = new RParamConfigCompatG2(this.rbDynamic.isSelected());
                connection.writeCommand(params1);
            } else if (connection.getTerminalType().equals((Object)TerminalType.TC_506_S)) {
                RParamConfigCompatG2 params1 = new RParamConfigCompatG2(this.rbDynamic.isSelected());
                connection.writeCommand(params1);
            } else {
                RParamConfig params1 = new RParamConfig(this.rbDynamic.isSelected());
                connection.writeCommand(params1);
            }
        } else {
            throw new UnsupportedOperationException();
        }
        this.dispose();
        connection.close();
        GuiUtils.showWarningMessage(null, J18N.tr("Settings saved! The terminal will restart", new Object[0]));
    }

    private void onUiChange() {
        if (!this.rbDynamic.isSelected()) {
            // empty if block
        }
    }
}

