/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.gui.util.GuiPanel;
import br.com.gertec.tc.server.gui.util.GuiTcDialog;
import br.com.gertec.tc.server.gui.util.GuiUtils;
import br.com.gertec.tc.server.gui.util.JTextFieldLimit;
import br.com.gertec.tc.server.gui.util.TextField;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.CommandListener;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc501.Sc501Connection;
import br.com.gertec.tc.server.protocol.sc501.commands.Config02;
import br.com.gertec.tc.server.protocol.sc501.commands.Config02Q;
import br.com.gertec.tc.server.protocol.sc501.commands.ExtConfig;
import br.com.gertec.tc.server.protocol.sc501.commands.ExtConfigQ;
import br.com.gertec.tc.server.protocol.sc501.commands.REConf02;
import br.com.gertec.tc.server.protocol.sc504.Sc504Connection;
import br.com.gertec.tc.server.protocol.sc504.commands.IDGetAudioStatus;
import br.com.gertec.tc.server.protocol.sc504.commands.IDGetBrightness;
import br.com.gertec.tc.server.protocol.sc504.commands.IDGetSensorStatus;
import br.com.gertec.tc.server.protocol.sc504.commands.IDGetVolume;
import br.com.gertec.tc.server.protocol.sc504.commands.IDbGetEnableKey;
import br.com.gertec.tc.server.protocol.sc504.commands.IDbGetLEC;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvGetTimeExhib;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.j18n.J18N;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class ConfigLineDialog
extends GuiTcDialog {
    private static final long serialVersionUID = 1L;
    private static final String IP_REGEX = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private final GuiPanel contentPane;
    private final GuiPanel displayTimePanel;
    private final JLabel lblDisplayTime;
    private final JSpinner spinnerDisplayTime;
    private final JLabel lblSeconds;
    private final JLabel lblNetmask;
    private final JTextField txtNetMask;
    private final JLabel lblIpTerminal;
    private final JTextField txtIpTerminal;
    private final GuiPanel linePanel;
    private final JLabel lblLine1;
    private final JTextField txtLine1;
    private final JLabel lblLine2;
    private final JTextField txtLine2;
    private final JLabel lblLine3;
    private final JTextField txtLine3;
    private final JLabel lblLine4;
    private final JTextField txtLine4;
    private final JButton btnOk;
    private final JButton btnCancel;
    private Config02.ConfigParams sc501Params;

    private static boolean validateInput(JTextField field) {
        String text = field.getText();
        Pattern pattern = Pattern.compile(IP_REGEX);
        Matcher m = pattern.matcher(text);
        if (m.matches()) {
            field.setForeground(Color.BLACK);
            return true;
        }
        field.setForeground(Color.RED);
        return false;
    }

    public ConfigLineDialog(AbstractTcConnection connection) {
        super(connection);
        this.setTitle(J18N.tr(J18N.tr("Text", new Object[0]) + " / " + J18N.tr("Network", new Object[0]) + " - %s (%s)", connection.getInetAddress().getHostAddress(), connection.getTerminal().getTcName()));
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPane = new GuiPanel();
        this.getContentPane().add((Component)this.contentPane, "Center");
        GridBagLayout gblContentPane = new GridBagLayout();
        gblContentPane.columnWidths = new int[]{0, 0};
        gblContentPane.rowHeights = new int[]{0, 0, 0, 0};
        gblContentPane.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gblContentPane.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.contentPane.setLayout(gblContentPane);
        this.displayTimePanel = new GuiPanel();
        GridBagConstraints gbcDisplayTimePanel = new GridBagConstraints();
        gbcDisplayTimePanel.fill = 2;
        gbcDisplayTimePanel.insets = new Insets(5, 5, 0, 5);
        gbcDisplayTimePanel.gridx = 0;
        gbcDisplayTimePanel.gridy = 0;
        this.contentPane.add((Component)this.displayTimePanel, gbcDisplayTimePanel);
        GridBagLayout gblDisplayTimePanel = new GridBagLayout();
        gblDisplayTimePanel.columnWidths = new int[]{0, 0, 0, 0};
        gblDisplayTimePanel.rowHeights = new int[]{0, 0};
        gblDisplayTimePanel.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gblDisplayTimePanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.displayTimePanel.setLayout(gblDisplayTimePanel);
        this.lblDisplayTime = new JLabel(J18N.tr("Display Time", new Object[0]) + ":");
        GridBagConstraints gbcLblDisplayTime = new GridBagConstraints();
        gbcLblDisplayTime.anchor = 17;
        gbcLblDisplayTime.gridx = 0;
        gbcLblDisplayTime.gridy = 0;
        this.displayTimePanel.add((Component)this.lblDisplayTime, gbcLblDisplayTime);
        this.spinnerDisplayTime = new JSpinner();
        this.spinnerDisplayTime.setModel(new SpinnerNumberModel(3, 1, 30, 1));
        ((JSpinner.DefaultEditor)this.spinnerDisplayTime.getEditor()).getTextField().setEditable(false);
        GridBagConstraints gbcSpinnerDisplayTime = new GridBagConstraints();
        gbcSpinnerDisplayTime.fill = 2;
        gbcSpinnerDisplayTime.insets = new Insets(0, 5, 0, 0);
        gbcSpinnerDisplayTime.gridx = 1;
        gbcSpinnerDisplayTime.gridy = 0;
        this.displayTimePanel.add((Component)this.spinnerDisplayTime, gbcSpinnerDisplayTime);
        this.lblSeconds = new JLabel(J18N.tr("Seconds", new Object[0]));
        GridBagConstraints gbcLblSeconds = new GridBagConstraints();
        gbcLblSeconds.insets = new Insets(0, 5, 0, 0);
        gbcLblSeconds.anchor = 17;
        gbcLblSeconds.gridx = 2;
        gbcLblSeconds.gridy = 0;
        this.displayTimePanel.add((Component)this.lblSeconds, gbcLblSeconds);
        this.linePanel = new GuiPanel();
        GridBagConstraints gbcLinePanel = new GridBagConstraints();
        gbcLinePanel.insets = new Insets(5, 5, 0, 5);
        gbcLinePanel.fill = 1;
        gbcLinePanel.gridx = 0;
        gbcLinePanel.gridy = 1;
        this.contentPane.add((Component)this.linePanel, gbcLinePanel);
        GridBagLayout gblLinePanel = new GridBagLayout();
        gblLinePanel.columnWidths = new int[]{0, 0, 0};
        gblLinePanel.rowHeights = new int[]{0, 0, 0, 0, 0};
        gblLinePanel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gblLinePanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.linePanel.setLayout(gblLinePanel);
        this.lblLine1 = new JLabel(J18N.tr("Line %d", 1) + ":");
        GridBagConstraints gbcLblLine1 = new GridBagConstraints();
        gbcLblLine1.anchor = 17;
        gbcLblLine1.gridx = 0;
        gbcLblLine1.gridy = 0;
        this.linePanel.add((Component)this.lblLine1, gbcLblLine1);
        this.txtLine1 = new CustomUiTextField();
        GridBagConstraints gbcTxtLine1 = new GridBagConstraints();
        gbcTxtLine1.insets = new Insets(0, 5, 0, 0);
        gbcTxtLine1.fill = 2;
        gbcTxtLine1.gridx = 1;
        gbcTxtLine1.gridy = 0;
        this.linePanel.add((Component)this.txtLine1, gbcTxtLine1);
        this.txtLine1.setColumns(10);
        this.txtLine1.setDocument(new JTextFieldLimit(20));
        this.lblLine2 = new JLabel(J18N.tr("Line %d", 2) + ":");
        GridBagConstraints gbcLblLine2 = new GridBagConstraints();
        gbcLblLine2.anchor = 17;
        gbcLblLine2.insets = new Insets(5, 0, 0, 0);
        gbcLblLine2.gridx = 0;
        gbcLblLine2.gridy = 1;
        this.linePanel.add((Component)this.lblLine2, gbcLblLine2);
        this.txtLine2 = new CustomUiTextField();
        GridBagConstraints gbcTxtLine2 = new GridBagConstraints();
        gbcTxtLine2.fill = 2;
        gbcTxtLine2.insets = new Insets(5, 5, 0, 0);
        gbcTxtLine2.gridx = 1;
        gbcTxtLine2.gridy = 1;
        this.linePanel.add((Component)this.txtLine2, gbcTxtLine2);
        this.txtLine2.setColumns(10);
        this.txtLine2.setDocument(new JTextFieldLimit(20));
        this.lblLine3 = new JLabel(J18N.tr("Line %d", 3) + ":");
        GridBagConstraints gbcLblLine3 = new GridBagConstraints();
        gbcLblLine3.anchor = 17;
        gbcLblLine3.insets = new Insets(5, 0, 0, 0);
        gbcLblLine3.gridx = 0;
        gbcLblLine3.gridy = 2;
        this.linePanel.add((Component)this.lblLine3, gbcLblLine3);
        this.txtLine3 = new CustomUiTextField();
        GridBagConstraints gbcTxtLine3 = new GridBagConstraints();
        gbcTxtLine3.fill = 2;
        gbcTxtLine3.insets = new Insets(5, 5, 0, 0);
        gbcTxtLine3.gridx = 1;
        gbcTxtLine3.gridy = 2;
        this.linePanel.add((Component)this.txtLine3, gbcTxtLine3);
        this.txtLine3.setColumns(10);
        this.txtLine3.setDocument(new JTextFieldLimit(20));
        this.lblLine4 = new JLabel(J18N.tr("Line %d", 4) + ":");
        GridBagConstraints gbcLblLine4 = new GridBagConstraints();
        gbcLblLine4.anchor = 17;
        gbcLblLine4.insets = new Insets(5, 0, 0, 0);
        gbcLblLine4.gridx = 0;
        gbcLblLine4.gridy = 3;
        this.linePanel.add((Component)this.lblLine4, gbcLblLine4);
        this.txtLine4 = new CustomUiTextField();
        GridBagConstraints gbcTxtLine4 = new GridBagConstraints();
        gbcTxtLine4.insets = new Insets(5, 5, 0, 0);
        gbcTxtLine4.fill = 2;
        gbcTxtLine4.gridx = 1;
        gbcTxtLine4.gridy = 3;
        this.linePanel.add((Component)this.txtLine4, gbcTxtLine4);
        this.txtLine4.setColumns(10);
        this.txtLine4.setDocument(new JTextFieldLimit(20));
        this.lblNetmask = new JLabel(J18N.tr("Netmask", new Object[0]) + ":");
        GridBagConstraints gbcLblNetmask = new GridBagConstraints();
        gbcLblNetmask.anchor = 17;
        gbcLblNetmask.insets = new Insets(5, 0, 0, 0);
        gbcLblNetmask.gridx = 0;
        gbcLblNetmask.gridy = 4;
        this.linePanel.add((Component)this.lblNetmask, gbcLblNetmask);
        this.txtNetMask = new CustomUiTextField();
        GridBagConstraints gbcTxtNetMask = new GridBagConstraints();
        gbcTxtNetMask.fill = 2;
        gbcTxtNetMask.insets = new Insets(5, 5, 0, 0);
        gbcTxtNetMask.gridx = 1;
        gbcTxtNetMask.gridy = 4;
        this.linePanel.add((Component)this.txtNetMask, gbcTxtNetMask);
        this.txtNetMask.setColumns(10);
        this.lblIpTerminal = new JLabel(J18N.tr("IP Terminal", new Object[0]) + ":");
        GridBagConstraints gbcLblIpTerminal = new GridBagConstraints();
        gbcLblIpTerminal.anchor = 17;
        gbcLblIpTerminal.insets = new Insets(5, 0, 0, 0);
        gbcLblIpTerminal.gridx = 0;
        gbcLblIpTerminal.gridy = 5;
        this.linePanel.add((Component)this.lblIpTerminal, gbcLblIpTerminal);
        this.txtIpTerminal = new CustomUiTextField();
        GridBagConstraints gbcTxtIpTerminal = new GridBagConstraints();
        gbcTxtIpTerminal.fill = 2;
        gbcTxtIpTerminal.insets = new Insets(5, 5, 0, 0);
        gbcTxtIpTerminal.gridx = 1;
        gbcTxtIpTerminal.gridy = 5;
        this.linePanel.add((Component)this.txtIpTerminal, gbcTxtIpTerminal);
        this.txtIpTerminal.setColumns(10);
        this.txtIpTerminal.setDocument(new JTextFieldLimit(15));
        GuiPanel buttonPane = new GuiPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        ActionListener okActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigLineDialog.this.save();
            }
        };
        ActionListener cancelActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigLineDialog.this.dispose();
            }
        };
        this.btnOk = new JButton(J18N.tr("Save", new Object[0]));
        this.btnOk.addActionListener(okActionListener);
        ((Container)buttonPane).add(this.btnOk);
        this.btnCancel = new JButton(J18N.tr("Cancel", new Object[0]));
        this.btnCancel.addActionListener(cancelActionListener);
        ((Container)buttonPane).add(this.btnCancel);
        this.setDefaultButton(this.btnOk);
        this.setCancelButton(this.btnCancel);
        this.init();
    }

    private void init() {
        this.contentPane.setEnabled(false);
        this.btnOk.setEnabled(false);
        this.initGui();
        this.registerListeners();
        this.requestTerminalInfo();
        this.onUiChange();
        this.pack();
    }

    private void initGui() {
        AbstractTcConnection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        TerminalType terminalType = connection.getTerminalType();
        switch (terminalType) {
            case TC_506_MIDIA: 
            case TC_508: {
                this.linePanel.setVisible(false);
                break;
            }
            case TC_504: {
                this.linePanel.setVisible(false);
                break;
            }
        }
    }

    private void registerListeners() {
        if (this.getConnection() == null) {
            return;
        }
        this.registerSc501CommandListener("#config02", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                Config02 response = (Config02)command;
                ConfigLineDialog.this.sc501Params = response.getParams();
                int exhibTime = ((ConfigLineDialog)ConfigLineDialog.this).sc501Params.exhibTime >= 1 ? ((ConfigLineDialog)ConfigLineDialog.this).sc501Params.exhibTime : 1;
                ConfigLineDialog.this.spinnerDisplayTime.setValue(exhibTime);
                ConfigLineDialog.this.txtLine1.setText(((ConfigLineDialog)ConfigLineDialog.this).sc501Params.line1);
                ConfigLineDialog.this.txtLine2.setText(((ConfigLineDialog)ConfigLineDialog.this).sc501Params.line2);
                ConfigLineDialog.this.txtLine3.setText(((ConfigLineDialog)ConfigLineDialog.this).sc501Params.line3);
                ConfigLineDialog.this.txtLine4.setText(((ConfigLineDialog)ConfigLineDialog.this).sc501Params.line4);
                ConfigLineDialog.this.txtNetMask.setText(((ConfigLineDialog)ConfigLineDialog.this).sc501Params.netmask);
                ConfigLineDialog.this.txtIpTerminal.setText(((ConfigLineDialog)ConfigLineDialog.this).sc501Params.terminalIp);
                ConfigLineDialog.this.contentPane.setEnabled(true);
                ConfigLineDialog.this.btnOk.setEnabled(true);
            }
        });
        this.registerSc501CommandListener("#extconfig", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                ExtConfig response = (ExtConfig)command;
                ExtConfig.ConfigParams params = response.getParams();
                ConfigLineDialog.this.txtNetMask.setText(params.netmask);
                ConfigLineDialog.this.txtIpTerminal.setText(params.terminalIp);
                ConfigLineDialog.this.contentPane.setEnabled(true);
                ConfigLineDialog.this.btnOk.setEnabled(true);
            }
        });
        this.registerSc501CommandListener("#reconf02_error\u0000", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                Log.error(J18N.tr("Terminal Configuration Error", new Object[0]), new Object[0]);
            }
        });
    }

    private void requestTerminalInfo() {
        AbstractTcConnection connection = this.getConnection();
        if (connection instanceof Sc501Connection) {
            connection.writeCommand(new Config02Q());
            connection.writeCommand(new ExtConfigQ());
        } else if (connection instanceof Sc504Connection) {
            if (connection.getTerminalType() != TerminalType.TC_504) {
                connection.writeCommand(new IDGetAudioStatus());
                connection.writeCommand(new IDGetBrightness());
                connection.writeCommand(new IDGetSensorStatus());
                connection.writeCommand(new IDGetVolume());
            } else {
                connection.writeCommand(new IDbGetEnableKey());
                connection.writeCommand(new IDbGetLEC());
            }
            connection.writeCommand(new IDvGetTimeExhib());
        } else {
            throw new UnsupportedOperationException("Unsupported connection type: " + connection.getClass().getName());
        }
    }

    private void save() {
        if (this.isValidNumberOfCharacters()) {
            GuiUtils.showWarningMessage(null, J18N.tr("Number of characters greater than supported by the terminal", new Object[0]));
            return;
        }
        this.contentPane.setEnabled(false);
        this.btnOk.setEnabled(false);
        this.btnCancel.setEnabled(false);
        AbstractTcConnection connection = this.getConnection();
        if (!(connection instanceof Sc501Connection)) {
            throw new UnsupportedOperationException("Unsupported connection type: " + connection.getClass().getName());
        }
        REConf02 request = new REConf02(this.sc501Params.serverIp, this.txtIpTerminal.getText(), this.txtNetMask.getText(), this.txtLine1.getText(), this.txtLine2.getText(), this.txtLine3.getText(), this.txtLine4.getText(), Integer.parseInt(this.spinnerDisplayTime.getValue().toString()));
        connection.writeCommand(request);
        this.dispose();
        GuiUtils.showWarningMessage(null, J18N.tr("Settings saved! The terminal will restart", new Object[0]));
        connection.close();
    }

    private boolean isValidNumberOfCharacters() {
        int sizeTotal = this.txtIpTerminal.getText().length() + this.txtLine1.getText().length() + this.txtLine2.getText().length() + this.txtLine3.getText().length() + this.txtLine4.getText().length();
        return sizeTotal > 79;
    }

    private void onUiChange() {
        AbstractTcConnection connection = this.getConnection();
        boolean readyTosave = connection.getTerminal().getType().getSc504Id() != null || connection.getTerminal().getType().getSc501Id() != null && !this.txtLine1.getText().isEmpty();
        ConfigLineDialog.validateInput(this.txtNetMask);
        this.btnOk.setEnabled(readyTosave);
    }

    private class CustomUiTextField
    extends TextField {
        private static final long serialVersionUID = 1L;

        private CustomUiTextField() {
        }

        @Override
        protected void onChange() {
            super.onChange();
            ConfigLineDialog.this.onUiChange();
        }
    }
}

