/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.dao.Exhibition;
import br.com.gertec.tc.server.dao.ExhibitionParam;
import br.com.gertec.tc.server.dao.Product;
import br.com.gertec.tc.server.dao.ProductExhibition;
import br.com.gertec.tc.server.gui.ExhibitionPanel;
import br.com.gertec.tc.server.gui.util.CurrencyComboBox;
import br.com.gertec.tc.server.gui.util.GuiDialog;
import br.com.gertec.tc.server.gui.util.TextField;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.util.FileUtilities;
import br.org.reconcavo.j18n.J18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Currency;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class ExhibitionDialog
extends GuiDialog {
    private static final long serialVersionUID = 1L;
    FileUtilities tempFile = new FileUtilities();
    final File baseDir = this.tempFile.getTemporaryCustomer();
    private final JPanel contentPanel;
    private final JPanel tabGeneral;
    private final JTextField txtLabel1;
    private final JTextField txtLabel2;
    private final TextField txtLabelNotFound;
    private final CurrencyComboBox cmbDefaultCurrency;
    private final JTabbedPane tabbedPane;
    private final ExhibitionPanel tab506m;
    private final ExhibitionPanel tab508;
    private final ExhibitionPanel tab406;
    private final ExhibitionPanel tab506e;
    private final ExhibitionPanel tab406e;
    private final ExhibitionPanel tab505;
    private final ExhibitionPanel tab507;
    private final ExhibitionPanel tabGb600;
    private final ExhibitionPanel tabGb601;
    private final ExhibitionPanel tab506s;
    private final JButton btnOk;
    private final Product product;
    private final JButton btnApply;
    public String timeExib;

    public static void main(String[] args) {
        try {
            ExhibitionDialog dialog = new ExhibitionDialog();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ExhibitionDialog() {
        this((Product)null);
    }

    public ExhibitionDialog(Product product) {
        this.product = product;
        if (product != null) {
            try {
                this.salvaTeste(product.getBarcode());
                System.out.println("C\u00f3digo do produto obtido.");
            }
            catch (IOException e) {
                System.out.println("Erro ao obter o c\u00f3digo do produto.");
            }
        }
        this.contentPanel = new JPanel();
        this.getContentPane().setPreferredSize(new Dimension(650, 350));
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 0, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        GridBagLayout gblContentPanel = new GridBagLayout();
        gblContentPanel.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gblContentPanel.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        this.contentPanel.setLayout(gblContentPanel);
        this.tabbedPane = new JTabbedPane(1);
        GridBagConstraints gbcTabbedPane = new GridBagConstraints();
        gbcTabbedPane.insets = new Insets(5, 0, 0, 0);
        gbcTabbedPane.fill = 1;
        gbcTabbedPane.gridx = 0;
        gbcTabbedPane.gridy = 0;
        this.contentPanel.add((Component)this.tabbedPane, gbcTabbedPane);
        this.tabGeneral = new JPanel();
        this.tabGeneral.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagLayout gblTabGeneral = new GridBagLayout();
        gblTabGeneral.columnWidths = new int[]{0, 0, 0};
        gblTabGeneral.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0};
        gblTabGeneral.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gblTabGeneral.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        this.tabGeneral.setLayout(gblTabGeneral);
        JLabel lblDefaultCurrency = new JLabel(J18N.tr("Default currency", new Object[0]) + ":");
        GridBagConstraints gbcLblDefaultCurrency = new GridBagConstraints();
        gbcLblDefaultCurrency.anchor = 17;
        gbcLblDefaultCurrency.gridx = 0;
        gbcLblDefaultCurrency.gridy = 0;
        this.tabGeneral.add((Component)lblDefaultCurrency, gbcLblDefaultCurrency);
        this.cmbDefaultCurrency = new CurrencyComboBox(String.format("(%s)", J18N.tr("NONE", new Object[0])));
        GridBagConstraints gbcComboBox = new GridBagConstraints();
        gbcComboBox.insets = new Insets(0, 5, 0, 0);
        gbcComboBox.fill = 2;
        gbcComboBox.gridx = 1;
        gbcComboBox.gridy = 0;
        this.tabGeneral.add((Component)this.cmbDefaultCurrency, gbcComboBox);
        JLabel lblLabel1 = new JLabel(J18N.tr("Price 1 label", new Object[0]) + ":");
        GridBagConstraints gbcLblLabel1 = new GridBagConstraints();
        gbcLblLabel1.anchor = 17;
        gbcLblLabel1.insets = new Insets(5, 0, 0, 0);
        gbcLblLabel1.gridx = 0;
        gbcLblLabel1.gridy = 1;
        this.tabGeneral.add((Component)lblLabel1, gbcLblLabel1);
        this.txtLabel1 = new TextField(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onChange() {
                ExhibitionDialog.this.refreshGui();
            }
        };
        GridBagConstraints gbcTxtLabel1 = new GridBagConstraints();
        gbcTxtLabel1.insets = new Insets(5, 5, 0, 0);
        gbcTxtLabel1.fill = 1;
        gbcTxtLabel1.gridx = 1;
        gbcTxtLabel1.gridy = 1;
        this.tabGeneral.add((Component)this.txtLabel1, gbcTxtLabel1);
        this.txtLabel1.setColumns(10);
        String label2ToolTip = J18N.tr("This label will be displayed only if product has a defined \"price 2\" field", new Object[0]);
        JLabel lblLabel2 = new JLabel(J18N.tr("Price 2 label", new Object[0]) + ":");
        lblLabel2.setToolTipText(label2ToolTip);
        GridBagConstraints gbcLblLabel2 = new GridBagConstraints();
        gbcLblLabel2.anchor = 17;
        gbcLblLabel2.insets = new Insets(5, 0, 0, 0);
        gbcLblLabel2.gridx = 0;
        gbcLblLabel2.gridy = 2;
        this.tabGeneral.add((Component)lblLabel2, gbcLblLabel2);
        this.txtLabel2 = new TextField(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onChange() {
                ExhibitionDialog.this.refreshGui();
            }
        };
        this.txtLabel2.setToolTipText(label2ToolTip);
        GridBagConstraints gbcTxtLabel2 = new GridBagConstraints();
        gbcTxtLabel2.insets = new Insets(5, 5, 0, 0);
        gbcTxtLabel2.fill = 1;
        gbcTxtLabel2.gridx = 1;
        gbcTxtLabel2.gridy = 2;
        this.tabGeneral.add((Component)this.txtLabel2, gbcTxtLabel2);
        this.txtLabel2.setColumns(10);
        JLabel lblLabelNotFound = new JLabel(J18N.tr("NOT FOUND label", new Object[0]) + ":*");
        GridBagConstraints gbcLblLabelNotFound = new GridBagConstraints();
        gbcLblLabelNotFound.anchor = 13;
        gbcLblLabelNotFound.insets = new Insets(5, 0, 0, 0);
        gbcLblLabelNotFound.gridx = 0;
        gbcLblLabelNotFound.gridy = 3;
        this.tabGeneral.add((Component)lblLabelNotFound, gbcLblLabelNotFound);
        this.txtLabelNotFound = new TextField(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onChange() {
                ExhibitionDialog.this.refreshGui();
            }
        };
        GridBagConstraints gbcTxtLabelNotFound = new GridBagConstraints();
        gbcTxtLabelNotFound.insets = new Insets(5, 5, 0, 0);
        gbcTxtLabelNotFound.fill = 1;
        gbcTxtLabelNotFound.gridx = 1;
        gbcTxtLabelNotFound.gridy = 3;
        this.tabGeneral.add((Component)this.txtLabelNotFound, gbcTxtLabelNotFound);
        this.txtLabelNotFound.setColumns(10);
        JButton btnRestoreDefaults = new JButton(J18N.tr("Restore defaults", new Object[0]));
        btnRestoreDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = JOptionPane.showConfirmDialog(ExhibitionDialog.this, J18N.tr("Default properties will be restored. Do you want to proceed?", new Object[0]), Application.APP_NAME, 0, 2);
                if (result == 0) {
                    Currency currency = null;
                    try {
                        currency = Currency.getInstance("");
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    ExhibitionDialog.this.cmbDefaultCurrency.setSelectedItem(currency);
                    ExhibitionDialog.this.txtLabel1.setText(J18N.tr("Price", new Object[0]));
                    ExhibitionDialog.this.txtLabel2.setText(J18N.tr("Custom price", new Object[0]));
                    ExhibitionDialog.this.txtLabelNotFound.setText(J18N.tr("Not found", new Object[0]));
                }
            }
        });
        GridBagConstraints gbcBtnRestoreDefaults = new GridBagConstraints();
        gbcBtnRestoreDefaults.anchor = 13;
        gbcBtnRestoreDefaults.insets = new Insets(5, 5, 0, 0);
        gbcBtnRestoreDefaults.gridx = 1;
        gbcBtnRestoreDefaults.gridy = 4;
        this.tabGeneral.add((Component)btnRestoreDefaults, gbcBtnRestoreDefaults);
        Component rigidArea = Box.createRigidArea(new Dimension(20, 20));
        GridBagConstraints gbcRigidArea = new GridBagConstraints();
        gbcRigidArea.fill = 1;
        gbcRigidArea.gridwidth = 2;
        gbcRigidArea.insets = new Insets(5, 0, 0, 0);
        gbcRigidArea.gridx = 0;
        gbcRigidArea.gridy = 5;
        this.tabGeneral.add(rigidArea, gbcRigidArea);
        if (product == null) {
            this.setTitle(J18N.tr("Standard product exhibition", new Object[0]));
            this.tabbedPane.addTab(J18N.tr("", new Object[0]), null, this.tabGeneral, null);
        } else {
            this.setTitle(J18N.tr("Customize product for exhibition (%s: %s)", product.getBarcode(), product.getDescription()));
        }
        this.tab506m = new ExhibitionPanel(TerminalType.TC_506_MIDIA, this.getProduct()){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onGuiChange() {
                ExhibitionDialog.this.refreshGui();
            }
        };
        this.tabbedPane.addTab("", null, this.tab506m, null);
        this.tab508 = new ExhibitionPanel(TerminalType.TC_508, this.getProduct()){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onGuiChange() {
                ExhibitionDialog.this.refreshGui();
            }
        };
        this.tabbedPane.addTab("", null, this.tab508, null);
        this.tab406 = new ExhibitionPanel(TerminalType.TC_406, this.getProduct()){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onGuiChange() {
                ExhibitionDialog.this.refreshGui();
            }
        };
        this.tabbedPane.addTab("", null, this.tab406, null);
        this.tab406e = new ExhibitionPanel(TerminalType.TC_406_E, this.getProduct()){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onGuiChange() {
                ExhibitionDialog.this.refreshGui();
            }
        };
        this.tabbedPane.addTab("", null, this.tab406e, null);
        this.tab506e = new ExhibitionPanel(TerminalType.TC_506_E, this.getProduct()){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onGuiChange() {
                ExhibitionDialog.this.refreshGui();
            }
        };
        this.tabbedPane.addTab("", null, this.tab506e, null);
        this.tab505 = new ExhibitionPanel(TerminalType.TC_505, this.getProduct()){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onGuiChange() {
                ExhibitionDialog.this.refreshGui();
            }
        };
        this.tabbedPane.addTab("", null, this.tab505, null);
        this.tab507 = new ExhibitionPanel(TerminalType.TC_507, this.getProduct()){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onGuiChange() {
                ExhibitionDialog.this.refreshGui();
            }
        };
        this.tabbedPane.addTab("", null, this.tab507, null);
        this.tabGb600 = new ExhibitionPanel(TerminalType.GB_600, this.getProduct()){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onGuiChange() {
                ExhibitionDialog.this.refreshGui();
            }
        };
        this.tabbedPane.addTab("", null, this.tabGb600, null);
        this.tabGb601 = new ExhibitionPanel(TerminalType.GB_601, this.getProduct()){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onGuiChange() {
                ExhibitionDialog.this.refreshGui();
            }
        };
        this.tabbedPane.addTab("", null, this.tabGb601, null);
        this.tab506s = new ExhibitionPanel(TerminalType.TC_506_S, this.getProduct()){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onGuiChange() {
                ExhibitionDialog.this.refreshGui();
            }
        };
        this.tabbedPane.addTab("", null, this.tab506s, null);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.btnOk = new JButton(J18N.tr("OK", new Object[0]));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ExhibitionDialog.this.tab406.isShowing() || ExhibitionDialog.this.tab506s.isShowing()) {
                    if (ExhibitionDialog.this.tab406.getEnvioDeMidia() && Integer.valueOf(ExhibitionDialog.this.tab406.getTempoExibicao()) <= 0) {
                        return;
                    }
                    if (ExhibitionDialog.this.tab506s.getEnvioDeMidia() && Integer.valueOf(ExhibitionDialog.this.tab506s.getTempoExibicao()) <= 0) {
                        return;
                    }
                    ExhibitionDialog.this.apply();
                    ExhibitionDialog.this.dispose();
                } else {
                    ExhibitionDialog.this.apply();
                    ExhibitionDialog.this.dispose();
                }
            }
        });
        buttonPane.add(this.btnOk);
        JButton btnCancel = new JButton(J18N.tr("Cancel", new Object[0]));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExhibitionDialog.this.dispose();
            }
        });
        buttonPane.add(btnCancel);
        this.btnApply = new JButton(J18N.tr("Save", new Object[0]));
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ExhibitionDialog.this.tab508.isGuiValid()) {
                    if (ExhibitionDialog.this.tab506m.isGuiValid()) {
                        if (ExhibitionDialog.this.tab505.isGui501Valid()) {
                            if (ExhibitionDialog.this.tab507.isGui501Valid()) {
                                if (ExhibitionDialog.this.tab506s.isGuiValid()) {
                                    if (ExhibitionDialog.this.tab506e.isGuiValid()) {
                                        if (ExhibitionDialog.this.tab406.isGuiValid()) {
                                            if (ExhibitionDialog.this.tab406e.isGuiValid()) {
                                                if (ExhibitionDialog.this.tabGb600.isGuiGB600Valid()) {
                                                    if (ExhibitionDialog.this.tabGb601.isGuiGB600Valid()) {
                                                        if (ExhibitionDialog.this.tab406.getEnvioDeMidia() || ExhibitionDialog.this.tab506s.getEnvioDeMidia() || ExhibitionDialog.this.tab506e.getEnvioDeMidia() || ExhibitionDialog.this.tab406e.getEnvioDeMidia()) {
                                                            try {
                                                                if (Integer.valueOf(ExhibitionDialog.this.tab406.getTempoExibicao()) > 0) {
                                                                    ExhibitionDialog.this.apply();
                                                                }
                                                            }
                                                            catch (Exception exception) {
                                                                JOptionPane.showMessageDialog(null, J18N.tr("Enter the display time!", new Object[0]), J18N.tr("Error to save data", new Object[0]), 0);
                                                            }
                                                            if (ExhibitionDialog.this.tab506s.getEnvioDeMidia()) {
                                                                try {
                                                                    if (Integer.valueOf(ExhibitionDialog.this.tab506s.getTempoExibicao()) > 0) {
                                                                        ExhibitionDialog.this.apply();
                                                                    }
                                                                }
                                                                catch (Exception exception) {
                                                                    JOptionPane.showMessageDialog(null, J18N.tr("Enter the display time!", new Object[0]), J18N.tr("Error to save data", new Object[0]), 0);
                                                                }
                                                            }
                                                        } else {
                                                            ExhibitionDialog.this.apply();
                                                        }
                                                    } else {
                                                        JOptionPane.showMessageDialog(null, "GB601 - Invalid data!", J18N.tr("Error to save data", new Object[0]), 0);
                                                    }
                                                } else {
                                                    JOptionPane.showMessageDialog(null, "GB600 - Invalid data!", J18N.tr("Error to save data", new Object[0]), 0);
                                                }
                                            } else {
                                                JOptionPane.showMessageDialog(null, J18N.tr("Search Price G2 E - Invalid data!", new Object[0]), J18N.tr("Error to save data", new Object[0]), 0);
                                            }
                                        } else {
                                            JOptionPane.showMessageDialog(null, J18N.tr("Search Price G2 - Invalid data!", new Object[0]), J18N.tr("Error to save data", new Object[0]), 0);
                                        }
                                    } else {
                                        JOptionPane.showMessageDialog(null, J18N.tr("TC506E - Invalid data!", new Object[0]), J18N.tr("Error to save data", new Object[0]), 0);
                                    }
                                } else {
                                    JOptionPane.showMessageDialog(null, J18N.tr("TC506S - Invalid data!", new Object[0]), J18N.tr("Error to save data", new Object[0]), 0);
                                }
                            } else {
                                JOptionPane.showMessageDialog(null, J18N.tr("TC506 - Invalid data!", new Object[0]), J18N.tr("Error to save data", new Object[0]), 0);
                            }
                        } else {
                            JOptionPane.showMessageDialog(null, J18N.tr("TC505 - Invalid data!", new Object[0]), J18N.tr("Error to save data", new Object[0]), 0);
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, J18N.tr("TC506M - Invalid data!", new Object[0]), J18N.tr("Error to save data", new Object[0]), 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, J18N.tr("TC508 - Invalid data!", new Object[0]), J18N.tr("Error to save data", new Object[0]), 0);
                }
            }
        });
        buttonPane.add(this.btnApply);
        this.setDefaultButton(this.btnOk);
        this.setCancelButton(btnCancel);
        this.init();
    }

    private void refreshGui() {
        this.btnApply.setEnabled(true);
        boolean tc506mValid = this.tab506m.isGuiValid();
        this.tabbedPane.setTitleAt(this.getProduct() == null ? 1 : 0, String.format("%sTC-506 M\u00eddia", tc506mValid ? "" : "(!) "));
        boolean tc508Valid = this.tab508.isGuiValid();
        this.tabbedPane.setTitleAt(this.getProduct() == null ? 2 : 1, String.format("%sTC-508", tc508Valid ? "" : "(!) "));
        boolean tc406Valid = this.tab406.isGuiValid();
        this.tabbedPane.setTitleAt(this.getProduct() == null ? 3 : 2, String.format("%sBP G2 ", tc406Valid ? "" : "(!) "));
        boolean tc406eValid = this.tab406e.isGuiValid();
        this.tabbedPane.setTitleAt(this.getProduct() == null ? 4 : 3, String.format("%sBP G2 E", tc406eValid ? "" : "(!) "));
        boolean tc506eValid = this.tab506e.isGuiValid();
        this.tabbedPane.setTitleAt(this.getProduct() == null ? 5 : 4, String.format("%sTC-506 E", tc506eValid ? "" : "(!) "));
        boolean tc505Valid = this.tab505.isGui501Valid();
        this.tabbedPane.setTitleAt(this.getProduct() == null ? 6 : 5, String.format("%sTC-505", tc505Valid ? "" : ""));
        boolean tc507Valid = this.tab507.isGui501Valid();
        this.tabbedPane.setTitleAt(this.getProduct() == null ? 7 : 6, String.format("%sTC-506", tc507Valid ? "" : ""));
        boolean gb600Valid = this.tabGb600.isGui501Valid();
        this.tabbedPane.setTitleAt(this.getProduct() == null ? 8 : 7, String.format("%sG-BOT", gb600Valid ? "" : "(!) "));
        boolean gb601Valid = this.tabGb600.isGui501Valid();
        this.tabbedPane.setTitleAt(this.getProduct() == null ? 9 : 8, String.format("%sG-BOT 2", gb601Valid ? "" : ""));
        boolean tc506sValid = this.tab506s.isGuiValid();
        this.tabbedPane.setTitleAt(this.getProduct() == null ? 10 : 9, String.format("%sTC-506 S", tc506sValid ? "" : "(!) "));
        boolean valid = tc506mValid && tc406Valid && tc508Valid && tc505Valid && tc506sValid && tc406eValid && tc506eValid && tc507Valid && gb600Valid && gb601Valid;
        this.btnApply.setEnabled(valid);
        this.btnOk.setEnabled(valid);
        if (this.product == null) {
            boolean generalValid = !this.txtLabelNotFound.getText().isEmpty();
            this.txtLabelNotFound.setValid(generalValid);
            this.tabbedPane.setTitleAt(0, String.format("%s%s", generalValid ? "" : "(!) ", J18N.tr("General", new Object[0])));
        }
    }

    public final Product getProduct() {
        return this.product;
    }

    private GuiData getGuiData() {
        return new GuiData();
    }

    private void init() {
        String currencyCode = Application.SETTINGS.getProperty("CURRENCY", "");
        Currency currency = null;
        try {
            currency = currencyCode == null || currencyCode.isEmpty() ? null : Currency.getInstance(currencyCode);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.cmbDefaultCurrency.setSelectedItem(currency);
        this.cmbDefaultCurrency.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExhibitionDialog.this.refreshGui();
            }
        });
        this.cmbDefaultCurrency.setSelectedItem(currency);
        String label1 = "";
        String label2 = "";
        String labelNotFound = "";
        try {
            label1 = Application.SETTINGS.getProperty("LABEL1");
            label2 = Application.SETTINGS.getProperty("LABEL2");
            labelNotFound = Application.SETTINGS.getProperty("LABEL_NOT_FOUND");
        }
        catch (NullPointerException np) {
            label1 = "";
            label2 = "";
            labelNotFound = "";
        }
        if (label1.isEmpty()) {
            this.txtLabel1.setText(J18N.tr("Price", new Object[0]));
        } else {
            this.txtLabel1.setText(label1);
        }
        if (label2.isEmpty()) {
            this.txtLabel2.setText(J18N.tr("Custom price", new Object[0]));
        } else {
            this.txtLabel2.setText(label2);
        }
        if (labelNotFound.isEmpty()) {
            this.txtLabelNotFound.setText(J18N.tr("Not found", new Object[0]));
        } else {
            this.txtLabelNotFound.setText(labelNotFound);
        }
        Exhibition exhibition506m = new Exhibition(Application.SETTINGS.getProperty("DEFAULT_EXHIB_TC506M"));
        ExhibitionParam notFoundExhibitionParam506m = new ExhibitionParam(Application.SETTINGS.getProperty("DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506M"));
        if (this.getProduct() != null) {
            exhibition506m = Exhibition.combine(exhibition506m, ProductExhibition.get(this.getProduct().getBarcode(), TerminalType.TC_506_MIDIA));
        }
        this.tab506m.load(exhibition506m, notFoundExhibitionParam506m);
        Exhibition exhibition508 = new Exhibition(Application.SETTINGS.getProperty("DEFAULT_EXHIB_TC508"));
        ExhibitionParam notFoundExhibitionParam508 = new ExhibitionParam(Application.SETTINGS.getProperty("DEFAULT_EXHIB_PARAM_NOT_FOUND_TC508"));
        if (this.getProduct() != null) {
            exhibition508 = Exhibition.combine(exhibition508, ProductExhibition.get(this.getProduct().getBarcode(), TerminalType.TC_508));
        }
        this.tab508.load(exhibition508, notFoundExhibitionParam508);
        Exhibition exhibition406 = new Exhibition(Application.SETTINGS.getProperty("DEFAULT_EXHIB_TC406"));
        ExhibitionParam notFoundExhibitionParam406 = new ExhibitionParam(Application.SETTINGS.getProperty("DEFAULT_EXHIB_PARAM_NOT_FOUND_TC406"));
        if (this.getProduct() != null) {
            exhibition406 = Exhibition.combine(exhibition406, ProductExhibition.get(this.getProduct().getBarcode(), TerminalType.TC_406));
        }
        this.tab406.load(exhibition406, notFoundExhibitionParam406);
        Exhibition exhibition505 = new Exhibition(Application.SETTINGS.getProperty("DEFAULT_EXHIB_TC505"));
        ExhibitionParam notFoundExhibitionParam505 = new ExhibitionParam(Application.SETTINGS.getProperty("DEFAULT_EXHIB_PARAM_NOT_FOUND_TC505"));
        if (this.getProduct() != null) {
            exhibition505 = Exhibition.combine(exhibition505, ProductExhibition.get(this.getProduct().getBarcode(), TerminalType.TC_505));
        }
        this.tab505.load(exhibition505, notFoundExhibitionParam505);
        Exhibition exhibition507 = new Exhibition(Application.SETTINGS.getProperty("DEFAULT_EXHIB_TC507"));
        ExhibitionParam notFoundExhibitionParam507 = new ExhibitionParam(Application.SETTINGS.getProperty("DEFAULT_EXHIB_PARAM_NOT_FOUND_TC507"));
        if (this.getProduct() != null) {
            exhibition507 = Exhibition.combine(exhibition507, ProductExhibition.get(this.getProduct().getBarcode(), TerminalType.TC_507));
        }
        this.tab507.load(exhibition507, notFoundExhibitionParam507);
        Exhibition exhibitionGb600 = new Exhibition(Application.SETTINGS.getProperty("DEFAULT_EXHIB_GB600"));
        ExhibitionParam notFoundExhibitionParamGb600 = new ExhibitionParam(Application.SETTINGS.getProperty("DEFAULT_EXHIB_PARAM_NOT_FOUND_GB600"));
        if (this.getProduct() != null) {
            exhibitionGb600 = Exhibition.combine(exhibitionGb600, ProductExhibition.get(this.getProduct().getBarcode(), TerminalType.GB_600));
        }
        this.tabGb600.load(exhibitionGb600, notFoundExhibitionParamGb600);
        Exhibition exhibitionGb601 = new Exhibition(Application.SETTINGS.getProperty("DEFAULT_EXHIB_GB601"));
        ExhibitionParam notFoundExhibitionParamGb601 = new ExhibitionParam(Application.SETTINGS.getProperty("DEFAULT_EXHIB_PARAM_NOT_FOUND_GB601"));
        if (this.getProduct() != null) {
            exhibitionGb601 = Exhibition.combine(exhibitionGb601, ProductExhibition.get(this.getProduct().getBarcode(), TerminalType.GB_601));
        }
        System.out.println();
        this.tabGb601.load(exhibitionGb601, notFoundExhibitionParamGb601);
        Exhibition exhibition506s = new Exhibition(Application.SETTINGS.getProperty("DEFAULT_EXHIB_TC506S"));
        ExhibitionParam notFoundExhibitionParam506s = new ExhibitionParam(Application.SETTINGS.getProperty("DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506S"));
        if (this.getProduct() != null) {
            exhibition506s = Exhibition.combine(exhibition506s, ProductExhibition.get(this.getProduct().getBarcode(), TerminalType.TC_506_S));
        }
        this.tab506s.load(exhibition506s, notFoundExhibitionParam506s);
        Exhibition exhibition506e = new Exhibition(Application.SETTINGS.getProperty("DEFAULT_EXHIB_TC506E"));
        ExhibitionParam notFoundExhibitionParam506e = new ExhibitionParam(Application.SETTINGS.getProperty("DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506E"));
        if (this.getProduct() != null) {
            exhibition506e = Exhibition.combine(exhibition506e, ProductExhibition.get(this.getProduct().getBarcode(), TerminalType.TC_506_E));
        }
        this.tab506e.load(exhibition506e, notFoundExhibitionParam506e);
        Exhibition exhibition406e = new Exhibition(Application.SETTINGS.getProperty("DEFAULT_EXHIB_TC406E"));
        ExhibitionParam notFoundExhibitionParam406e = new ExhibitionParam(Application.SETTINGS.getProperty("DEFAULT_EXHIB_PARAM_NOT_FOUND_TC406E"));
        if (this.getProduct() != null) {
            exhibition406e = Exhibition.combine(exhibition406e, ProductExhibition.get(this.getProduct().getBarcode(), TerminalType.TC_406_E));
        }
        this.tab406e.load(exhibition406e, notFoundExhibitionParam406e);
        this.refreshGui();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExhibitionDialog.this.btnApply.setEnabled(false);
            }
        });
        this.pack();
    }

    public void apply() {
        boolean hasCustomExhibition;
        GuiData data = this.getGuiData();
        try {
            Product product = this.getProduct();
            hasCustomExhibition = ProductExhibition.hasCustomExhibition(product.getBarcode());
        }
        catch (NullPointerException e) {
            hasCustomExhibition = false;
        }
        if (!hasCustomExhibition && this.getProduct() == null) {
            this.saveDefaultExhibition(data);
        } else if (this.getProduct() != null) {
            this.saveCustomExhibition(data);
        }
        this.btnApply.setEnabled(false);
    }

    private void saveCustomExhibition(GuiData data) {
        ProductExhibition.save(this.getProduct().getBarcode(), TerminalType.TC_506_MIDIA, data.exhibition506m);
        ProductExhibition.save(this.getProduct().getBarcode(), TerminalType.TC_508, data.exhibition508);
        if (this.tab406.getEnvioDeMidia()) {
            if (!this.tab406.getTempoExibicao().isEmpty()) {
                ProductExhibition.save(this.getProduct().getBarcode(), TerminalType.TC_406, data.exhibition406, this.tab406.getEnvioDeMidia(), this.tab406.getTempoExibicao());
            }
        } else {
            ProductExhibition.save(this.getProduct().getBarcode(), TerminalType.TC_406, data.exhibition406, this.tab406.getEnvioDeMidia(), this.tab406.getTempoExibicao());
        }
        if (this.tab506s.getEnvioDeMidia()) {
            if (!this.tab506s.getTempoExibicao().isEmpty()) {
                ProductExhibition.save(this.getProduct().getBarcode(), TerminalType.TC_506_S, data.exhibition506s, this.tab506s.getEnvioDeMidia(), this.tab506s.getTempoExibicao());
            }
        } else {
            ProductExhibition.save(this.getProduct().getBarcode(), TerminalType.TC_506_S, data.exhibition506s, this.tab506s.getEnvioDeMidia(), this.tab506s.getTempoExibicao());
        }
        if (this.tab506e.getEnvioDeMidia()) {
            if (!this.tab506e.getTempoExibicao().isEmpty()) {
                ProductExhibition.save(this.getProduct().getBarcode(), TerminalType.TC_506_E, data.exhibition506e, this.tab506e.getEnvioDeMidia(), this.tab506e.getTempoExibicao());
            }
        } else {
            ProductExhibition.save(this.getProduct().getBarcode(), TerminalType.TC_506_E, data.exhibition506e, this.tab506e.getEnvioDeMidia(), this.tab506e.getTempoExibicao());
        }
        if (this.tab406e.getEnvioDeMidia()) {
            if (!this.tab406e.getTempoExibicao().isEmpty()) {
                ProductExhibition.save(this.getProduct().getBarcode(), TerminalType.TC_406_E, data.exhibition406e, this.tab406e.getEnvioDeMidia(), this.tab406e.getTempoExibicao());
            }
        } else {
            ProductExhibition.save(this.getProduct().getBarcode(), TerminalType.TC_406_E, data.exhibition406e, this.tab406e.getEnvioDeMidia(), this.tab406e.getTempoExibicao());
        }
        ProductExhibition.save(this.getProduct().getBarcode(), TerminalType.TC_505, data.exhibition505);
        ProductExhibition.save(this.getProduct().getBarcode(), TerminalType.TC_507, data.exhibition507);
        ProductExhibition.save(this.getProduct().getBarcode(), TerminalType.GB_600, data.exhibitionGb600);
        ProductExhibition.save(this.getProduct().getBarcode(), TerminalType.GB_601, data.exhibitionGb601);
    }

    private void saveDefaultExhibition(GuiData data) {
        Application.SETTINGS.setProperty("LABEL1", data.label1);
        Application.SETTINGS.setProperty("LABEL2", data.label2);
        Application.SETTINGS.setProperty("LABEL_NOT_FOUND", data.labelNotFound);
        String currencyCode = data.currency == null ? "" : data.currency.getCurrencyCode();
        Application.SETTINGS.setProperty("CURRENCY", currencyCode);
        Application.SETTINGS.setProperty("DEFAULT_EXHIB_TC506M", data.exhibition506m.getPropertyString());
        Application.SETTINGS.setProperty("DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506M", data.exhibitionParamNotFound506m.getPropertyString());
        Application.SETTINGS.setProperty("DEFAULT_EXHIB_TC508", data.exhibition508.getPropertyString());
        Application.SETTINGS.setProperty("DEFAULT_EXHIB_PARAM_NOT_FOUND_TC508", data.exhibitionParamNotFound508.getPropertyString());
        Application.SETTINGS.setProperty("DEFAULT_EXHIB_TC406", data.exhibition406.getPropertyString());
        Application.SETTINGS.setProperty("DEFAULT_EXHIB_PARAM_NOT_FOUND_TC406", data.exhibitionParamNotFound406.getPropertyString());
        Application.SETTINGS.setProperty("DEFAULT_EXHIB_TC505", data.exhibition505.getPropertyString());
        Application.SETTINGS.setProperty("DEFAULT_EXHIB_PARAM_NOT_FOUND_TC505", data.exhibitionParamNotFound505.getPropertyString());
        Application.SETTINGS.setProperty("DEFAULT_EXHIB_TC507", data.exhibition507.getPropertyString());
        Application.SETTINGS.setProperty("DEFAULT_EXHIB_PARAM_NOT_FOUND_TC507", data.exhibitionParamNotFound507.getPropertyString());
        Application.SETTINGS.setProperty("DEFAULT_EXHIB_GB600", data.exhibitionGb600.getPropertyString());
        Application.SETTINGS.setProperty("DEFAULT_EXHIB_PARAM_NOT_FOUND_GB600", data.exhibitionParamNotFoundGb600.getPropertyString());
        Application.SETTINGS.setProperty("DEFAULT_EXHIB_GB601", data.exhibitionGb601.getPropertyString());
        Application.SETTINGS.setProperty("DEFAULT_EXHIB_PARAM_NOT_FOUND_GB601", data.exhibitionParamNotFoundGb601.getPropertyString());
        Application.SETTINGS.setProperty("DEFAULT_EXHIB_TC506S", data.exhibition506s.getPropertyString());
        Application.SETTINGS.setProperty("DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506S", data.exhibitionParamNotFound506s.getPropertyString());
        Application.SETTINGS.setProperty("DEFAULT_EXHIB_TC506E", data.exhibition506e.getPropertyString());
        Application.SETTINGS.setProperty("DEFAULT_EXHIB_PARAM_NOT_FOUND_TC506E", data.exhibitionParamNotFound506e.getPropertyString());
        Application.SETTINGS.setProperty("DEFAULT_EXHIB_TC406E", data.exhibition406e.getPropertyString());
        Application.SETTINGS.setProperty("DEFAULT_EXHIB_PARAM_NOT_FOUND_TC406E", data.exhibitionParamNotFound406e.getPropertyString());
    }

    public void salvaTeste(String codebar) throws IOException {
        BufferedWriter fr = new BufferedWriter(new FileWriter(this.baseDir + "/\\codeBar.txt"));
        fr.write(codebar);
        fr.close();
    }

    public void disableOkBtn() {
        this.btnOk.setEnabled(false);
    }

    public void disableApplyBtn() {
        this.btnApply.setEnabled(false);
    }

    public class GuiData {
        public String label1;
        public String label2;
        public String labelNotFound;
        public Currency currency;
        public Exhibition exhibition506s;
        public ExhibitionParam exhibitionParamNotFound506s;
        public Exhibition exhibition506e;
        public ExhibitionParam exhibitionParamNotFound506e;
        public Exhibition exhibition406e;
        public ExhibitionParam exhibitionParamNotFound406e;
        public Exhibition exhibition406;
        public ExhibitionParam exhibitionParamNotFound406;
        public Exhibition exhibition506m;
        public ExhibitionParam exhibitionParamNotFound506m;
        public Exhibition exhibition508;
        public ExhibitionParam exhibitionParamNotFound508;
        public Exhibition exhibition505;
        public ExhibitionParam exhibitionParamNotFound505;
        public Exhibition exhibition507;
        public ExhibitionParam exhibitionParamNotFound507;
        public Exhibition exhibitionGb600;
        public ExhibitionParam exhibitionParamNotFoundGb600;
        public Exhibition exhibitionGb601;
        public ExhibitionParam exhibitionParamNotFoundGb601;

        private GuiData() {
            this.label1 = ExhibitionDialog.this.txtLabel1.getText();
            this.label2 = ExhibitionDialog.this.txtLabel2.getText();
            this.labelNotFound = ExhibitionDialog.this.txtLabelNotFound.getText();
            this.currency = (Currency)ExhibitionDialog.this.cmbDefaultCurrency.getSelectedItem();
            ExhibitionPanel.GuiData guiData506s = ExhibitionDialog.this.tab506s.getGuiData();
            this.exhibition506s = guiData506s.exhibition;
            this.exhibitionParamNotFound506s = guiData506s.notFoundExhibitionParam;
            ExhibitionPanel.GuiData guiData406 = ExhibitionDialog.this.tab406.getGuiData();
            this.exhibition406 = guiData406.exhibition;
            this.exhibitionParamNotFound406 = guiData406.notFoundExhibitionParam;
            ExhibitionPanel.GuiData guiData406e = ExhibitionDialog.this.tab406e.getGuiData();
            this.exhibition406e = guiData406e.exhibition;
            this.exhibitionParamNotFound406e = guiData406e.notFoundExhibitionParam;
            ExhibitionPanel.GuiData guiData506e = ExhibitionDialog.this.tab506e.getGuiData();
            this.exhibition506e = guiData506e.exhibition;
            this.exhibitionParamNotFound506e = guiData506e.notFoundExhibitionParam;
            ExhibitionPanel.GuiData guiData506m = ExhibitionDialog.this.tab506m.getGuiData();
            this.exhibition506m = guiData506m.exhibition;
            this.exhibitionParamNotFound506m = guiData506m.notFoundExhibitionParam;
            ExhibitionPanel.GuiData guiData508 = ExhibitionDialog.this.tab508.getGuiData();
            this.exhibition508 = guiData508.exhibition;
            this.exhibitionParamNotFound508 = guiData508.notFoundExhibitionParam;
            ExhibitionPanel.GuiData guiData505 = ExhibitionDialog.this.tab505.getGuiData();
            this.exhibition505 = guiData505.exhibition;
            this.exhibitionParamNotFound505 = guiData505.notFoundExhibitionParam;
            ExhibitionPanel.GuiData guiData507 = ExhibitionDialog.this.tab507.getGuiData();
            this.exhibition507 = guiData507.exhibition;
            this.exhibitionParamNotFound507 = guiData507.notFoundExhibitionParam;
            ExhibitionPanel.GuiData guiDataGb600 = ExhibitionDialog.this.tabGb600.getGuiData();
            this.exhibitionGb600 = guiDataGb600.exhibition;
            this.exhibitionParamNotFoundGb600 = guiDataGb600.notFoundExhibitionParam;
            ExhibitionPanel.GuiData guiDataGb601 = ExhibitionDialog.this.tabGb601.getGuiData();
            this.exhibitionGb601 = guiDataGb601.exhibition;
            this.exhibitionParamNotFoundGb601 = guiDataGb601.notFoundExhibitionParam;
        }
    }
}

