/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.ApplicationSettings;
import br.com.gertec.tc.server.bean.TerminalGroup;
import br.com.gertec.tc.server.gui.util.GuiDialog;
import br.com.gertec.tc.server.gui.util.TextField;
import br.com.gertec.tc.server.protocol.GenericTc;
import br.org.reconcavo.j18n.J18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class GroupCreateEditDialog
extends GuiDialog {
    private static final long serialVersionUID = 1L;
    private final List<TerminalGroup> terminalGroups = Application.SETTINGS.getTerminalGroups();
    private final JPanel contentPanel = new JPanel();
    private final TextField txtGroupName;
    private final JList<GenericTc> uiTerminalList;
    private final JList<GenericTc> uiGroupList;
    private final GenericTcListModel groupModel;
    private final GenericTcListModel terminalModel;
    private final JScrollPane scrollUiTerminalList;
    private final JScrollPane scrollUiGroupList;
    private final JButton okButton;

    private static boolean containsNameIgnoreCase(Collection<TerminalGroup> groups, String name) {
        for (TerminalGroup terminalGroup : groups) {
            String groupName = terminalGroup.getName();
            if (groupName == null || !groupName.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public GroupCreateEditDialog() {
        this((TerminalGroup)null);
    }

    public GroupCreateEditDialog(TerminalGroup group) {
        super(group);
        this.setTitle(J18N.tr(group == null ? "Create group" : "Edit Group", new Object[0]));
        this.setMinimumSize(new Dimension(320, 320));
        this.getContentPane().setLayout(new BorderLayout());
        GridBagLayout gblContentPanel = new GridBagLayout();
        gblContentPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0};
        gblContentPanel.columnWeights = new double[]{1.0, 0.0, 1.0};
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 0, 5));
        this.contentPanel.setLayout(gblContentPanel);
        this.getContentPane().add((Component)this.contentPanel, "Center");
        JLabel lblGroupName = new JLabel(J18N.tr("Group name", new Object[0]) + ":*");
        GridBagConstraints gbcLblGroupName = new GridBagConstraints();
        gbcLblGroupName.anchor = 17;
        gbcLblGroupName.gridx = 0;
        gbcLblGroupName.gridy = 0;
        gbcLblGroupName.gridwidth = 3;
        this.contentPanel.add((Component)lblGroupName, gbcLblGroupName);
        this.txtGroupName = new TextField(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onChange() {
                super.onChange();
                GroupCreateEditDialog.this.refreshUi();
            }
        };
        GridBagConstraints gbcTxtGroupName = new GridBagConstraints();
        gbcTxtGroupName.fill = 2;
        gbcTxtGroupName.insets = new Insets(5, 0, 0, 0);
        gbcTxtGroupName.gridx = 0;
        gbcTxtGroupName.gridy = 1;
        gbcTxtGroupName.gridwidth = 3;
        this.contentPanel.add((Component)this.txtGroupName, gbcTxtGroupName);
        JLabel lblAvailable = new JLabel(J18N.tr("Available Terminals", new Object[0]));
        GridBagConstraints gbcLblAvailable = new GridBagConstraints();
        gbcLblAvailable.anchor = 17;
        gbcLblAvailable.insets = new Insets(5, 0, 0, 0);
        gbcLblAvailable.gridx = 0;
        gbcLblAvailable.gridy = 2;
        this.contentPanel.add((Component)lblAvailable, gbcLblAvailable);
        GridBagConstraints gbcUiTerminalList = new GridBagConstraints();
        gbcUiTerminalList.insets = new Insets(5, 0, 0, 0);
        this.terminalModel = new GenericTcListModel();
        this.uiTerminalList = new JList<GenericTc>(this.terminalModel);
        this.uiTerminalList.setCellRenderer(new TcClientRenderer());
        this.uiTerminalList.setSelectionMode(0);
        gbcUiTerminalList.gridx = 0;
        gbcUiTerminalList.gridy = 3;
        gbcUiTerminalList.weighty = 1.0;
        gbcUiTerminalList.fill = 1;
        this.scrollUiTerminalList = new JScrollPane(this.uiTerminalList);
        this.contentPanel.add((Component)this.scrollUiTerminalList, gbcUiTerminalList);
        JPanel centerPanel = new JPanel();
        GridBagConstraints gbcCenterPanel = new GridBagConstraints();
        gbcCenterPanel.insets = new Insets(5, 5, 0, 0);
        gbcCenterPanel.fill = 1;
        gbcCenterPanel.gridx = 1;
        gbcCenterPanel.gridy = 3;
        this.contentPanel.add((Component)centerPanel, gbcCenterPanel);
        GridBagLayout gblPanel = new GridBagLayout();
        gblPanel.columnWidths = new int[]{0, 0};
        gblPanel.rowHeights = new int[]{0, 0, 0, 0, 0};
        gblPanel.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gblPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        centerPanel.setLayout(gblPanel);
        JButton btnAdd = new JButton(J18N.tr("Add", new Object[0]) + " >>");
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupCreateEditDialog.this.moveItem((GenericTc)GroupCreateEditDialog.this.uiTerminalList.getSelectedValue(), true);
            }
        });
        GridBagConstraints gbcBtnAdd = new GridBagConstraints();
        gbcBtnAdd.fill = 2;
        gbcBtnAdd.insets = new Insets(0, 0, 5, 0);
        gbcBtnAdd.gridx = 0;
        gbcBtnAdd.gridy = 0;
        centerPanel.add((Component)btnAdd, gbcBtnAdd);
        JButton btnAddAll = new JButton(J18N.tr("Add all", new Object[0]) + " >>");
        btnAddAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupCreateEditDialog.this.moveAll(true);
            }
        });
        GridBagConstraints gbcBtnAddAll = new GridBagConstraints();
        gbcBtnAddAll.fill = 2;
        gbcBtnAddAll.insets = new Insets(0, 0, 5, 0);
        gbcBtnAddAll.gridx = 0;
        gbcBtnAddAll.gridy = 1;
        centerPanel.add((Component)btnAddAll, gbcBtnAddAll);
        JButton btnRemove = new JButton("<< " + J18N.tr("Remove", new Object[0]));
        btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupCreateEditDialog.this.moveItem((GenericTc)GroupCreateEditDialog.this.uiGroupList.getSelectedValue(), false);
            }
        });
        GridBagConstraints gbcBtnRemove = new GridBagConstraints();
        gbcBtnRemove.fill = 2;
        gbcBtnRemove.insets = new Insets(0, 0, 5, 0);
        gbcBtnRemove.gridx = 0;
        gbcBtnRemove.gridy = 2;
        centerPanel.add((Component)btnRemove, gbcBtnRemove);
        JButton btnRemoveAll = new JButton("<< " + J18N.tr("Remove all", new Object[0]));
        btnRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupCreateEditDialog.this.moveAll(false);
            }
        });
        GridBagConstraints gbcBtnRemoveAll = new GridBagConstraints();
        gbcBtnRemoveAll.fill = 2;
        gbcBtnRemoveAll.gridx = 0;
        gbcBtnRemoveAll.gridy = 3;
        centerPanel.add((Component)btnRemoveAll, gbcBtnRemoveAll);
        JLabel lblGroupMembers = new JLabel(J18N.tr("Group members", new Object[0]));
        GridBagConstraints gbcLblGroupMembers = new GridBagConstraints();
        gbcLblGroupMembers.anchor = 17;
        gbcLblGroupMembers.insets = new Insets(5, 5, 0, 0);
        gbcLblGroupMembers.gridx = 2;
        gbcLblGroupMembers.gridy = 2;
        this.contentPanel.add((Component)lblGroupMembers, gbcLblGroupMembers);
        this.groupModel = new GenericTcListModel();
        this.uiGroupList = new JList<GenericTc>(this.groupModel);
        this.uiGroupList.setCellRenderer(new TcClientRenderer());
        GridBagConstraints gbcUiGroupList = new GridBagConstraints();
        gbcUiGroupList.insets = new Insets(5, 5, 0, 0);
        gbcUiGroupList.gridx = 2;
        gbcUiGroupList.gridy = 3;
        gbcUiGroupList.weighty = 1.0;
        gbcUiGroupList.fill = 1;
        this.uiGroupList.setSelectionMode(0);
        this.scrollUiGroupList = new JScrollPane(this.uiGroupList);
        this.contentPanel.add((Component)this.scrollUiGroupList, gbcUiGroupList);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.okButton = new JButton(J18N.tr("OK", new Object[0]));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupCreateEditDialog.this.onOk();
            }
        });
        buttonPane.add(this.okButton);
        JButton cancelButton = new JButton(J18N.tr("Cancel", new Object[0]));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupCreateEditDialog.this.dispose();
            }
        });
        buttonPane.add(cancelButton);
        this.setDefaultButton(this.okButton);
        this.setCancelButton(cancelButton);
        this.init();
    }

    public final TerminalGroup getGroup() {
        return (TerminalGroup)this.getManagedObject();
    }

    private void init() {
        TerminalGroup managedGroup = this.getGroup();
        if (managedGroup == null) {
            for (GenericTc tc : Application.SERVER_MANAGER.getClients()) {
                if (tc.getMacAddress() == null || tc.getMacAddress().isEmpty() || ApplicationSettings.getInstance().verifyHasGroup(tc.getMacAddress())) continue;
                this.terminalModel.addElement(tc);
            }
        } else {
            this.txtGroupName.setText(managedGroup.getName());
            for (int i = 0; i < Application.SERVER_MANAGER.getClients().size(); ++i) {
                boolean belongsToGroup;
                GenericTc client = Application.SERVER_MANAGER.getClients().get(i);
                if ((client.getMacAddress() == null || ApplicationSettings.getInstance().verifyHasGroup(client.getMacAddress())) && !ApplicationSettings.getInstance().isFromGroup(managedGroup.getName(), client.getMacAddress())) continue;
                boolean bl = belongsToGroup = managedGroup.getByMac(client.getMacAddress()) != null;
                if (belongsToGroup) {
                    this.groupModel.addElement(client);
                    continue;
                }
                this.terminalModel.addElement(client);
            }
            for (GenericTc terminal : managedGroup) {
                boolean added = this.groupModel.containsMac(terminal.getMacAddress());
                if (added) continue;
                this.groupModel.addElement(terminal);
            }
        }
        this.refreshUi();
        this.pack();
    }

    private String getGuiGroupName() {
        return this.txtGroupName.getText().trim();
    }

    private void refreshUi() {
        String tooltip;
        boolean valid = !this.getGuiGroupName().isEmpty();
        String string = tooltip = valid ? "" : J18N.tr("Group name cannot be empty", new Object[0]);
        if (valid) {
            String guiGroupName = this.getGuiGroupName();
            if (this.getGroup() != null) {
                if (!guiGroupName.equals(this.getGroup().getName()) && GroupCreateEditDialog.containsNameIgnoreCase(this.terminalGroups, guiGroupName)) {
                    valid = false;
                }
            } else {
                valid = !GroupCreateEditDialog.containsNameIgnoreCase(this.terminalGroups, guiGroupName);
            }
            tooltip = valid ? tooltip : J18N.tr("A group with the same name is already registered", new Object[0]);
        }
        this.txtGroupName.setValid(valid);
        this.txtGroupName.setToolTipText(tooltip);
        this.okButton.setEnabled(valid);
    }

    private void moveItem(GenericTc tc, boolean add) {
        try {
            if (add) {
                if (!this.terminalModel.containsMac(tc.getMacAddress())) {
                    throw new RuntimeException("Terminal does not belong to available list");
                }
                this.terminalModel.removeElement(tc);
                this.groupModel.addElement(tc);
            } else {
                if (!this.groupModel.containsMac(tc.getMacAddress())) {
                    throw new RuntimeException("Terminal does not belong to group list");
                }
                this.terminalModel.addElement(tc);
                this.groupModel.removeElement(tc);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.scrollUiTerminalList.repaint();
        this.scrollUiGroupList.repaint();
    }

    private void moveAll(boolean add) {
        GenericTcListModel destModel;
        GenericTcListModel srcModel;
        if (add) {
            srcModel = this.terminalModel;
            destModel = this.groupModel;
        } else {
            srcModel = this.groupModel;
            destModel = this.terminalModel;
        }
        while (!srcModel.isEmpty()) {
            destModel.addElement(srcModel.remove(0));
        }
        this.scrollUiTerminalList.repaint();
        this.scrollUiGroupList.repaint();
    }

    private TerminalGroup getUiGroup() {
        TerminalGroup terminalGroup = new TerminalGroup();
        terminalGroup.setName(this.txtGroupName.getText());
        for (int i = 0; i < this.groupModel.getSize(); ++i) {
            terminalGroup.add((GenericTc)this.groupModel.get(i));
        }
        return terminalGroup;
    }

    private void onOk() {
        if (this.getManagedObject() == null) {
            this.create();
        } else {
            this.update();
        }
    }

    private void create() {
        int result;
        String groupName = this.txtGroupName.getText();
        TerminalGroup existingGroup = ApplicationSettings.getInstance().getTerminalGroup(groupName);
        if (existingGroup != null) {
            JOptionPane.showMessageDialog(null, String.format(J18N.tr("A group with name '%s' already exists", new Object[0]), groupName), Application.APP_NAME, 2);
            return;
        }
        if (this.groupModel.isEmpty() && (result = JOptionPane.showConfirmDialog(null, J18N.tr("Group is empty. Do you want to proceed?", new Object[0]), Application.APP_NAME, 0, 2)) != 0) {
            return;
        }
        TerminalGroup group = this.getUiGroup();
        Application.SETTINGS.addTerminalGroup(group);
        this.dispose(group);
    }

    private void update() {
        TerminalGroup previousGroup = (TerminalGroup)this.getManagedObject();
        TerminalGroup newGroup = this.getUiGroup();
        ApplicationSettings settings = ApplicationSettings.getInstance();
        settings.removeTerminalGroup(previousGroup.getName());
        settings.addTerminalGroup(newGroup);
        this.dispose(newGroup);
    }

    private static class TcClientRenderer
    extends JLabel
    implements ListCellRenderer<GenericTc> {
        private static final long serialVersionUID = 1L;

        public TcClientRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends GenericTc> list, GenericTc client, int index, boolean isSelected, boolean cellHasFocus) {
            try {
                if (client.getConnection() != null) {
                    this.setText(String.format("%s (%s)", client.getIpAddress().getHostAddress(), client.getTcName()));
                } else {
                    this.setText(String.format(J18N.tr("%s (OFFLINE)", client.getMacAddress()), new Object[0]));
                }
                if (isSelected) {
                    this.setBackground(UIManager.getColor("List.selectionBackground"));
                    this.setForeground(UIManager.getColor("List.selectionForeground"));
                } else {
                    this.setBackground(UIManager.getColor("List.background"));
                    this.setForeground(UIManager.getColor("List.foreground"));
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return this;
        }
    }

    private static class GenericTcListModel
    extends DefaultListModel<GenericTc> {
        private static final long serialVersionUID = 1L;

        private GenericTcListModel() {
        }

        public boolean containsMac(String mac) {
            for (int i = 0; i < this.getSize(); ++i) {
                GenericTc tc = (GenericTc)this.get(i);
                String mMac = tc.getMacAddress();
                if (!Objects.equals(mac.toLowerCase(), mMac.toLowerCase())) continue;
                return true;
            }
            return false;
        }
    }
}

