/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.dao.Product;
import br.com.gertec.tc.server.dao.TextDbProductDao;
import br.com.gertec.tc.server.gui.ExhibitionDialog;
import br.com.gertec.tc.server.gui.ProductDbDialog;
import br.com.gertec.tc.server.gui.ProductTable;
import br.com.gertec.tc.server.gui.util.ProgressBarBuilder;
import br.com.gertec.tc.server.gui.util.TextField;
import br.com.gertec.tc.server.util.Resources;
import br.org.reconcavo.j18n.J18N;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.LineBorder;

public class ProductListPanel
extends JPanel
implements J18N.LocaleChangeListener {
    private static final long serialVersionUID = 1L;
    private TextDbProductDao.AutoReloadListener textDbAutoReloadListener = new TextDbProductDao.AutoReloadListener(){

        @Override
        public void onAutoReload(TextDbProductDao dao) {
            ProductListPanel.this.productTable.refresh();
        }
    };
    private final JButton btnAddProduct;
    private final JButton btnDbSettings;
    private final JButton btnFilter;
    private final JButton btnStandardExhibition;
    private final ProductTable productTable;
    private final JPanel buttonPanel;
    private final TextField txtFilter;
    private boolean filter = false;
    private JDialog dlg;
    private Frame parentFrame;
    private Window parentWindow = SwingUtilities.windowForComponent(this);

    public ProductListPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowHeights = new int[]{0, 220};
        gridBagLayout.rowWeights = new double[]{0.0, 1.0};
        gridBagLayout.columnWeights = new double[]{1.0};
        this.setLayout(gridBagLayout);
        this.buttonPanel = new JPanel();
        GridBagConstraints gbcButtonPanel = new GridBagConstraints();
        gbcButtonPanel.fill = 1;
        gbcButtonPanel.gridx = 0;
        gbcButtonPanel.gridy = 0;
        this.add((Component)this.buttonPanel, gbcButtonPanel);
        GridBagLayout gblButtonPanel = new GridBagLayout();
        gblButtonPanel.columnWidths = new int[]{146, 146, 146, 0, 0};
        gblButtonPanel.rowHeights = new int[]{26, 0};
        gblButtonPanel.columnWeights = new double[]{0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        gblButtonPanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.buttonPanel.setLayout(gblButtonPanel);
        this.btnAddProduct = new JButton();
        this.btnAddProduct.setIcon(Resources.getImageIcon("/res/img_add.png"));
        this.btnAddProduct.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JButton okay = new JButton("Ok");
                okay.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JOptionPane pane = ProductListPanel.this.getOptionPane((JComponent)e.getSource());
                        pane.setValue(okay);
                    }
                });
                okay.setEnabled(false);
                final JButton cancel = new JButton("Cancel");
                cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JOptionPane pane = ProductListPanel.this.getOptionPane((JComponent)e.getSource());
                        pane.setValue(cancel);
                    }
                });
                final JTextField barCodeField = new JTextField(20);
                final JTextField descriptionField = new JTextField(20);
                final JTextField price1Field = new JTextField(20);
                JTextField price2Field = new JTextField(20);
                barCodeField.addKeyListener(new KeyListener(){

                    @Override
                    public void keyReleased(KeyEvent e) {
                        if (barCodeField.getText().length() == 0) {
                            barCodeField.setBorder(new LineBorder(Color.RED, 1, true));
                            if (descriptionField.getText().length() == 0) {
                                descriptionField.setBorder(new LineBorder(Color.RED, 1, true));
                            } else {
                                descriptionField.setBorder(new LineBorder(Color.BLACK, 1, true));
                            }
                            if (price1Field.getText().length() == 0) {
                                price1Field.setBorder(new LineBorder(Color.RED, 1, true));
                            } else {
                                price1Field.setBorder(new LineBorder(Color.BLACK, 1, true));
                            }
                            okay.setEnabled(false);
                        } else {
                            barCodeField.setBorder(new LineBorder(Color.BLACK, 1, true));
                            if (descriptionField.getText().length() == 0) {
                                descriptionField.setBorder(new LineBorder(Color.RED, 1, true));
                                if (price1Field.getText().length() == 0) {
                                    price1Field.setBorder(new LineBorder(Color.RED, 1, true));
                                }
                            } else {
                                descriptionField.setBorder(new LineBorder(Color.BLACK, 1, true));
                                if (price1Field.getText().length() == 0) {
                                    price1Field.setBorder(new LineBorder(Color.RED, 1, true));
                                } else {
                                    price1Field.setBorder(new LineBorder(Color.BLACK, 1, true));
                                    okay.setEnabled(true);
                                }
                            }
                        }
                    }

                    @Override
                    public void keyPressed(KeyEvent e) {
                    }

                    @Override
                    public void keyTyped(KeyEvent e) {
                    }
                });
                descriptionField.addKeyListener(new KeyListener(){

                    @Override
                    public void keyReleased(KeyEvent e) {
                        if (barCodeField.getText().length() == 0) {
                            barCodeField.setBorder(new LineBorder(Color.RED, 1, true));
                            if (descriptionField.getText().length() == 0) {
                                descriptionField.setBorder(new LineBorder(Color.RED, 1, true));
                            } else {
                                descriptionField.setBorder(new LineBorder(Color.BLACK, 1, true));
                            }
                            if (price1Field.getText().length() == 0) {
                                price1Field.setBorder(new LineBorder(Color.RED, 1, true));
                            } else {
                                price1Field.setBorder(new LineBorder(Color.BLACK, 1, true));
                            }
                            okay.setEnabled(false);
                        } else {
                            barCodeField.setBorder(new LineBorder(Color.BLACK, 1, true));
                            if (descriptionField.getText().length() == 0) {
                                descriptionField.setBorder(new LineBorder(Color.RED, 1, true));
                                if (price1Field.getText().length() == 0) {
                                    price1Field.setBorder(new LineBorder(Color.RED, 1, true));
                                }
                            } else {
                                descriptionField.setBorder(new LineBorder(Color.BLACK, 1, true));
                                if (price1Field.getText().length() == 0) {
                                    price1Field.setBorder(new LineBorder(Color.RED, 1, true));
                                } else {
                                    price1Field.setBorder(new LineBorder(Color.BLACK, 1, true));
                                    okay.setEnabled(true);
                                }
                            }
                        }
                    }

                    @Override
                    public void keyPressed(KeyEvent e) {
                    }

                    @Override
                    public void keyTyped(KeyEvent e) {
                    }
                });
                price1Field.addKeyListener(new KeyListener(){

                    @Override
                    public void keyReleased(KeyEvent e) {
                        if (barCodeField.getText().length() == 0) {
                            barCodeField.setBorder(new LineBorder(Color.RED, 1, true));
                            if (descriptionField.getText().length() == 0) {
                                descriptionField.setBorder(new LineBorder(Color.RED, 1, true));
                            } else {
                                descriptionField.setBorder(new LineBorder(Color.BLACK, 1, true));
                            }
                            if (price1Field.getText().length() == 0) {
                                price1Field.setBorder(new LineBorder(Color.RED, 1, true));
                            } else {
                                price1Field.setBorder(new LineBorder(Color.BLACK, 1, true));
                            }
                            okay.setEnabled(false);
                        } else {
                            barCodeField.setBorder(new LineBorder(Color.BLACK, 1, true));
                            if (descriptionField.getText().length() == 0) {
                                descriptionField.setBorder(new LineBorder(Color.RED, 1, true));
                                if (price1Field.getText().length() == 0) {
                                    price1Field.setBorder(new LineBorder(Color.RED, 1, true));
                                }
                            } else {
                                descriptionField.setBorder(new LineBorder(Color.BLACK, 1, true));
                                if (price1Field.getText().length() == 0) {
                                    price1Field.setBorder(new LineBorder(Color.RED, 1, true));
                                } else {
                                    price1Field.setBorder(new LineBorder(Color.BLACK, 1, true));
                                    okay.setEnabled(true);
                                }
                            }
                        }
                    }

                    @Override
                    public void keyPressed(KeyEvent e) {
                    }

                    @Override
                    public void keyTyped(KeyEvent e) {
                    }
                });
                JPanel myPanel = new JPanel();
                myPanel.add(new JLabel(J18N.tr("Barcode", new Object[0]) + ":"));
                myPanel.add(barCodeField);
                myPanel.setLayout(new GridLayout(0, 1));
                myPanel.add(new JLabel(J18N.tr("Description", new Object[0]) + ":"));
                myPanel.add(descriptionField);
                myPanel.add(new JLabel(J18N.tr("Price", new Object[0]) + " 1:"));
                myPanel.add(price1Field);
                myPanel.add(new JLabel(J18N.tr("Price", new Object[0]) + " 2:"));
                myPanel.add(price2Field);
                descriptionField.addKeyListener(new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                    }

                    @Override
                    public void keyReleased(KeyEvent e) {
                    }

                    @Override
                    public void keyPressed(KeyEvent e) {
                    }
                });
                int result = JOptionPane.showOptionDialog(null, myPanel, J18N.tr("Enter new product barcode", new Object[0]), 2, 3, null, new Object[]{okay, cancel}, okay);
                if (result == 0) {
                    String barCode = barCodeField.getText();
                    String description = descriptionField.getText();
                    String price1 = price1Field.getText();
                    String price2 = price2Field.getText();
                    if (!ProductListPanel.this.txtFilter.getText().isEmpty() && ProductListPanel.this.isFilter()) {
                        ProductListPanel.this.filterDefaultTable();
                        ProductListPanel.this.txtFilter.setText("");
                        ProductListPanel.this.productTable.addNewProduct(barCode, description, price1, price2);
                    } else {
                        ProductListPanel.this.productTable.addNewProduct(barCode, description, price1, price2);
                    }
                }
            }
        });
        GridBagConstraints gbcBtnAddProduct = new GridBagConstraints();
        gbcBtnAddProduct.fill = 1;
        gbcBtnAddProduct.gridx = 0;
        gbcBtnAddProduct.gridy = 0;
        this.buttonPanel.add((Component)this.btnAddProduct, gbcBtnAddProduct);
        this.btnDbSettings = new JButton();
        this.btnDbSettings.setIcon(Resources.getImageIcon("/res/img_db.png"));
        this.btnDbSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Product.LoadedDataListener loadedDataListener = new Product.LoadedDataListener(){

                    @Override
                    public void onLoadedData() {
                        ProductListPanel.this.productTable.revalidate();
                        ProductListPanel.this.productTable.repaint();
                    }
                };
                ProductDbDialog dialog = new ProductDbDialog(loadedDataListener){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected void onClose(Object result) {
                        super.onClose(result);
                        if (result != null) {
                            ProductListPanel.this.productTable.refresh();
                            ProductListPanel.this.checkTextDbDao();
                            ProductListPanel.this.refreshUi();
                        }
                    }
                };
                dialog.setTitle(J18N.tr("Edit database", new Object[0]));
                dialog.setLocationRelativeTo(ProductListPanel.this);
                dialog.setVisible(true);
            }
        });
        GridBagConstraints gbcBtnDbSettings = new GridBagConstraints();
        gbcBtnDbSettings.fill = 1;
        gbcBtnDbSettings.insets = new Insets(0, 5, 0, 0);
        gbcBtnDbSettings.gridx = 1;
        gbcBtnDbSettings.gridy = 0;
        this.buttonPanel.add((Component)this.btnDbSettings, gbcBtnDbSettings);
        this.btnStandardExhibition = new JButton();
        this.btnStandardExhibition.setIcon(Resources.getImageIcon("/res/img_exhib.png"));
        this.btnStandardExhibition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExhibitionDialog dialog = new ExhibitionDialog();
                dialog.setLocationRelativeTo(ProductListPanel.this);
                dialog.setVisible(true);
            }
        });
        GridBagConstraints gbcBtnStandardExhibition = new GridBagConstraints();
        gbcBtnStandardExhibition.insets = new Insets(0, 5, 0, 0);
        gbcBtnStandardExhibition.fill = 1;
        gbcBtnStandardExhibition.gridx = 2;
        gbcBtnStandardExhibition.gridy = 0;
        this.buttonPanel.add((Component)this.btnStandardExhibition, gbcBtnStandardExhibition);
        this.txtFilter = new TextField();
        GridBagConstraints gbcTxtFilter = new GridBagConstraints();
        gbcTxtFilter.fill = 1;
        gbcTxtFilter.insets = new Insets(0, 5, 0, 0);
        gbcTxtFilter.gridx = 3;
        gbcTxtFilter.gridy = 0;
        this.buttonPanel.add((Component)this.txtFilter, gbcTxtFilter);
        this.txtFilter.setColumns(10);
        this.btnFilter = new JButton();
        this.btnFilter.setIcon(Resources.getImageIcon("/res/icon_filter.png"));
        this.btnFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductListPanel.this.productTable.refresh();
                ProductListPanel.this.filterTable();
                ProductListPanel.this.onFilter(true);
            }
        });
        this.txtFilter.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (ProductListPanel.this.txtFilter.getText().length() == 0 && ProductListPanel.this.isFilter()) {
                    ProductListPanel.this.filterDefaultTable();
                    ProductListPanel.this.onFilter(false);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ProductListPanel.this.btnFilter.doClick();
                }
            }
        });
        GridBagConstraints gbcBtnFilter = new GridBagConstraints();
        gbcBtnFilter.fill = 1;
        gbcBtnFilter.insets = new Insets(0, 6, 0, 0);
        gbcBtnFilter.gridx = 4;
        gbcBtnFilter.gridy = 0;
        this.buttonPanel.add((Component)this.btnFilter, gbcBtnFilter);
        this.productTable = new ProductTable();
        GridBagConstraints gbcScroll = new GridBagConstraints();
        gbcScroll.insets = new Insets(5, 0, 0, 0);
        gbcScroll.weightx = 1.0;
        gbcScroll.gridx = 0;
        gbcScroll.gridy = 1;
        gbcScroll.weighty = 1.0;
        gbcScroll.fill = 1;
        JScrollPane scroll = new JScrollPane(this.productTable);
        this.add((Component)scroll, gbcScroll);
        this.setFocusable(true);
        this.requestFocus(true);
        this.setRequestFocusEnabled(true);
        this.requestFocusInWindow();
        this.retranslateUi(true);
        this.refreshUi();
        J18N.registerListener(this);
        this.checkTextDbDao();
        this.productTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
    }

    private void checkTextDbDao() {
        Product.AbstractProductDao currentDao = Product.getCurrentDao();
        if (currentDao instanceof TextDbProductDao) {
            ((TextDbProductDao)currentDao).addAutoReloadListener(this.textDbAutoReloadListener);
        }
    }

    private void refreshUi() {
        boolean readOnlyDb = Product.getCurrentDao().isReadOnly();
        this.btnAddProduct.setEnabled(!readOnlyDb);
        this.btnAddProduct.setToolTipText(readOnlyDb ? J18N.tr("Database is read-only", new Object[0]) : null);
    }

    private void retranslateUi(boolean constructorCall) {
        this.btnStandardExhibition.setText(J18N.tr("Standard product exhibition", new Object[0]) + "...");
        this.btnAddProduct.setText(J18N.tr("Add Product", new Object[0]) + "...");
        this.btnDbSettings.setText(J18N.tr("Database settings", new Object[0]) + "...");
        this.txtFilter.setPlaceholder(J18N.tr("Search for a product", new Object[0]) + "...");
        if (!constructorCall) {
            this.productTable.retranslateUi(constructorCall);
        }
    }

    @Override
    public void onLocaleChange(Locale newLocale) {
        this.retranslateUi(false);
        this.productTable.retranslateUi(false);
    }

    private void filterTable() {
        this.dlg = ProgressBarBuilder.build(this.parentFrame, J18N.tr("Filtering table", new Object[0]));
        Application.EVENT_LOOP.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ProductListPanel.this.dlg.setVisible(true);
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }
        });
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                ProductListPanel.this.parentFrame = (Frame)ProductListPanel.this.parentWindow;
                ProductListPanel.this.productTable.filterProducts(ProductListPanel.this.txtFilter.getText());
                return null;
            }

            @Override
            protected void done() {
                Application.EVENT_LOOP.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProductListPanel.this.dlg.setVisible(false);
                    }
                });
            }
        }.execute();
    }

    private void filterDefaultTable() {
        this.productTable.refresh();
        this.dlg = ProgressBarBuilder.build(this.parentFrame, J18N.tr("Filtering table", new Object[0]));
        Application.EVENT_LOOP.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ProductListPanel.this.dlg.setVisible(true);
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }
        });
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                ProductListPanel.this.parentFrame = (Frame)ProductListPanel.this.parentWindow;
                ProductListPanel.this.productTable.filterProducts("");
                return null;
            }

            @Override
            protected void done() {
                Application.EVENT_LOOP.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProductListPanel.this.dlg.setVisible(false);
                    }
                });
            }
        }.execute();
    }

    protected JOptionPane getOptionPane(JComponent parent) {
        JOptionPane pane = null;
        pane = !(parent instanceof JOptionPane) ? this.getOptionPane((JComponent)parent.getParent()) : (JOptionPane)parent;
        return pane;
    }

    public boolean isFilter() {
        return this.filter;
    }

    public void onFilter(boolean filter) {
        this.filter = filter;
    }

    public void makeRefresh() {
        this.dlg = ProgressBarBuilder.build(this.parentFrame, J18N.tr("Filtering table", new Object[0]));
        Application.EVENT_LOOP.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ProductListPanel.this.dlg.setVisible(true);
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }
        });
        SwingWorker<Void, Void> sw = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                ProductListPanel.this.productTable.refresh();
                return null;
            }

            @Override
            protected void done() {
                Application.EVENT_LOOP.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProductListPanel.this.dlg.setVisible(false);
                    }
                });
            }
        };
        sw.execute();
    }
}

