/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.dao.Product;
import br.com.gertec.tc.server.gui.ExhibitionDialog;
import br.com.gertec.tc.server.gui.util.GuiUtils;
import br.com.gertec.tc.server.gui.util.ProductRowSorter;
import br.com.gertec.tc.server.gui.util.ProgressBarBuilder;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.util.jdbc.JdbcException;
import br.org.reconcavo.j18n.J18N;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ProductTable
extends JTable {
    private static final long serialVersionUID = 1L;
    public ProductRowSorter sorter;
    private JDialog dlg;
    private Frame parentFrame;
    private Window parentWindow = SwingUtilities.windowForComponent(this);
    private static final int COL_BARCODE = 0;
    private static final int COL_DESCRIPTION = 1;
    private static final int COL_PRICE1 = 2;
    private static final int COL_PRICE2 = 3;
    private static final int MAX_BARCODE_LENGTH = 100;
    private static final int MAX_DESCRIPTION_LENGTH = 128;
    private static final int MAX_PRICE_1_LENGTH = 100;
    private static final int MAX_PRICE_2_LENGTH = 100;
    private final JPopupMenu popup = new JPopupMenu();
    private final JMenuItem reloadPopupItem;
    private final JMenuItem deletePopupItem;
    private final JMenuItem customExhibItem;

    public ProductTable() {
        this.setModel(new ProductModel());
        this.setFillsViewportHeight(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.setAutoCreateRowSorter(false);
        this.setSelectionMode(1);
        this.sorter = new ProductRowSorter(this.getModel());
        this.sorter.addRowSorterListener(new RowSorterListener(){

            @Override
            public void sorterChanged(RowSorterEvent evt) {
                ColumnSortRequest x = ProductTable.this.getSortKeyValues(evt);
                if (x == null) {
                    ProductTable.this.refresh();
                } else {
                    switch (x) {
                        case BARCODE_ASC: {
                            ProductTable.this.getModel().ordenaListaBarcode(false);
                            break;
                        }
                        case BARCODE_DESC: {
                            ProductTable.this.getModel().ordenaListaBarcode(true);
                            break;
                        }
                        case PRICE1_ASC: {
                            ProductTable.this.getModel().ordenaListaPreco(false);
                            break;
                        }
                        case PRICE1_DESC: {
                            ProductTable.this.getModel().ordenaListaPreco(true);
                            break;
                        }
                        case PRICE2_ASC: {
                            ProductTable.this.getModel().ordenaListaPreco2(false);
                            break;
                        }
                        case PRICE2_DESC: {
                            ProductTable.this.getModel().ordenaListaPreco2(true);
                            break;
                        }
                        case DESCRIPTION_ASC: {
                            ProductTable.this.getModel().ordenaListaDescription(false);
                            break;
                        }
                        case DESCRIPTION_DESC: {
                            ProductTable.this.getModel().ordenaListaDescription(true);
                            break;
                        }
                        default: {
                            ProductTable.this.refresh();
                        }
                    }
                }
            }
        });
        this.reloadPopupItem = new JMenuItem();
        this.reloadPopupItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductTable.this.dlg = ProgressBarBuilder.build(ProductTable.this.parentFrame, J18N.tr("Filtering table", new Object[0]));
                Application.EVENT_LOOP.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ProductTable.this.dlg.setVisible(true);
                        }
                        catch (NullPointerException e) {
                            e.printStackTrace();
                        }
                    }
                });
                new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        ProductTable.this.parentFrame = (Frame)ProductTable.this.parentWindow;
                        ProductTable.this.reload();
                        Log.infoTag("DB", J18N.tr("DB was manually reloaded", new Object[0]), new Object[0]);
                        return null;
                    }

                    @Override
                    protected void done() {
                        Application.EVENT_LOOP.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ProductTable.this.dlg.setVisible(false);
                            }
                        });
                    }
                }.execute();
            }
        });
        this.popup.add(this.reloadPopupItem);
        this.deletePopupItem = new JMenuItem();
        this.deletePopupItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = JOptionPane.showConfirmDialog(ProductTable.this, J18N.tr("Do you want to delete selected product(s)?", new Object[0]), Application.APP_NAME, 0);
                if (result == 0) {
                    ProductTable.this.deleteSelected();
                }
            }
        });
        this.popup.add(this.deletePopupItem);
        this.customExhibItem = new JMenuItem();
        this.customExhibItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Product selectedProduct = ProductTable.this.getFirstSelectedProduct();
                ExhibitionDialog dialog = new ExhibitionDialog(selectedProduct);
                dialog.setVisible(true);
            }
        });
        this.popup.add(this.customExhibItem);
        this.retranslateUi(true);
        this.setRowSorter(this.sorter);
    }

    @Override
    public ProductModel getModel() {
        TableModel superModel = super.getModel();
        if (superModel instanceof ProductModel) {
            return (ProductModel)super.getModel();
        }
        return null;
    }

    public void addNewProduct(String barCode, String description, String price1, String price2) {
        this.getModel().addNewProduct(barCode, description, price1, price2);
    }

    public void reload() {
        this.getModel().reload();
    }

    public void refresh() {
        this.getModel().refresh();
    }

    public void setProductDao(Product.AbstractProductDao dao) {
        Product.setCurrentDao(dao);
        this.deletePopupItem.setVisible(!dao.isReadOnly());
        this.getModel().reload();
    }

    @Override
    public JPopupMenu getComponentPopupMenu() {
        boolean readOnly = Product.getCurrentDao().isReadOnly();
        int selectedRowCount = this.getSelectedRowCount();
        this.deletePopupItem.setVisible(!readOnly && selectedRowCount > 0);
        this.customExhibItem.setVisible(selectedRowCount == 1);
        return this.popup;
    }

    void retranslateUi(boolean constructorCall) {
        this.reloadPopupItem.setText(J18N.tr("Reload", new Object[0]));
        this.deletePopupItem.setText(J18N.tr("Delete selected", new Object[0]));
        this.customExhibItem.setText(J18N.tr("Customize product exhibition...", new Object[0]));
        if (!constructorCall) {
            JTableHeader header = this.getTableHeader();
            TableColumnModel columns = header.getColumnModel();
            for (int col = 0; col <= 3; ++col) {
                columns.getColumn(col).setHeaderValue(this.getModel().getColumnName(col));
            }
        }
    }

    public void selectProduct(Product product) {
        int modelIndex = this.getModel().indexOf(product);
        if (modelIndex != -1) {
            int viewIndex = this.convertRowIndexToView(modelIndex);
            this.setRowSelectionInterval(viewIndex, viewIndex);
            this.scrollRectToVisible(this.getCellRect(viewIndex, 0, true));
        }
    }

    public Product getProduct(int viewIndex) {
        if (viewIndex == -1) {
            return null;
        }
        return this.getModel().getProduct(this.convertRowIndexToModel(viewIndex));
    }

    public Product getFirstSelectedProduct() {
        return this.getProduct(this.getSelectedRow());
    }

    public List<Product> getSelectedProducts() {
        LinkedList<Product> products = new LinkedList<Product>();
        for (int row : this.getSelectedRows()) {
            products.add(this.getProduct(row));
        }
        return products;
    }

    public void deleteSelected() {
        for (Product product : this.getSelectedProducts()) {
            this.getModel().deleteProduct(product);
            Log.warningTag("DB", J18N.tr("Deleted product '%s'", product.getBarcode()), new Object[0]);
        }
    }

    public void filterProducts(String searchString) {
        if (searchString != null && !searchString.isEmpty()) {
            this.getModel().filtroDeBusca(searchString);
        }
    }

    public ColumnSortRequest getSortKeyValues(RowSorterEvent evt) {
        block14: {
            try {
                if (((Object)((RowSorter)evt.getSource()).getSortKeys().get(0)).equals(new RowSorter.SortKey(2, SortOrder.ASCENDING)) || ((Object)((RowSorter)evt.getSource()).getSortKeys().get(0)).equals(new RowSorter.SortKey(2, SortOrder.DESCENDING))) {
                    if (((RowSorter)evt.getSource()).getSortKeys().get(0).getSortOrder().equals((Object)SortOrder.ASCENDING)) {
                        return ColumnSortRequest.PRICE1_ASC;
                    }
                    if (((RowSorter)evt.getSource()).getSortKeys().get(0).getSortOrder().equals((Object)SortOrder.DESCENDING)) {
                        return ColumnSortRequest.PRICE1_DESC;
                    }
                    break block14;
                }
                if (((Object)((RowSorter)evt.getSource()).getSortKeys().get(0)).equals(new RowSorter.SortKey(3, SortOrder.ASCENDING)) || ((Object)((RowSorter)evt.getSource()).getSortKeys().get(0)).equals(new RowSorter.SortKey(3, SortOrder.DESCENDING))) {
                    if (((RowSorter)evt.getSource()).getSortKeys().get(0).getSortOrder().equals((Object)SortOrder.ASCENDING)) {
                        return ColumnSortRequest.PRICE2_ASC;
                    }
                    if (((RowSorter)evt.getSource()).getSortKeys().get(0).getSortOrder().equals((Object)SortOrder.DESCENDING)) {
                        return ColumnSortRequest.PRICE2_DESC;
                    }
                    break block14;
                }
                if (((Object)((RowSorter)evt.getSource()).getSortKeys().get(0)).equals(new RowSorter.SortKey(0, SortOrder.ASCENDING)) || ((Object)((RowSorter)evt.getSource()).getSortKeys().get(0)).equals(new RowSorter.SortKey(0, SortOrder.DESCENDING))) {
                    if (((RowSorter)evt.getSource()).getSortKeys().get(0).getSortOrder().equals((Object)SortOrder.ASCENDING)) {
                        return ColumnSortRequest.BARCODE_ASC;
                    }
                    if (((RowSorter)evt.getSource()).getSortKeys().get(0).getSortOrder().equals((Object)SortOrder.DESCENDING)) {
                        return ColumnSortRequest.BARCODE_DESC;
                    }
                    break block14;
                }
                if (((Object)((RowSorter)evt.getSource()).getSortKeys().get(0)).equals(new RowSorter.SortKey(1, SortOrder.ASCENDING)) || ((Object)((RowSorter)evt.getSource()).getSortKeys().get(0)).equals(new RowSorter.SortKey(1, SortOrder.DESCENDING))) {
                    if (((RowSorter)evt.getSource()).getSortKeys().get(0).getSortOrder().equals((Object)SortOrder.ASCENDING)) {
                        return ColumnSortRequest.DESCRIPTION_ASC;
                    }
                    if (((RowSorter)evt.getSource()).getSortKeys().get(0).getSortOrder().equals((Object)SortOrder.DESCENDING)) {
                        return ColumnSortRequest.DESCRIPTION_DESC;
                    }
                    break block14;
                }
                return null;
            }
            catch (IndexOutOfBoundsException e) {
                System.out.println(e.getMessage());
                return null;
            }
        }
        return null;
    }

    static enum ColumnSortRequest {
        BARCODE_ASC,
        BARCODE_DESC,
        DESCRIPTION_ASC,
        DESCRIPTION_DESC,
        PRICE1_ASC,
        PRICE1_DESC,
        PRICE2_ASC,
        PRICE2_DESC;

    }

    public class ProductModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;
        private List<Product> products;

        private void reload(boolean constructorCall) {
            try {
                if (!constructorCall) {
                    Product.getCurrentDao().reload();
                }
                this.products = Product.getAll();
            }
            catch (RuntimeException ex) {
                GuiUtils.showErrorMessage(ProductTable.this, String.format("Product DB error: %s", ex));
                this.products = new LinkedList<Product>();
            }
            this.fireTableStructureChanged();
            this.refresh();
        }

        public void filtroDeBusca(String searchString) {
            this.products = this.products.stream().filter(line -> Objects.toString(line.getBarcode(), "").toLowerCase().contains(searchString.toLowerCase()) || Objects.toString(line.getDescription(), "").toLowerCase().contains(searchString.toLowerCase()) || Objects.toString(line.getPrice1(), "").toLowerCase().contains(searchString.toLowerCase()) || Objects.toString(line.getPrice2(), "").toLowerCase().contains(searchString.toLowerCase())).collect(Collectors.toList());
            this.fireTableDataChanged();
        }

        public void ordenaListaDescription(boolean order) {
            if (!order) {
                try {
                    this.products = this.products.stream().sorted(Comparator.comparing(Product::getDescription)).collect(Collectors.toList());
                    Thread.sleep(1000L);
                    this.fireTableDataChanged();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    this.products = this.products.stream().sorted(Comparator.comparing(Product::getDescription).reversed()).collect(Collectors.toList());
                    Thread.sleep(1000L);
                    this.fireTableDataChanged();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public void ordenaListaBarcode(boolean order) {
            if (!order) {
                try {
                    this.products = this.products.stream().sorted(Comparator.comparing(Product::getBarcode)).collect(Collectors.toList());
                    Thread.sleep(1000L);
                    this.fireTableDataChanged();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    this.products = this.products.stream().sorted(Comparator.comparing(Product::getBarcode).reversed()).collect(Collectors.toList());
                    Thread.sleep(1000L);
                    this.fireTableDataChanged();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public void ordenaListaPreco(boolean order) {
            if (!order) {
                try {
                    this.products = this.products.stream().sorted(Comparator.comparing(Product::getPrice1)).collect(Collectors.toList());
                    Thread.sleep(1000L);
                    this.fireTableDataChanged();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    this.products = this.products.stream().sorted(Comparator.comparing(Product::getPrice1).reversed()).collect(Collectors.toList());
                    Thread.sleep(1000L);
                    this.fireTableDataChanged();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public void ordenaListaPreco2(boolean order) {
            if (!order) {
                try {
                    this.products = this.products.stream().sorted(Comparator.comparing(Product::getPrice2)).collect(Collectors.toList());
                    Thread.sleep(1000L);
                    this.fireTableDataChanged();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    this.products = this.products.stream().sorted(Comparator.comparing(Product::getPrice2).reversed()).collect(Collectors.toList());
                    Thread.sleep(1000L);
                    this.fireTableDataChanged();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public void refresh() {
            try {
                this.products = Product.getAll();
                if (this.products.size() > 100000) {
                    Thread.sleep(3000L);
                }
                this.fireTableStructureChanged();
                this.fireTableDataChanged();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void reload() {
            this.reload(false);
            this.refresh();
        }

        @Override
        public int getRowCount() {
            if (this.products == null) {
                return 0;
            }
            return this.products.size();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return J18N.tr("Barcode", new Object[0]);
                }
                case 1: {
                    return J18N.tr("Description", new Object[0]);
                }
                case 2: {
                    return J18N.tr("Price 1", new Object[0]);
                }
                case 3: {
                    return J18N.tr("Price 2", new Object[0]);
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return !Product.getCurrentDao().isReadOnly();
        }

        @Override
        public Object getValueAt(int row, int column) {
            Product p = this.getProduct(row);
            switch (column) {
                case 0: {
                    return p.getBarcode();
                }
                case 1: {
                    return p.getDescription();
                }
                case 2: {
                    return p.getPrice1();
                }
                case 3: {
                    return p.getPrice2();
                }
            }
            throw new IndexOutOfBoundsException("Unsupported column: " + column);
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            String oldValue;
            Product product = this.getProduct(row);
            String newValue = (String)aValue;
            if ((newValue == null || newValue.trim().equals("") || newValue.equals("")) && column != 3) {
                return;
            }
            switch (column) {
                case 0: {
                    int result;
                    oldValue = product.getBarcode();
                    if (!product.hasCustomExhibition()) {
                        if (newValue.trim().isEmpty()) {
                            GuiUtils.showErrorMessage(ProductTable.this, J18N.tr("Barcode cannot be empty", new Object[0]));
                            break;
                        }
                        product.setBarcode(newValue);
                        break;
                    }
                    if (Objects.equals(oldValue, newValue) || (result = JOptionPane.showConfirmDialog(ProductTable.this, J18N.tr("Changing product barcode will cause custom exhibitions to be lost. Do you want to proceed?", new Object[0]), Application.APP_NAME, 0, 2)) != 0) break;
                    product.setBarcode(newValue);
                    break;
                }
                case 1: {
                    oldValue = product.getDescription();
                    product.setDescription(newValue);
                    break;
                }
                case 2: {
                    oldValue = product.getPrice1();
                    product.setPrice1(newValue);
                    break;
                }
                case 3: {
                    oldValue = product.getPrice2();
                    product.setPrice2(newValue);
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException();
                }
            }
            try {
                product.save();
                this.fireTableCellUpdated(row, column);
            }
            catch (JdbcException ex) {
                int error = ex.getErrorCode();
                if (error == 23505) {
                    GuiUtils.showErrorMessage(ProductTable.this, J18N.tr("A product with the same barcode (%s) is already registered", product.getBarcode()));
                } else if (error == 22001) {
                    if (product.getBarcode().length() > 100) {
                        GuiUtils.showErrorMessage(ProductTable.this, J18N.tr("The product was not saved! Maximum allowed barcode length: %s characters!", 100));
                    }
                    if (product.getDescription().length() > 128) {
                        GuiUtils.showErrorMessage(ProductTable.this, J18N.tr("The product was not saved! Maximum allowed description length: %s characters!", 128));
                    }
                    if (product.getPrice1().length() > 100) {
                        GuiUtils.showErrorMessage(ProductTable.this, J18N.tr("The product was not saved! Maximum allowed price 1 length: %s characters!", 100));
                    }
                    if (product.getPrice2() != null && product.getPrice2().length() > 100) {
                        GuiUtils.showErrorMessage(ProductTable.this, J18N.tr("The product was not saved! Maximum allowed price 2 length: %s characters!", 100));
                    }
                } else {
                    GuiUtils.showErrorMessage(ProductTable.this, J18N.tr("Error updating database: %s", ex.getMessage()));
                }
                switch (column) {
                    case 0: {
                        product.setBarcode(oldValue);
                        break;
                    }
                    case 1: {
                        product.setDescription(oldValue);
                        break;
                    }
                    case 2: {
                        product.setPrice1(oldValue);
                        break;
                    }
                    case 3: {
                        product.setPrice2(oldValue);
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException();
                    }
                }
                this.fireTableCellUpdated(row, column);
            }
        }

        public int indexOf(Product product) {
            int i = 0;
            for (Product p : this.products) {
                if (Objects.equals(product.getBarcode(), p.getBarcode())) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public Product getProduct(int row) {
            return this.products.get(row);
        }

        public void deleteProduct(int row) {
            Product.getCurrentDao().delete(this.getProduct(row));
            this.fireTableRowsDeleted(row, row);
        }

        public void deleteProduct(Product product) {
            int row = this.indexOf(product);
            Product.getCurrentDao().delete(product);
            this.fireTableRowsDeleted(row, row);
        }

        public void addNewProduct(String barCode, String description, String price1, String price2) {
            int maxProd = 165536;
            int i = 0;
            while (i < maxProd) {
                try {
                    Product p = new Product();
                    p.setBarcode(barCode);
                    p.setDescription(description);
                    p.setPrice1(price1);
                    p.setPrice2(price2);
                    p.save();
                    this.fireTableDataChanged();
                    ProductTable.this.selectProduct(this.getProduct(this.getRowCount() - 1));
                    return;
                }
                catch (JdbcException ex) {
                    int code = ((SQLException)ex.getCause()).getErrorCode();
                    if (code != 23505) {
                        if (barCode.length() > 100) {
                            GuiUtils.showErrorMessage(ProductTable.this, J18N.tr("The product was not saved! Maximum allowed barcode length: %s characters!", 100));
                            return;
                        }
                        if (description.length() > 128) {
                            GuiUtils.showErrorMessage(ProductTable.this, J18N.tr("The product was not saved! Maximum allowed description length: %s characters!", 128));
                            return;
                        }
                        if (price1.length() > 100) {
                            GuiUtils.showErrorMessage(ProductTable.this, J18N.tr("The product was not saved! Maximum allowed price 1 length: %s characters!", 100));
                            return;
                        }
                        if (price2 != null) {
                            if (price2.length() <= 100) continue;
                            GuiUtils.showErrorMessage(ProductTable.this, J18N.tr("The product was not saved! Maximum allowed price 2 length: %s characters!", 100));
                            return;
                        }
                        GuiUtils.showErrorMessage(ProductTable.this, J18N.tr("constraint-violation exception: %s", ex.getMessage()));
                        JOptionPane.showMessageDialog(null, J18N.tr("A product with the same barcode (%s) is already registered", barCode), J18N.tr("Error", new Object[0]), 0);
                        ProductTable.this.selectProduct(Product.get(barCode));
                        return;
                    }
                    JOptionPane.showMessageDialog(null, J18N.tr("A product with the same barcode (%s) is already registered", barCode), J18N.tr("Error", new Object[0]), 0);
                    return;
                }
            }
            JOptionPane.showMessageDialog(null, J18N.tr("Maximum number of product registrations already reached!", new Object[0]), J18N.tr("Cannot create a new product", new Object[0]), 0);
            throw new RuntimeException("Cannot create a new product");
        }
    }
}

