/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.bean.Slide;
import br.com.gertec.tc.server.gui.AddMediaDialog;
import br.com.gertec.tc.server.gui.util.GuiPanel;
import br.com.gertec.tc.server.gui.util.GuiUtils;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.CommandListener;
import br.com.gertec.tc.server.protocol.sc501.Sc501Connection;
import br.com.gertec.tc.server.protocol.sc501.commands.GetListMedias;
import br.com.gertec.tc.server.protocol.sc501.commands.GetListMediasQ;
import br.com.gertec.tc.server.protocol.sc501.commands.MediaError;
import br.com.gertec.tc.server.protocol.sc501.commands.RemoveAllMedias;
import br.com.gertec.tc.server.protocol.sc501.commands.RemoveMedia;
import br.com.gertec.tc.server.util.GrouppedSettings;
import br.com.gertec.tc.server.util.Settings;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.j18n.J18N;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class Sc501EMediaPanel
extends GuiPanel {
    private static final long serialVersionUID = 1L;
    public static final String ALL_MEDIAS_CONF_FILENAME = "#getmediasconf";
    private static final String INT_MEM = "INT_MEM";
    private static final String INT_MEM_TITLE = "Internal memory";
    private final JTable table;
    private final DefaultTableModel model;
    private final JButton btnDel;

    public Sc501EMediaPanel(final Sc501Connection connection) {
        super(connection);
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowWeights = new double[]{1.0, 0.0};
        gridBagLayout.columnWeights = new double[]{1.0, 0.0};
        this.setLayout(gridBagLayout);
        this.table = new JTable();
        this.model = new DefaultTableModel(new Object[0][], new String[]{J18N.tr("Storage", new Object[0]), J18N.tr("Name", new Object[0])}){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.table.setModel(this.model);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Sc501EMediaPanel.this.btnDel.setEnabled(Sc501EMediaPanel.this.table.getSelectedRow() != -1);
            }
        });
        GridBagConstraints gbcTable = new GridBagConstraints();
        gbcTable.fill = 2;
        gbcTable.weighty = 1.0;
        gbcTable.gridx = 0;
        gbcTable.gridy = 0;
        gbcTable.weightx = 1.0;
        gbcTable.fill = 1;
        JScrollPane scroll = new JScrollPane(this.table);
        this.add((Component)scroll, gbcTable);
        GuiPanel panel1 = new GuiPanel();
        GridBagConstraints gbcPanel1 = new GridBagConstraints();
        gbcPanel1.insets = new Insets(0, 5, 0, 0);
        gbcPanel1.fill = 1;
        gbcPanel1.gridx = 1;
        gbcPanel1.gridy = 0;
        this.add((Component)panel1, gbcPanel1);
        GridBagLayout gblPanel1 = new GridBagLayout();
        gblPanel1.columnWidths = new int[]{0, 0};
        gblPanel1.rowHeights = new int[]{0, 0, 0, 0, 0};
        gblPanel1.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gblPanel1.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        panel1.setLayout(gblPanel1);
        JButton btnNew = new JButton(J18N.tr("New", new Object[0]));
        btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddMediaDialog dialog = new AddMediaDialog(Sc501EMediaPanel.this.getConnection()){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected void onClose(Object result) {
                        boolean fileSent;
                        super.onClose(result);
                        boolean bl = fileSent = result != null && (Boolean)result != false;
                        if (fileSent) {
                            Sc501EMediaPanel.this.setEnabled(false);
                        }
                    }
                };
                dialog.setLocationRelativeTo(Sc501EMediaPanel.this);
                dialog.setVisible(true);
            }
        });
        GridBagConstraints gbcBtnNew = new GridBagConstraints();
        gbcBtnNew.insets = new Insets(0, 0, 5, 0);
        gbcBtnNew.fill = 2;
        gbcBtnNew.gridx = 0;
        gbcBtnNew.gridy = 0;
        ((Container)panel1).add((Component)btnNew, gbcBtnNew);
        this.btnDel = new JButton(J18N.tr("Delete", new Object[0]));
        this.btnDel.setEnabled(false);
        this.btnDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] selectedFilePaths = Sc501EMediaPanel.this.getSelectedFilePaths();
                if (selectedFilePaths == null) {
                    GuiUtils.showWarningMessage(Sc501EMediaPanel.this, J18N.tr("Please, select media first", new Object[0]));
                } else {
                    int result = JOptionPane.showConfirmDialog(Sc501EMediaPanel.this, J18N.tr("Do you really want to delete selected file(s)?", new Object[0]), Application.APP_NAME, 0, 2);
                    if (result == 0) {
                        Sc501EMediaPanel.this.setEnabled(false);
                        Sc501Connection connection = Sc501EMediaPanel.this.getConnection();
                        for (String path : selectedFilePaths) {
                            connection.writeCommand(new RemoveMedia(path.replaceAll("null/", "")));
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                }
            }
        });
        GridBagConstraints gbcBtnDel = new GridBagConstraints();
        gbcBtnDel.insets = new Insets(5, 0, 5, 0);
        gbcBtnDel.fill = 2;
        gbcBtnDel.gridx = 0;
        gbcBtnDel.gridy = 1;
        ((Container)panel1).add((Component)this.btnDel, gbcBtnDel);
        JButton btnRemoveAll = new JButton(J18N.tr("Delete all", new Object[0]));
        btnRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] buttons = new String[]{J18N.tr("Yes", new Object[0]), J18N.tr("Cancel", new Object[0])};
                int result = JOptionPane.showOptionDialog(null, J18N.tr("By sending this command, ALL media files in the terminal will be deleted. Do you want to continue?", new Object[0]), null, 2, 2, null, buttons, buttons[1]);
                switch (result) {
                    case 0: {
                        connection.writeCommand(new RemoveAllMedias());
                        Sc501EMediaPanel.this.init();
                        return;
                    }
                    case 1: {
                        return;
                    }
                }
            }
        });
        GridBagConstraints gbcBtnRemoveAll = new GridBagConstraints();
        gbcBtnRemoveAll.insets = new Insets(10, 0, 5, 0);
        gbcBtnRemoveAll.fill = 2;
        gbcBtnRemoveAll.gridx = 0;
        gbcBtnRemoveAll.gridy = 2;
        ((Container)panel1).add((Component)btnRemoveAll, gbcBtnRemoveAll);
        Component verticalStrut = Box.createVerticalStrut(20);
        GridBagConstraints gbcVerticalStrut = new GridBagConstraints();
        gbcVerticalStrut.gridheight = 2;
        gbcVerticalStrut.insets = new Insets(5, 0, 0, 0);
        gbcVerticalStrut.fill = 1;
        gbcVerticalStrut.gridx = 0;
        gbcVerticalStrut.gridy = 2;
        ((Container)panel1).add(verticalStrut, gbcVerticalStrut);
        GuiPanel panel = new GuiPanel();
        GridBagConstraints gbcPanel = new GridBagConstraints();
        gbcPanel.gridwidth = 2;
        gbcPanel.insets = new Insets(5, 0, 0, 0);
        gbcPanel.fill = 1;
        gbcPanel.gridx = 0;
        gbcPanel.gridy = 1;
        this.add((Component)panel, gbcPanel);
        GridBagLayout gblPanel = new GridBagLayout();
        gblPanel.columnWidths = new int[]{0, 0, 118, 0};
        gblPanel.rowHeights = new int[]{0, 0};
        gblPanel.columnWeights = new double[]{0.0, 0.0, 1.0, Double.MIN_VALUE};
        gblPanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel.setLayout(gblPanel);
        Component horizontalStrut = Box.createHorizontalStrut(20);
        GridBagConstraints gbcHorizontalStrut = new GridBagConstraints();
        gbcHorizontalStrut.insets = new Insets(0, 5, 0, 0);
        gbcHorizontalStrut.fill = 1;
        gbcHorizontalStrut.gridx = 2;
        gbcHorizontalStrut.gridy = 0;
        ((Container)panel).add(horizontalStrut, gbcHorizontalStrut);
        this.init();
    }

    public final Sc501Connection getConnection() {
        return (Sc501Connection)this.getManagedObject();
    }

    private void init() {
        this.registerListeners();
        this.getConnection().writeCommand(new GetListMediasQ());
    }

    private void registerListeners() {
        this.registerSc501CommandListener("#getlistmedias", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                GetListMedias response = (GetListMedias)command;
                String file = response.getFile();
                if (file.length() > 0) {
                    Sc501EMediaPanel.this.model.setRowCount(0);
                    try {
                        GrouppedSettings allMediasConf = GrouppedSettings.loadListMedias(file);
                        Settings intMemGroup = allMediasConf.getSection(Sc501EMediaPanel.INT_MEM);
                        if (intMemGroup != null) {
                            for (Map.Entry<String, String> entry : intMemGroup.entrySet()) {
                                Sc501EMediaPanel.this.addMedia(J18N.tr(Sc501EMediaPanel.INT_MEM_TITLE, new Object[0]), entry.getValue());
                            }
                        }
                        Sc501EMediaPanel.this.setEnabled(true);
                    }
                    catch (IOException e) {
                        GuiUtils.showErrorMessage(Sc501EMediaPanel.this, J18N.tr("Error parsing %s: %s", Sc501EMediaPanel.ALL_MEDIAS_CONF_FILENAME, e.getMessage()));
                    }
                }
            }
        });
        this.registerSc501CommandListener("#removemedia_ok", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                Sc501EMediaPanel.this.getConnection().writeCommand(new GetListMediasQ());
            }
        });
        this.registerSc501CommandListener("#sendmedia_error", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                MediaError mediaError = (MediaError)command;
                Log.error(mediaError.toString(), new Object[0]);
            }
        });
        this.registerSc501CommandListener("#removemedia_ok", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                Log.error(J18N.tr("Error getting media from Terminal", new Object[0]), new Object[0]);
            }
        });
        this.registerSc501CommandListener("#removeallmedias_error\u0000", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                Log.error(J18N.tr("Error removing media from Terminal", new Object[0]), new Object[0]);
            }
        });
        this.registerSc501CommandListener("#getlistmedias_error\u0000", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                Log.error(J18N.tr("Error getting media from Terminal", new Object[0]), new Object[0]);
            }
        });
        this.registerSc501CommandListener("#removeallmedias_error\u0000", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                Log.error(J18N.tr("Error removing media from Terminal", new Object[0]), new Object[0]);
            }
        });
    }

    private void addMedia(String storageLocationTitle, String filePath) {
        Vector<String> row = new Vector<String>();
        row.add(storageLocationTitle);
        row.add(filePath);
        this.model.addRow(row);
    }

    public void addNewMedia(String storageLocationTitle, String filePath) {
        Vector<String> row = new Vector<String>();
        row.add(storageLocationTitle);
        row.add(filePath);
        this.model.addRow(row);
        this.model.fireTableDataChanged();
    }

    private String[] getSelectedFilePaths() {
        if (this.table.getSelectedRow() == -1) {
            return null;
        }
        int[] selectedRows = this.table.getSelectedRows();
        String[] paths = new String[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            Slide s = this.getSlide(selectedRows[i]);
            paths[i] = String.format("%s/%s", s.getMemory(), s.getMainFile());
        }
        return paths;
    }

    private Slide getSlide(int row) {
        Slide ep = new Slide();
        ep.setMainFile((String)this.table.getModel().getValueAt(row, 1));
        return ep;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.btnDel.setEnabled(enabled && this.table.getSelectedRow() != -1);
    }

    @Override
    public String toString() {
        return String.format("%s#%d", this.getClass().getSimpleName(), this.hashCode());
    }
}

