/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.gui.util.GuiPanel;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.CommandListener;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc501.commands.GetListMedias;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.j18n.J18N;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;

public class Sc501EMediaValidation {
    private final int NUMBER_MAX_FILES = 10;
    private final int NUMBER_MAX_CHARACTERS = 30;
    private final int MAX_HEIGHT_IMG = 240;
    private final int MAX_WIDTH_IMG = 320;
    private final int MAX_FILE_SIZE = 45000;
    GuiPanel guiPanel = new GuiPanel();
    private int numberFileInTerminal;
    private List<String> filesWithCharactersExceeded = new ArrayList<String>();
    private List<String> filesWithMidiaResolutionExceede = new ArrayList<String>();
    private List<String> filesWithFileSizeExceede = new ArrayList<String>();
    private List<String> filesWithFileInTerminal = new ArrayList<String>();
    private String filaInTerminal;

    public Sc501EMediaValidation() {
        this.registerListener();
    }

    public boolean isNumberOfImagesExceeded(int numberFiles) {
        return this.numberFileInTerminal + numberFiles > 10;
    }

    private boolean isNumberOfCharactersExceeded(File file) {
        boolean charactersExceeded;
        boolean bl = charactersExceeded = file.getName().length() > 30;
        if (charactersExceeded) {
            this.filesWithCharactersExceeded.add(file.getName());
        }
        return charactersExceeded;
    }

    private boolean isMidiaResolutionExceeded(File file) {
        try {
            boolean resolutionExceeded;
            BufferedImage fileImg = ImageIO.read(file);
            int widthFileImg = fileImg.getWidth();
            int heightFileImg = fileImg.getHeight();
            boolean bl = resolutionExceeded = widthFileImg > 320 || heightFileImg > 240;
            if (resolutionExceeded) {
                this.filesWithMidiaResolutionExceede.add(file.getName());
            }
            return resolutionExceeded;
        }
        catch (IOException e) {
            Log.debug("fails to generate in midiaResolutionExceeded()", e);
            return false;
        }
    }

    private boolean isFileSizeExceeded(File file) {
        boolean fileSizeExceeded;
        boolean bl = fileSizeExceeded = file.length() > 45000L;
        if (fileSizeExceeded) {
            this.filesWithFileSizeExceede.add(file.getName());
        }
        return fileSizeExceeded;
    }

    public boolean IsfilesExceeded(File file, TerminalType terminalType) {
        if (Sc501EMediaValidation.isTc406EOrTC506E(terminalType)) {
            boolean validationNumberOfChar = this.isNumberOfCharactersExceeded(file);
            boolean validationMediaResolution = this.isMidiaResolutionExceeded(file);
            boolean validationFileSize = this.isFileSizeExceeded(file);
            boolean validationName = this.isNameInTerminal(file);
            return validationNumberOfChar || validationFileSize || validationMediaResolution || validationName;
        }
        return false;
    }

    private boolean isNameInTerminal(File file) {
        if (file != null) {
            boolean existFileInTerminal = this.filaInTerminal.contains(file.getName());
            if (existFileInTerminal) {
                this.filesWithFileInTerminal.add(file.getName());
            }
            return existFileInTerminal;
        }
        return false;
    }

    private void registerListener() {
        this.guiPanel.registerSc501CommandListener("#getlistmedias", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                GetListMedias response = (GetListMedias)command;
                Sc501EMediaValidation.this.filaInTerminal = response.getFile();
                Sc501EMediaValidation.this.numberFileInTerminal = response.getFile().split("\\r").length - 1;
            }
        });
        this.guiPanel.registerSc501CommandListener("#medias_error\u0000", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                Log.error(J18N.tr("Error getting media from Terminal", new Object[0]), new Object[0]);
            }
        });
    }

    public void logGenerator() {
        if (this.filesWithCharactersExceeded.size() + this.filesWithFileSizeExceede.size() + this.filesWithMidiaResolutionExceede.size() + this.filesWithFileInTerminal.size() > 0) {
            int i;
            String msgExceeded = "<html><h1>" + J18N.tr("Below files are off system acceptance criteria", new Object[0]) + "</h1><br><br>";
            if (this.filesWithFileSizeExceede.size() > 0) {
                msgExceeded = msgExceeded + J18N.tr("Maximum file size (45Kb): ", new Object[0]);
                for (i = 0; i < this.filesWithFileSizeExceede.size(); ++i) {
                    msgExceeded = msgExceeded + this.filesWithFileSizeExceede.get(i) + "; ";
                }
                msgExceeded = msgExceeded + "<br><br>";
            }
            if (this.filesWithCharactersExceeded.size() > 0) {
                msgExceeded = msgExceeded + J18N.tr("Maximum filename length (30 characters): ", new Object[0]);
                for (i = 0; i < this.filesWithCharactersExceeded.size(); ++i) {
                    msgExceeded = msgExceeded + this.filesWithCharactersExceeded.get(i) + "; ";
                }
                msgExceeded = msgExceeded + "<br><br>";
            }
            if (this.filesWithMidiaResolutionExceede.size() > 0) {
                msgExceeded = msgExceeded + J18N.tr("Maximum file resolution (320x240): ", new Object[0]);
                for (i = 0; i < this.filesWithMidiaResolutionExceede.size(); ++i) {
                    msgExceeded = msgExceeded + this.filesWithMidiaResolutionExceede.get(i) + "; ";
                }
            }
            if (this.filesWithFileInTerminal.size() > 0) {
                msgExceeded = msgExceeded + J18N.tr("Esse arquivo j\u00e1 existe no terminal: ", new Object[0]);
                for (i = 0; i < this.filesWithFileInTerminal.size(); ++i) {
                    msgExceeded = msgExceeded + this.filesWithFileInTerminal.get(i) + "; ";
                }
            }
            JOptionPane.showMessageDialog(null, msgExceeded);
        }
    }

    public static boolean isTc406EOrTC506E(TerminalType terminalType) {
        return terminalType == TerminalType.TC_406_E || terminalType == TerminalType.TC_506_E;
    }
}

