/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.bean.Slide;
import br.com.gertec.tc.server.gui.AddMediaDialog;
import br.com.gertec.tc.server.gui.SlideTable;
import br.com.gertec.tc.server.gui.util.GuiPanel;
import br.com.gertec.tc.server.gui.util.GuiUtils;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.CommandListener;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc501.Sc501Connection;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.j18n.J18N;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Sc501MediaPanel
extends GuiPanel {
    private static final long serialVersionUID = 1L;
    private final SlideTable slideTable;
    private int responseCount = 0;
    private boolean isClear = false;
    private final JButton btnDel;
    private final JButton btnUp;
    private final JButton btnDown;
    private final JButton btnSave;

    public Sc501MediaPanel(Sc501Connection connection) {
        super(connection);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowWeights = new double[]{1.0};
        gridBagLayout.columnWeights = new double[]{1.0, 0.0};
        this.setLayout(gridBagLayout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        this.slideTable = new SlideTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1 || column == 2;
            }
        };
        this.slideTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Sc501MediaPanel.this.refreshGui();
            }
        });
        c.weighty = 2.0;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 1;
        JScrollPane scroll = new JScrollPane(this.slideTable);
        this.add((Component)scroll, c);
        GuiPanel buttonPanel = new GuiPanel();
        GridBagConstraints gbcButtonPanel = new GridBagConstraints();
        gbcButtonPanel.insets = new Insets(0, 5, 0, 0);
        gbcButtonPanel.fill = 1;
        gbcButtonPanel.gridx = 1;
        gbcButtonPanel.gridy = 0;
        this.add((Component)buttonPanel, gbcButtonPanel);
        GridBagLayout gblPanel = new GridBagLayout();
        gblPanel.columnWidths = new int[]{0, 0};
        gblPanel.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        gblPanel.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gblPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        buttonPanel.setLayout(gblPanel);
        JButton btnNew = new JButton(J18N.tr("New", new Object[0]));
        btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddMediaDialog dialog = new AddMediaDialog(Sc501MediaPanel.this.getConnection()){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected void onClose(Object result) {
                        super.onClose(result);
                        Slide[] slides = (Slide[])result;
                        if (slides != null) {
                            for (Slide slide : slides) {
                                Sc501MediaPanel.this.slideTable.addRow(slide);
                            }
                            Sc501MediaPanel.this.refreshGui();
                        }
                    }
                };
                dialog.setLocationRelativeTo(Sc501MediaPanel.this);
                dialog.setVisible(true);
            }
        });
        GridBagConstraints gbcBtnNew = new GridBagConstraints();
        gbcBtnNew.fill = 2;
        gbcBtnNew.gridx = 0;
        gbcBtnNew.gridy = 0;
        ((Container)buttonPanel).add((Component)btnNew, gbcBtnNew);
        this.btnDel = new JButton(J18N.tr("Delete", new Object[0]));
        this.btnDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sc501MediaPanel.this.slideTable.deleteSelected();
            }
        });
        GridBagConstraints gbcBtnDel = new GridBagConstraints();
        gbcBtnDel.fill = 2;
        gbcBtnDel.insets = new Insets(5, 0, 0, 0);
        gbcBtnDel.gridx = 0;
        gbcBtnDel.gridy = 1;
        ((Container)buttonPanel).add((Component)this.btnDel, gbcBtnDel);
        this.btnUp = new JButton("/\\");
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sc501MediaPanel.this.slideTable.moveSelection(-1);
            }
        });
        GridBagConstraints gbcBtnUp = new GridBagConstraints();
        gbcBtnUp.fill = 2;
        gbcBtnUp.insets = new Insets(5, 0, 0, 0);
        gbcBtnUp.gridx = 0;
        gbcBtnUp.gridy = 2;
        ((Container)buttonPanel).add((Component)this.btnUp, gbcBtnUp);
        this.btnDown = new JButton("\\/");
        this.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sc501MediaPanel.this.slideTable.moveSelection(1);
            }
        });
        GridBagConstraints gbcBtnDown = new GridBagConstraints();
        gbcBtnDown.fill = 2;
        gbcBtnDown.insets = new Insets(5, 0, 0, 0);
        gbcBtnDown.gridx = 0;
        gbcBtnDown.gridy = 3;
        ((Container)buttonPanel).add((Component)this.btnDown, gbcBtnDown);
        Component verticalStrut = Box.createVerticalStrut(20);
        GridBagConstraints gbcVerticalStrut = new GridBagConstraints();
        gbcVerticalStrut.fill = 1;
        gbcVerticalStrut.insets = new Insets(5, 0, 0, 0);
        gbcVerticalStrut.gridx = 0;
        gbcVerticalStrut.gridy = 4;
        ((Container)buttonPanel).add(verticalStrut, gbcVerticalStrut);
        this.btnSave = new JButton(J18N.tr("Save", new Object[0]));
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Sc501MediaPanel.this.slideTable.getData().isEmpty()) {
                    GuiUtils.showWarningMessage(Sc501MediaPanel.this, J18N.tr("There is no data to be sent", new Object[0]));
                } else {
                    Sc501MediaPanel.this.setEnabled(false);
                    Sc501MediaPanel.this.responseCount = 0;
                    Sc501MediaPanel.this.isClear = false;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int i = 0;
                            int indexMode = 1;
                            for (Slide s : Sc501MediaPanel.this.slideTable.getData()) {
                                try {
                                    Sc501Connection connection = Sc501MediaPanel.this.getConnection();
                                    TerminalType terminalType = connection.getTerminalType();
                                    if (terminalType != TerminalType.TC_406 && terminalType != TerminalType.TC_506_S) {
                                        connection.sendImageFromFile(new File(s.getMainFile()), terminalType.getDisplayWidth(), terminalType.getDisplayHeight(), indexMode, s.getRepetitions(), s.getDuration(), true);
                                    } else {
                                        Log.debug("%s - %s - %s - %s - %s", s.getMainFile(), terminalType.getDisplayWidth(), terminalType.getDisplayHeight(), indexMode, s.getRepetitions(), s.getDuration());
                                        connection.sendGifFromFile(new File(s.getMainFile()), (short)(i + 1), (short)1, (short)s.getRepetitions(), (short)s.getDuration());
                                    }
                                    ++i;
                                }
                                catch (IOException exception) {
                                    throw new RuntimeException(exception);
                                }
                            }
                        }
                    });
                }
            }
        });
        GridBagConstraints gbcbtnSave = new GridBagConstraints();
        gbcbtnSave.fill = 2;
        gbcbtnSave.insets = new Insets(5, 0, 0, 0);
        gbcbtnSave.gridx = 0;
        gbcbtnSave.gridy = 5;
        ((Container)buttonPanel).add((Component)this.btnSave, gbcbtnSave);
        JButton btnClearMemory = new JButton(J18N.tr("Clear memory", new Object[0]));
        btnClearMemory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Sc501MediaPanel.this.setEnabled(false);
                    Sc501MediaPanel.this.responseCount = 0;
                    Sc501MediaPanel.this.isClear = true;
                    Sc501MediaPanel.this.getConnection().sendImageFromFile(null, 0, 0, 255, 0, 0, false);
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
            }
        });
        GridBagConstraints gbcBtnClearMemory = new GridBagConstraints();
        gbcBtnClearMemory.fill = 2;
        gbcBtnClearMemory.insets = new Insets(5, 0, 0, 0);
        gbcBtnClearMemory.gridx = 0;
        gbcBtnClearMemory.gridy = 6;
        ((Container)buttonPanel).add((Component)btnClearMemory, gbcBtnClearMemory);
        this.registerListeners();
        this.refreshGui();
    }

    public final Sc501Connection getConnection() {
        return (Sc501Connection)this.getManagedObject();
    }

    private void refreshGui() {
        boolean hasSelection = this.slideTable.getSelectedRow() != -1;
        this.btnDel.setEnabled(hasSelection);
        this.btnUp.setEnabled(hasSelection);
        this.btnDown.setEnabled(hasSelection);
        this.btnSave.setEnabled(this.slideTable.getRowCount() > 0);
    }

    private void registerListeners() {
        this.registerSc501CommandListener("#img_ok", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                Sc501MediaPanel.this.responseCount++;
                if (Sc501MediaPanel.this.isClear || Sc501MediaPanel.this.responseCount == Sc501MediaPanel.this.slideTable.getRowCount()) {
                    Sc501MediaPanel.this.setEnabled(true);
                    String message = Sc501MediaPanel.this.isClear ? J18N.tr("Memory cleared", new Object[0]) : J18N.tr("Successfully updated medias", new Object[0]);
                    GuiUtils.showInfoMessage(Sc501MediaPanel.this, message);
                    Sc501MediaPanel.this.refreshGui();
                }
            }
        });
    }
}

