/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.bean.Slide;
import br.com.gertec.tc.server.gui.AddMediaDialog;
import br.com.gertec.tc.server.gui.util.GuiPanel;
import br.com.gertec.tc.server.gui.util.GuiUtils;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.CommandListener;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc504.Sc504Connection;
import br.com.gertec.tc.server.protocol.sc504.Sc504Utils;
import br.com.gertec.tc.server.protocol.sc504.commands.IDCleanExternalMem;
import br.com.gertec.tc.server.protocol.sc504.commands.IDCleanInternalMem;
import br.com.gertec.tc.server.protocol.sc504.commands.IDDeleteLocalMedia;
import br.com.gertec.tc.server.protocol.sc504.commands.IDReloadADV;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDCleanExternalMem;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDCleanInternalMem;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDDeleteLocalMedia;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvRecvFile;
import br.com.gertec.tc.server.util.GrouppedSettings;
import br.com.gertec.tc.server.util.Settings;
import br.org.reconcavo.event.Timer;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.event.comm.CommandConnection;
import br.org.reconcavo.j18n.J18N;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class Sc504MediaPanel
extends GuiPanel {
    private static final long serialVersionUID = 1L;
    public static final String ALL_MEDIAS_CONF_FILENAME = "all_medias.conf";
    public static final String ALL_MEDIAS_CONF_FILENAME_504 = "images.cfg";
    public static final String PREIMG_CONF_FILENAME_504 = "preimg.cfg";
    private static final String INT_MEM = "INT_MEM";
    private static final String INT_MEM_TITLE = "Internal memory";
    private static final String SDCARD1 = "SDCARD1";
    private static final String SDCARD1_TITLE = "External memory";
    private final JTable table;
    private final DefaultTableModel model;
    private final JButton btnDel;
    private boolean update = false;

    public Sc504MediaPanel(Sc504Connection connection) {
        super(connection);
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowWeights = new double[]{1.0, 0.0};
        gridBagLayout.columnWeights = new double[]{1.0, 0.0};
        this.setLayout(gridBagLayout);
        this.table = new JTable();
        this.model = connection.getTerminalType().equals((Object)TerminalType.TC_504) ? new DefaultTableModel(new Object[0][], new String[]{J18N.tr("New media", new Object[0]), J18N.tr("Type", new Object[0])}){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        } : new DefaultTableModel(new Object[0][], new String[]{J18N.tr("Storage", new Object[0]), J18N.tr("Name", new Object[0])}){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.table.setModel(this.model);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Sc504MediaPanel.this.btnDel.setEnabled(Sc504MediaPanel.this.table.getSelectedRow() != -1);
            }
        });
        if (connection.getTerminalType().equals((Object)TerminalType.TC_504)) {
            this.table.setEnabled(true);
        }
        GridBagConstraints gbcTable = new GridBagConstraints();
        gbcTable.fill = 2;
        gbcTable.weighty = 1.0;
        gbcTable.gridx = 0;
        gbcTable.gridy = 0;
        gbcTable.weightx = 1.0;
        gbcTable.fill = 1;
        JScrollPane scroll = new JScrollPane(this.table);
        this.add((Component)scroll, gbcTable);
        GuiPanel panel1 = new GuiPanel();
        GridBagConstraints gbcPanel1 = new GridBagConstraints();
        gbcPanel1.insets = new Insets(0, 5, 0, 0);
        gbcPanel1.fill = 1;
        gbcPanel1.gridx = 1;
        gbcPanel1.gridy = 0;
        this.add((Component)panel1, gbcPanel1);
        GridBagLayout gblPanel1 = new GridBagLayout();
        gblPanel1.columnWidths = new int[]{0, 0};
        gblPanel1.rowHeights = new int[]{0, 0, 0, 0, 0};
        gblPanel1.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gblPanel1.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        panel1.setLayout(gblPanel1);
        JButton btnNew = new JButton(J18N.tr("New", new Object[0]));
        btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sc504MediaPanel.this.update = false;
                AddMediaDialog dialog = new AddMediaDialog(Sc504MediaPanel.this.getConnection()){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected void onClose(Object result) {
                        boolean fileSent;
                        super.onClose(result);
                        boolean bl = fileSent = result != null && (Boolean)result != false;
                        if (fileSent) {
                            Sc504MediaPanel.this.update = true;
                            Sc504MediaPanel.this.setEnabled(false);
                            if (this.getConnection().getTerminalType() != TerminalType.TC_506_MIDIA) {
                                this.getConnection().writeCommand(new IDReloadADV());
                                Sc504Utils.requestAllMediasConf(this.getConnection());
                            }
                        }
                    }
                };
                dialog.setLocationRelativeTo(Sc504MediaPanel.this);
                dialog.setVisible(true);
            }
        });
        GridBagConstraints gbcBtnNew = new GridBagConstraints();
        gbcBtnNew.insets = new Insets(0, 0, 5, 0);
        gbcBtnNew.fill = 2;
        gbcBtnNew.gridx = 0;
        gbcBtnNew.gridy = 0;
        ((Container)panel1).add((Component)btnNew, gbcBtnNew);
        this.btnDel = new JButton(J18N.tr("Delete", new Object[0]));
        this.btnDel.setEnabled(false);
        this.btnDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] selectedFilePaths = Sc504MediaPanel.this.getSelectedFilePaths();
                if (selectedFilePaths == null) {
                    GuiUtils.showWarningMessage(Sc504MediaPanel.this, J18N.tr("Please, select media first", new Object[0]));
                } else {
                    int result = JOptionPane.showConfirmDialog(Sc504MediaPanel.this, J18N.tr("Do you really want to delete selected file(s)?", new Object[0]), Application.APP_NAME, 0, 2);
                    if (result == 0) {
                        Sc504MediaPanel.this.setEnabled(false);
                        Sc504Connection connection = Sc504MediaPanel.this.getConnection();
                        for (String path : selectedFilePaths) {
                            ((CommandConnection)connection).writeCommand(new IDDeleteLocalMedia(path));
                        }
                        ((CommandConnection)connection).writeCommand(new IDReloadADV());
                        Sc504Utils.requestAllMediasConf(connection);
                    }
                }
            }
        });
        GridBagConstraints gbcBtnDel = new GridBagConstraints();
        gbcBtnDel.insets = new Insets(5, 0, 5, 0);
        gbcBtnDel.fill = 2;
        gbcBtnDel.gridx = 0;
        gbcBtnDel.gridy = 1;
        ((Container)panel1).add((Component)this.btnDel, gbcBtnDel);
        Component verticalStrut = Box.createVerticalStrut(20);
        GridBagConstraints gbcVerticalStrut = new GridBagConstraints();
        gbcVerticalStrut.gridheight = 2;
        gbcVerticalStrut.insets = new Insets(5, 0, 0, 0);
        gbcVerticalStrut.fill = 1;
        gbcVerticalStrut.gridx = 0;
        gbcVerticalStrut.gridy = 2;
        ((Container)panel1).add(verticalStrut, gbcVerticalStrut);
        GuiPanel panel = new GuiPanel();
        GridBagConstraints gbcPanel = new GridBagConstraints();
        gbcPanel.gridwidth = 2;
        gbcPanel.insets = new Insets(5, 0, 0, 0);
        gbcPanel.fill = 1;
        gbcPanel.gridx = 0;
        gbcPanel.gridy = 1;
        this.add((Component)panel, gbcPanel);
        GridBagLayout gblPanel = new GridBagLayout();
        gblPanel.columnWidths = new int[]{0, 0, 118, 0};
        gblPanel.rowHeights = new int[]{0, 0};
        gblPanel.columnWeights = new double[]{0.0, 0.0, 1.0, Double.MIN_VALUE};
        gblPanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel.setLayout(gblPanel);
        JButton btnClearInternal = new JButton(J18N.tr("Clear Internal Memory", new Object[0]));
        btnClearInternal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sc504MediaPanel.this.setEnabled(false);
                Sc504Connection connection = Sc504MediaPanel.this.getConnection();
                connection.writeCommand(new IDCleanInternalMem());
                connection.writeCommand(new IDReloadADV());
                Sc504Utils.requestAllMediasConf(connection);
            }
        });
        GridBagConstraints gbcBtnClearInternal = new GridBagConstraints();
        gbcBtnClearInternal.fill = 2;
        gbcBtnClearInternal.gridx = 0;
        gbcBtnClearInternal.gridy = 0;
        ((Container)panel).add((Component)btnClearInternal, gbcBtnClearInternal);
        JButton btnClearExternal = new JButton(J18N.tr("Clear External Memory", new Object[0]));
        btnClearExternal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sc504MediaPanel.this.setEnabled(false);
                Sc504Connection connection = Sc504MediaPanel.this.getConnection();
                connection.writeCommand(new IDCleanExternalMem());
                connection.writeCommand(new IDReloadADV());
                Sc504Utils.requestAllMediasConf(connection);
            }
        });
        GridBagConstraints gbcBtnClearExternal = new GridBagConstraints();
        gbcBtnClearExternal.fill = 2;
        gbcBtnClearExternal.insets = new Insets(0, 5, 0, 0);
        gbcBtnClearExternal.gridx = 1;
        gbcBtnClearExternal.gridy = 0;
        ((Container)panel).add((Component)btnClearExternal, gbcBtnClearExternal);
        if (connection.getTerminalType().equals((Object)TerminalType.TC_504) || connection.getTerminalType().equals((Object)TerminalType.GB_600) || connection.getTerminalType().equals((Object)TerminalType.GB_601)) {
            btnClearExternal.setVisible(false);
            btnClearExternal.setEnabled(false);
        }
        Component horizontalStrut = Box.createHorizontalStrut(20);
        GridBagConstraints gbcHorizontalStrut = new GridBagConstraints();
        gbcHorizontalStrut.insets = new Insets(0, 5, 0, 0);
        gbcHorizontalStrut.fill = 1;
        gbcHorizontalStrut.gridx = 2;
        gbcHorizontalStrut.gridy = 0;
        ((Container)panel).add(horizontalStrut, gbcHorizontalStrut);
        this.init();
    }

    public final Sc504Connection getConnection() {
        return (Sc504Connection)this.getManagedObject();
    }

    private void init() {
        Sc504Connection connection = this.getConnection();
        if (!connection.getTerminalType().equals((Object)TerminalType.TC_504)) {
            this.registerListeners();
            Sc504Utils.requestAllMediasConf(connection);
        } else {
            this.registerListeners();
        }
    }

    private void registerListeners() {
        this.registerSc504CommandListener((short)189, new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                RIDCleanExternalMem commandClean = (RIDCleanExternalMem)command;
                if (!commandClean.isSuccess()) {
                    GuiUtils.showErrorMessage(Sc504MediaPanel.this, J18N.tr("Could not clean external memory", new Object[0]));
                }
                Sc504MediaPanel.this.setEnabled(true);
            }

            public String toString() {
                return "RIDCleanExternalMem Listener";
            }
        });
        this.registerSc504CommandListener((short)187, new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                RIDCleanInternalMem commandClean = (RIDCleanInternalMem)command;
                if (!commandClean.isSuccess()) {
                    GuiUtils.showErrorMessage(Sc504MediaPanel.this, J18N.tr("Could not clean internal memory", new Object[0]));
                }
                Sc504MediaPanel.this.setEnabled(true);
            }

            public String toString() {
                return "RIDCleanInternalMem Listener";
            }
        });
        this.registerSc504CommandListener((short)185, new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                RIDDeleteLocalMedia iDelete = (RIDDeleteLocalMedia)command;
                if (!iDelete.isSuccess()) {
                    GuiUtils.showErrorMessage(Sc504MediaPanel.this, J18N.tr("Error deleting file(s)", new Object[0]));
                }
                Sc504MediaPanel.this.setEnabled(true);
            }

            public String toString() {
                return "RIDDeleteLocalMedia Listener";
            }
        });
        this.registerSc504CommandListener((short)100, new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                if (connection == Sc504MediaPanel.this.getConnection() && connection.getTerminalType() == TerminalType.TC_506_MIDIA && Sc504MediaPanel.this.update) {
                    Timer.startSingleshot(Application.EVENT_LOOP, 3000L, new Timer.TimerListener(){

                        @Override
                        public void onTimeout(Timer timer) {
                            Sc504Connection connection = Sc504MediaPanel.this.getConnection();
                            ((CommandConnection)connection).writeCommand(new IDReloadADV());
                            Sc504Utils.requestAllMediasConf(connection);
                        }
                    });
                }
            }
        });
        this.registerListener(new Sc504Connection.FileReceiveListener(){

            @Override
            public void onFileReceived(Sc504Connection connection, RIDvRecvFile response) {
                if (response.isFound() && response.getReceivedFile().getName().equals(Sc504MediaPanel.ALL_MEDIAS_CONF_FILENAME)) {
                    Sc504MediaPanel.this.model.setRowCount(0);
                    try {
                        Settings sdCardGroup;
                        GrouppedSettings allMediasConf = GrouppedSettings.load(response.getReceivedFile());
                        Settings intMemGroup = allMediasConf.getSection(Sc504MediaPanel.INT_MEM);
                        if (intMemGroup != null) {
                            for (Map.Entry<String, String> entry : intMemGroup.entrySet()) {
                                Sc504MediaPanel.this.addMedia(J18N.tr(Sc504MediaPanel.INT_MEM_TITLE, new Object[0]), entry.getValue());
                            }
                        }
                        if ((sdCardGroup = allMediasConf.getSection(Sc504MediaPanel.SDCARD1)) != null) {
                            for (Map.Entry<String, String> entry : sdCardGroup.entrySet()) {
                                Sc504MediaPanel.this.addMedia(J18N.tr(Sc504MediaPanel.SDCARD1_TITLE, new Object[0]), entry.getValue());
                            }
                        }
                        Sc504MediaPanel.this.setEnabled(true);
                    }
                    catch (IOException e) {
                        GuiUtils.showErrorMessage(Sc504MediaPanel.this, J18N.tr("Error parsing %s: %s", Sc504MediaPanel.ALL_MEDIAS_CONF_FILENAME, e.getMessage()));
                    }
                }
            }

            @Override
            public void onReceivingFile(Sc504Connection connection, String filepath, double progress, int filesize) {
            }

            public String toString() {
                return "FileReceiveListener";
            }
        });
    }

    private void addMedia(String storageLocationTitle, String filePath) {
        Vector<String> row = new Vector<String>();
        row.add(storageLocationTitle);
        row.add(filePath);
        this.model.addRow(row);
    }

    public void addNewMedia(String storageLocationTitle, String filePath) {
        Vector<String> row = new Vector<String>();
        row.add(storageLocationTitle);
        row.add(filePath);
        this.model.addRow(row);
        this.model.fireTableDataChanged();
    }

    private String[] getSelectedFilePaths() {
        if (this.table.getSelectedRow() == -1) {
            return null;
        }
        int[] selectedRows = this.table.getSelectedRows();
        String[] paths = new String[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            Slide s = this.getSlide(selectedRows[i]);
            paths[i] = String.format("%s/%s", s.getMemory(), s.getMainFile());
        }
        return paths;
    }

    private Slide getSlide(int row) {
        Slide ep = new Slide();
        ep.setMainFile((String)this.table.getModel().getValueAt(row, 1));
        if (this.getConnection().getTerminalType() != TerminalType.TC_504) {
            if (((String)this.table.getModel().getValueAt(row, 0)).equals(J18N.tr(INT_MEM_TITLE, new Object[0]))) {
                ep.setMemory(INT_MEM);
            } else {
                ep.setMemory(SDCARD1);
            }
        } else {
            ep.setMemory(INT_MEM_TITLE);
        }
        return ep;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.btnDel.setEnabled(enabled && this.table.getSelectedRow() != -1);
        if (this.getConnection().getTerminalType().equals((Object)TerminalType.TC_504)) {
            super.setEnabled(true);
            this.table.setEnabled(false);
        }
    }

    @Override
    public String toString() {
        return String.format("%s#%d", this.getClass().getSimpleName(), this.hashCode());
    }
}

