/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.bean.Slide;
import br.com.gertec.tc.server.gui.SlideTable;
import br.com.gertec.tc.server.gui.util.GuiPanel;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.CommandListener;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc504.Sc504Connection;
import br.com.gertec.tc.server.protocol.sc504.commands.IDReloadADV;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvRecvFile;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvSendFile;
import br.com.gertec.tc.server.protocol.sc504.commands.RIDvRecvFile;
import br.com.gertec.tc.server.util.FileUtilities;
import br.com.gertec.tc.server.util.GrouppedSettings;
import br.com.gertec.tc.server.util.Playlist;
import br.com.gertec.tc.server.util.Settings;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.j18n.J18N;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class Sc504SlideShowPanel
extends GuiPanel {
    private static final long serialVersionUID = 1L;
    public static final String TC_CONFIG_PATH_PREFIX = "CONF_DIR/";
    public static final String ALL_MEDIAS_CONF_FILENAME = "all_medias.conf";
    private static final String INT_MEM_PREFIX = "INT_MEM";
    private static final String SD_CARD_PREFIX = "SDCARD1";
    private final SlideTable slideTable;
    private final JButton btnDel;
    private final JButton btnUp;
    private final JButton btnDown;
    private final Sc504Connection connection;
    private final String playlistFilename;
    private GrouppedSettings gpSettings;

    public Sc504SlideShowPanel(Sc504Connection connection, String playlistFilename) {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        if (connection == null) {
            throw new IllegalArgumentException("Null connection");
        }
        this.connection = connection;
        if (playlistFilename == null || playlistFilename.trim().isEmpty()) {
            throw new IllegalArgumentException("Null/empty playlist filename");
        }
        this.playlistFilename = playlistFilename;
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowWeights = new double[]{1.0};
        gridBagLayout.columnWeights = new double[]{1.0, 0.0};
        this.setLayout(gridBagLayout);
        this.slideTable = new SlideTable(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onSelection() {
                Sc504SlideShowPanel.this.refreshGui();
            }
        };
        JScrollPane scrollSlideTable = new JScrollPane(this.slideTable);
        GridBagConstraints gbcScrollSlideTable = new GridBagConstraints();
        gbcScrollSlideTable.fill = 2;
        gbcScrollSlideTable.weighty = 1.0;
        gbcScrollSlideTable.gridx = 0;
        gbcScrollSlideTable.gridy = 0;
        gbcScrollSlideTable.weightx = 1.0;
        gbcScrollSlideTable.fill = 1;
        this.add((Component)scrollSlideTable, gbcScrollSlideTable);
        GuiPanel buttonPanel = new GuiPanel();
        GridBagConstraints gbcButtonPanel = new GridBagConstraints();
        gbcButtonPanel.insets = new Insets(0, 5, 0, 0);
        gbcButtonPanel.fill = 1;
        gbcButtonPanel.gridx = 1;
        gbcButtonPanel.gridy = 0;
        this.add((Component)buttonPanel, gbcButtonPanel);
        GridBagLayout gblButtonPanel = new GridBagLayout();
        gblButtonPanel.columnWidths = new int[]{0, 0};
        gblButtonPanel.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0};
        gblButtonPanel.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gblButtonPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        buttonPanel.setLayout(gblButtonPanel);
        JButton btnNew = new JButton(J18N.tr("New", new Object[0]));
        btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sc504SlideShowPanel.this.slideTable.addRow();
            }
        });
        GridBagConstraints gbcBtnNew = new GridBagConstraints();
        gbcBtnNew.fill = 2;
        gbcBtnNew.gridx = 0;
        gbcBtnNew.gridy = 0;
        ((Container)buttonPanel).add((Component)btnNew, gbcBtnNew);
        this.btnDel = new JButton(J18N.tr("Delete", new Object[0]));
        this.btnDel.setEnabled(false);
        this.btnDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sc504SlideShowPanel.this.slideTable.deleteSelected();
            }
        });
        GridBagConstraints gbcBtnDel = new GridBagConstraints();
        gbcBtnDel.fill = 2;
        gbcBtnDel.insets = new Insets(5, 0, 0, 0);
        gbcBtnDel.gridx = 0;
        gbcBtnDel.gridy = 1;
        ((Container)buttonPanel).add((Component)this.btnDel, gbcBtnDel);
        this.btnUp = new JButton("/\\");
        this.btnUp.setEnabled(false);
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sc504SlideShowPanel.this.slideTable.moveSelection(-1);
            }
        });
        GridBagConstraints gbcBtnUp = new GridBagConstraints();
        gbcBtnUp.fill = 2;
        gbcBtnUp.insets = new Insets(5, 0, 0, 0);
        gbcBtnUp.gridx = 0;
        gbcBtnUp.gridy = 2;
        ((Container)buttonPanel).add((Component)this.btnUp, gbcBtnUp);
        this.btnDown = new JButton("\\/");
        this.btnDown.setEnabled(false);
        this.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sc504SlideShowPanel.this.slideTable.moveSelection(1);
            }
        });
        GridBagConstraints gbcBtnDown = new GridBagConstraints();
        gbcBtnDown.fill = 2;
        gbcBtnDown.insets = new Insets(5, 0, 0, 0);
        gbcBtnDown.gridx = 0;
        gbcBtnDown.gridy = 3;
        ((Container)buttonPanel).add((Component)this.btnDown, gbcBtnDown);
        JButton btnSave = new JButton(J18N.tr("Save", new Object[0]));
        btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = JOptionPane.showConfirmDialog(null, String.format(J18N.tr("Before saving, check that the presence sensor in the terminal configuration is active. Save?", new Object[0]), new Object[0]), Application.APP_NAME, 0, 2);
                if (result == 0) {
                    Sc504SlideShowPanel.this.save();
                }
            }
        });
        GridBagConstraints gbcBtnSave = new GridBagConstraints();
        gbcBtnSave.fill = 2;
        gbcBtnSave.insets = new Insets(5, 0, 0, 0);
        gbcBtnSave.gridx = 0;
        gbcBtnSave.gridy = 4;
        ((Container)buttonPanel).add((Component)btnSave, gbcBtnSave);
        Component verticalStrut = Box.createVerticalStrut(20);
        GridBagConstraints gbcVerticalStrut = new GridBagConstraints();
        gbcVerticalStrut.insets = new Insets(5, 0, 0, 0);
        gbcVerticalStrut.gridx = 0;
        gbcVerticalStrut.gridy = 5;
        ((Container)buttonPanel).add(verticalStrut, gbcVerticalStrut);
        this.init();
    }

    public final Sc504Connection getConnection() {
        return this.connection;
    }

    public final String getPlaylistFilename() {
        return this.playlistFilename;
    }

    private String getTcPlaylistFilePath() {
        if (this.getConnection().getTerminalType() == TerminalType.TC_504) {
            return this.getPlaylistFilename();
        }
        return String.format("%s%s", TC_CONFIG_PATH_PREFIX, this.getPlaylistFilename());
    }

    private void init() {
        this.setupListeners();
        this.requestTerminalData();
    }

    private void setupListeners() {
        this.registerListener(new Sc504Connection.FileReceiveListener.FileReceiveAdapter(){

            private void loadPlaylistFile(File file) {
                try {
                    Sc504SlideShowPanel.this.slideTable.setData(Playlist.load(file));
                    Sc504SlideShowPanel.this.setEnabled(true);
                    Sc504SlideShowPanel.this.refreshGui();
                }
                catch (RuntimeException ex) {
                    JOptionPane.showMessageDialog(null, String.format(J18N.tr("Error loading data: %s", new Object[0]), ex.getMessage()), Application.APP_NAME, 0);
                }
            }

            private void onAllMediasConf(File file) {
                Settings sdCardSection;
                LinkedList<String> pathList = new LinkedList<String>();
                try {
                    Sc504SlideShowPanel.this.gpSettings = GrouppedSettings.load(file);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                Settings intMemSection = Sc504SlideShowPanel.this.gpSettings.getSection(Sc504SlideShowPanel.INT_MEM_PREFIX);
                if (intMemSection != null) {
                    for (Map.Entry<String, String> entry : intMemSection.entrySet()) {
                        pathList.add("INT_MEM/" + entry.getValue());
                    }
                }
                if ((sdCardSection = Sc504SlideShowPanel.this.gpSettings.getSection(Sc504SlideShowPanel.SD_CARD_PREFIX)) != null) {
                    for (Map.Entry<String, String> entry : sdCardSection.entrySet()) {
                        pathList.add("SDCARD1/" + entry.getValue());
                    }
                }
                Sc504SlideShowPanel.this.slideTable.setPathList(pathList);
            }

            @Override
            public void onFileReceived(Sc504Connection connection, RIDvRecvFile receivedFileCmd) {
                if (receivedFileCmd.isFound()) {
                    if (receivedFileCmd.getReceivedFile().getName().equals(Sc504SlideShowPanel.this.getPlaylistFilename())) {
                        this.loadPlaylistFile(receivedFileCmd.getReceivedFile());
                    } else if (receivedFileCmd.getReceivedFile().getName().equals(Sc504SlideShowPanel.ALL_MEDIAS_CONF_FILENAME)) {
                        this.onAllMediasConf(receivedFileCmd.getReceivedFile());
                    }
                }
            }
        });
        this.registerSc504CommandListener((short)118, new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                Sc504SlideShowPanel.this.setEnabled(true);
                Sc504SlideShowPanel.this.refreshGui();
            }
        });
        this.registerSc504CommandListener((short)189, new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                Sc504SlideShowPanel.this.removePathsFromSlides(Sc504SlideShowPanel.SD_CARD_PREFIX);
            }
        });
        this.registerSc504CommandListener((short)187, new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                Sc504SlideShowPanel.this.removePathsFromSlides(Sc504SlideShowPanel.INT_MEM_PREFIX);
            }
        });
    }

    private void removePathsFromSlides(String memType) {
        if (this.slideTable.getData() != null) {
            List<Slide> slides = this.slideTable.getData();
            LinkedList<Slide> tmpList = new LinkedList<Slide>();
            for (Slide slide : slides) {
                if (!slide.getMainFile().contains(memType)) continue;
                tmpList.add(slide);
            }
            for (Slide s : tmpList) {
                slides.remove(s);
            }
            this.slideTable.setData(slides);
            String data = this.generateFileFromSlides(slides);
            this.sendFile(data);
        }
    }

    private void requestTerminalData() {
        this.setEnabled(false);
        this.getConnection().writeCommand(new IDvRecvFile(this.getTcPlaylistFilePath()));
    }

    private void refreshGui() {
        boolean hasSelection = this.slideTable.getSelectedRowCount() != 0;
        this.btnDel.setEnabled(hasSelection);
        this.btnUp.setEnabled(hasSelection);
        this.btnDown.setEnabled(hasSelection);
    }

    private void save() {
        int result;
        this.setEnabled(false);
        StringBuilder txtFile = new StringBuilder("<\n");
        List<Slide> slides = this.slideTable.getData();
        if (slides.isEmpty() && (result = JOptionPane.showConfirmDialog(this, J18N.tr("Slideshow is empty. Do you want to proceed?", new Object[0]), Application.APP_NAME, 0, 2)) == 1) {
            this.setEnabled(true);
            return;
        }
        List<String> pathList = this.slideTable.getPathList();
        boolean allowEmptyPath = false;
        for (Slide s : slides) {
            int result2;
            if (!allowEmptyPath && s.getMainFile().trim().isEmpty()) {
                result2 = JOptionPane.showConfirmDialog(this, J18N.tr("Slideshow contains an entry with empty path. Do you want to proceed?", new Object[0]), Application.APP_NAME, 0, 2);
                if (result2 == 1) {
                    this.setEnabled(true);
                    return;
                }
                allowEmptyPath = true;
            }
            if (!(s.getMainFile().trim().isEmpty() || pathList != null && pathList.contains(s.getMainFile().trim()) || (result2 = JOptionPane.showConfirmDialog(this, J18N.tr("'%s' is not available in terminal. Do you want to proceed?", s.getMainFile().trim()), Application.APP_NAME, 0, 2)) != 1)) {
                this.setEnabled(true);
                return;
            }
            txtFile.append(String.format("|%s|%d|%d|\n", s.getMainFile(), s.getDuration(), s.getRepetitions()));
        }
        txtFile.append(">");
        this.sendFile(txtFile.toString());
    }

    private String generateFileFromSlides(List<Slide> slides) {
        StringBuilder txtFile = new StringBuilder("<\n");
        for (Slide s : slides) {
            txtFile.append(String.format("|%s|%d|%d|\n", s.getMainFile(), s.getDuration(), s.getRepetitions()));
        }
        txtFile.append(">");
        return txtFile.toString();
    }

    private void sendFile(String data) {
        File file = new File(FileUtilities.getInstance().getTemporaryConfigDir(), this.getPlaylistFilename());
        try (FileWriter w = new FileWriter(file);){
            w.write(data);
            w.flush();
            Sc504Connection connection = this.getConnection();
            connection.sendFile(new IDvSendFile(this.getTcPlaylistFilePath(), file), null);
            connection.writeCommand(new IDReloadADV());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

