/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.ApplicationSettings;
import br.com.gertec.tc.server.gui.util.IntTextField;
import br.com.gertec.tc.server.gui.util.LogView;
import br.com.gertec.tc.server.http.TcHttpServer;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.util.Resources;
import br.org.reconcavo.event.comm.socket.TcpServer;
import br.org.reconcavo.event.comm.socket.TcpServerListener;
import br.org.reconcavo.j18n.J18N;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class ServerPanel
extends JPanel
implements J18N.LocaleChangeListener {
    private static final long serialVersionUID = 1L;
    private final TitledBorder sc501Border;
    private final TitledBorder sc504Border;
    private final TitledBorder httpBorder;
    private final PortTextField txtPortSc501;
    private final JButton btnStartStopSc501;
    private final PortTextField txtPortSc504;
    private final JButton btnStartStopSc504;
    private final PortTextField txtPortHttp;
    private final JButton btnStarStoptHttp;
    private final LogView logArea;
    private final JPopupMenu popup;
    private final JMenuItem clearLogItem;
    private final JPanel sc501Panel;
    private final JPanel sc504Panel;
    private final JPanel httpPanel;
    private final JLabel lblSc501Port;
    private final JLabel lblSc504Port;
    private final JLabel lblHttpPort;

    public ServerPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowWeights = new double[]{0.0, 1.0};
        gridBagLayout.columnWeights = new double[]{1.0, 1.0, 1.0};
        this.setLayout(gridBagLayout);
        this.sc501Panel = new JPanel();
        this.sc501Border = new TitledBorder(null, "", 4, 2, null, null);
        this.sc501Panel.setBorder(this.sc501Border);
        GridBagConstraints gbcSc501Panel = new GridBagConstraints();
        gbcSc501Panel.fill = 1;
        gbcSc501Panel.gridx = 0;
        gbcSc501Panel.gridy = 0;
        this.add((Component)this.sc501Panel, gbcSc501Panel);
        GridBagLayout gblSc501Panel = new GridBagLayout();
        gblSc501Panel.columnWidths = new int[]{0, 0, 0, 0};
        gblSc501Panel.rowHeights = new int[]{0, 0};
        gblSc501Panel.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gblSc501Panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.sc501Panel.setLayout(gblSc501Panel);
        this.lblSc501Port = new JLabel();
        GridBagConstraints gbcLblSc501Port = new GridBagConstraints();
        gbcLblSc501Port.insets = new Insets(5, 5, 5, 0);
        gbcLblSc501Port.anchor = 13;
        gbcLblSc501Port.gridx = 0;
        gbcLblSc501Port.gridy = 0;
        this.sc501Panel.add((Component)this.lblSc501Port, gbcLblSc501Port);
        this.txtPortSc501 = new PortTextField(5){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onChange() {
                super.onChange();
                ServerPanel.this.btnStartStopSc501.setEnabled(this.isValid());
            }
        };
        this.txtPortSc501.setHorizontalAlignment(0);
        GridBagConstraints gbcTxtPortSc501 = new GridBagConstraints();
        gbcTxtPortSc501.fill = 1;
        gbcTxtPortSc501.insets = new Insets(5, 5, 5, 0);
        gbcTxtPortSc501.gridx = 1;
        gbcTxtPortSc501.gridy = 0;
        this.sc501Panel.add((Component)this.txtPortSc501, gbcTxtPortSc501);
        this.txtPortSc501.setColumns(5);
        this.btnStartStopSc501 = new JButton();
        GridBagConstraints gbcBtnStartStopSc501 = new GridBagConstraints();
        gbcBtnStartStopSc501.insets = new Insets(5, 5, 5, 5);
        gbcBtnStartStopSc501.gridx = 2;
        gbcBtnStartStopSc501.gridy = 0;
        this.sc501Panel.add((Component)this.btnStartStopSc501, gbcBtnStartStopSc501);
        this.btnStartStopSc501.setIcon(Resources.getImageIcon("/res/img_start.png"));
        this.btnStartStopSc501.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Application.SERVER_MANAGER.isS501Running()) {
                    Application.SERVER_MANAGER.stopSc501Server();
                } else {
                    Application.SERVER_MANAGER.startSc501Server(Integer.parseInt(ServerPanel.this.txtPortSc501.getText()));
                }
            }
        });
        this.sc504Panel = new JPanel();
        this.sc504Border = new TitledBorder(null, "", 4, 2, null, null);
        this.sc504Panel.setBorder(this.sc504Border);
        GridBagConstraints gbcSc504Panel = new GridBagConstraints();
        gbcSc504Panel.fill = 1;
        gbcSc504Panel.insets = new Insets(0, 5, 0, 0);
        gbcSc504Panel.gridx = 1;
        gbcSc504Panel.gridy = 0;
        this.add((Component)this.sc504Panel, gbcSc504Panel);
        GridBagLayout gblSc504Panel = new GridBagLayout();
        gblSc504Panel.columnWidths = new int[]{0, 0, 0, 0};
        gblSc504Panel.rowHeights = new int[]{0, 0};
        gblSc504Panel.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gblSc504Panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.sc504Panel.setLayout(gblSc504Panel);
        this.lblSc504Port = new JLabel();
        GridBagConstraints gbcLblSc504Port = new GridBagConstraints();
        gbcLblSc504Port.insets = new Insets(5, 5, 5, 0);
        gbcLblSc504Port.anchor = 13;
        gbcLblSc504Port.gridx = 0;
        gbcLblSc504Port.gridy = 0;
        this.sc504Panel.add((Component)this.lblSc504Port, gbcLblSc504Port);
        this.txtPortSc504 = new PortTextField(5){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onChange() {
                super.onChange();
                ServerPanel.this.btnStartStopSc504.setEnabled(this.isValid());
            }
        };
        this.txtPortSc504.setHorizontalAlignment(0);
        GridBagConstraints gbcTxtPortSc504 = new GridBagConstraints();
        gbcTxtPortSc504.fill = 1;
        gbcTxtPortSc504.insets = new Insets(5, 5, 5, 0);
        gbcTxtPortSc504.gridx = 1;
        gbcTxtPortSc504.gridy = 0;
        this.sc504Panel.add((Component)this.txtPortSc504, gbcTxtPortSc504);
        this.txtPortSc504.setColumns(5);
        this.btnStartStopSc504 = new JButton();
        GridBagConstraints gbcBtnStartStopSc504 = new GridBagConstraints();
        gbcBtnStartStopSc504.insets = new Insets(5, 5, 5, 5);
        gbcBtnStartStopSc504.gridx = 2;
        gbcBtnStartStopSc504.gridy = 0;
        this.sc504Panel.add((Component)this.btnStartStopSc504, gbcBtnStartStopSc504);
        this.btnStartStopSc504.setIcon(Resources.getImageIcon("/res/img_start.png"));
        this.btnStartStopSc504.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Application.SERVER_MANAGER.isS504Running()) {
                    Application.SERVER_MANAGER.stopSc504Server();
                } else {
                    Application.SERVER_MANAGER.startSc504Server(Integer.parseInt(ServerPanel.this.txtPortSc504.getText()));
                }
            }
        });
        this.httpPanel = new JPanel();
        this.httpBorder = new TitledBorder(null, "", 4, 2, null, null);
        this.httpPanel.setBorder(this.httpBorder);
        GridBagConstraints gbcHttpPanel = new GridBagConstraints();
        gbcHttpPanel.fill = 1;
        gbcHttpPanel.insets = new Insets(0, 5, 0, 0);
        gbcHttpPanel.gridx = 2;
        gbcHttpPanel.gridy = 0;
        this.add((Component)this.httpPanel, gbcHttpPanel);
        GridBagLayout gblHttpPanel = new GridBagLayout();
        gblHttpPanel.columnWidths = new int[]{0, 0, 0, 0};
        gblHttpPanel.rowHeights = new int[]{0, 0};
        gblHttpPanel.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gblHttpPanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.httpPanel.setLayout(gblHttpPanel);
        this.lblHttpPort = new JLabel();
        GridBagConstraints gbcLblHttpPort = new GridBagConstraints();
        gbcLblHttpPort.insets = new Insets(5, 5, 5, 0);
        gbcLblHttpPort.anchor = 13;
        gbcLblHttpPort.gridx = 0;
        gbcLblHttpPort.gridy = 0;
        this.httpPanel.add((Component)this.lblHttpPort, gbcLblHttpPort);
        this.txtPortHttp = new PortTextField(5){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onChange() {
                super.onChange();
                ServerPanel.this.btnStarStoptHttp.setEnabled(this.isValid());
            }
        };
        this.txtPortHttp.setHorizontalAlignment(0);
        GridBagConstraints gbcTxtPortHttp = new GridBagConstraints();
        gbcTxtPortHttp.fill = 1;
        gbcTxtPortHttp.insets = new Insets(5, 5, 5, 0);
        gbcTxtPortHttp.gridx = 1;
        gbcTxtPortHttp.gridy = 0;
        this.httpPanel.add((Component)this.txtPortHttp, gbcTxtPortHttp);
        this.txtPortHttp.setColumns(5);
        this.btnStarStoptHttp = new JButton();
        GridBagConstraints gbcBtnStartHttp = new GridBagConstraints();
        gbcBtnStartHttp.insets = new Insets(5, 5, 5, 5);
        gbcBtnStartHttp.gridx = 2;
        gbcBtnStartHttp.gridy = 0;
        this.httpPanel.add((Component)this.btnStarStoptHttp, gbcBtnStartHttp);
        this.btnStarStoptHttp.setIcon(Resources.getImageIcon("/res/img_start.png"));
        this.btnStarStoptHttp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Application.SERVER_MANAGER.isHttpServerRunning()) {
                    Application.SERVER_MANAGER.startHttpServer(Integer.parseInt(ServerPanel.this.txtPortHttp.getText()));
                } else {
                    Application.SERVER_MANAGER.stopHttpServer();
                }
            }
        });
        this.logArea = new LogView();
        this.logArea.setEditable(false);
        Log.flushQueue(this.logArea);
        Log.enableQueue(false);
        Log.registerStream(this.logArea);
        this.popup = new JPopupMenu();
        this.clearLogItem = new JMenuItem();
        this.clearLogItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerPanel.this.logArea.setText("");
            }
        });
        this.popup.add(this.clearLogItem);
        this.logArea.setComponentPopupMenu(this.popup);
        GridBagConstraints gbcAreaLog = new GridBagConstraints();
        gbcAreaLog.insets = new Insets(5, 0, 0, 0);
        gbcAreaLog.gridwidth = 3;
        gbcAreaLog.gridx = 0;
        gbcAreaLog.gridy = 1;
        gbcAreaLog.fill = 1;
        JScrollPane scrollPane = new JScrollPane(this.logArea);
        this.add((Component)scrollPane, gbcAreaLog);
        this.registerListeners();
        this.loadSettings();
        this.retranslateUi();
        this.checkServerState();
    }

    private void loadSettings() {
        this.txtPortSc501.setText(ApplicationSettings.getInstance().getProperty("LAST_PORT_501"));
        this.txtPortSc504.setText(ApplicationSettings.getInstance().getProperty("LAST_PORT_504"));
        this.txtPortHttp.setText(ApplicationSettings.getInstance().getProperty("LAST_PORT_HTTP"));
    }

    private void registerListeners() {
        J18N.registerListener(this);
        Application.SERVER_MANAGER.registerHttpServerListener(new TcHttpServer.HttpServerListener.HttpServerAdapter(){

            @Override
            public void onStop(TcHttpServer server) {
                ServerPanel.this.checkServerState();
            }

            @Override
            public void onStart(TcHttpServer serverThread) {
                ServerPanel.this.checkServerState();
            }

            @Override
            public void onError(TcHttpServer serverThread, Throwable error) {
                Log.error(J18N.tr("HTTP server error: %s", error.getMessage()), new Object[0]);
                error.printStackTrace();
            }
        });
        Application.SERVER_MANAGER.register501Listener(new TcpServerListener.TcpServerAdapter(){

            @Override
            public void onStart(TcpServer server) {
                ServerPanel.this.checkServerState();
            }

            @Override
            public void onStop(TcpServer server) {
                ServerPanel.this.checkServerState();
            }

            @Override
            public void onError(TcpServer server, Throwable error) {
                Log.error(J18N.tr("SC501 server error: %s", error.getMessage()), new Object[0]);
            }
        });
        Application.SERVER_MANAGER.register504Listener(new TcpServerListener.TcpServerAdapter(){

            @Override
            public void onStart(TcpServer server) {
                ServerPanel.this.checkServerState();
            }

            @Override
            public void onStop(TcpServer server) {
                ServerPanel.this.checkServerState();
            }

            @Override
            public void onError(TcpServer server, Throwable error) {
                Log.error(J18N.tr("SC504 server error: %s", error.getMessage()), new Object[0]);
            }
        });
    }

    private void retranslateUi() {
        this.sc501Border.setTitle(J18N.tr("SC501 server", new Object[0]));
        this.sc504Border.setTitle(J18N.tr("SC504 server", new Object[0]));
        this.httpBorder.setTitle(J18N.tr("HTTP server", new Object[0]));
        this.lblSc501Port.setText(J18N.tr("Port", new Object[0]) + ":");
        this.lblSc504Port.setText(J18N.tr("Port", new Object[0]) + ":");
        this.lblHttpPort.setText(J18N.tr("Port", new Object[0]) + ":");
        this.clearLogItem.setText(J18N.tr("Clear", new Object[0]));
        this.checkServerState();
    }

    private void checkServerState() {
        if (Application.SERVER_MANAGER.isS501Running()) {
            this.btnStartStopSc501.setText(J18N.tr("Stop", new Object[0]));
            this.btnStartStopSc501.setIcon(Resources.getImageIcon("/res/img_stop.png"));
            this.lblSc501Port.setEnabled(false);
            this.txtPortSc501.setEnabled(false);
        } else {
            this.btnStartStopSc501.setText(J18N.tr("Start", new Object[0]));
            this.btnStartStopSc501.setIcon(Resources.getImageIcon("/res/img_start.png"));
            this.lblSc501Port.setEnabled(true);
            this.txtPortSc501.setEnabled(true);
        }
        if (Application.SERVER_MANAGER.isS504Running()) {
            this.btnStartStopSc504.setText(J18N.tr("Stop", new Object[0]));
            this.btnStartStopSc504.setIcon(Resources.getImageIcon("/res/img_stop.png"));
            this.lblSc504Port.setEnabled(false);
            this.txtPortSc504.setEnabled(false);
        } else {
            this.btnStartStopSc504.setText(J18N.tr("Start", new Object[0]));
            this.btnStartStopSc504.setIcon(Resources.getImageIcon("/res/img_start.png"));
            this.lblSc504Port.setEnabled(true);
            this.txtPortSc504.setEnabled(true);
        }
        if (Application.SERVER_MANAGER.isHttpServerRunning()) {
            this.btnStarStoptHttp.setText(J18N.tr("Stop", new Object[0]));
            this.btnStarStoptHttp.setIcon(Resources.getImageIcon("/res/img_stop.png"));
            this.lblHttpPort.setEnabled(false);
            this.txtPortHttp.setEnabled(false);
        } else {
            this.btnStarStoptHttp.setText(J18N.tr("Start", new Object[0]));
            this.btnStarStoptHttp.setIcon(Resources.getImageIcon("/res/img_start.png"));
            this.lblHttpPort.setEnabled(true);
            this.txtPortHttp.setEnabled(true);
        }
    }

    @Override
    public void onLocaleChange(Locale newLocale) {
        this.retranslateUi();
    }

    private static class PortTextField
    extends IntTextField {
        private static final long serialVersionUID = 1L;
        private static final int MIN_TCP_PORT = 1;
        private static final int MAX_TCP_PORT = 65536;

        public PortTextField(int columns) {
            super(columns);
        }

        public int getPort() {
            Integer port = this.getText().trim().isEmpty() ? null : Integer.valueOf(Integer.parseInt(this.getText()));
            boolean valid = port != null && port >= 1 && port <= 65536;
            return valid ? port : -1;
        }

        @Override
        protected void onChange() {
            super.onChange();
            this.setValid(this.getPort() != -1);
        }
    }
}

