/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.ApplicationSettings;
import br.com.gertec.tc.server.bean.TerminalGroup;
import br.com.gertec.tc.server.gui.GroupCreateEditDialog;
import br.com.gertec.tc.server.gui.util.GuiDialog;
import br.com.gertec.tc.server.gui.util.GuiPanel;
import br.com.gertec.tc.server.gui.util.GuiUtils;
import br.org.reconcavo.j18n.J18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TcGroupManagerDialog
extends GuiDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new GuiPanel();
    private final JList<TerminalGroup> uiGroupList;
    private final DefaultListModel<TerminalGroup> listModel;
    private final JButton btnNew;
    private final JButton btnEdit;
    private final JButton btnDelete;
    private boolean modified = false;

    public TcGroupManagerDialog() {
        this.setMinimumSize(new Dimension(360, 220));
        this.setTitle(J18N.tr("Terminal grouping", new Object[0]));
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        GridBagLayout gblContentPanel = new GridBagLayout();
        gblContentPanel.columnWidths = new int[]{0, 0, 0};
        gblContentPanel.rowHeights = new int[]{0, 60, 0};
        gblContentPanel.columnWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        gblContentPanel.rowWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        this.contentPanel.setLayout(gblContentPanel);
        JLabel lblRegisteredGroups = new JLabel(J18N.tr("Registered groups", new Object[0]));
        GridBagConstraints gbcLblNewLabel = new GridBagConstraints();
        gbcLblNewLabel.anchor = 17;
        gbcLblNewLabel.gridwidth = 2;
        gbcLblNewLabel.gridx = 0;
        gbcLblNewLabel.gridy = 0;
        this.contentPanel.add((Component)lblRegisteredGroups, gbcLblNewLabel);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setMinimumSize(new Dimension(250, 22));
        GridBagConstraints gbcScrollPane = new GridBagConstraints();
        gbcScrollPane.insets = new Insets(5, 0, 0, 0);
        gbcScrollPane.fill = 1;
        gbcScrollPane.gridx = 0;
        gbcScrollPane.gridy = 1;
        this.contentPanel.add((Component)scrollPane, gbcScrollPane);
        this.listModel = new DefaultListModel();
        this.uiGroupList = new JList<TerminalGroup>(this.listModel);
        this.uiGroupList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    boolean hasSelection = TcGroupManagerDialog.this.uiGroupList.getSelectedIndex() != -1;
                    TcGroupManagerDialog.this.btnEdit.setEnabled(hasSelection);
                    TcGroupManagerDialog.this.btnDelete.setEnabled(hasSelection);
                }
            }
        });
        scrollPane.setViewportView(this.uiGroupList);
        this.uiGroupList.setBorder(new EmptyBorder(5, 0, 0, 0));
        this.uiGroupList.setSelectionMode(0);
        JPanel lateralPanel = new JPanel();
        GridBagConstraints gbcLateralPanel = new GridBagConstraints();
        gbcLateralPanel.fill = 3;
        gbcLateralPanel.insets = new Insets(5, 5, 0, 0);
        gbcLateralPanel.gridx = 1;
        gbcLateralPanel.gridy = 1;
        this.contentPanel.add((Component)lateralPanel, gbcLateralPanel);
        lateralPanel.setBorder(null);
        GridBagLayout gblLateralPanel = new GridBagLayout();
        gblLateralPanel.columnWidths = new int[]{80, 0};
        gblLateralPanel.rowHeights = new int[]{22, 22, 0, 0, 0};
        gblLateralPanel.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gblLateralPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        lateralPanel.setLayout(gblLateralPanel);
        this.btnNew = new JButton(J18N.tr("New", new Object[0]) + "...");
        this.btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupCreateEditDialog dialog = new GroupCreateEditDialog(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected void onClose(Object result) {
                        super.onClose(result);
                        if (result != null) {
                            TcGroupManagerDialog.this.modified = true;
                            TcGroupManagerDialog.this.loadGroups();
                        }
                    }
                };
                dialog.setLocationRelativeTo(TcGroupManagerDialog.this);
                dialog.setVisible(true);
            }
        });
        GridBagConstraints gbcBtnNew = new GridBagConstraints();
        gbcBtnNew.fill = 1;
        gbcBtnNew.insets = new Insets(0, 0, 5, 0);
        gbcBtnNew.gridx = 0;
        gbcBtnNew.gridy = 0;
        lateralPanel.add((Component)this.btnNew, gbcBtnNew);
        this.btnEdit = new JButton(J18N.tr("Edit", new Object[0]) + "...");
        this.btnEdit.setEnabled(false);
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupCreateEditDialog dialog = new GroupCreateEditDialog((TerminalGroup)TcGroupManagerDialog.this.uiGroupList.getSelectedValue()){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected void onClose(Object result) {
                        super.onClose(result);
                        if (result != null) {
                            TcGroupManagerDialog.this.modified = true;
                            TcGroupManagerDialog.this.loadGroups();
                        }
                    }
                };
                dialog.setLocationRelativeTo(TcGroupManagerDialog.this);
                dialog.setVisible(true);
            }
        });
        GridBagConstraints gbcBtnEdit = new GridBagConstraints();
        gbcBtnEdit.insets = new Insets(0, 0, 5, 0);
        gbcBtnEdit.fill = 1;
        gbcBtnEdit.gridx = 0;
        gbcBtnEdit.gridy = 1;
        lateralPanel.add((Component)this.btnEdit, gbcBtnEdit);
        this.btnDelete = new JButton(J18N.tr("Delete", new Object[0]));
        this.btnDelete.setEnabled(false);
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TerminalGroup selectedGroup = (TerminalGroup)TcGroupManagerDialog.this.uiGroupList.getSelectedValue();
                if (selectedGroup == null) {
                    GuiUtils.showWarningMessage(TcGroupManagerDialog.this, "Select a group first");
                } else {
                    int result = JOptionPane.showConfirmDialog(TcGroupManagerDialog.this, J18N.tr("Do you really want to delete group '%s'?", selectedGroup.getName()), Application.APP_NAME, 0, 2);
                    if (result == 0) {
                        Application.SETTINGS.removeTerminalGroup(selectedGroup.getName());
                        TcGroupManagerDialog.this.modified = true;
                        TcGroupManagerDialog.this.loadGroups();
                    }
                }
            }
        });
        GridBagConstraints gbcBtnDelete = new GridBagConstraints();
        gbcBtnDelete.fill = 2;
        gbcBtnDelete.insets = new Insets(0, 0, 5, 0);
        gbcBtnDelete.gridx = 0;
        gbcBtnDelete.gridy = 2;
        lateralPanel.add((Component)this.btnDelete, gbcBtnDelete);
        Component verticalStrut = Box.createVerticalStrut(20);
        GridBagConstraints gbcVerticalStrut = new GridBagConstraints();
        gbcVerticalStrut.fill = 1;
        gbcVerticalStrut.gridx = 0;
        gbcVerticalStrut.gridy = 3;
        lateralPanel.add(verticalStrut, gbcVerticalStrut);
        JPanel buttonPane = new JPanel();
        FlowLayout flButtonPane = new FlowLayout(2);
        buttonPane.setLayout(flButtonPane);
        this.getContentPane().add((Component)buttonPane, "South");
        JButton btnOk = new JButton(J18N.tr("OK", new Object[0]));
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TcGroupManagerDialog.this.modified) {
                    TcGroupManagerDialog.this.dispose(TcGroupManagerDialog.this.modified);
                } else {
                    TcGroupManagerDialog.this.dispose();
                }
            }
        });
        buttonPane.add(btnOk);
        this.setDefaultButton(btnOk);
        this.setCancelButton(btnOk);
        this.loadGroups();
        this.pack();
    }

    private void loadGroups() {
        this.listModel.removeAllElements();
        List<TerminalGroup> listGroup = ApplicationSettings.getInstance().getTerminalGroups();
        for (TerminalGroup g : listGroup) {
            this.listModel.addElement(g);
        }
    }
}

