/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.bean.TerminalGroup;
import br.com.gertec.tc.server.gui.AddMediaDialog;
import br.com.gertec.tc.server.gui.ConfigIpDinamicDialog;
import br.com.gertec.tc.server.gui.ConfigLineDialog;
import br.com.gertec.tc.server.gui.ConfigMiscDialog;
import br.com.gertec.tc.server.gui.ConfigTCP501Dialog;
import br.com.gertec.tc.server.gui.ConfigTcpIpDialog;
import br.com.gertec.tc.server.gui.ConfigWiFiDialog;
import br.com.gertec.tc.server.gui.REConf02Dialog;
import br.com.gertec.tc.server.gui.mediadialog.sc504.MediaDialog;
import br.com.gertec.tc.server.gui.util.GuiUtils;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.GenericTc;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc501.Sc501Connection;
import br.com.gertec.tc.server.protocol.sc501.Sc501Server;
import br.com.gertec.tc.server.protocol.sc501.commands.AlwaysLive;
import br.com.gertec.tc.server.protocol.sc501.commands.CheckLive;
import br.com.gertec.tc.server.protocol.sc501.commands.Config02Q;
import br.com.gertec.tc.server.protocol.sc501.commands.Gif;
import br.com.gertec.tc.server.protocol.sc501.commands.Img;
import br.com.gertec.tc.server.protocol.sc501.commands.LiveQ;
import br.com.gertec.tc.server.protocol.sc501.commands.ParamConfigQ;
import br.com.gertec.tc.server.protocol.sc501.commands.RestartSoft;
import br.com.gertec.tc.server.protocol.sc501.commands.WlanConfigQ;
import br.com.gertec.tc.server.protocol.sc501.listener.Sc501ServerListener;
import br.com.gertec.tc.server.protocol.sc504.Sc504Connection;
import br.com.gertec.tc.server.protocol.sc504.Sc504Server;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvAlwaysLive;
import br.com.gertec.tc.server.protocol.sc504.listener.Sc504ServerListener;
import br.com.gertec.tc.server.util.version.DeviceVersion;
import br.org.reconcavo.event.comm.socket.SocketConnection;
import br.org.reconcavo.event.comm.socket.TcpServer;
import br.org.reconcavo.j18n.J18N;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TcTree
extends JTree
implements J18N.LocaleChangeListener {
    private static final long serialVersionUID = 1L;
    private final DefaultTreeModel model;
    private final DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(J18N.tr("Groups", new Object[0]));
    private final JPopupMenu popupMenu = new JPopupMenu();
    private final JMenuItem mntmCloseConnection;
    private final JCheckBoxMenuItem chckbxmntmAlwaysLive;
    private final JMenuItem mntmRestartTerminal;
    private final JMenuItem mntmMediaManagement;
    private final JMenu mntmTerminalConfig;
    private final JMenuItem mntmTcpMenuItem;
    private final JMenuItem mntmWiFiMenuItem;
    private final JMenuItem mntmIPDinamicMenuItem;
    private final JMenuItem mntmLinhaMenuItem;
    private final JMenuItem mntmTCP501MenuItem;
    private final JMenuItem mntmMiscMenuItem;
    private final JSeparator configSeparator;
    private final Sc501DebugMenu mntSc501DebugMenu = new Sc501DebugMenu("SC501 Debug");
    private boolean nameVisible;
    private boolean typeVisible;

    private void showSelectionWarning() {
        GuiUtils.showWarningMessage(this, J18N.tr("Please select a client", new Object[0]));
    }

    public TcTree() {
        this.popupMenu.add(this.mntSc501DebugMenu);
        this.mntmCloseConnection = new JMenuItem();
        this.mntmCloseConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TcTree.this.getSelectedConnection() == null) {
                    TcTree.this.showSelectionWarning();
                } else {
                    TcTree.this.getSelectedConnection().close();
                }
            }
        });
        this.popupMenu.add(this.mntmCloseConnection);
        this.chckbxmntmAlwaysLive = new JCheckBoxMenuItem();
        this.chckbxmntmAlwaysLive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractTcConnection connection = TcTree.this.getSelectedConnection();
                if (connection == null) {
                    TcTree.this.showSelectionWarning();
                } else {
                    boolean alwaysLive = TcTree.this.chckbxmntmAlwaysLive.isSelected();
                    connection.enableLiveTimer(!alwaysLive);
                    connection.writeCommand(new IDvAlwaysLive(alwaysLive));
                }
            }
        });
        this.popupMenu.add(this.chckbxmntmAlwaysLive);
        this.mntmRestartTerminal = new JMenuItem();
        this.mntmRestartTerminal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TcTree.this.getSelectedConnection() == null) {
                    TcTree.this.showSelectionWarning();
                } else {
                    AbstractTcConnection connection = TcTree.this.getSelectedConnection();
                    connection.sendRestartTerminal();
                }
            }
        });
        this.popupMenu.add(this.mntmRestartTerminal);
        this.mntmMediaManagement = new JMenuItem();
        this.mntmMediaManagement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractTcConnection connection = TcTree.this.getSelectedConnection();
                if (TcTree.this.getSelectedConnection() == null) {
                    TcTree.this.showSelectionWarning();
                } else if (TcTree.this.getSelectedConnection().getTerminalType().equals((Object)TerminalType.TC_406) || TcTree.this.getSelectedConnection().getTerminalType().equals((Object)TerminalType.TC_506_S) || TcTree.this.getSelectedConnection().getTerminalType().equals((Object)TerminalType.TC_507) || TcTree.this.getSelectedConnection().getTerminalType().equals((Object)TerminalType.TC_505)) {
                    AddMediaDialog dialog = new AddMediaDialog(TcTree.this.getSelectedConnection());
                    dialog.setLocationRelativeTo(Application.getMainWindow());
                    dialog.setVisible(true);
                } else if (connection instanceof Sc504Connection || TcTree.this.getSelectedConnection().getTerminalType().equals((Object)TerminalType.TC_506_E) || TcTree.this.getSelectedConnection().getTerminalType().equals((Object)TerminalType.TC_406_E)) {
                    MediaDialog dialog = new MediaDialog(TcTree.this.getSelectedConnection());
                    dialog.setLocationRelativeTo(Application.getMainWindow());
                    dialog.setVisible(true);
                }
            }
        });
        this.popupMenu.add(this.mntmMediaManagement);
        this.mntmTerminalConfig = new JMenu();
        this.mntmTcpMenuItem = new JMenuItem();
        this.mntmTcpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TcTree.this.getSelectedConnection() == null) {
                    TcTree.this.showSelectionWarning();
                } else {
                    ConfigTcpIpDialog dialog = new ConfigTcpIpDialog(TcTree.this.getSelectedConnection());
                    dialog.setLocationRelativeTo(Application.getMainWindow());
                    dialog.setVisible(true);
                }
            }
        });
        this.mntmTerminalConfig.add(this.mntmTcpMenuItem);
        this.mntmWiFiMenuItem = new JMenuItem();
        this.mntmWiFiMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TcTree.this.getSelectedConnection() == null) {
                    TcTree.this.showSelectionWarning();
                } else {
                    ConfigWiFiDialog dialog = new ConfigWiFiDialog(TcTree.this.getSelectedConnection());
                    dialog.setLocationRelativeTo(Application.getMainWindow());
                    dialog.setVisible(true);
                }
            }
        });
        this.mntmTerminalConfig.add(this.mntmWiFiMenuItem);
        this.mntmIPDinamicMenuItem = new JMenuItem();
        this.mntmIPDinamicMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TcTree.this.getSelectedConnection() == null) {
                    TcTree.this.showSelectionWarning();
                } else {
                    ConfigIpDinamicDialog dialog = new ConfigIpDinamicDialog(TcTree.this.getSelectedConnection());
                    dialog.setLocationRelativeTo(Application.getMainWindow());
                    dialog.setVisible(true);
                }
            }
        });
        this.mntmTerminalConfig.add(this.mntmIPDinamicMenuItem);
        this.mntmTCP501MenuItem = new JMenuItem();
        this.mntmTCP501MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TcTree.this.getSelectedConnection() == null) {
                    TcTree.this.showSelectionWarning();
                } else {
                    ConfigTCP501Dialog dialog = new ConfigTCP501Dialog(TcTree.this.getSelectedConnection());
                    dialog.setLocationRelativeTo(Application.getMainWindow());
                    dialog.setVisible(true);
                }
            }
        });
        this.mntmTerminalConfig.add(this.mntmTCP501MenuItem);
        this.mntmLinhaMenuItem = new JMenuItem();
        this.mntmLinhaMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TcTree.this.getSelectedConnection() == null) {
                    TcTree.this.showSelectionWarning();
                } else {
                    ConfigLineDialog dialog = new ConfigLineDialog(TcTree.this.getSelectedConnection());
                    dialog.setLocationRelativeTo(Application.getMainWindow());
                    dialog.setVisible(true);
                }
            }
        });
        this.mntmTerminalConfig.add(this.mntmLinhaMenuItem);
        this.configSeparator = new JSeparator();
        this.mntmMiscMenuItem = new JMenuItem();
        this.mntmMiscMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TcTree.this.getSelectedConnection() == null) {
                    TcTree.this.showSelectionWarning();
                } else {
                    AbstractTcConnection connection = TcTree.this.getSelectedConnection();
                    ConfigMiscDialog dialog = new ConfigMiscDialog(connection);
                    dialog.setLocationRelativeTo(Application.getMainWindow());
                    dialog.setVisible(true);
                }
            }
        });
        this.mntmTerminalConfig.add(this.mntmMiscMenuItem);
        this.popupMenu.add(this.mntmTerminalConfig);
        this.model = new DefaultTreeModel(this.rootNode);
        this.setModel(this.model);
        this.setShowsRootHandles(true);
        this.setRootVisible(false);
        this.getSelectionModel().setSelectionMode(1);
        this.setCellRenderer(new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                String text;
                JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if ((value = ((DefaultMutableTreeNode)value).getUserObject()) instanceof TerminalTypeGroup) {
                    text = ((TerminalTypeGroup)value).getType().getMarketName();
                } else if (value instanceof TerminalGroup) {
                    text = ((TerminalGroup)value).getName();
                    text = text + "(" + ((TerminalGroup)value).getTerminals().size() + ")";
                } else if (value instanceof AbstractTcConnection) {
                    AbstractTcConnection connection = (AbstractTcConnection)value;
                    if (TcTree.this.isNameVisible() || TcTree.this.isTypeVisible()) {
                        String suffix = TcTree.this.isNameVisible() && TcTree.this.isTypeVisible() ? String.format("%s | %s", connection.getTerminal().getTcName(), connection.getTerminalType().getMarketName()) : (TcTree.this.isNameVisible() ? connection.getTerminal().getTcName() : connection.getTerminalType().getMarketName());
                        String audioInfo = String.format(J18N.tr("Query Audio: %s", new Object[0]), connection.getTerminal().getLogAudioStatus());
                        text = String.format("%s - %s (%s)", connection.getInetAddress().getHostAddress(), audioInfo, suffix);
                    } else {
                        text = connection.getInetAddress().getHostAddress();
                    }
                } else {
                    text = value == null ? "" : value.toString();
                }
                label.setText(text);
                return label;
            }
        });
        this.registerListeners();
        this.retranslateUi();
        this.setComponentPopupMenu(this.popupMenu);
    }

    public boolean isNameVisible() {
        return this.nameVisible;
    }

    public void setNameVisible(boolean visible) {
        if (this.nameVisible != visible) {
            this.nameVisible = visible;
            this.refreshConnectionNodes();
        }
    }

    public boolean isTypeVisible() {
        return this.typeVisible;
    }

    public void setTypeVisible(boolean visible) {
        if (this.typeVisible != visible) {
            this.typeVisible = visible;
            this.refreshConnectionNodes();
        }
    }

    @Override
    public JPopupMenu getComponentPopupMenu() {
        AbstractTcConnection selectedConnection = this.getSelectedConnection();
        if (selectedConnection != null) {
            switch (selectedConnection.getTerminalType().getProtocolType()) {
                case SC501: {
                    this.mntSc501DebugMenu.setVisible(Application.DEBUG_ENABLED);
                    this.mntmIPDinamicMenuItem.setVisible(true);
                    this.mntmLinhaMenuItem.setVisible(true);
                    this.mntmTCP501MenuItem.setVisible(true);
                    break;
                }
                default: {
                    this.mntmIPDinamicMenuItem.setVisible(false);
                    this.mntmLinhaMenuItem.setVisible(false);
                    this.mntmTCP501MenuItem.setVisible(false);
                    this.mntSc501DebugMenu.setVisible(false);
                }
            }
            this.chckbxmntmAlwaysLive.setSelected(!selectedConnection.isLiveTimerActive());
            GenericTc terminal = selectedConnection.getTerminal();
            switch (terminal.getType()) {
                case TC_502: {
                    this.mntmCloseConnection.setVisible(true);
                    this.chckbxmntmAlwaysLive.setVisible(false);
                    this.mntmRestartTerminal.setVisible(true);
                    this.mntmMediaManagement.setVisible(false);
                    this.mntmTerminalConfig.setVisible(true);
                    this.mntmTcpMenuItem.setVisible(false);
                    if (terminal.getMacAddress() == null) {
                        this.mntmWiFiMenuItem.setVisible(false);
                    } else {
                        this.mntmWiFiMenuItem.setVisible(true);
                    }
                    this.configSeparator.setVisible(true);
                    this.mntmMiscMenuItem.setVisible(false);
                    break;
                }
                case TC_406: {
                    this.mntmCloseConnection.setVisible(true);
                    this.chckbxmntmAlwaysLive.setVisible(false);
                    this.mntmRestartTerminal.setVisible(true);
                    this.mntmMediaManagement.setVisible(true);
                    this.mntmTerminalConfig.setVisible(true);
                    this.mntmTcpMenuItem.setVisible(false);
                    if (terminal.getMacAddress() == null) {
                        this.mntmWiFiMenuItem.setVisible(false);
                    } else {
                        this.mntmWiFiMenuItem.setVisible(true);
                    }
                    this.configSeparator.setVisible(true);
                    if (DeviceVersion.isNewVersion(terminal.getType(), terminal.getTerminalVersion())) {
                        this.mntmMiscMenuItem.setVisible(true);
                        break;
                    }
                    this.mntmMiscMenuItem.setVisible(false);
                    break;
                }
                case TC_506_S: {
                    this.mntmCloseConnection.setVisible(true);
                    this.chckbxmntmAlwaysLive.setVisible(false);
                    this.mntmRestartTerminal.setVisible(true);
                    this.mntmMediaManagement.setVisible(true);
                    this.mntmTerminalConfig.setVisible(true);
                    this.mntmTcpMenuItem.setVisible(false);
                    if (terminal.getMacAddress() == null) {
                        this.mntmWiFiMenuItem.setVisible(false);
                    } else {
                        this.mntmWiFiMenuItem.setVisible(true);
                    }
                    this.configSeparator.setVisible(true);
                    if (DeviceVersion.isNewVersion(terminal.getType(), terminal.getTerminalVersion())) {
                        this.mntmMiscMenuItem.setVisible(true);
                        break;
                    }
                    this.mntmMiscMenuItem.setVisible(false);
                    break;
                }
                case TC_506_E: {
                    this.mntmCloseConnection.setVisible(true);
                    this.chckbxmntmAlwaysLive.setVisible(false);
                    this.mntmRestartTerminal.setVisible(true);
                    this.mntmMediaManagement.setVisible(true);
                    this.mntmTerminalConfig.setVisible(true);
                    this.mntmTcpMenuItem.setVisible(false);
                    if (terminal.getMacAddress() == null) {
                        this.mntmWiFiMenuItem.setVisible(false);
                    } else {
                        this.mntmWiFiMenuItem.setVisible(true);
                    }
                    this.configSeparator.setVisible(true);
                    this.mntmMiscMenuItem.setVisible(true);
                    break;
                }
                case TC_406_E: {
                    this.mntmCloseConnection.setVisible(true);
                    this.chckbxmntmAlwaysLive.setVisible(false);
                    this.mntmRestartTerminal.setVisible(true);
                    this.mntmMediaManagement.setVisible(true);
                    this.mntmTerminalConfig.setVisible(true);
                    this.mntmTcpMenuItem.setVisible(false);
                    if (terminal.getMacAddress() == null) {
                        this.mntmWiFiMenuItem.setVisible(false);
                    } else {
                        this.mntmWiFiMenuItem.setVisible(true);
                    }
                    this.configSeparator.setVisible(true);
                    this.mntmMiscMenuItem.setVisible(true);
                    break;
                }
                case TC_504: {
                    this.mntmCloseConnection.setVisible(true);
                    this.chckbxmntmAlwaysLive.setVisible(true);
                    this.mntmRestartTerminal.setVisible(true);
                    this.mntmMediaManagement.setVisible(true);
                    this.mntmTerminalConfig.setVisible(true);
                    this.mntmTcpMenuItem.setVisible(true);
                    this.mntmWiFiMenuItem.setVisible(true);
                    this.configSeparator.setVisible(true);
                    this.mntmMiscMenuItem.setVisible(true);
                    break;
                }
                case TC_505: {
                    this.mntmCloseConnection.setVisible(true);
                    this.chckbxmntmAlwaysLive.setVisible(false);
                    this.mntmRestartTerminal.setVisible(true);
                    this.mntmMediaManagement.setVisible(true);
                    this.mntmTerminalConfig.setVisible(true);
                    this.mntmTcpMenuItem.setVisible(false);
                    if (selectedConnection.getTerminal().getMacAddress() == null) {
                        this.mntmWiFiMenuItem.setVisible(false);
                    } else {
                        this.mntmWiFiMenuItem.setVisible(true);
                    }
                    this.configSeparator.setVisible(true);
                    this.mntmMiscMenuItem.setVisible(false);
                    break;
                }
                case TC_506_MIDIA: {
                    this.mntmCloseConnection.setVisible(true);
                    this.chckbxmntmAlwaysLive.setVisible(true);
                    this.mntmRestartTerminal.setVisible(true);
                    this.mntmMediaManagement.setVisible(true);
                    this.mntmTerminalConfig.setVisible(true);
                    this.mntmTcpMenuItem.setVisible(true);
                    this.mntmWiFiMenuItem.setVisible(true);
                    this.configSeparator.setVisible(true);
                    this.mntmMiscMenuItem.setVisible(true);
                    break;
                }
                case TC_507: {
                    this.mntmCloseConnection.setVisible(true);
                    this.chckbxmntmAlwaysLive.setVisible(false);
                    this.mntmRestartTerminal.setVisible(true);
                    this.mntmMediaManagement.setVisible(true);
                    this.mntmTerminalConfig.setVisible(true);
                    this.mntmTcpMenuItem.setVisible(false);
                    this.mntmWiFiMenuItem.setVisible(true);
                    this.configSeparator.setVisible(true);
                    this.mntmMiscMenuItem.setVisible(false);
                    break;
                }
                case TC_508: {
                    this.mntmCloseConnection.setVisible(true);
                    this.chckbxmntmAlwaysLive.setVisible(Application.DEBUG_ENABLED);
                    this.mntmRestartTerminal.setVisible(false);
                    this.mntmMediaManagement.setVisible(true);
                    this.mntmTerminalConfig.setVisible(true);
                    this.mntmTcpMenuItem.setVisible(false);
                    this.mntmWiFiMenuItem.setVisible(false);
                    this.configSeparator.setVisible(false);
                    this.mntmMiscMenuItem.setVisible(true);
                    break;
                }
                case GB_600: {
                    this.mntmCloseConnection.setVisible(true);
                    this.chckbxmntmAlwaysLive.setVisible(true);
                    this.mntmRestartTerminal.setVisible(true);
                    this.mntmMediaManagement.setVisible(true);
                    this.mntmTerminalConfig.setVisible(true);
                    this.mntmTcpMenuItem.setVisible(true);
                    this.mntmWiFiMenuItem.setVisible(true);
                    this.configSeparator.setVisible(true);
                    this.mntmMiscMenuItem.setVisible(true);
                    break;
                }
                case GB_601: {
                    this.mntmCloseConnection.setVisible(true);
                    this.chckbxmntmAlwaysLive.setVisible(true);
                    this.mntmRestartTerminal.setVisible(true);
                    this.mntmMediaManagement.setVisible(true);
                    this.mntmTerminalConfig.setVisible(true);
                    this.mntmTcpMenuItem.setVisible(true);
                    this.mntmWiFiMenuItem.setVisible(true);
                    this.configSeparator.setVisible(true);
                    this.mntmMiscMenuItem.setVisible(true);
                    break;
                }
                default: {
                    this.mntmCloseConnection.setVisible(true);
                    this.chckbxmntmAlwaysLive.setVisible(false);
                    this.mntmRestartTerminal.setVisible(false);
                    this.mntmMediaManagement.setVisible(false);
                    this.mntmTerminalConfig.setVisible(false);
                    this.mntmTcpMenuItem.setVisible(false);
                    this.mntmWiFiMenuItem.setVisible(false);
                    this.configSeparator.setVisible(false);
                    this.mntmMiscMenuItem.setVisible(false);
                }
            }
            this.mntmWiFiMenuItem.setVisible(false);
            return super.getComponentPopupMenu();
        }
        return null;
    }

    @Override
    public void onLocaleChange(Locale newLocale) {
        System.out.println("Mudou o idioma");
        this.retranslateUi();
    }

    private void registerListeners() {
        Application.SERVER_MANAGER.register501Listener(new Sc501ServerListener.Sc501ServerAdapter(){

            @Override
            public void onHandshakeComplete(Sc501Server server, Sc501Connection connection) {
                TcTree.this.addConnectionNode(connection);
            }

            @Override
            public void onClientDrop(TcpServer server, SocketConnection client) {
                TcTree.this.removeConnectionNode((AbstractTcConnection)client);
            }
        });
        Application.SERVER_MANAGER.register504Listener(new Sc504ServerListener.Sc504ServerAdapter(){

            @Override
            public void onHandshakeComplete(Sc504Server server, Sc504Connection connection) {
                TcTree.this.addConnectionNode(connection);
            }

            @Override
            public void onClientDrop(TcpServer server, SocketConnection client) {
                TcTree.this.removeConnectionNode((AbstractTcConnection)client);
            }
        });
    }

    private AbstractTcConnection getSelectedConnection() {
        TreePath selectedPath = this.getSelectionPath();
        if (selectedPath == null) {
            return null;
        }
        Object selectedUserObject = ((DefaultMutableTreeNode)selectedPath.getLastPathComponent()).getUserObject();
        if (selectedUserObject instanceof AbstractTcConnection) {
            return (AbstractTcConnection)selectedUserObject;
        }
        return null;
    }

    public void retranslateUi() {
        this.rootNode.setUserObject(J18N.tr("Groups", new Object[0]));
        this.mntmCloseConnection.setText(J18N.tr("Close connection", new Object[0]));
        this.chckbxmntmAlwaysLive.setText(J18N.tr("Always live", new Object[0]));
        this.mntmMiscMenuItem.setText(J18N.tr("Miscellaneous", new Object[0]) + "...");
        this.mntmTcpMenuItem.setText(J18N.tr("TCP/IP", new Object[0]) + "...");
        this.mntmLinhaMenuItem.setText(J18N.tr("Text", new Object[0]) + " / " + J18N.tr("Network", new Object[0]));
        this.mntmIPDinamicMenuItem.setText(J18N.tr("DHCP", new Object[0]));
        this.mntmTCP501MenuItem.setText(J18N.tr("Gateway / Terminal", new Object[0]));
        this.mntmMediaManagement.setText(J18N.tr("Media management", new Object[0]) + "...");
        this.mntmRestartTerminal.setText(J18N.tr("Restart Terminal", new Object[0]));
        this.mntmTerminalConfig.setText(J18N.tr("Terminal configuration", new Object[0]));
    }

    private DefaultMutableTreeNode getTerminalTypeGroupNode(AbstractTcConnection connection) {
        Enumeration<TreeNode> e = this.rootNode.breadthFirstEnumeration();
        DefaultMutableTreeNode terminalTypeGroupNode = null;
        while (e.hasMoreElements()) {
            TerminalTypeGroup terminalTypeGroup;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            Object userObject = node.getUserObject();
            if (userObject == null || !(userObject instanceof TerminalTypeGroup) || (terminalTypeGroup = (TerminalTypeGroup)userObject).getType() != connection.getTerminalType()) continue;
            terminalTypeGroupNode = node;
            break;
        }
        if (terminalTypeGroupNode == null) {
            TerminalTypeGroup terminalTypeGroup = new TerminalTypeGroup(connection.getTerminalType());
            terminalTypeGroupNode = new DefaultMutableTreeNode(terminalTypeGroup);
            this.rootNode.add(terminalTypeGroupNode);
            this.model.reload(this.rootNode);
        }
        return terminalTypeGroupNode;
    }

    private DefaultMutableTreeNode getUserDefinedGroupNode(TerminalGroup group) {
        Enumeration<TreeNode> e = this.rootNode.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            TerminalGroup terminalGroup;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            Object userObject = node.getUserObject();
            if (userObject == null || !(userObject instanceof TerminalGroup) || userObject instanceof TerminalTypeGroup || !(terminalGroup = (TerminalGroup)userObject).getName().equals(group.getName())) continue;
            return node;
        }
        return null;
    }

    private DefaultMutableTreeNode getConnectionNode(AbstractTcConnection connection) {
        Enumeration<TreeNode> e = this.rootNode.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            AbstractTcConnection tmpConnection;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            Object userObject = node.getUserObject();
            if (userObject == null || !(userObject instanceof AbstractTcConnection) || !(tmpConnection = (AbstractTcConnection)userObject).getLocalAddress().equals(connection.getLocalAddress())) continue;
            return node;
        }
        return null;
    }

    private void refreshConnectionNodes() {
        Enumeration<TreeNode> e = this.rootNode.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            Object userObject = node.getUserObject();
            if (userObject == null || !(userObject instanceof AbstractTcConnection)) continue;
            this.model.reload(node);
        }
    }

    private void addConnectionNode(AbstractTcConnection tcConnection) {
        DefaultMutableTreeNode userDefinedGroupNode = null;
        boolean addedToGroup = false;
        for (TerminalGroup terminalGroup : Application.SETTINGS.getTerminalGroups()) {
            if (!terminalGroup.contains(tcConnection)) continue;
            userDefinedGroupNode = this.getUserDefinedGroupNode(terminalGroup);
            if (userDefinedGroupNode == null) {
                userDefinedGroupNode = new DefaultMutableTreeNode(terminalGroup);
                this.rootNode.add(userDefinedGroupNode);
                this.model.reload(this.rootNode);
            }
            userDefinedGroupNode.add(new DefaultMutableTreeNode(tcConnection));
            this.model.reload(userDefinedGroupNode);
            addedToGroup = true;
        }
        if (!addedToGroup) {
            DefaultMutableTreeNode connectionNode = new DefaultMutableTreeNode(tcConnection);
            DefaultMutableTreeNode terminalTypeGroupNode = this.getTerminalTypeGroupNode(tcConnection);
            terminalTypeGroupNode.add(connectionNode);
            this.model.reload(terminalTypeGroupNode);
        }
    }

    private void removeConnectionNode(AbstractTcConnection tcConnection) {
        DefaultMutableTreeNode node;
        while ((node = this.getConnectionNode(tcConnection)) != null) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
            this.model.removeNodeFromParent(node);
            this.model.reload(parentNode);
            if (parentNode.getChildCount() != 0) continue;
            this.model.removeNodeFromParent(parentNode);
            this.model.reload(this.rootNode);
        }
    }

    public void reload() {
        this.rootNode.removeAllChildren();
        for (GenericTc tc : Application.SERVER_MANAGER.getClients()) {
            this.addConnectionNode(tc.getConnection());
        }
    }

    private class Sc501DebugMenu
    extends JMenu {
        private static final long serialVersionUID = 1L;
        private final PopupItem mntLiveQ;
        private final PopupItem mntAlwaysLive;
        private final PopupItem mntCheckLive;
        private final PopupItem mntRestartSoft;
        private final PopupItem mntConfig02Q;
        private final PopupItem mntparamConfigQ;
        private final PopupItem mntREConf02;
        private final PopupItem mntGif;
        private final PopupItem mntImg;
        private final PopupItem mntWlanConfigQ;

        public Sc501DebugMenu(String label) {
            super(label);
            this.mntLiveQ = new PopupItem("#live?", new AbstractPopUpAction(){

                @Override
                protected void run(AbstractTcConnection connection) {
                    Log.debug("=====" + J18N.tr("MANUAL COMMAND", new Object[0]) + " =====", new Object[0]);
                    connection.writeCommand(new LiveQ());
                }
            });
            this.add(this.mntLiveQ);
            this.mntAlwaysLive = new PopupItem("#alwayslive", new AbstractPopUpAction(){

                @Override
                protected void run(AbstractTcConnection connection) {
                    Log.debug("=====" + J18N.tr("MANUAL COMMAND", new Object[0]) + " =====", new Object[0]);
                    connection.writeCommand(new AlwaysLive());
                    connection.enableLiveTimer(false);
                }
            });
            this.add(this.mntAlwaysLive);
            this.mntCheckLive = new PopupItem("#checklive", new AbstractPopUpAction(){

                @Override
                protected void run(AbstractTcConnection connection) {
                    Log.debug("=====" + J18N.tr("MANUAL COMMAND", new Object[0]) + " =====", new Object[0]);
                    connection.writeCommand(new CheckLive());
                }
            });
            this.add(this.mntCheckLive);
            this.mntRestartSoft = new PopupItem("#restartsoft", new AbstractPopUpAction(){

                @Override
                protected void run(AbstractTcConnection connection) {
                    String resetPassword = (String)JOptionPane.showInputDialog(TcTree.this, "Informe o c\u00f3digo de reset", "#restartsoft", 3, null, null, String.format("0x%X", -1513334221));
                    if (resetPassword != null) {
                        if ((resetPassword = resetPassword.toUpperCase()).startsWith("0X")) {
                            resetPassword = resetPassword.replaceAll(Pattern.quote("0X"), "");
                        }
                        try {
                            Log.debug("=====" + J18N.tr("MANUAL COMMAND", new Object[0]) + " =====", new Object[0]);
                            connection.writeCommand(new RestartSoft((int)Long.parseLong(resetPassword, 16)));
                        }
                        catch (NumberFormatException e) {
                            Log.debug("Invalid input", new Object[0]);
                        }
                    }
                }
            });
            this.add(this.mntRestartSoft);
            this.mntConfig02Q = new PopupItem("#config02?", new AbstractPopUpAction(){

                @Override
                protected void run(AbstractTcConnection connection) {
                    Log.debug("=====" + J18N.tr("MANUAL COMMAND", new Object[0]) + " =====", new Object[0]);
                    connection.writeCommand(new Config02Q());
                }
            });
            this.add(this.mntConfig02Q);
            this.mntparamConfigQ = new PopupItem("#paramconfig?", new AbstractPopUpAction(){

                @Override
                protected void run(AbstractTcConnection connection) {
                    Log.debug("=====" + J18N.tr("MANUAL COMMAND", new Object[0]) + " =====", new Object[0]);
                    connection.writeCommand(new ParamConfigQ());
                }
            });
            this.add(this.mntparamConfigQ);
            this.mntREConf02 = new PopupItem("#reconf02", new AbstractPopUpAction(){

                @Override
                protected void run(AbstractTcConnection connection) {
                    REConf02Dialog dialog = new REConf02Dialog(TcTree.this.getSelectedConnection());
                    dialog.setLocationRelativeTo(Application.getMainWindow());
                    dialog.setVisible(true);
                }
            });
            this.add(this.mntREConf02);
            this.mntGif = new PopupItem("#gif", new AbstractPopUpAction(){

                @Override
                protected void run(AbstractTcConnection connection) {
                    JFileChooser fileChooser = new JFileChooser();
                    fileChooser.setFileFilter(new FileNameExtensionFilter("GIF files", "gif"));
                    fileChooser.setMultiSelectionEnabled(true);
                    int result = fileChooser.showOpenDialog(TcTree.this);
                    if (result == 0) {
                        File[] selectedFiles = fileChooser.getSelectedFiles();
                        LinkedList<Gif> gifCmdList = new LinkedList<Gif>();
                        if (selectedFiles.length == 1) {
                            gifCmdList.add(new Gif(selectedFiles[0], Gif.ExhibitionMode.IMMEDIATELY, 10, 20));
                        } else {
                            for (File selectedFile : selectedFiles) {
                                gifCmdList.add(new Gif(selectedFile, Gif.ExhibitionMode.LOOP, 5, 10));
                            }
                        }
                        Log.debug("=====" + J18N.tr("MANUAL COMMAND", new Object[0]) + " =====", new Object[0]);
                        for (Gif gif : gifCmdList) {
                            connection.writeCommand(gif);
                        }
                    }
                }
            });
            this.add(this.mntGif);
            this.mntImg = new PopupItem("#img", new AbstractPopUpAction(){

                @Override
                protected void run(AbstractTcConnection connection) {
                    JFileChooser fileChooser = new JFileChooser();
                    fileChooser.setFileFilter(new FileNameExtensionFilter("bmp or gif files", "bmp", "gif"));
                    fileChooser.setMultiSelectionEnabled(true);
                    int result = fileChooser.showOpenDialog(TcTree.this);
                    if (result == 0) {
                        File[] selectedFiles = fileChooser.getSelectedFiles();
                        LinkedList<Img> gifCmdList = new LinkedList<Img>();
                        if (selectedFiles.length == 1) {
                            gifCmdList.add(new Img(selectedFiles[0], Img.ExhibitionModeImg.IMMEDIATELY, 0, 5));
                        } else {
                            for (File selectedFile : selectedFiles) {
                                gifCmdList.add(new Img(selectedFile, Img.ExhibitionModeImg.LOOP, 0, 5));
                            }
                        }
                        Log.debug("=====" + J18N.tr("MANUAL COMMAND", new Object[0]) + " =====", new Object[0]);
                        for (Img img : gifCmdList) {
                            connection.writeCommand(img);
                        }
                    }
                }
            });
            this.add(this.mntImg);
            this.mntWlanConfigQ = new PopupItem("#wlanconfig?", new AbstractPopUpAction(){

                @Override
                protected void run(AbstractTcConnection connection) {
                    Log.debug("=====" + J18N.tr("MANUAL COMMAND", new Object[0]) + " =====", new Object[0]);
                    connection.writeCommand(new WlanConfigQ());
                }
            });
            this.add(this.mntWlanConfigQ);
        }

        private class PopupItem
        extends JMenuItem {
            private static final long serialVersionUID = 1L;

            public PopupItem(String label, final AbstractPopUpAction action) {
                super(label);
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (action != null) {
                            action.run();
                        }
                    }
                });
            }
        }

        private abstract class AbstractPopUpAction {
            private AbstractPopUpAction() {
            }

            public final void run() {
                AbstractTcConnection connection = TcTree.this.getSelectedConnection();
                if (connection == null) {
                    TcTree.this.showSelectionWarning();
                } else {
                    this.run(connection);
                }
            }

            protected abstract void run(AbstractTcConnection var1);
        }
    }

    private static class TerminalTypeGroup
    extends TerminalGroup {
        private final TerminalType terminalType;

        public TerminalTypeGroup(TerminalType terminalType) {
            this.terminalType = terminalType;
        }

        public final TerminalType getType() {
            return this.terminalType;
        }
    }
}

