/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.gui.SwingUtils;
import br.com.gertec.tc.server.gui.util.GuiDialog;
import br.com.gertec.tc.server.gui.util.GuiPanel;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.CommandListener;
import br.com.gertec.tc.server.protocol.GenericTc;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc501.commands.AlwaysLive;
import br.com.gertec.tc.server.protocol.sc501.commands.UpdateFirmware;
import br.com.gertec.tc.server.protocol.sc501.commands.UpdateFirmwareOk;
import br.com.gertec.tc.server.protocol.sc504.Sc504Connection;
import br.com.gertec.tc.server.protocol.sc504.commands.IDvSendFile;
import br.com.gertec.tc.server.util.version.DeviceVersion;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.j18n.J18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.filechooser.FileFilter;

public class UpdateDialog
extends GuiDialog {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_FILE_SUFFIXES_TAR_GZ = new String(".tar.gz");
    private static final String DEFAULT_FILE_SUFFIXES_BIN = new String(".bin");
    private static final String UPDATE_DIR_TC_506_M = "UPDATE/";
    private File file;
    private final JPanel contentPane;
    private final JPanel miscPanel;
    private final JLabel lblLine1;
    private final JLabel lblLine2;
    private final JLabel lblLine3;
    private final JLabel lblLine4;
    private final JButton btnSelect;
    private final JButton btnSend;
    private final JButton btnCancel;
    private final JComboBox<String> cmbBoxTerminalList;
    private ArrayList<GenericTc> tcList = new ArrayList();

    public UpdateDialog() {
        this.setTitle(J18N.tr("Update Devices", new Object[0]));
        this.setSize(540, 170);
        this.setResizable(false);
        this.setModal(true);
        this.setLocationRelativeTo(null);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPane = new JPanel();
        this.getContentPane().add((Component)this.contentPane, "Center");
        GridBagLayout gblContentPane = new GridBagLayout();
        gblContentPane.columnWidths = new int[]{0, 0};
        gblContentPane.rowHeights = new int[]{0, 0, 0, 0};
        gblContentPane.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gblContentPane.rowWeights = new double[]{0.0, 0.0, 0.0};
        this.contentPane.setLayout(gblContentPane);
        this.miscPanel = new GuiPanel();
        GridBagConstraints gbcMiscPanel = new GridBagConstraints();
        gbcMiscPanel.anchor = 15;
        gbcMiscPanel.gridheight = 0;
        gbcMiscPanel.insets = new Insets(5, 5, 0, 5);
        gbcMiscPanel.fill = 2;
        gbcMiscPanel.gridx = 0;
        gbcMiscPanel.gridy = 0;
        this.contentPane.add((Component)this.miscPanel, gbcMiscPanel);
        GridBagLayout gblMiscPanel = new GridBagLayout();
        gblMiscPanel.columnWidths = new int[]{0, 0};
        gblMiscPanel.rowHeights = new int[]{40, 40, 40};
        gblMiscPanel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gblMiscPanel.rowWeights = new double[]{0.0, 0.0, 0.0};
        this.miscPanel.setLayout(gblMiscPanel);
        this.miscPanel.setVisible(true);
        this.lblLine1 = new JLabel(J18N.tr("Select terminal to be updated", new Object[0]) + ":");
        this.lblLine1.setFont(new Font("Tahoma", 0, 12));
        GridBagConstraints gbcLblLine1 = new GridBagConstraints();
        gbcLblLine1.anchor = 17;
        gbcLblLine1.insets = new Insets(5, 0, 5, 5);
        gbcLblLine1.gridx = 0;
        gbcLblLine1.gridy = 0;
        this.miscPanel.add((Component)this.lblLine1, gbcLblLine1);
        this.lblLine2 = new JLabel(J18N.tr("Select new firmware file", new Object[0]) + ":");
        this.lblLine2.setFont(new Font("Tahoma", 0, 12));
        GridBagConstraints gbcLblLine2 = new GridBagConstraints();
        gbcLblLine2.anchor = 17;
        gbcLblLine2.insets = new Insets(5, 0, 5, 5);
        gbcLblLine2.gridx = 0;
        gbcLblLine2.gridy = 1;
        this.miscPanel.add((Component)this.lblLine2, gbcLblLine2);
        this.lblLine3 = new JLabel(J18N.tr("Select", new Object[0]) + "...");
        GridBagConstraints gbcLblLine3 = new GridBagConstraints();
        gbcLblLine3.anchor = 17;
        gbcLblLine3.insets = new Insets(5, 0, 5, 5);
        gbcLblLine3.gridx = 1;
        gbcLblLine3.gridy = 1;
        this.miscPanel.add((Component)this.lblLine3, gbcLblLine3);
        this.lblLine3.setEnabled(false);
        this.lblLine4 = new JLabel(J18N.tr("", new Object[0]));
        this.lblLine4.setFont(new Font("Tahoma", 0, 12));
        GridBagConstraints gbcLblLine4 = new GridBagConstraints();
        gbcLblLine4.anchor = 17;
        gbcLblLine4.insets = new Insets(5, 0, 5, 5);
        gbcLblLine4.gridx = 0;
        gbcLblLine4.gridy = 2;
        this.miscPanel.add((Component)this.lblLine4, gbcLblLine4);
        this.btnSelect = new JButton(J18N.tr("...", new Object[0]));
        GridBagConstraints gbcBtnSelect = new GridBagConstraints();
        gbcBtnSelect.anchor = 13;
        gbcBtnSelect.insets = new Insets(5, 0, 5, 0);
        gbcBtnSelect.gridx = 1;
        gbcBtnSelect.gridy = 1;
        this.miscPanel.add((Component)this.btnSelect, gbcBtnSelect);
        this.btnSelect.setEnabled(false);
        this.btnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                JList list = SwingUtils.getDescendantOfType(JList.class, fileChooser, "Enabled", true);
                JPopupMenu popup = list.getComponentPopupMenu();
                popup.remove(0);
                UpdateDialog.this.disableComponent(fileChooser);
                fileChooser.setMultiSelectionEnabled(false);
                fileChooser.setAcceptAllFileFilterUsed(false);
                fileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.getName().endsWith(DEFAULT_FILE_SUFFIXES_TAR_GZ) || f.getName().endsWith(DEFAULT_FILE_SUFFIXES_BIN) || f.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return new String(J18N.tr("Supported files", new Object[0]) + ": " + DEFAULT_FILE_SUFFIXES_TAR_GZ + " / " + DEFAULT_FILE_SUFFIXES_BIN);
                    }
                });
                int result = fileChooser.showOpenDialog(UpdateDialog.this);
                if (result == 0) {
                    UpdateDialog.this.file = fileChooser.getSelectedFile();
                    UpdateDialog.this.lblLine3.setText(fileChooser.getSelectedFile().getName());
                    UpdateDialog.this.btnSend.setEnabled(true);
                } else {
                    UpdateDialog.this.file = null;
                    UpdateDialog.this.lblLine3.setText(J18N.tr("Select", new Object[0]) + "...");
                    UpdateDialog.this.btnSend.setEnabled(false);
                }
            }
        });
        this.cmbBoxTerminalList = new JComboBox();
        GridBagConstraints gbcCmbList = new GridBagConstraints();
        gbcCmbList.fill = 2;
        gbcCmbList.insets = new Insets(5, 0, 5, 0);
        gbcCmbList.gridx = 1;
        gbcCmbList.gridy = 0;
        this.miscPanel.add(this.cmbBoxTerminalList, gbcCmbList);
        for (GenericTc tc : Application.SERVER_MANAGER.getClients()) {
            if (!this.tcsupportUpdate(tc.getType(), tc.getFirmwareVersion())) continue;
            String form = String.format("[%s] - [%s] - [%s] - [%s]", tc.getType().getMarketName(), tc.getIpAddress(), tc.getMacAddress(), tc.getTerminalVersion());
            this.cmbBoxTerminalList.addItem(form);
            this.tcList.add(tc);
            this.btnSelect.setEnabled(true);
        }
        this.cmbBoxTerminalList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UpdateDialog.this.cmbBoxTerminalList.getSelectedIndex() != -1) {
                    UpdateDialog.this.btnSelect.setEnabled(true);
                } else {
                    UpdateDialog.this.btnSelect.setEnabled(false);
                }
            }
        });
        this.btnSend = new JButton(J18N.tr("Send", new Object[0]));
        this.btnSend.setEnabled(false);
        GridBagConstraints gbcBtnSend = new GridBagConstraints();
        gbcBtnSend.anchor = 13;
        gbcBtnSend.insets = new Insets(0, 5, 5, 0);
        gbcBtnSend.gridx = 1;
        gbcBtnSend.gridy = 2;
        this.miscPanel.add((Component)this.btnSend, gbcBtnSend);
        this.btnSend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int dialogButton = 0;
                int dialogResult = JOptionPane.showConfirmDialog(null, J18N.tr("After receiving a update file, the Terminal will restart as soon as it detects inactivity to install the new version. Do you confirm sending this update to the Terminal?", new Object[0]), "Warning", dialogButton);
                if (dialogResult == 0) {
                    int position = UpdateDialog.this.cmbBoxTerminalList.getSelectedIndex();
                    AbstractTcConnection connectionSelected = ((GenericTc)UpdateDialog.this.tcList.get(position)).getConnection();
                    this.registerListeners(connectionSelected);
                    if (connectionSelected.getTerminalType() == TerminalType.TC_406_E || connectionSelected.getTerminalType() == TerminalType.TC_506_E) {
                        UpdateDialog.this.lblLine4.setText(J18N.tr("Updating", new Object[0]));
                        connectionSelected.enableLiveTimer(false);
                        connectionSelected.writeCommand(new AlwaysLive());
                        try {
                            Thread.sleep(800L);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                        connectionSelected.writeCommand(new UpdateFirmware());
                    } else {
                        IDvSendFile updCommand = new IDvSendFile(UpdateDialog.UPDATE_DIR_TC_506_M + UpdateDialog.this.file.getName(), UpdateDialog.this.file);
                        Sc504Connection terminal = (Sc504Connection)((GenericTc)UpdateDialog.this.tcList.get(position)).getConnection();
                        terminal.sendFile(updCommand, null);
                    }
                }
            }

            private void registerListeners(AbstractTcConnection connection) {
                UpdateDialog.this.registerSc501CommandListener("#updatefirmware_ok\u0000", new CommandListener(){

                    @Override
                    public void onCommandRead(AbstractTcConnection connection, Command command) {
                        UpdateFirmwareOk updateFirmwareOk = new UpdateFirmwareOk();
                        updateFirmwareOk.sendFirmware(UpdateDialog.this.file, connection);
                    }
                });
                UpdateDialog.this.registerSc501CommandListener("#finishupdatefirmware_ok", new CommandListener(){

                    @Override
                    public void onCommandRead(AbstractTcConnection connection, Command command) {
                        UpdateDialog.this.lblLine4.setText(J18N.tr("Firmware updated successfully", new Object[0]));
                    }
                });
                UpdateDialog.this.registerSc501CommandListener("#finishupdatefirmware_error", new CommandListener(){

                    @Override
                    public void onCommandRead(AbstractTcConnection connection, Command command) {
                        UpdateDialog.this.lblLine4.setText(J18N.tr("Firmware update failed", new Object[0]));
                    }
                });
            }
        });
        this.btnCancel = new JButton(J18N.tr("Cancel", new Object[0]));
        GridBagConstraints gbcBtnCancel = new GridBagConstraints();
        gbcBtnCancel.insets = new Insets(0, 5, 5, 0);
        gbcBtnCancel.gridx = 1;
        gbcBtnCancel.gridy = 2;
        this.miscPanel.add((Component)this.btnCancel, gbcBtnCancel);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateDialog.this.dispose();
            }
        });
    }

    private boolean tcsupportUpdate(TerminalType type, String version) {
        return type == TerminalType.TC_506_E || type == TerminalType.TC_406_E || type == TerminalType.TC_506_MIDIA && DeviceVersion.isNewVersion(type, version);
    }

    public void disableComponent(Container c) {
        int len = c.getComponentCount();
        for (int i = 0; i < len; ++i) {
            Component comp = c.getComponent(i);
            if (comp instanceof JToggleButton) {
                comp.setEnabled(false);
                continue;
            }
            if (!(comp instanceof Container)) continue;
            this.disableComponent((Container)comp);
        }
    }
}

