/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui.mediadialog.sc504;

import br.com.gertec.tc.server.gui.Sc501EMediaPanel;
import br.com.gertec.tc.server.gui.Sc501MediaPanel;
import br.com.gertec.tc.server.gui.Sc504MediaPanel;
import br.com.gertec.tc.server.gui.SlideshowTabbedPaneSc501;
import br.com.gertec.tc.server.gui.SlideshowTabbedPaneSc504;
import br.com.gertec.tc.server.gui.util.GuiPanel;
import br.com.gertec.tc.server.gui.util.GuiTabbedPane;
import br.com.gertec.tc.server.gui.util.GuiTcDialog;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc501.Sc501Connection;
import br.com.gertec.tc.server.protocol.sc504.Sc504Connection;
import br.org.reconcavo.j18n.J18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.border.EmptyBorder;

public class MediaDialog
extends GuiTcDialog {
    private static final long serialVersionUID = 1L;
    private final GuiTabbedPane tabbedPane;
    private Sc501MediaPanel sc501MediaPanel;
    private Sc501EMediaPanel sc501EMediaPanel;
    private Sc504MediaPanel sc504MediaPanel;
    private SlideshowTabbedPaneSc504 slideMediaPanelImage;
    private SlideshowTabbedPaneSc504 slideShowPanelSc504;
    private SlideshowTabbedPaneSc501 slideShowPanelSc501;

    public MediaDialog(AbstractTcConnection connection) {
        super(connection);
        this.setTitle(J18N.tr("Media management - %s (%s)", connection.getInetAddress().getHostAddress(), connection.getTerminal().getTcName()));
        this.setMinimumSize(new Dimension(520, 520));
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.tabbedPane = new GuiTabbedPane();
        this.tabbedPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        GuiPanel buttonPane = new GuiPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton(J18N.tr("OK", new Object[0]));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediaDialog.this.dispose();
            }
        });
        ((Container)buttonPane).add(okButton);
        this.setDefaultButton(okButton);
        this.setCancelButton(okButton);
        this.init();
    }

    public MediaDialog(AbstractTcConnection connection, String title) {
        this(connection);
        this.setTitle(J18N.tr("%s - %s (%s)", title, connection.getInetAddress().getHostAddress(), connection.getTerminal().getTcName()));
    }

    private void init() {
        AbstractTcConnection c = (AbstractTcConnection)this.getManagedObject();
        if (c.isSc504()) {
            Sc504Connection sc504Connection = (Sc504Connection)c;
            TerminalType terminal = c.getTerminalType();
            if (terminal == TerminalType.TC_506_MIDIA || terminal == TerminalType.TC_508 || terminal == TerminalType.GB_600 || terminal == TerminalType.GB_601) {
                this.sc504MediaPanel = new Sc504MediaPanel(sc504Connection);
                this.slideShowPanelSc504 = new SlideshowTabbedPaneSc504(sc504Connection);
                this.tabbedPane.addTab(J18N.tr("Media", new Object[0]), null, this.sc504MediaPanel, null);
                this.tabbedPane.addTab(J18N.tr("Slideshow", new Object[0]), null, this.slideShowPanelSc504, null);
            } else if (terminal == TerminalType.TC_504) {
                this.slideMediaPanelImage = new SlideshowTabbedPaneSc504(sc504Connection);
                this.getContentPane().add((Component)this.slideMediaPanelImage, "Center");
            } else if (c.isSc501()) {
                Sc501Connection sc501Connection = (Sc501Connection)c;
                this.sc501MediaPanel = new Sc501MediaPanel(sc501Connection);
                this.tabbedPane.addTab(J18N.tr("Media", new Object[0]), null, this.sc501MediaPanel, null);
            } else {
                throw new UnsupportedOperationException("Unsupported terminal type: " + c.getClass().getName());
            }
            this.pack();
        } else if (c.isSc501Media()) {
            Sc501Connection sc501Connection = (Sc501Connection)c;
            TerminalType terminal = c.getTerminalType();
            if (terminal != TerminalType.TC_406_E && terminal != TerminalType.TC_506_E) {
                throw new UnsupportedOperationException("Unsupported terminal type: " + c.getClass().getName());
            }
            this.sc501EMediaPanel = new Sc501EMediaPanel(sc501Connection);
            this.slideShowPanelSc501 = new SlideshowTabbedPaneSc501(sc501Connection);
            this.tabbedPane.addTab(J18N.tr("Media", new Object[0]), null, this.sc501EMediaPanel, null);
            this.tabbedPane.addTab(J18N.tr("Slideshow", new Object[0]), null, this.slideShowPanelSc501, null);
            this.pack();
        }
    }
}

