/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui.util;

import br.com.gertec.tc.server.gui.util.NamedColorChooser;
import br.com.gertec.tc.server.gui.util.NamedColorChooserPanel;
import br.com.gertec.tc.server.util.NamedColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.table.TableCellRenderer;

public class ButtonRenderer
extends JButton
implements TableCellRenderer {
    private static final long serialVersionUID = -5345713253498713155L;
    private static NamedColor selectedColor;
    private static int coluna;
    private static NamedColor colorTexto;

    public NamedColor getSelectedColor() {
        return selectedColor;
    }

    public void setSelectedColor(NamedColor defaultColor) {
        selectedColor = defaultColor;
    }

    public ButtonRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.isSelected()) {
            this.setForeground(table.getSelectionBackground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(UIManager.getColor("Button.background"));
        }
        this.setText(value == null ? "" : value.toString());
        return this;
    }

    public static class ButtonColorEditor
    extends DefaultCellEditor {
        protected JButton button = new JButton();
        private String label;
        private Color color;
        private boolean isPushed;
        private JColorChooser chooser;
        private static final long serialVersionUID = 6682255705849030525L;

        public ButtonColorEditor(JCheckBox checkBox) {
            super(checkBox);
            this.button.setOpaque(true);
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.fireEditingStopped();
                }
            });
            AbstractColorChooserPanel[] panels = new AbstractColorChooserPanel[]{new NamedColorChooserPanel()};
            this.chooser = new JColorChooser();
            this.chooser.setChooserPanels(panels);
        }

        public ButtonColorEditor(JCheckBox checkBox, String defaultColorName) {
            this(checkBox);
            selectedColor = NamedColor.fromName(defaultColorName);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (isSelected) {
                this.button.setForeground(table.getSelectionForeground());
                this.button.setBackground(table.getSelectionBackground());
            } else {
                this.button.setForeground(table.getForeground());
                this.button.setBackground(table.getBackground());
            }
            this.label = value == null ? "" : value.toString();
            this.button.setText(this.label);
            this.isPushed = true;
            if (column == 6) {
                colorTexto = (NamedColor)((Object)table.getModel().getValueAt(row, column - 1));
            }
            coluna = column;
            return this.button;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof KeyEvent) {
                KeyEvent keyEvent = (KeyEvent)anEvent;
                if (keyEvent.getKeyCode() == 525) {
                    return false;
                }
                return super.isCellEditable(anEvent);
            }
            return super.isCellEditable(anEvent);
        }

        @Override
        public Object getCellEditorValue() {
            NamedColor namedColor = null;
            if (this.isPushed) {
                namedColor = coluna == 5 ? NamedColorChooser.showDialog(NamedColor.fromName(this.label), false) : NamedColorChooser.showDialog(NamedColor.fromName(this.label), true, colorTexto);
                this.color = new Color(namedColor.getRgb());
                if (this.color != null) {
                    this.button.setText(namedColor.toString());
                    this.button.setBackground(this.color);
                    this.button.setForeground(this.color);
                }
            }
            this.isPushed = false;
            return namedColor;
        }

        @Override
        public boolean stopCellEditing() {
            this.isPushed = false;
            return super.stopCellEditing();
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }

        public NamedColor getSelectedColor() {
            return selectedColor;
        }
    }
}

