/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui.util;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;

public class CurrencyComboBox
extends JComboBox<Currency> {
    private static final long serialVersionUID = 1L;
    private static final List<Currency> CURRENCY_LIST;

    public CurrencyComboBox() {
        this((String)null);
    }

    public CurrencyComboBox(String noneItem) {
        CurrencyModel model = new CurrencyModel();
        model.setNoneIncluded(noneItem != null);
        this.setModel(model);
        this.setRenderer(new CurrencyRenderer(noneItem));
    }

    static {
        Set<Currency> currencySet = Currency.getAvailableCurrencies();
        CURRENCY_LIST = new ArrayList<Currency>();
        for (Currency currency : currencySet) {
            CURRENCY_LIST.add(currency);
        }
        Collections.sort(CURRENCY_LIST, new Comparator<Currency>(){

            @Override
            public int compare(Currency c1, Currency c2) {
                return c1.getCurrencyCode().compareTo(c2.getCurrencyCode());
            }
        });
    }

    private static class CurrencyModel
    extends DefaultComboBoxModel<Currency> {
        private static final long serialVersionUID = 1L;
        private boolean noneIncluded = false;

        private CurrencyModel() {
        }

        public void setNoneIncluded(boolean included) {
            this.noneIncluded = included;
        }

        public boolean isNoneIncluded() {
            return this.noneIncluded;
        }

        @Override
        public Currency getElementAt(int index) {
            if (index == 0 && this.isNoneIncluded()) {
                return null;
            }
            if (this.isNoneIncluded()) {
                --index;
            }
            return (Currency)CURRENCY_LIST.get(index);
        }

        @Override
        public int getIndexOf(Object anObject) {
            if (anObject == null && this.isNoneIncluded()) {
                return 0;
            }
            if (anObject == null) {
                return -1;
            }
            return CURRENCY_LIST.indexOf(anObject);
        }

        @Override
        public int getSize() {
            int delta = this.isNoneIncluded() ? 1 : 0;
            return CURRENCY_LIST.size() + delta;
        }

        @Override
        public void addElement(Currency anObject) {
        }

        @Override
        public void insertElementAt(Currency anObject, int index) {
        }

        @Override
        public void removeAllElements() {
        }

        @Override
        public void removeElement(Object anObject) {
        }

        @Override
        public void removeElementAt(int index) {
        }
    }

    private static class CurrencyRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;
        private final String noneItem;

        public CurrencyRenderer(String noneItem) {
            this.noneItem = noneItem;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel superComponent = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                superComponent.setText(((Currency)value).getCurrencyCode());
            } else if (this.noneItem != null) {
                superComponent.setText(this.noneItem);
            }
            return superComponent;
        }
    }
}

