/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui.util;

import br.com.gertec.tc.server.gui.util.GuiDialog;
import br.com.gertec.tc.server.gui.util.GuiUtils;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.ConnectionListener;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.org.reconcavo.j18n.J18N;

public class GuiTcDialog
extends GuiDialog {
    private static final long serialVersionUID = 1L;

    protected GuiTcDialog(AbstractTcConnection connection, boolean allowNull) {
        super(connection);
        if (connection == null && !allowNull) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        this.registerListener(new ConnectionListener(){

            @Override
            public void onClose(AbstractTcConnection connection) {
                if (connection == GuiTcDialog.this.getConnection()) {
                    if (connection.getTerminalType() == TerminalType.TC_504) {
                        GuiUtils.showWarningMessage(GuiTcDialog.this, J18N.tr("Media sent! The terminal will restart", new Object[0]));
                        Log.warningTag("APP", J18N.tr("Terminal was disconnected", new Object[0]), new Object[0]);
                        GuiTcDialog.this.dispose();
                    } else {
                        Log.warningTag("APP", J18N.tr("Terminal was disconnected", new Object[0]), new Object[0]);
                    }
                }
            }
        });
    }

    public GuiTcDialog(AbstractTcConnection connection) {
        this(connection, false);
    }

    public final AbstractTcConnection getConnection() {
        return (AbstractTcConnection)this.getManagedObject();
    }

    public GuiTcDialog(boolean close) {
        if (close) {
            this.dispose();
        }
    }
}

