/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui.util;

import br.com.gertec.tc.server.gui.util.TextField;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class IntTextField
extends TextField {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_MAX_LENGTH = -1;
    private final int maxLength;

    private void registerChangeListener() {
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                IntTextField.this.onChange();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                IntTextField.this.onChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                IntTextField.this.onChange();
            }
        });
    }

    public IntTextField() {
        this(-1);
    }

    public IntTextField(int maxLength) {
        this.maxLength = maxLength;
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                IntTextField.this.onKey(evt);
            }
        });
        this.registerChangeListener();
    }

    private void onKey(KeyEvent evt) {
        String chars = "0987654321";
        if (!chars.contains(evt.getKeyChar() + "")) {
            evt.consume();
        }
        if (this.getText().length() >= this.getMaxLength() && this.getMaxLength() != -1) {
            evt.consume();
            this.setText(this.getText().substring(0, this.getMaxLength()));
        }
    }

    public final int getMaxLength() {
        return this.maxLength;
    }

    @Override
    protected void onChange() {
    }
}

