/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui.util;

import br.com.gertec.tc.server.log.Log;
import java.awt.Color;
import java.awt.Font;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class LogView
extends JTextPane
implements Log.LogStream {
    private static final long serialVersionUID = 1L;
    private static final DateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final Color BG_COLOR = Color.WHITE;
    public static final Color FG_COLOR = Color.BLACK;
    public static final Color FG_DEBUG = Color.GRAY;
    public static final Color FG_INFO = new Color(26, 167, 26, 255);
    public static final Color FG_WARNING = new Color(160, 160, 25, 255);
    public static final Color FG_ERROR = Color.RED;
    private final StyledDocument doc = this.getStyledDocument();
    private final Style normalStyle;
    private final Map<Log.LogLevel, Style> styleMap = new LinkedHashMap<Log.LogLevel, Style>();

    private static void setStyle(MutableAttributeSet attrs, Font font, Color fg) {
        StyleConstants.setFontFamily(attrs, font.getFamily());
        StyleConstants.setFontSize(attrs, font.getSize());
        StyleConstants.setItalic(attrs, (font.getStyle() & 2) != 0);
        StyleConstants.setBold(attrs, (font.getStyle() & 1) != 0);
        StyleConstants.setForeground(attrs, fg);
    }

    public LogView() {
        this.setBackground(BG_COLOR);
        this.normalStyle = this.addStyle("NORMAL", null);
        LogView.setStyle(this.getInputAttributes(), new Font("Monospaced", 0, 13), FG_COLOR);
        Style style = this.addStyle("DEBUG", this.normalStyle);
        StyleConstants.setForeground(style, FG_DEBUG);
        this.styleMap.put(Log.LogLevel.DEBUG, style);
        style = this.addStyle("INFO", this.normalStyle);
        StyleConstants.setForeground(style, FG_INFO);
        this.styleMap.put(Log.LogLevel.INFO, style);
        style = this.addStyle("WARNING", this.normalStyle);
        StyleConstants.setForeground(style, FG_WARNING);
        this.styleMap.put(Log.LogLevel.WARNING, style);
        style = this.addStyle("ERROR", this.normalStyle);
        StyleConstants.setForeground(style, FG_ERROR);
        this.styleMap.put(Log.LogLevel.ERROR, style);
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void open() {
    }

    @Override
    public void add(String tag, Log.LogLevel level, Date timestamp, String msg) {
        String timestampStr = DEFAULT_DATE_FORMAT.format(timestamp);
        try {
            this.doc.insertString(this.doc.getLength(), String.format("%s [", timestampStr), this.normalStyle);
            this.doc.insertString(this.doc.getLength(), level.getLabel(), this.styleMap.get((Object)level));
            this.doc.insertString(this.doc.getLength(), String.format("]%s %s\n", tag == null ? "" : String.format("[%s]", tag), msg), this.normalStyle);
            this.setCaretPosition(this.doc.getLength());
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() {
    }
}

