/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui.util;

import br.com.gertec.tc.server.gui.util.NamedColorChooserPanel;
import br.com.gertec.tc.server.util.NamedColor;
import br.org.reconcavo.j18n.J18N;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NamedColorChooser
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 3936224868708615731L;
    private static JDialog colorDiag;
    private static NamedColor selectedColor;
    private static JButton okButton;
    private static JButton cancelButton;
    protected JColorChooser tcc;
    protected JLabel banner = new JLabel(J18N.tr("Preview", new Object[0]), 0);
    private boolean isBack;

    public NamedColorChooser() {
        super(new BorderLayout());
        this.banner.setForeground(new Color(selectedColor.getRgb()));
        this.banner.setOpaque(true);
        this.banner.setFont(new Font("SansSerif", 1, 24));
        this.banner.setPreferredSize(new Dimension(100, 65));
        JPanel bannerPanel = new JPanel(new BorderLayout());
        bannerPanel.add((Component)this.banner, "Center");
        bannerPanel.setBorder(BorderFactory.createTitledBorder(J18N.tr("Preview", new Object[0])));
        bannerPanel.setPreferredSize(new Dimension(100, 65));
        ActionListener closeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NamedColorChooser.this.apply();
            }
        };
        ActionListener cancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NamedColorChooser.this.dispose();
            }
        };
        colorDiag = new JDialog();
        okButton = new JButton(J18N.tr("Ok", new Object[0]));
        okButton.addActionListener(closeListener);
        cancelButton = new JButton(J18N.tr("Cancel", new Object[0]));
        cancelButton.addActionListener(cancelListener);
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder());
        buttonsPanel.add(okButton);
        buttonsPanel.add(cancelButton);
        this.tcc = new JColorChooser(new Color(selectedColor.getRgb()));
        this.tcc.getSelectionModel().addChangeListener(this);
        this.tcc.setBorder(BorderFactory.createTitledBorder(J18N.tr("Choose a Color", new Object[0])));
        this.tcc.setPreviewPanel(new JPanel());
        AbstractColorChooserPanel[] panels = new AbstractColorChooserPanel[]{new NamedColorChooserPanel()};
        this.tcc.setChooserPanels(panels);
        this.tcc.setColor(this.banner.getForeground());
        this.add((Component)this.tcc, "First");
        this.add((Component)bannerPanel, "Center");
        this.add((Component)buttonsPanel, "Last");
    }

    public NamedColorChooser(NamedColor defaultColor, boolean isBack) {
        this();
        NamedColorChooser.setSelectedColor(defaultColor);
        this.isBack = isBack;
        this.tcc.setColor(new Color(defaultColor.getRgb()));
        if (isBack) {
            this.banner.setText("");
        }
    }

    public NamedColorChooser(NamedColor defaultColor, boolean isBack, NamedColor colorBack) {
        this();
        selectedColor = defaultColor;
        this.isBack = isBack;
        this.tcc.setColor(new Color(defaultColor.getRgb()));
        this.banner.setForeground(new Color(colorBack.getRgb()));
    }

    private static void setSelectedColor(NamedColor selectedColor) {
        NamedColorChooser.selectedColor = selectedColor;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Color newColor = this.tcc.getColor();
        if (this.isBack) {
            this.banner.setBackground(newColor);
        } else {
            this.banner.setForeground(newColor);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Color newColor = JColorChooser.showDialog(this, J18N.tr("Choose Background Color", new Object[0]), this.banner.getBackground());
        if (newColor != null) {
            this.banner.setBackground(newColor);
        }
    }

    public static NamedColor showDialog(NamedColor defaultColor, boolean isBack) {
        JDialog diag = new JDialog(colorDiag, J18N.tr("Choose a Color", new Object[0]), true);
        diag.setDefaultCloseOperation(2);
        diag.setLocationRelativeTo(null);
        NamedColorChooser.setSelectedColor(defaultColor);
        NamedColorChooser newContentPane = new NamedColorChooser(defaultColor, isBack);
        newContentPane.setOpaque(true);
        diag.setResizable(false);
        diag.setContentPane(newContentPane);
        diag.setPreferredSize(new Dimension(400, 350));
        diag.setSize(new Dimension(400, 350));
        diag.setVisible(true);
        diag.pack();
        return selectedColor;
    }

    public static NamedColor showDialog(NamedColor defaultColor, boolean isBack, NamedColor colorBack) {
        JDialog diag = new JDialog(colorDiag, J18N.tr("Choose a Color", new Object[0]), true);
        diag.setDefaultCloseOperation(2);
        diag.setLocationRelativeTo(null);
        NamedColorChooser.setSelectedColor(defaultColor);
        NamedColorChooser newContentPane = new NamedColorChooser(defaultColor, isBack, colorBack);
        newContentPane.setOpaque(true);
        diag.setResizable(false);
        diag.setContentPane(newContentPane);
        diag.setPreferredSize(new Dimension(400, 350));
        diag.setSize(new Dimension(400, 350));
        diag.setVisible(true);
        diag.pack();
        return selectedColor;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NamedColorChooser.showDialog(NamedColor.BLUE, true, NamedColor.RED);
            }
        });
    }

    private void dispose() {
        Container component = this.getParent().getParent().getParent();
        if (component instanceof JDialog) {
            ((JDialog)component).dispose();
        }
    }

    private void apply() {
        Container component = this.getParent().getParent().getParent();
        if (component instanceof JDialog) {
            JDialog dialog = (JDialog)component;
            int rgb = 0;
            for (Component c : dialog.getContentPane().getComponents()) {
                if (!(c instanceof JColorChooser)) continue;
                System.out.println(((JColorChooser)c).getColor().getRGB());
                rgb = ((JColorChooser)c).getColor().getRGB();
            }
            selectedColor = NamedColor.fromRGB(rgb);
            System.out.println(selectedColor.toString());
        }
        this.dispose();
    }

    static {
        selectedColor = NamedColor.GREY;
    }
}

