/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.gui.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class TextField
extends JTextField {
    private static final long serialVersionUID = -457023184886873290L;
    private final Border defaultBorder;
    private final Border invalidBorder = new LineBorder(Color.RED);
    private String placeholder;
    private boolean valid = true;

    private void changeListener() {
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextField.this.onChange();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextField.this.onChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TextField.this.onChange();
            }
        });
    }

    public TextField() {
        this.changeListener();
        this.defaultBorder = this.getBorder();
    }

    public TextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.changeListener();
        this.defaultBorder = this.getBorder();
    }

    public TextField(int columns) {
        super(columns);
        this.changeListener();
        this.defaultBorder = this.getBorder();
    }

    public TextField(String text, int columns) {
        super(text, columns);
        this.changeListener();
        this.defaultBorder = this.getBorder();
    }

    public TextField(String text) {
        super(text);
        this.changeListener();
        this.defaultBorder = this.getBorder();
    }

    protected void onChange() {
    }

    protected Border getInvalidBorder() {
        return this.invalidBorder;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
        this.setBorder(valid ? this.defaultBorder : this.getInvalidBorder());
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String s) {
        this.placeholder = s;
    }

    @Override
    protected void paintComponent(Graphics pG) {
        super.paintComponent(pG);
        if (this.placeholder == null || this.placeholder.length() == 0 || this.getText().length() > 0) {
            return;
        }
        Graphics2D g = (Graphics2D)pG;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.getDisabledTextColor());
        g.drawString(this.placeholder, this.getInsets().left, (this.getHeight() + pG.getFontMetrics().getMaxAscent()) / 2 - this.getInsets().top);
    }
}

