/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.http;

import br.com.gertec.tc.server.Application;
import br.com.gertec.tc.server.dao.Product;
import br.com.gertec.tc.server.http.TcHttpServer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BarcodeServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String PATH_NOT_FOUND = "/notfound.jsp";
    private static final String PATH_HANDLER = "/product.jsp";
    private static final String PARAM_BARCODE = "param";
    private static final String ATTR_BARCODE = "barcode";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_PRICE1 = "price1";
    private static final String ATTR_PRICE2 = "price2";
    private static final String ATTR_LABEL1 = "label1";
    private static final String ATTR_LABEL2 = "label2";

    private static InetAddress getClientIp(HttpServletRequest request) {
        String remoteAddr = "";
        if (request != null && ((remoteAddr = request.getHeader("X-FORWARDED-FOR")) == null || remoteAddr.isEmpty())) {
            remoteAddr = request.getRemoteAddr();
        }
        try {
            return InetAddress.getByName(remoteAddr);
        }
        catch (UnknownHostException ignored) {
            return null;
        }
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String paramBarcode = req.getParameter(PARAM_BARCODE);
        req.setAttribute(ATTR_BARCODE, paramBarcode);
        if (paramBarcode == null || paramBarcode.trim().isEmpty()) {
            req.getRequestDispatcher(PATH_NOT_FOUND).forward(req, resp);
            return;
        }
        Product product = Product.get(paramBarcode);
        TcHttpServer server = (TcHttpServer)req.getServletContext().getAttribute(TcHttpServer.ATTR_SERVER);
        server.notifyListenersAboutBarcodeQuery(BarcodeServlet.getClientIp(req), paramBarcode, product);
        System.out.println(BarcodeServlet.getClientIp(req));
        if (product == null) {
            req.getRequestDispatcher(PATH_NOT_FOUND).forward(req, resp);
            return;
        }
        if (product.getDescription() == null) {
            product.setDescription("Problema de descri\u00e7\u00e3o.");
        }
        if (product.getPrice1() == null) {
            product.setPrice1("R$");
        }
        req.setAttribute(ATTR_BARCODE, product.getBarcode());
        req.setAttribute(ATTR_DESCRIPTION, product.getDescription());
        req.setAttribute(ATTR_PRICE1, product.getPrice1());
        req.setAttribute(ATTR_PRICE2, product.getPrice2());
        req.setAttribute(ATTR_LABEL1, Application.SETTINGS.getProperty("LABEL1"));
        req.setAttribute(ATTR_LABEL2, Application.SETTINGS.getProperty("LABEL2"));
        req.getRequestDispatcher(PATH_HANDLER).forward(req, resp);
    }
}

