/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.log;

import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.util.jdbc.JdbcConnection;
import br.com.gertec.tc.server.util.jdbc.JdbcResultSet;
import br.com.gertec.tc.server.util.jdbc.JdbcStatment;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class DbLogStream
implements Log.LogStream {
    private static final String TABLE_NAME = "DB_LOG";
    private static final String COL_ID = "DB_ID";
    private static final String COL_TAG = "DB_TAG";
    private static final String COL_LOG_LEVEL = "DB_LOG_LEVEL";
    private static final String COL_TIMESTAMP = "DB_TIMESTAMP";
    private static final String COL_MESSAGE = "DB_MESSAGE";
    private final File dbLogFile;
    private JdbcConnection connection;
    private volatile boolean locked = false;
    private final List<Runnable> writeQueue = new LinkedList<Runnable>();

    private static JdbcConnection getConnectionForEmbeddedDb(File dbFile) {
        try {
            String uri = String.format("jdbc:h2:%s", dbFile.getCanonicalPath());
            return JdbcConnection.getConnection(uri, "", "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DbLogStream(File dbLogFile) {
        if (dbLogFile == null) {
            throw new IllegalArgumentException("dbLogFile cannot be null");
        }
        this.dbLogFile = dbLogFile;
    }

    public final File getDbLogFile() {
        return this.dbLogFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        if (this.locked) {
            return true;
        }
        DbLogStream dbLogStream = this;
        synchronized (dbLogStream) {
            return this.connection != null && this.connection.isOpen();
        }
    }

    private void createLogTableIfNotExist() {
        if (!this.connection.getTableNames().contains(TABLE_NAME)) {
            StringBuilder sqlFormat = new StringBuilder().append("CREATE TABLE %s ").append("(").append("%s INT PRIMARY KEY AUTO_INCREMENT, ").append("%s VARCHAR(100), ").append("%s VARCHAR(100), ").append("%s TIMESTAMP, ").append("%s VARCHAR(4096) ").append(")");
            String sql = String.format(sqlFormat.toString(), TABLE_NAME, COL_ID, COL_TAG, COL_LOG_LEVEL, COL_TIMESTAMP, COL_MESSAGE);
            JdbcStatment stmt = this.connection.prepareStatement(sql);
            stmt.execute();
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        DbLogStream dbLogStream = this;
        synchronized (dbLogStream) {
            if (!this.isOpen()) {
                this.connection = DbLogStream.getConnectionForEmbeddedDb(this.getDbLogFile());
                this.createLogTableIfNotExist();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(final String tag, final Log.LogLevel level, final Date timestamp, final String msg) {
        Runnable writeRunnable = new Runnable(){

            @Override
            public void run() {
                DbLogStream.this.open();
                String sql = String.format("INSERT INTO %s (%s, %s, %s, %s) VALUES (?, ?, ?, ?)", DbLogStream.TABLE_NAME, DbLogStream.COL_TAG, DbLogStream.COL_LOG_LEVEL, DbLogStream.COL_TIMESTAMP, DbLogStream.COL_MESSAGE);
                JdbcStatment stmt = DbLogStream.this.connection.prepareStatement(sql);
                stmt.set(1, tag);
                stmt.set(2, level.getLabel());
                stmt.set(3, new Timestamp(timestamp.getTime()));
                stmt.set(4, msg);
                stmt.execute();
                stmt.close();
            }
        };
        if (this.locked) {
            this.writeQueue.add(writeRunnable);
        } else {
            DbLogStream dbLogStream = this;
            synchronized (dbLogStream) {
                for (Runnable queueItem : this.writeQueue) {
                    queueItem.run();
                }
                this.writeQueue.clear();
                writeRunnable.run();
            }
        }
    }

    private String buildWhereClause(String ... filters) {
        StringBuilder clause = new StringBuilder();
        boolean foundNonEmptyFilter = false;
        for (String filter : filters) {
            if (filter.trim().isEmpty()) continue;
            if (foundNonEmptyFilter) {
                clause.append(" AND ");
            }
            clause.append(String.format("(%s)", filter.trim()));
            foundNonEmptyFilter = true;
        }
        if (!foundNonEmptyFilter) {
            return "1 = 1";
        }
        return clause.toString();
    }

    public List<String> getTags() {
        this.open();
        String sql = String.format("SELECT DISTINCT %s FROM %s", COL_TAG, TABLE_NAME);
        JdbcStatment stmt = this.connection.prepareStatement(sql);
        JdbcResultSet rs = stmt.executeQuery();
        LinkedList<String> tags = new LinkedList<String>();
        while (rs.next()) {
            String tag = rs.getString(1);
            if (tag == null) continue;
            tags.add(rs.getString(1));
        }
        rs.close();
        stmt.close();
        return tags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogEntry> getEntries(String tag, Date minDate, Date maxDate, Log.LogLevel[] shownLevels, Log.LogLevel[] hiddenLevels) {
        DbLogStream dbLogStream = this;
        synchronized (dbLogStream) {
            String hiddenLevelFilter;
            String shownLevelFilter;
            this.locked = true;
            this.open();
            LinkedList<LogEntry> entries = new LinkedList<LogEntry>();
            String periodFiter = minDate == null && maxDate == null ? "" : (minDate == null && maxDate != null ? String.format("DATE(%s) <= DATE(TIMESTAMP(%s))", COL_TIMESTAMP, maxDate.getTime()) : (minDate != null && maxDate == null ? String.format("DATE(%s) >= DATE(TIMESTAMP(%s))", COL_TIMESTAMP, minDate.getTime()) : String.format("DATE(%s) >= DATE(TIMESTAMP(%s) AND DATE(%s) <= DATE(TIMESTAMP(%s))", COL_TIMESTAMP, minDate.getTime(), COL_TIMESTAMP, maxDate.getTime())));
            if (shownLevels.length == 0) {
                shownLevelFilter = "";
            } else {
                StringBuilder filter = new StringBuilder();
                int i = 0;
                for (Log.LogLevel level : shownLevels) {
                    if (i > 0) {
                        filter.append(" OR ");
                    }
                    filter.append(String.format("%s = '%s'", COL_LOG_LEVEL, level.getLabel()));
                    ++i;
                }
                shownLevelFilter = filter.toString();
            }
            if (hiddenLevels.length == 0) {
                hiddenLevelFilter = "";
            } else {
                StringBuilder filter = new StringBuilder();
                int i = 0;
                for (Log.LogLevel level : hiddenLevels) {
                    if (i > 0) {
                        filter.append(" AND ");
                    }
                    filter.append(String.format("%s != '%s'", COL_LOG_LEVEL, level.getLabel()));
                    ++i;
                }
                hiddenLevelFilter = filter.toString();
            }
            String tagFilter = tag == null ? "" : String.format("%s LIKE '%s'", COL_TAG, tag);
            String sql = String.format("SELECT * FROM %s WHERE %s", TABLE_NAME, this.buildWhereClause(periodFiter, shownLevelFilter, hiddenLevelFilter, tagFilter));
            JdbcStatment stmt = this.connection.prepareStatement(sql);
            JdbcResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                entries.add(new LogEntry(rs));
            }
            rs.close();
            stmt.close();
            this.locked = false;
            return entries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogEntry> getEntries(String timeStampDate) {
        LinkedList<LogEntry> entries = new LinkedList<LogEntry>();
        DbLogStream dbLogStream = this;
        synchronized (dbLogStream) {
            this.open();
            String tagFilter = String.format("%s LIKE '%s'", COL_TIMESTAMP, timeStampDate + "%");
            String sql = String.format("SELECT * FROM %s WHERE %s ", TABLE_NAME, tagFilter);
            JdbcStatment stmt = this.connection.prepareStatement(sql);
            JdbcResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                entries.add(new LogEntry(rs));
            }
            rs.close();
            stmt.close();
            this.locked = false;
            return entries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEntriesOlderThan(Date minDate) {
        DbLogStream dbLogStream = this;
        synchronized (dbLogStream) {
            this.open();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String periodFiter = minDate == null ? "1 = 1" : String.format("%s < TIMESTAMP '%s'", COL_TIMESTAMP, sdf.format(minDate));
            String sql = String.format("DELETE FROM %s WHERE %s", TABLE_NAME, periodFiter);
            JdbcStatment stmt = this.connection.prepareStatement(sql);
            stmt.execute();
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        DbLogStream dbLogStream = this;
        synchronized (dbLogStream) {
            if (this.isOpen()) {
                this.connection.close();
            }
        }
    }

    public static class LogEntry
    extends Log.LogEntry {
        public final long id;

        private static final String getTag(JdbcResultSet rs) {
            return rs.getString(DbLogStream.COL_TAG);
        }

        private static final Log.LogLevel getLogLevel(JdbcResultSet rs) {
            return Log.LogLevel.fromLabel(rs.getString(DbLogStream.COL_LOG_LEVEL));
        }

        private static final Date getTimestamp(JdbcResultSet rs) {
            return rs.getTimestamp(DbLogStream.COL_TIMESTAMP);
        }

        private static final String getMessage(JdbcResultSet rs) {
            return rs.getString(DbLogStream.COL_MESSAGE);
        }

        private LogEntry(JdbcResultSet rs) {
            super(LogEntry.getTag(rs), LogEntry.getLogLevel(rs), LogEntry.getTimestamp(rs), LogEntry.getMessage(rs));
            this.id = rs.getLong(DbLogStream.COL_ID);
        }
    }
}

