/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.log;

import br.com.gertec.tc.server.log.DbLogStream;
import br.com.gertec.tc.server.log.Log;
import br.org.reconcavo.j18n.J18N;
import java.sql.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.DefaultTableModel;

public class DbLogStreamTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    public static final int COL_TAG = 0;
    public static final int COL_TIMESTAMP = 1;
    public static final int COL_LEVEL = 2;
    public static final int COL_MESSAGE = 3;
    private final DbLogStream dblogStream;
    private final List<Log.LogLevel> shownLevels = new LinkedList<Log.LogLevel>();
    private final List<Log.LogLevel> hiddenLevels = new LinkedList<Log.LogLevel>();
    private List<? extends Log.LogEntry> logEntries;
    private String tag;

    public DbLogStreamTableModel(DbLogStream dblogStream) {
        if (dblogStream == null) {
            throw new IllegalArgumentException("dblogStream cannot be null");
        }
        this.dblogStream = dblogStream;
    }

    public final DbLogStream getDbLogStream() {
        return this.dblogStream;
    }

    public final void reload() {
        this.reload(true);
    }

    public void reload(boolean fireRefreshEvent) {
        Log.LogLevel[] shownLevels = new Log.LogLevel[this.shownLevels.size()];
        shownLevels = this.shownLevels.toArray(shownLevels);
        Log.LogLevel[] hiddenLevels = new Log.LogLevel[this.hiddenLevels.size()];
        hiddenLevels = this.hiddenLevels.toArray(hiddenLevels);
        this.logEntries = this.getDbLogStream().getEntries(this.getTag(), null, null, shownLevels, hiddenLevels);
        if (fireRefreshEvent) {
            this.fireTableStructureChanged();
        }
    }

    public List<Log.LogLevel> getLogLevels() {
        return this.shownLevels;
    }

    public void setShownLevels(Log.LogLevel ... levels) {
        this.shownLevels.clear();
        for (Log.LogLevel logLevel : levels) {
            this.shownLevels.add(logLevel);
        }
    }

    public void setHiddenLevels(Log.LogLevel ... levels) {
        this.hiddenLevels.clear();
        for (Log.LogLevel logLevel : levels) {
            this.hiddenLevels.add(logLevel);
        }
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public List<? extends Log.LogEntry> getLogEntries() {
        return this.logEntries;
    }

    @Override
    public int getRowCount() {
        return this.logEntries == null ? 0 : this.logEntries.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return J18N.tr("Tag", new Object[0]);
            }
            case 1: {
                return J18N.tr("Timestamp", new Object[0]);
            }
            case 2: {
                return J18N.tr("Level", new Object[0]);
            }
            case 3: {
                return J18N.tr("Message", new Object[0]);
            }
        }
        throw new IndexOutOfBoundsException("No such column: " + column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Log.LogEntry logEntry;
        Log.LogEntry logEntry2 = logEntry = this.logEntries == null ? null : this.logEntries.get(row);
        if (logEntry == null) {
            return null;
        }
        switch (column) {
            case 0: {
                return new LogTag(logEntry.tag);
            }
            case 1: {
                return logEntry.timestamp;
            }
            case 2: {
                return logEntry.level;
            }
            case 3: {
                return logEntry.msg;
            }
        }
        throw new IndexOutOfBoundsException("No such column: " + column);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return LogTag.class;
            }
            case 3: {
                return String.class;
            }
            case 2: {
                return Log.LogLevel.class;
            }
            case 1: {
                return Date.class;
            }
        }
        throw new IndexOutOfBoundsException("No column: " + columnIndex);
    }

    public static class LogTag {
        private final String tag;

        public LogTag(String tag) {
            this.tag = tag;
        }

        public String toString() {
            return this.tag;
        }
    }
}

