/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.log;

import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.util.HtmlUtilities;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.List;

public class HtmlLogExporter {
    private static final String HTML_START = "<html><body><table>";
    private static final String HTML_END = "</table></body></html>";
    private static final SimpleDateFormat SDF = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");
    private static HtmlLogExporter singleton;

    public static HtmlLogExporter getInstance() {
        if (singleton == null) {
            singleton = new HtmlLogExporter();
        }
        return singleton;
    }

    private HtmlLogExporter() {
    }

    public void export(List<? extends Log.LogEntry> entries, File destination) throws IOException {
        if (destination.exists() && destination.isDirectory()) {
            throw new IllegalArgumentException("Destination is a directory");
        }
        if (!(destination.exists() || destination.getParentFile().exists() || destination.getParentFile().mkdirs())) {
            throw new IOException("Cannot create parent dir: " + destination.getParentFile().getCanonicalPath());
        }
        try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(new File(destination.getAbsolutePath() + ".html"))));){
            out.println(HTML_START);
            out.println(HtmlUtilities.getTableHeaderHtml("Timestamp", "Level", "Message"));
            for (Log.LogEntry logEntry : entries) {
                out.println(HtmlUtilities.getTableRowHtml(SDF.format(logEntry.timestamp), logEntry.level.getLabel(), logEntry.msg));
            }
            out.println(HTML_END);
        }
    }
}

