/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class Log {
    private static final SimpleDateFormat SDF = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");
    private static final String LBL_DEBUG = "DEBUG";
    private static final String LBL_INFO = "INFO";
    private static final String LBL_WARNING = "WARNING";
    private static final String LBL_ERROR = "ERROR";
    private static String defaultTag = null;
    private static volatile boolean debugEnabled = false;
    private static final List<LogStream> STREAMS = new LinkedList<LogStream>();
    private static final List<LogEntry> ENTRY_QUEUE = new LinkedList<LogEntry>();
    private static volatile boolean enqueue = false;

    private Log() {
    }

    public static synchronized String getDefaultTag() {
        return defaultTag;
    }

    public static synchronized void setDefaultTag(String tag) {
        defaultTag = tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableQueue(boolean enable) {
        List<LogStream> list = STREAMS;
        synchronized (list) {
            enqueue = enable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushQueue(LogStream stream) {
        List<LogStream> list = STREAMS;
        synchronized (list) {
            while (!ENTRY_QUEUE.isEmpty()) {
                LogEntry entry = ENTRY_QUEUE.remove(0);
                if (!stream.isOpen()) {
                    stream.open();
                }
                stream.add(entry.tag, entry.level, entry.timestamp, entry.msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerStream(LogStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("Null stream");
        }
        List<LogStream> list = STREAMS;
        synchronized (list) {
            if (!STREAMS.contains(stream)) {
                STREAMS.add(stream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterStream(LogStream stream) {
        List<LogStream> list = STREAMS;
        synchronized (list) {
            STREAMS.remove(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void open() {
        List<LogStream> list = STREAMS;
        synchronized (list) {
            for (LogStream stream : STREAMS) {
                if (stream.isOpen()) continue;
                stream.open();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        List<LogStream> list = STREAMS;
        synchronized (list) {
            for (LogStream stream : STREAMS) {
                if (!stream.isOpen()) continue;
                stream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDebugEnabled() {
        List<LogStream> list = STREAMS;
        synchronized (list) {
            return debugEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDebugEnabled(boolean enabled) {
        List<LogStream> list = STREAMS;
        synchronized (list) {
            debugEnabled = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(String tag, LogLevel level, Date timestamp, String msg, Object ... msgArgs) {
        String finalMsg;
        if (level == LogLevel.DEBUG && !Log.isDebugEnabled()) {
            return;
        }
        String string = finalMsg = msgArgs.length == 0 ? msg : String.format(msg, msgArgs);
        if (enqueue) {
            ENTRY_QUEUE.add(new LogEntry(tag, level, timestamp, finalMsg));
        }
        List<LogStream> list = STREAMS;
        synchronized (list) {
            for (LogStream stream : STREAMS) {
                if (!stream.isOpen()) {
                    stream.open();
                }
                stream.add(tag, level, timestamp, finalMsg);
            }
        }
    }

    public static void add(LogLevel level, Date timestamp, String msg, Object ... msgArgs) {
        Log.add(Log.getDefaultTag(), level, timestamp, msg, msgArgs);
    }

    public static void add(LogLevel level, String msg, Object ... msgArgs) {
        Log.add(level, new Date(), msg, msgArgs);
    }

    public static void debug(String tag, Date timestamp, String msg, Object ... msgArgs) {
        Log.add(tag, LogLevel.DEBUG, timestamp, msg, msgArgs);
    }

    public static void debug(Date timestamp, String msg, Object ... msgArgs) {
        Log.debug(Log.getDefaultTag(), timestamp, msg, msgArgs);
    }

    public static void debug(String msg, Object ... msgArgs) {
        Log.debug(new Date(), msg, msgArgs);
    }

    public static void debugTag(String tag, String msg, Object ... msgArgs) {
        Log.debug(tag, new Date(), msg, msgArgs);
    }

    public static void info(String tag, Date timestamp, String msg, Object ... msgArgs) {
        Log.add(tag, LogLevel.INFO, timestamp, msg, msgArgs);
    }

    public static void info(Date timestamp, String msg, Object ... msgArgs) {
        Log.info(Log.getDefaultTag(), timestamp, msg, msgArgs);
    }

    public static void info(String msg, Object ... msgArgs) {
        Log.info(new Date(), msg, msgArgs);
    }

    public static void infoTag(String tag, String msg, Object ... msgArgs) {
        Log.info(tag, new Date(), msg, msgArgs);
    }

    public static void warning(String tag, Date timestamp, String msg, Object ... msgArgs) {
        Log.add(tag, LogLevel.WARNING, timestamp, msg, msgArgs);
    }

    public static void warning(Date timestamp, String msg, Object ... msgArgs) {
        Log.warning(Log.getDefaultTag(), timestamp, msg, msgArgs);
    }

    public static void warning(String msg, Object ... msgArgs) {
        Log.warning(new Date(), msg, msgArgs);
    }

    public static void warningTag(String tag, String msg, Object ... msgArgs) {
        Log.warning(tag, new Date(), msg, msgArgs);
    }

    public static void error(String tag, Date timestamp, String msg, Object ... msgArgs) {
        Log.add(tag, LogLevel.ERROR, timestamp, msg, msgArgs);
    }

    public static void error(Date timestamp, String msg, Object ... msgArgs) {
        Log.error(Log.getDefaultTag(), timestamp, msg, msgArgs);
    }

    public static void error(String msg, Object ... msgArgs) {
        Log.error(new Date(), msg, msgArgs);
    }

    public static void errorTag(String tag, String msg, Object ... msgArgs) {
        Log.error(tag, new Date(), msg, msgArgs);
    }

    public static interface LogStream {
        public boolean isOpen();

        public void open();

        public void add(String var1, LogLevel var2, Date var3, String var4);

        public void close();
    }

    public static enum LogLevel {
        DEBUG("DEBUG"),
        INFO("INFO"),
        WARNING("WARNING"),
        ERROR("ERROR");

        private final String label;

        public static LogLevel fromLabel(String label) {
            switch (label) {
                case "DEBUG": {
                    return DEBUG;
                }
                case "INFO": {
                    return INFO;
                }
                case "WARNING": {
                    return WARNING;
                }
                case "ERROR": {
                    return ERROR;
                }
            }
            return null;
        }

        private LogLevel(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static class LogEntry {
        public final String tag;
        public final LogLevel level;
        public final Date timestamp;
        public final String msg;

        protected LogEntry(String tag, LogLevel level, Date timestamp, String msg) {
            this.tag = tag;
            this.level = level;
            this.timestamp = timestamp;
            this.msg = msg;
        }

        public String toString() {
            return String.format("%s [%s][%s] %s", SDF.format(this.timestamp), this.level.getLabel(), this.tag, this.msg);
        }
    }
}

