/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol;

import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.org.reconcavo.j18n.J18N;
import java.net.InetAddress;

public class GenericTc {
    private String macAddress = "00:00:00:00:00";
    private String macWifi = "00:00:00:00:00";
    private String firmwareVersion = "";
    private String tcName = "";
    private String gateway = "";
    private String netmask = "";
    private String dns = "";
    private InetAddress inetAddress;
    private TerminalType type;
    private boolean usesDhcp;
    private Object protocolId;
    private String terminalVersion;
    private boolean audioStatus = false;
    private boolean audioStatusDefault = true;
    private boolean isTcWithAudio = true;
    private boolean isTcWithMedia = false;
    private AbstractTcConnection connection;

    public GenericTc() {
    }

    public GenericTc(String macAddress, InetAddress ipAddress, TerminalType type, String tcName) {
        this.macAddress = macAddress;
        this.inetAddress = ipAddress;
        this.type = type;
        this.tcName = tcName;
    }

    public GenericTc(TerminalType type, InetAddress ipAddress) {
        this.inetAddress = ipAddress;
        this.type = type;
    }

    public AbstractTcConnection getConnection() {
        return this.connection;
    }

    void setConnection(AbstractTcConnection connection) {
        if (this.connection != null) {
            throw new IllegalStateException("Connection already set");
        }
        this.connection = connection;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public String getMacWifi() {
        return this.macWifi;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public InetAddress getIpAddress() {
        return this.inetAddress;
    }

    public TerminalType getType() {
        return this.type;
    }

    public String getTcName() {
        return this.tcName;
    }

    public Object getProtocolId() {
        return this.protocolId;
    }

    public void setProtocolId(Object protocolId) {
        this.protocolId = protocolId;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public void setMacWifi(String macAddress) {
        this.macWifi = macAddress;
    }

    public void setInetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
    }

    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public void setType(TerminalType type) {
        this.type = type;
    }

    public void setTcName(String tcName) {
        this.tcName = tcName;
    }

    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public boolean usesDhcp() {
        return this.usesDhcp;
    }

    public void usesDhcp(boolean usesDhcp) {
        this.usesDhcp = usesDhcp;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public void setNetmask(String netmask) {
        this.netmask = netmask;
    }

    public String getDns() {
        return this.dns;
    }

    public void setDns(String dns) {
        this.dns = dns;
    }

    public String getTerminalVersion() {
        return this.terminalVersion;
    }

    public void setTerminalVersion(String terminalVersion) {
        this.terminalVersion = terminalVersion;
    }

    public void setAudioStatus(boolean audioStatus) {
        this.audioStatusDefault = false;
        this.audioStatus = audioStatus;
    }

    public boolean getAudioStatus() {
        return this.audioStatus;
    }

    public String getLogAudioStatus() {
        return this.getStrAudioStatus();
    }

    public boolean isTcWithAudio() {
        return this.isTcWithAudio;
    }

    public void isTcWithAudio(boolean isTcWithAudio) {
        this.isTcWithAudio = isTcWithAudio;
    }

    public boolean isTcWithMedia() {
        return this.isTcWithMedia;
    }

    public void isTcWithMedia(boolean isTcWithMedia) {
        this.isTcWithMedia = isTcWithMedia;
    }

    public boolean isUsesDhcp() {
        return this.usesDhcp;
    }

    public void setUsesDhcp(boolean usesDhcp) {
        this.usesDhcp = usesDhcp;
    }

    public String toString() {
        return this.getIpAddress() == null ? "" : this.getIpAddress().toString();
    }

    public boolean isSc504() {
        return this.getType().getSc504Id() != null;
    }

    public boolean isSc501() {
        return this.getType().getSc501Id() != null;
    }

    private String getStrAudioStatus() {
        if (this.audioStatus) {
            return J18N.tr("Enabled", new Object[0]);
        }
        if (!this.audioStatusDefault) {
            return J18N.tr("Disabled", new Object[0]);
        }
        return J18N.tr("Not Supported", new Object[0]);
    }
}

