/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol;

import br.com.gertec.tc.server.http.TcHttpServer;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.GenericTc;
import br.com.gertec.tc.server.protocol.sc501.Sc501Connection;
import br.com.gertec.tc.server.protocol.sc501.Sc501Server;
import br.com.gertec.tc.server.protocol.sc504.Sc504Connection;
import br.com.gertec.tc.server.protocol.sc504.Sc504Server;
import br.org.reconcavo.event.EventLoop;
import br.org.reconcavo.event.comm.socket.SocketConnection;
import br.org.reconcavo.event.comm.socket.TcpServerListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ServerManager {
    private static final int DEFAULT_SC501_PORT = 6500;
    private static final int DEFAULT_TC504_PORT = 16510;
    private static final int DEFAULT_HTTP_PORT = 8080;
    private final List<GenericTc> clients = new LinkedList<GenericTc>();
    private final List<GenericTc> readOnlyClients = Collections.unmodifiableList(this.clients);
    private final EventLoop eventLoop;
    private final Sc501Server server501;
    private final Sc504Server server504;
    private final TcHttpServer httpServer;

    public ServerManager(EventLoop eventLoop) {
        if (eventLoop == null) {
            throw new IllegalArgumentException("Event-loop cannot be null");
        }
        this.eventLoop = eventLoop;
        this.server501 = new Sc501Server(eventLoop){

            @Override
            protected void onClientDrop(SocketConnection client) {
                super.onClientDrop(client);
                ServerManager.this.clients.remove(((AbstractTcConnection)client).getTerminal());
            }

            @Override
            protected void onHandshakeComplete(Sc501Connection connection) {
                super.onHandshakeComplete(connection);
                ServerManager.this.clients.add(connection.getTerminal());
            }
        };
        this.server504 = new Sc504Server(eventLoop){

            @Override
            protected void onClientDrop(SocketConnection client) {
                super.onClientDrop(client);
                ServerManager.this.clients.remove(((AbstractTcConnection)client).getTerminal());
            }

            @Override
            protected void onHandshakeComplete(Sc504Connection connection) {
                super.onHandshakeComplete(connection);
                ServerManager.this.clients.add(connection.getTerminal());
            }
        };
        this.httpServer = new TcHttpServer(eventLoop);
    }

    public final EventLoop getEventLoop() {
        return this.eventLoop;
    }

    public List<GenericTc> getClients() {
        return this.readOnlyClients;
    }

    public void register501Listener(TcpServerListener listener) {
        this.server501.addListener(listener);
    }

    public boolean isS501Running() {
        return this.server501.isRunning();
    }

    public void startSc501Server(int port) {
        final int fPort = port;
        this.eventLoop.invokeLater(new Runnable(){

            @Override
            public void run() {
                ServerManager.this.server501.start(fPort);
            }
        });
    }

    public final void startSc501Server() {
        this.startSc501Server(6500);
    }

    public void stopSc501Server() {
        this.eventLoop.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ServerManager.this.server501.isRunning()) {
                    ServerManager.this.server501.stop();
                }
            }
        });
    }

    public Sc501Server getSc501Server() {
        return this.server501;
    }

    public void register504Listener(TcpServerListener listener) {
        this.server504.addListener(listener);
    }

    public boolean isS504Running() {
        return this.server504.isRunning();
    }

    public void startSc504Server(int port) {
        final int fPort = port;
        this.eventLoop.invokeLater(new Runnable(){

            @Override
            public void run() {
                ServerManager.this.server504.start(fPort);
            }
        });
    }

    public final void startTc504Server() {
        this.startSc504Server(16510);
    }

    public void stopSc504Server() {
        this.eventLoop.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ServerManager.this.server504.isRunning()) {
                    ServerManager.this.server504.stop();
                }
            }
        });
    }

    public Sc504Server getSc504Server() {
        return this.server504;
    }

    public void registerHttpServerListener(TcHttpServer.HttpServerListener listener) {
        this.httpServer.addListener(listener);
    }

    public boolean isHttpServerRunning() {
        return this.httpServer.isRunning();
    }

    public void startHttpServer(int port) {
        final int fPort = port;
        this.eventLoop.invokeLater(new Runnable(){

            @Override
            public void run() {
                ServerManager.this.httpServer.start(fPort);
            }
        });
    }

    public final void startHttpServer() {
        this.startHttpServer(8080);
    }

    public void stopHttpServer() {
        this.eventLoop.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ServerManager.this.httpServer.isRunning()) {
                    ServerManager.this.httpServer.stop();
                }
            }
        });
    }

    public TcHttpServer getHttpServer() {
        return this.httpServer;
    }
}

