/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol;

import br.com.gertec.tc.server.protocol.ProtocolType;
import br.com.gertec.tc.server.query.BPG2EQueryExecutor;
import br.com.gertec.tc.server.query.BPG2QueryExecutor;
import br.com.gertec.tc.server.query.GerBotQueryExecutor;
import br.com.gertec.tc.server.query.GerBotTwoQueryExecutor;
import br.com.gertec.tc.server.query.QueryExecutor;
import br.com.gertec.tc.server.query.Sc501QueryExecutor;
import br.com.gertec.tc.server.query.Sc504QueryExecutor;
import br.com.gertec.tc.server.query.TC506EQueryExecutor;
import br.com.gertec.tc.server.query.TC506MQueryExecutor;
import br.com.gertec.tc.server.query.TC506QueryExecutor;
import br.com.gertec.tc.server.query.TC506SQueryExecutor;

public enum TerminalType {
    TC_406(null, "#tc406", "Busca pre\u00e7o G2", 320, 240, ProtocolType.SC501, new BPG2QueryExecutor()),
    TC_502(null, "#tc502", "Busca pre\u00e7o", null, null, ProtocolType.SC501, new Sc501QueryExecutor()),
    TC_505(null, "#tc505", "TC-505", 128, 64, ProtocolType.SC501, new Sc501QueryExecutor()),
    TC_507(null, "#tc507", "TC-506", 128, 64, ProtocolType.SC501, new TC506QueryExecutor()),
    TC_506_S(null, "#tc506s", "TC-506 S", 320, 240, ProtocolType.SC501, new TC506SQueryExecutor()),
    TC_506_E(null, "#tc506e", "TC-506 E", 320, 240, ProtocolType.SC501, new TC506EQueryExecutor()),
    TC_406_E(null, "#bpg2e", "Busca pre\u00e7o G2 E", 320, 240, ProtocolType.SC501, new BPG2EQueryExecutor()),
    TC_504((short)504, null, "TC-504", 320, 240, ProtocolType.SC504, new Sc504QueryExecutor()),
    TC_506_MIDIA((short)506, null, "TC-506 M\u00eddia", 480, 272, ProtocolType.SC504, new TC506MQueryExecutor()),
    TC_508((short)508, null, "TC-508", 480, 272, ProtocolType.SC504, new Sc504QueryExecutor()),
    GB_600((short)600, null, "G-BOT", 1280, 800, ProtocolType.SC504, new GerBotQueryExecutor()),
    GB_601((short)601, null, "G-BOT - 2", 1280, 800, ProtocolType.SC504, new GerBotTwoQueryExecutor());

    private final Short sc504Id;
    private final String sc501Id;
    private final String marketName;
    private final Integer displayWidth;
    private final Integer displayHeight;
    private final ProtocolType protocolType;
    private final QueryExecutor queryExecutor;

    public static TerminalType fomSc504Id(short sc504Id) {
        switch (sc504Id) {
            case 504: {
                return TC_504;
            }
            case 506: {
                return TC_506_MIDIA;
            }
            case 508: {
                return TC_508;
            }
            case 600: {
                return GB_600;
            }
            case 601: {
                return GB_601;
            }
        }
        return null;
    }

    public static TerminalType fromSc501Id(String commandId) {
        switch (commandId) {
            case "#tc406": {
                return TC_406;
            }
            case "#tc502": 
            case "#tc300": {
                return TC_502;
            }
            case "#tc505": {
                return TC_505;
            }
            case "#tc507": {
                return TC_507;
            }
            case "#tc506s": {
                return TC_506_S;
            }
            case "#tc506e": {
                return TC_506_E;
            }
            case "#bpg2e": {
                return TC_406_E;
            }
        }
        return null;
    }

    public static TerminalType fromDbValue(String dbValue) {
        if (dbValue == null) {
            return null;
        }
        try {
            return TerminalType.valueOf(dbValue);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private TerminalType(Short sc504Id, String sc501Id, String marketName, Integer displayWidth, Integer displayHeight, ProtocolType protocolType, QueryExecutor queryExecutor) {
        this.sc504Id = sc504Id;
        this.sc501Id = sc501Id;
        this.marketName = marketName;
        this.displayWidth = displayWidth;
        this.displayHeight = displayHeight;
        this.protocolType = protocolType;
        this.queryExecutor = queryExecutor;
    }

    public String getSc501Id() {
        return this.sc501Id;
    }

    public Short getSc504Id() {
        return this.sc504Id;
    }

    public String getMarketName() {
        return this.marketName;
    }

    public String getDbValue() {
        return this.name();
    }

    public Integer getDisplayWidth() {
        return this.displayWidth;
    }

    public Integer getDisplayHeight() {
        return this.displayHeight;
    }

    public ProtocolType getProtocolType() {
        return this.protocolType;
    }

    public QueryExecutor getQueryExecutor() {
        return this.queryExecutor;
    }
}

