/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501;

import br.com.gertec.tc.server.protocol.sc501.Sc501CommDefs;
import br.org.reconcavo.event.comm.DataBuffer;
import java.io.UnsupportedEncodingException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class CommUtils {
    private static final byte GERTEC_MAGIC_NUMBER = 48;

    private CommUtils() {
    }

    public static byte getProtocolStrSize(String strValue) {
        int stringSize = strValue.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length;
        int val = stringSize + 48;
        if (val > 127) {
            throw new IndexOutOfBoundsException(String.format("String size not supported: %d (maximum accepted: %d)", stringSize, 79));
        }
        return (byte)val;
    }

    public static byte getProtocolByte(byte b) {
        int val = b + 48;
        if (val > 127) {
            throw new IndexOutOfBoundsException(String.format("Byte value not supported: %d (maximum accepted: %d)", b, 79));
        }
        return (byte)val;
    }

    public static byte getRealByte(byte protocolByte) {
        int val = protocolByte - 48;
        if (val < -128) {
            throw new IllegalArgumentException(String.format("Invalid protocol byte: %d (minimum value: %d)", -80));
        }
        return (byte)val;
    }

    public static void putProtocolStringIntoBuffer(DataBuffer dataBuffer, String strValue) {
        strValue = CommUtils.stripZeroChar(strValue);
        try {
            dataBuffer.put(CommUtils.getProtocolStrSize(strValue)).putString(strValue, Sc501CommDefs.DEFAULT_CHARSET.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String stripZeroChar(String fromString) {
        return fromString.split(String.valueOf('\u0000'))[0];
    }

    public static String getProtocolString(ByteBuffer buffer) throws BufferUnderflowException {
        int stringSize = CommUtils.getUnsignedByte(CommUtils.getRealByte(buffer.get()));
        String str = CommUtils.getString(buffer, stringSize);
        return str;
    }

    public static int getUnsignedByte(byte b) {
        return b & 0xFF;
    }

    public static String getString(ByteBuffer buffer, int length) throws BufferUnderflowException {
        int available = buffer.remaining();
        if (available < length) {
            throw new BufferUnderflowException();
        }
        String str = new String(buffer.array(), buffer.position(), length, Sc501CommDefs.DEFAULT_CHARSET);
        buffer.position(buffer.position() + length);
        return str;
    }
}

