/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501;

import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.sc501.Sc501CommDefs;
import br.com.gertec.tc.server.protocol.sc501.commands.AbstractSc501Command;
import br.com.gertec.tc.server.protocol.sc501.commands.AlwaysLiveOk;
import br.com.gertec.tc.server.protocol.sc501.commands.AudioConfig;
import br.com.gertec.tc.server.protocol.sc501.commands.Barcode;
import br.com.gertec.tc.server.protocol.sc501.commands.CheckLiveOk;
import br.com.gertec.tc.server.protocol.sc501.commands.Config02;
import br.com.gertec.tc.server.protocol.sc501.commands.ExtConfig;
import br.com.gertec.tc.server.protocol.sc501.commands.FinishUpdateFirmware;
import br.com.gertec.tc.server.protocol.sc501.commands.FinishUpdateFirmwareError;
import br.com.gertec.tc.server.protocol.sc501.commands.FinishUpdateFirmwareOk;
import br.com.gertec.tc.server.protocol.sc501.commands.FullMacAddr;
import br.com.gertec.tc.server.protocol.sc501.commands.GetListMedias;
import br.com.gertec.tc.server.protocol.sc501.commands.GetListMediasError;
import br.com.gertec.tc.server.protocol.sc501.commands.GetMediasConf;
import br.com.gertec.tc.server.protocol.sc501.commands.GifError;
import br.com.gertec.tc.server.protocol.sc501.commands.GifOk;
import br.com.gertec.tc.server.protocol.sc501.commands.GoSleepOk;
import br.com.gertec.tc.server.protocol.sc501.commands.ImageError;
import br.com.gertec.tc.server.protocol.sc501.commands.ImageOk;
import br.com.gertec.tc.server.protocol.sc501.commands.IncompleteCommandException;
import br.com.gertec.tc.server.protocol.sc501.commands.InvalidCommandBufferData;
import br.com.gertec.tc.server.protocol.sc501.commands.Live;
import br.com.gertec.tc.server.protocol.sc501.commands.LiveN;
import br.com.gertec.tc.server.protocol.sc501.commands.MediaError;
import br.com.gertec.tc.server.protocol.sc501.commands.MediaOk;
import br.com.gertec.tc.server.protocol.sc501.commands.ParamConfig;
import br.com.gertec.tc.server.protocol.sc501.commands.PegaMacAddr;
import br.com.gertec.tc.server.protocol.sc501.commands.PlayAudioWithMsgError;
import br.com.gertec.tc.server.protocol.sc501.commands.PlayAudioWithMsgOk;
import br.com.gertec.tc.server.protocol.sc501.commands.QueryProcessFailure;
import br.com.gertec.tc.server.protocol.sc501.commands.RAudioConfigError;
import br.com.gertec.tc.server.protocol.sc501.commands.RAudioConfigOk;
import br.com.gertec.tc.server.protocol.sc501.commands.REConf02Error;
import br.com.gertec.tc.server.protocol.sc501.commands.RExtConfError;
import br.com.gertec.tc.server.protocol.sc501.commands.RExtConfOk;
import br.com.gertec.tc.server.protocol.sc501.commands.RParamConfigError;
import br.com.gertec.tc.server.protocol.sc501.commands.RParamConfigOk;
import br.com.gertec.tc.server.protocol.sc501.commands.RUpdConfigError;
import br.com.gertec.tc.server.protocol.sc501.commands.RUpdConfigOk;
import br.com.gertec.tc.server.protocol.sc501.commands.RWlanConfigOk;
import br.com.gertec.tc.server.protocol.sc501.commands.RemoveAllMedias;
import br.com.gertec.tc.server.protocol.sc501.commands.RemoveAllMediasError;
import br.com.gertec.tc.server.protocol.sc501.commands.RemoveAllMediasOk;
import br.com.gertec.tc.server.protocol.sc501.commands.RemoveMediaError;
import br.com.gertec.tc.server.protocol.sc501.commands.RemoveMediaOk;
import br.com.gertec.tc.server.protocol.sc501.commands.RestartSoftError;
import br.com.gertec.tc.server.protocol.sc501.commands.RestartSoftOk;
import br.com.gertec.tc.server.protocol.sc501.commands.SaveMediasConfOk;
import br.com.gertec.tc.server.protocol.sc501.commands.Tc300;
import br.com.gertec.tc.server.protocol.sc501.commands.Tc406;
import br.com.gertec.tc.server.protocol.sc501.commands.Tc406E;
import br.com.gertec.tc.server.protocol.sc501.commands.Tc502;
import br.com.gertec.tc.server.protocol.sc501.commands.Tc505;
import br.com.gertec.tc.server.protocol.sc501.commands.Tc506E;
import br.com.gertec.tc.server.protocol.sc501.commands.Tc506S;
import br.com.gertec.tc.server.protocol.sc501.commands.Tc507;
import br.com.gertec.tc.server.protocol.sc501.commands.UpdConfig;
import br.com.gertec.tc.server.protocol.sc501.commands.UpdateFirmware;
import br.com.gertec.tc.server.protocol.sc501.commands.UpdateFirmwareOk;
import br.com.gertec.tc.server.protocol.sc501.commands.WlanConfig;
import br.org.reconcavo.event.comm.AbstractHeapCommand;
import br.org.reconcavo.event.comm.CommandBuilder;
import br.org.reconcavo.event.comm.DataBuffer;
import br.org.reconcavo.j18n.J18N;

public class Sc501CommandBuilder
implements CommandBuilder {
    private String currentId = null;
    private AbstractSc501Command currentCommand = null;
    private boolean possibleCommand = false;

    private String getCommandId(DataBuffer buffer, String[] supportedCommandSet) {
        this.possibleCommand = false;
        String str = new String(buffer.copy(), Sc501CommDefs.DEFAULT_CHARSET);
        if (str.contains("#playaudiowithmessage_ok".replace("#", ""))) {
            buffer.clear();
            buffer.putString("#playaudiowithmessage_ok");
            str = "#playaudiowithmessage_ok";
        }
        if (str.contains("#playaudiowithmessage_error".replace("#", ""))) {
            buffer.clear();
            buffer.putString("#playaudiowithmessage_error");
            str = "#playaudiowithmessage_error";
        }
        if (str.contains("#getlistmedias_error\u0000") && this.match(str, "#getlistmedias_error\u0000")) {
            buffer.clear();
            buffer.putString("#medias_error\u0000");
            str = "#medias_error\u0000";
        }
        for (String supportedCmdId : supportedCommandSet) {
            if (supportedCmdId.startsWith(str)) {
                this.possibleCommand = true;
            }
            if (!str.startsWith(supportedCmdId)) continue;
            buffer.readBytes(supportedCmdId.getBytes(Sc501CommDefs.DEFAULT_CHARSET).length);
            return supportedCmdId;
        }
        return null;
    }

    private boolean match(String source, String item) {
        return source.equals(item);
    }

    private Barcode getBarcodeCommand(DataBuffer buffer) throws InvalidCommandBufferData {
        String barcode = new String(buffer.copy(), Sc501CommDefs.DEFAULT_CHARSET);
        if (barcode.isEmpty()) {
            return null;
        }
        int lengthWithoutLast = barcode.length() - 1;
        if (barcode.charAt(lengthWithoutLast) == '\u0000') {
            return new Barcode(buffer.readString(lengthWithoutLast + 1));
        }
        return null;
    }

    @Override
    public boolean canBuild(DataBuffer dataBuffer) {
        if (this.currentId == null) {
            this.currentId = this.getCommandId(dataBuffer, Sc501CommDefs.TERMINAL_COMMANDS);
        }
        if (this.currentId == null) {
            if (!this.possibleCommand) {
                try {
                    this.currentCommand = this.getBarcodeCommand(dataBuffer);
                    if (this.currentCommand == null) {
                        throw new InvalidCommandBufferData();
                    }
                    return true;
                }
                catch (InvalidCommandBufferData ex) {
                    String removedTrash = new String(dataBuffer.readBytes());
                    Log.debug("WARNING: CORRUPTED BUFFER INFORMATION REMOVED: %s", removedTrash);
                    return false;
                }
            }
            return false;
        }
        try {
            this.currentCommand = this.getCommand(this.currentId, dataBuffer);
            return true;
        }
        catch (IncompleteCommandException ex) {
            return false;
        }
    }

    protected AbstractSc501Command getCommand(String commandId, DataBuffer buffer) throws IncompleteCommandException {
        Log.debug(J18N.tr("Current input buffer state", new Object[0]) + "= [%s]", new String(buffer.copy(), Sc501CommDefs.DEFAULT_CHARSET));
        switch (commandId) {
            case "#tc406": {
                return new Tc406(buffer);
            }
            case "#tc300": {
                return new Tc300(buffer);
            }
            case "#tc502": {
                return new Tc502(buffer);
            }
            case "#tc505": {
                return new Tc505(buffer);
            }
            case "#tc507": {
                return new Tc507(buffer);
            }
            case "#tc506s": {
                return new Tc506S(buffer);
            }
            case "#tc506e": {
                return new Tc506E(buffer);
            }
            case "#bpg2e": {
                return new Tc406E(buffer);
            }
            case "#live\u0000": {
                return new LiveN();
            }
            case "#live": {
                return new Live();
            }
            case "#updconfig": {
                return new UpdConfig(buffer);
            }
            case "#macaddr": {
                return new PegaMacAddr(buffer);
            }
            case "#getlistmedias": {
                return new GetListMedias(buffer);
            }
            case "#medias_error\u0000": {
                return new GetListMediasError();
            }
            case "#getmediasconf": {
                return new GetMediasConf(buffer);
            }
            case "#rextconf_ok\u0000": {
                return new RExtConfOk();
            }
            case "#rextconf_error\u0000": {
                return new RExtConfError();
            }
            case "#rwlanconfig_ok\u0000": {
                return new RWlanConfigOk();
            }
            case "#config02": {
                return new Config02(buffer);
            }
            case "#extconfig": {
                return new ExtConfig(buffer);
            }
            case "#paramconfig": {
                return new ParamConfig(buffer);
            }
            case "#alwayslive_ok\u0000": {
                return new AlwaysLiveOk();
            }
            case "#checklive_ok\u0000": {
                return new CheckLiveOk();
            }
            case "#restartsoft_ok\u0000": {
                return new RestartSoftOk();
            }
            case "#restartsoft_error\u0000": {
                return new RestartSoftError();
            }
            case "#removemedia_ok": {
                return new RemoveMediaOk(buffer);
            }
            case "#rupdconfigok\u0000": {
                return new RUpdConfigOk(buffer);
            }
            case "#rupdconfig_error\u0000": {
                return new RUpdConfigError();
            }
            case "#rparamconfig_ok\u0000": {
                return new RParamConfigOk(buffer);
            }
            case "#rparamconfig_error\u0000": {
                return new RParamConfigError();
            }
            case "#savemediasconf_ok\u0000": {
                return new SaveMediasConfOk(buffer);
            }
            case "#sendmedia_ok\u0000": {
                return new MediaOk();
            }
            case "#sendmedia_error": {
                return new MediaError(buffer);
            }
            case "#sleep_ok": {
                return new GoSleepOk();
            }
            case "#img_ok": {
                return new ImageOk(buffer);
            }
            case "#img_error": {
                return new ImageError();
            }
            case "#wlanconfig": {
                return new WlanConfig(buffer);
            }
            case "#gif_ok": {
                return new GifOk(buffer);
            }
            case "#gif_error": {
                return new GifError(buffer);
            }
            case "#playaudiowithmessage_ok": {
                return new PlayAudioWithMsgOk();
            }
            case "#playaudiowithmessage_error": {
                return new PlayAudioWithMsgError();
            }
            case "#fullmacaddr": {
                return new FullMacAddr(buffer);
            }
            case "#audioconfig": {
                return new AudioConfig(buffer);
            }
            case "#raudioconfig_ok\u0000": {
                return new RAudioConfigOk();
            }
            case "#raudioconfig_error": {
                return new RAudioConfigError();
            }
            case "#removemedia_error": {
                return new RemoveMediaError();
            }
            case "#queryprocessfailure": {
                return new QueryProcessFailure();
            }
            case "#updatefirmware": {
                return new UpdateFirmware();
            }
            case "#finishupdatefirmware": {
                return new FinishUpdateFirmware();
            }
            case "#finishupdatefirmware_ok": {
                return new FinishUpdateFirmwareOk();
            }
            case "#finishupdatefirmware_error": {
                return new FinishUpdateFirmwareError();
            }
            case "#updatefirmware_ok\u0000": {
                return new UpdateFirmwareOk();
            }
            case "#removeallmedias_ok\u0000": {
                return new RemoveAllMediasOk();
            }
            case "#removeallmedias_error\u0000": {
                return new RemoveAllMediasError();
            }
            case "#removeallmedias": {
                return new RemoveAllMedias();
            }
            case "#reconf02_error\u0000": {
                return new REConf02Error();
            }
        }
        throw new UnsupportedOperationException("Unsupported command id: " + commandId);
    }

    @Override
    public AbstractHeapCommand getCommand(DataBuffer dataBuffer) {
        return this.currentCommand;
    }

    @Override
    public void reset() {
        this.currentId = null;
        this.currentCommand = null;
    }
}

