/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501;

import br.com.gertec.tc.server.gui.util.GuiPanel;
import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.CommandListener;
import br.com.gertec.tc.server.protocol.sc501.CommUtils;
import br.com.gertec.tc.server.protocol.sc501.Sc501CommandBuilder;
import br.com.gertec.tc.server.protocol.sc501.Sc501TC;
import br.com.gertec.tc.server.protocol.sc501.commands.ImageData;
import br.com.gertec.tc.server.protocol.sc501.commands.ImageHeader;
import br.com.gertec.tc.server.protocol.sc501.commands.LiveQ;
import br.com.gertec.tc.server.protocol.sc501.commands.Ok;
import br.com.gertec.tc.server.protocol.sc501.commands.PedeMacAddr;
import br.com.gertec.tc.server.protocol.sc501.commands.RestartSoft;
import br.com.gertec.tc.server.protocol.sc501.commands.SendGIF;
import br.com.gertec.tc.server.util.ImageFrame;
import br.com.gertec.tc.server.util.ImageUtils;
import br.org.reconcavo.event.EventLoop;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.event.comm.CommandBuilder;
import br.org.reconcavo.j18n.J18N;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class Sc501Connection
extends AbstractTcConnection {
    private final CommandBuilder commandBuilder = new Sc501CommandBuilder();

    public Sc501Connection(EventLoop eventLoop) {
        super(eventLoop);
        this.setTerminal(new Sc501TC());
        this.registerListener();
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        this.writeCommand(new Ok());
    }

    @Override
    protected CommandBuilder getCommandBuilder() {
        return this.commandBuilder;
    }

    public void pedeMacAddr() {
        this.writeCommand(new PedeMacAddr(CommUtils.getProtocolByte((byte)9)));
    }

    @Override
    protected void checkLive() {
        this.writeCommand(new LiveQ());
    }

    @Override
    public void sendRestartTerminal() {
        RestartSoft restart = new RestartSoft();
        this.writeCommand(restart);
    }

    public void sendImageFromFile(File file, int width, int height, int index, int loop, int duration, boolean resize) throws IOException {
        if (index == 255) {
            this.sendImageHead(index, 0, 0, 0, 0, 0);
            return;
        }
        if (width > 128 && resize) {
            throw new RuntimeException("WIDTH must be less than 128");
        }
        if (height > 64 && resize) {
            throw new RuntimeException("HEIGHT must be less than 64");
        }
        int imagebytes = (int)file.length();
        int threshold = 127;
        ArrayList<ImageFrame> frames = ImageUtils.getInstance().getFrames(file);
        int frameCount = frames.size();
        if (frameCount > 0) {
            int defaultWidth = 128;
            int defaultHeight = 64;
            for (int i = 0; i < frameCount; ++i) {
                ImageUtils.getInstance().toBinary(frames, threshold);
                if (resize) {
                    ImageUtils.getInstance().resize(frames, width, height);
                    continue;
                }
                ImageUtils.getInstance().crop(frames, 0, 0, 128, 64);
            }
            this.sendImageHead(index, loop, duration, frameCount, imagebytes, 0);
            for (ImageFrame frame : frames) {
                this.sendImageData(frame);
            }
        }
    }

    public void sendGifFromFile(File file, short index, short mode, short loop, short pause) throws IOException {
        int imageLength = (int)file.length();
        if (imageLength > 196608) {
            throw new RuntimeException("Image length must be less than 196608");
        }
        ArrayList<ImageFrame> frames = ImageUtils.getInstance().getFrames(file);
        ImageUtils.getInstance().toBinary(frames, 0);
        SendGIF gifHeader = new SendGIF();
        gifHeader.setHeader(mode, loop, pause, imageLength);
        Log.debug(gifHeader.toString(), new Object[0]);
        this.writeCommand(gifHeader);
        for (ImageFrame frame : frames) {
            this.sendImageData(frame);
        }
    }

    private void sendImageHead(int index, int loop, int delay, int frames, int imgbytes, int crc) {
        ImageHeader header = new ImageHeader();
        header.setHeader(index, loop, delay, frames, imgbytes, 48);
        this.writeCommand(header);
    }

    private void sendImageData(ImageFrame frame) {
        ImageData data = new ImageData();
        data.setFrame(frame);
        this.writeCommand(data);
    }

    private void registerListener() {
        GuiPanel guiPanel = new GuiPanel();
        guiPanel.registerSc501CommandListener("#restartsoft_error\u0000", new CommandListener(){

            @Override
            public void onCommandRead(AbstractTcConnection connection, Command command) {
                Log.error(J18N.tr("Terminal restart error", new Object[0]), new Object[0]);
            }
        });
    }
}

