/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501;

import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.AbstractTcConnection;
import br.com.gertec.tc.server.protocol.CommandListener;
import br.com.gertec.tc.server.protocol.GenericTc;
import br.com.gertec.tc.server.protocol.ListenerGroup;
import br.com.gertec.tc.server.protocol.TerminalType;
import br.com.gertec.tc.server.protocol.sc501.Sc501Connection;
import br.com.gertec.tc.server.protocol.sc501.Sc501TC;
import br.com.gertec.tc.server.protocol.sc501.commands.AbstractSc501Command;
import br.com.gertec.tc.server.protocol.sc501.commands.AudioConfig;
import br.com.gertec.tc.server.protocol.sc501.commands.AudioConfigQ;
import br.com.gertec.tc.server.protocol.sc501.commands.Config02;
import br.com.gertec.tc.server.protocol.sc501.commands.ExtConfig;
import br.com.gertec.tc.server.protocol.sc501.commands.FullMacAddr;
import br.com.gertec.tc.server.protocol.sc501.commands.FullMacAddrQ;
import br.com.gertec.tc.server.protocol.sc501.commands.PegaMacAddr;
import br.com.gertec.tc.server.protocol.sc501.commands.UpdConfig;
import br.com.gertec.tc.server.protocol.sc501.commands.UpdConfigQ;
import br.com.gertec.tc.server.protocol.sc501.listener.Sc501ServerListener;
import br.com.gertec.tc.server.util.version.DeviceVersion;
import br.com.gertec.tc.server.util.version.VersionsWithAudio;
import br.org.reconcavo.event.Event;
import br.org.reconcavo.event.EventLoop;
import br.org.reconcavo.event.Listener;
import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.event.comm.socket.SocketConnection;
import br.org.reconcavo.event.comm.socket.TcpServer;
import br.org.reconcavo.j18n.J18N;

public class Sc501Server
extends TcpServer {
    public static final Event EVT_COMMAND_READ = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            if (listener instanceof Sc501ServerListener && args[2] instanceof AbstractSc501Command) {
                ((Sc501ServerListener)listener).onCommandRead((Sc501Server)args[0], (Sc501Connection)args[1], (AbstractSc501Command)args[2]);
            }
        }

        @Override
        public void onEvent(Object ... args) {
            if (args[2] instanceof AbstractSc501Command) {
                ((Sc501Server)args[0]).onCommandRead((Sc501Connection)args[1], (AbstractSc501Command)args[2]);
            }
        }
    };
    public static final Event EVT_COMMAND_WRITE = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            if (listener instanceof Sc501ServerListener && args[2] instanceof AbstractSc501Command) {
                ((Sc501ServerListener)listener).onCommandWrite((Sc501Server)args[0], (Sc501Connection)args[1], (AbstractSc501Command)args[2]);
            }
        }

        @Override
        public void onEvent(Object ... args) {
            if (args[2] instanceof AbstractSc501Command) {
                ((Sc501Server)args[0]).onCommandWrite((Sc501Connection)args[1], (AbstractSc501Command)args[2]);
            }
        }
    };
    public static final Event EVT_HANDSHAKE_COMPLETE = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            if (listener instanceof Sc501ServerListener) {
                ((Sc501ServerListener)listener).onHandshakeComplete((Sc501Server)args[0], (Sc501Connection)args[1]);
            }
        }

        @Override
        public void onEvent(Object ... args) {
            ((Sc501Server)args[0]).onHandshakeComplete((Sc501Connection)args[1]);
        }
    };

    public Sc501Server(EventLoop eventLoop) {
        super(eventLoop);
    }

    @Override
    protected SocketConnection getClientConnection(EventLoop serverEventLoop) {
        return new Sc501Connection(serverEventLoop){

            public void registerCascadeCommandListener() {
                Sc501Server.this.registerSc501CascadeCommandListener("#updconfig", new CommandListener(){

                    @Override
                    public void onCommandRead(AbstractTcConnection connection, Command command) {
                        Sc501Server.this.unregisterSc501CascadeCommandListener();
                        Sc501Server.this.registerSc501CascadeCommandListener("#audioconfig", new CommandListener(){

                            @Override
                            public void onCommandRead(AbstractTcConnection connection, Command command) {
                                Sc501Server.this.unregisterSc501CascadeCommandListener();
                                this.writeCommand(new FullMacAddrQ());
                            }
                        });
                        this.writeCommand(new AudioConfigQ());
                    }
                });
            }

            @Override
            protected void onCommandRead(Command command) {
                super.onCommandRead(command);
                AbstractSc501Command protocolCmd = (AbstractSc501Command)command;
                Sc501Server.this.notifyEvent(EVT_COMMAND_READ, Sc501Server.this, this, protocolCmd);
                Log.debug(J18N.tr("Received command %s from %s", command, this.getInetAddress().getHostAddress()), new Object[0]);
                GenericTc terminal = this.getTerminal();
                String idCommand = protocolCmd.getId();
                switch (idCommand) {
                    case "#tc506s": {
                        terminal.setType(TerminalType.TC_506_S);
                        terminal.setTerminalVersion(protocolCmd.getTerminalVersion());
                        terminal.setProtocolId(protocolCmd.getId());
                        terminal.setInetAddress(this.getInetAddress());
                        this.registerCascadeCommandListener();
                        this.writeCommand(new UpdConfigQ());
                        break;
                    }
                    case "#tc506e": {
                        terminal.setType(TerminalType.TC_506_E);
                        terminal.setTerminalVersion(protocolCmd.getTerminalVersion());
                        terminal.setProtocolId(protocolCmd.getId());
                        terminal.setInetAddress(this.getInetAddress());
                        terminal.isTcWithMedia(true);
                        this.registerCascadeCommandListener();
                        this.writeCommand(new UpdConfigQ());
                        break;
                    }
                    case "#bpg2e": {
                        terminal.setType(TerminalType.TC_406_E);
                        terminal.setTerminalVersion(protocolCmd.getTerminalVersion());
                        terminal.setProtocolId(protocolCmd.getId());
                        terminal.setInetAddress(this.getInetAddress());
                        terminal.isTcWithMedia(true);
                        this.registerCascadeCommandListener();
                        this.writeCommand(new UpdConfigQ());
                        break;
                    }
                    case "#tc406": {
                        terminal.setType(TerminalType.TC_406);
                        terminal.setTerminalVersion(protocolCmd.getTerminalVersion());
                        terminal.setProtocolId(protocolCmd.getId());
                        terminal.setInetAddress(this.getInetAddress());
                        if (DeviceVersion.isNewVersion(terminal.getType(), terminal.getTerminalVersion())) {
                            this.registerCascadeCommandListener();
                            this.writeCommand(new UpdConfigQ());
                            break;
                        }
                        this.writeCommand(new UpdConfigQ());
                        if (VersionsWithAudio.isTC406Audio(terminal.getTerminalVersion())) {
                            terminal.setAudioStatus(true);
                            this.pedeMacAddr();
                            break;
                        }
                        this.writeCommand(new UpdConfigQ());
                        terminal.isTcWithAudio(false);
                        this.pedeMacAddr();
                        break;
                    }
                    case "#tc300": 
                    case "#tc502": {
                        terminal.setType(TerminalType.TC_502);
                        terminal.setProtocolId(protocolCmd.getId());
                        terminal.setInetAddress(this.getInetAddress());
                        this.writeCommand(new UpdConfigQ());
                        this.pedeMacAddr();
                        break;
                    }
                    case "#tc505": {
                        terminal.setType(TerminalType.TC_505);
                        terminal.setInetAddress(this.getInetAddress());
                        this.writeCommand(new UpdConfigQ());
                        this.pedeMacAddr();
                        break;
                    }
                    case "#tc507": {
                        terminal.setType(TerminalType.TC_507);
                        terminal.setInetAddress(this.getInetAddress());
                        this.writeCommand(new UpdConfigQ());
                        this.pedeMacAddr();
                        break;
                    }
                    case "#updconfig": {
                        UpdConfig updConfig = (UpdConfig)command;
                        terminal.setTcName(updConfig.getTerminalName());
                        terminal.setGateway(updConfig.getGateway());
                        break;
                    }
                    case "#macaddr": {
                        PegaMacAddr macComm = (PegaMacAddr)command;
                        boolean usesWifi = macComm.getIface() == 1;
                        terminal.setMacAddress(macComm.getMacAddress());
                        terminal.setInetAddress(this.getInetAddress());
                        ((Sc501TC)terminal).setUsingWifi(usesWifi);
                        Sc501Server.this.notifyEvent(EVT_HANDSHAKE_COMPLETE, Sc501Server.this, this);
                        this.onHandshakeCompleted();
                        break;
                    }
                    case "#config02": {
                        Config02 configCommand = (Config02)command;
                        Object params = configCommand.getParams();
                        ((Sc501TC)terminal).setLine1(((Config02.ConfigParams)params).line1);
                        ((Sc501TC)terminal).setLine2(((Config02.ConfigParams)params).line2);
                        ((Sc501TC)terminal).setLine3(((Config02.ConfigParams)params).line3);
                        ((Sc501TC)terminal).setLine4(((Config02.ConfigParams)params).line4);
                        ((Sc501TC)terminal).setExhibTime((byte)((Config02.ConfigParams)params).exhibTime);
                        ((Sc501TC)terminal).setNetmask(((Config02.ConfigParams)params).netmask);
                        break;
                    }
                    case "#extconfig": {
                        ExtConfig extConfigCommand = (ExtConfig)command;
                        Object params = extConfigCommand.getParams();
                        ((Sc501TC)terminal).setLine1(((ExtConfig.ConfigParams)params).line1);
                        ((Sc501TC)terminal).setLine2(((ExtConfig.ConfigParams)params).line2);
                        ((Sc501TC)terminal).setTcName(((ExtConfig.ConfigParams)params).terminalName);
                        ((Sc501TC)terminal).setGateway(((ExtConfig.ConfigParams)params).gateway);
                        ((Sc501TC)terminal).usesDhcp(((ExtConfig.ConfigParams)params).dynamicIp);
                        ((Sc501TC)terminal).setExhibTime((byte)((ExtConfig.ConfigParams)params).exhibTime);
                        break;
                    }
                    case "#restartsoft_ok\u0000": {
                        Log.debug(J18N.tr("Closing connection (%s) due to restart", this.getInetAddress().getHostAddress()), new Object[0]);
                        this.close();
                        break;
                    }
                    case "#playaudiowithmessage_ok": {
                        Log.info(J18N.tr("Audio played successfully on %s%s", terminal.getTcName(), terminal.getIpAddress()), new Object[0]);
                        break;
                    }
                    case "#playaudiowithmessage_error": {
                        Log.warning(J18N.tr("Error playing audio on %s%s", terminal.getTcName(), terminal.getIpAddress()), new Object[0]);
                        break;
                    }
                    case "#reconf02_error\u0000": {
                        Log.error(J18N.tr("Terminal Configuration Error", new Object[0]), new Object[0]);
                        break;
                    }
                    case "#fullmacaddr": {
                        FullMacAddr fullMac = (FullMacAddr)command;
                        terminal.setMacAddress(fullMac.getMacEth());
                        terminal.setMacWifi(fullMac.getMacWifi());
                        Sc501Server.this.notifyEvent(EVT_HANDSHAKE_COMPLETE, Sc501Server.this, this);
                        this.onHandshakeCompleted();
                        break;
                    }
                    case "#audioconfig": {
                        AudioConfig audioConfig = (AudioConfig)command;
                        terminal.setAudioStatus(audioConfig.getAudioStatus());
                    }
                }
                for (CommandListener cmdListener : ListenerGroup.getInstance().getAllCommandListeners(protocolCmd)) {
                    cmdListener.onCommandRead(this, command);
                }
            }

            @Override
            protected void onCommandWrite(Command command) {
                super.onCommandWrite(command);
                Sc501Server.this.notifyEvent(EVT_COMMAND_WRITE, Sc501Server.this, this, command);
                String terminalTypeStr = this.getTerminalType() == null ? "" : String.format(" (%s)", this.getTerminalType().name());
                Log.debug(J18N.tr("Command sent %s to %s%s", command, this.getInetAddress().getHostAddress(), terminalTypeStr), new Object[0]);
            }
        };
    }

    @Override
    protected void onNewClient(SocketConnection client) {
        super.onNewClient(client);
        Log.debug(J18N.tr("New client: %s", client.getInetAddress()), new Object[0]);
    }

    @Override
    protected void onStart() {
        super.onStart();
        Log.debug(J18N.tr("SC501 server is running on port %s", this.getLocalPort()), new Object[0]);
    }

    @Override
    protected void onStop() {
        super.onStop();
        Log.debug(J18N.tr("SC501 server stopped", new Object[0]), new Object[0]);
    }

    protected void onCommandRead(Sc501Connection connection, AbstractSc501Command command) {
    }

    protected void onCommandWrite(Sc501Connection connection, AbstractSc501Command command) {
    }

    protected void onHandshakeComplete(Sc501Connection connection) {
    }

    public void registerSc501CascadeCommandListener(String cmdId, CommandListener listener) {
        ListenerGroup.getInstance().registerSc501CommandListener(this + "sc501CascadeCommands", cmdId, listener);
    }

    public void unregisterSc501CascadeCommandListener() {
        ListenerGroup.getInstance().unregisterListenerGroup(this + "sc501CascadeCommands");
    }
}

