/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501.commands;

import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.sc501.Sc501CommDefs;
import br.com.gertec.tc.server.protocol.sc501.commands.WlanConfig;
import br.org.reconcavo.event.comm.AbstractHeapCommand;
import br.org.reconcavo.event.comm.DataBuffer;
import br.org.reconcavo.j18n.J18N;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractSc501Command
extends AbstractHeapCommand {
    private static final long serialVersionUID = 1L;
    private final String id;
    private String terminalVersion;

    public AbstractSc501Command(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Null/Empty ID");
        }
        this.id = id;
    }

    public void setTerminalVersion(String terminalVersion) {
        this.terminalVersion = terminalVersion;
    }

    public final String getId() {
        return this.id;
    }

    public final String getTerminalVersion() {
        return this.terminalVersion;
    }

    @Override
    protected final byte[] getSerializedData() {
        DataBuffer buffer = new DataBuffer();
        buffer.put(this.getId().getBytes(Sc501CommDefs.DEFAULT_CHARSET));
        buffer.put(this.getSerializedPayload());
        this.printPrettyDebugData(buffer);
        this.printRawDebugData(buffer);
        return buffer.readBytes();
    }

    protected abstract byte[] getSerializedPayload();

    public String toString() {
        return this.getId();
    }

    protected void printPrettyDebugData(DataBuffer buffer) {
        try {
            DataBuffer copy = new DataBuffer();
            copy.put(buffer.copy());
            String text = new String(copy.readBytes(), "ISO-8859-1");
            char[] chars = text.toCharArray();
            Log.debug(this.getId() + J18N.tr(" serialized data is: \n %s", new String(chars)), new Object[0]);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(WlanConfig.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void printRawDebugData(DataBuffer buffer) {
        DataBuffer copy = new DataBuffer();
        copy.put(buffer.copy());
        Log.debug(this.getId() + J18N.tr(" raw data is: \n %s", Arrays.toString(copy.readBytes(copy.available()))), new Object[0]);
    }
}

