/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501.commands;

import br.com.gertec.tc.server.log.Log;
import br.com.gertec.tc.server.protocol.sc501.CommUtils;
import br.com.gertec.tc.server.protocol.sc501.commands.AbstractSc501Command;
import br.com.gertec.tc.server.protocol.sc501.commands.IncompleteCommandException;
import br.org.reconcavo.event.comm.DataBuffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class FullMacAddr
extends AbstractSc501Command {
    private String macEth;
    private byte macEthIsAble;
    private String macWifi;
    private byte macWifiIsAble;
    private static final long serialVersionUID = 1L;

    public FullMacAddr() throws IncompleteCommandException {
        super("#fullmacaddr");
    }

    public FullMacAddr(DataBuffer dataBuffer) throws IncompleteCommandException {
        super("#fullmacaddr");
        ByteBuffer bb = ByteBuffer.wrap(dataBuffer.copy());
        try {
            this.macEthIsAble = bb.get();
            byte stringSize = CommUtils.getRealByte(bb.get());
            this.macEth = CommUtils.getString(bb, stringSize);
            this.macWifiIsAble = bb.get();
            stringSize = CommUtils.getRealByte(bb.get());
            this.macWifi = CommUtils.getString(bb, stringSize);
            dataBuffer.clear();
        }
        catch (BufferUnderflowException ex) {
            Log.warning("Problema de protocolo no comando #fullmacaddr", new Object[0]);
        }
    }

    public String getMacEth() {
        return this.macEth;
    }

    public byte getMacEthIsAble() {
        return this.macEthIsAble;
    }

    public String getMacWifi() {
        return this.macWifi;
    }

    public byte getMacWifiIsAble() {
        return this.macWifiIsAble;
    }

    @Override
    protected byte[] getSerializedPayload() {
        return null;
    }
}

