/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501.commands;

import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.event.comm.ConnectionChannel;
import br.org.reconcavo.event.comm.DataBuffer;
import br.org.reconcavo.j18n.J18N;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class Gif
implements Command {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final int IMG_MAX_SIZE = 0xFFFFFF;
    private static final int FILE_BUFFER_SIZE = 4096;
    private static final int MAX_NUM_LOOPS = 255;
    private static final int MAX_TIME = 255;
    private final File gifFile;
    private final ExhibitionMode exhibitionMode;
    private final int numLoops;
    private final int time;

    private static String getHex(int i, int bytes) {
        String formatStr = String.format("%%0%dX", bytes * 2);
        return String.format(formatStr, i);
    }

    private static void putString(DataBuffer buffer, String str) {
        try {
            buffer.putString(str, DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public Gif(File gifFile, ExhibitionMode exhibitionMode, int numLoops, int time) {
        if (gifFile == null) {
            throw new IllegalArgumentException("gifFile is null");
        }
        if (exhibitionMode == null) {
            throw new IllegalArgumentException("mode cannot be null");
        }
        if (!gifFile.exists()) {
            throw new IllegalArgumentException("File not found");
        }
        if (gifFile.length() > 0xFFFFFFL) {
            throw new IllegalArgumentException("Image is too big");
        }
        if (numLoops < 0 || numLoops > 255) {
            throw new IllegalArgumentException("Invalid numLoops: " + numLoops);
        }
        if (time < 0 || time > 255) {
            throw new IllegalArgumentException("Invalid time: " + time);
        }
        this.gifFile = gifFile;
        this.exhibitionMode = exhibitionMode;
        this.numLoops = numLoops;
        this.time = time;
    }

    public final File getGifFile() {
        return this.gifFile;
    }

    public final ExhibitionMode getExhibitionMode() {
        return this.exhibitionMode;
    }

    public int getNumLoops() {
        return this.numLoops;
    }

    public int getTime() {
        return this.time;
    }

    @Override
    public final void write(ConnectionChannel channel) throws IOException {
        byte[] imageSize = String.format("%06X", this.getGifFile().length()).getBytes();
        byte[] time = String.format("%02X", this.getTime()).getBytes();
        DataBuffer headerBuffer = new DataBuffer();
        Gif.putString(headerBuffer, "#gif");
        Gif.putString(headerBuffer, Gif.getHex(this.getExhibitionMode().getHeaderValue(), 1));
        Gif.putString(headerBuffer, Gif.getHex(this.getNumLoops(), 1));
        headerBuffer.put(time[0]);
        headerBuffer.put(time[1]);
        headerBuffer.put(imageSize[0]);
        headerBuffer.put(imageSize[1]);
        headerBuffer.put(imageSize[2]);
        headerBuffer.put(imageSize[3]);
        headerBuffer.put(imageSize[4]);
        headerBuffer.put(imageSize[5]);
        headerBuffer.put((byte)48);
        headerBuffer.put((byte)48);
        headerBuffer.put((byte)48);
        headerBuffer.put((byte)48);
        headerBuffer.put((byte)23);
        channel.write(headerBuffer.readBytes());
        byte[] buffer = new byte[4096];
        try (FileInputStream fis = new FileInputStream(this.getGifFile());){
            int read;
            while ((read = fis.read(buffer)) != -1) {
                if (read == 4096) {
                    channel.write(buffer);
                    continue;
                }
                DataBuffer tmpBuffer = new DataBuffer();
                tmpBuffer.put(buffer, 0, read);
                channel.write(tmpBuffer.readBytes());
            }
        }
    }

    public String toString() {
        return String.format("%s {file: %s, mode: %s, numLoops: %s, time: %s}", "#gif", this.getGifFile().getName(), Gif.getHex(this.getExhibitionMode().getHeaderValue(), 1), Gif.getHex(this.getNumLoops(), 1), Gif.getHex(this.getTime(), 1));
    }

    public static enum ExhibitionMode {
        IMMEDIATELY(0),
        LOOP(1),
        QUERY(254),
        RESET(255);

        private final int headerVal;

        private ExhibitionMode(int headerVal) {
            this.headerVal = headerVal;
        }

        public int getHeaderValue() {
            return this.headerVal;
        }

        public int getHeaderFromString(String exhibitionModeName) {
            switch (J18N.tr(exhibitionModeName, new Object[0])) {
                case "IMMEDIATELY": {
                    return IMMEDIATELY.getHeaderValue();
                }
                case "LOOP": {
                    return LOOP.getHeaderValue();
                }
                case "QUERY": {
                    return QUERY.getHeaderValue();
                }
                case "RESET": {
                    return RESET.getHeaderValue();
                }
            }
            return -1;
        }
    }
}

