/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501.commands;

import br.com.gertec.tc.server.protocol.sc501.commands.AbstractSc501Command;
import br.org.reconcavo.event.comm.ByteOrder;
import br.org.reconcavo.event.comm.DataBuffer;

public class GifError
extends AbstractSc501Command {
    private static final long serialVersionUID = 1L;
    private final Short status;

    public GifError(Short status) {
        super("#gif_error");
        this.status = status;
    }

    public GifError(DataBuffer buffer) {
        super("#gif_error");
        byte b1 = buffer.readByte();
        if (b1 == 0) {
            this.status = null;
        } else {
            byte b2 = buffer.readByte();
            buffer.readByte();
            DataBuffer tmpBuffer = new DataBuffer();
            tmpBuffer.put(b1).put(b2);
            this.status = tmpBuffer.readShort(ByteOrder.LITTLE_ENDIAN);
        }
    }

    public final Short getStatus() {
        return this.status;
    }

    @Override
    protected byte[] getSerializedPayload() {
        DataBuffer buffer = new DataBuffer();
        if (this.status == null) {
            buffer.put((byte)0);
        } else {
            buffer.putShort(this.getStatus());
            buffer.put((byte)0);
        }
        return buffer.readBytes();
    }

    @Override
    public String toString() {
        return String.format("%s {status: %02X}", super.toString(), this.getStatus() != null ? this.getStatus() : (short)0);
    }
}

