/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.protocol.sc501.commands;

import br.org.reconcavo.event.comm.Command;
import br.org.reconcavo.event.comm.ConnectionChannel;
import br.org.reconcavo.event.comm.DataBuffer;
import br.org.reconcavo.j18n.J18N;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Img
implements Command {
    private static final long serialVersionUID = 1L;
    private static final int IMG_MAX_SIZE = 0xFFFFFF;
    private static final int MAX_NUM_LOOPS = 255;
    private static final int MAX_TIME = 255;
    private File gifFile = null;
    private ExhibitionModeImg exhibitionMode = null;
    private int numLoops;
    private int time = 0;
    boolean resetImg = false;

    private static String getHex(int i, int bytes) {
        String formatStr = String.format("%%0%dX", bytes * 2);
        return String.format(formatStr, i);
    }

    public Img(File gifFile, ExhibitionModeImg exhibitionMode, int numLoops, int time) {
        this.exhibitionMode = null;
        this.numLoops = 0;
        this.numLoops = 0;
        this.numLoops = 0;
        this.exhibitionMode = null;
        this.time = 0;
        this.exhibitionMode = null;
        if (gifFile == null) {
            throw new IllegalArgumentException("gifFile is null");
        }
        if (exhibitionMode == null) {
            throw new IllegalArgumentException("mode cannot be null");
        }
        if (!gifFile.exists()) {
            throw new IllegalArgumentException("File not found");
        }
        if (gifFile.length() > 0xFFFFFFL) {
            throw new IllegalArgumentException("Image is too big");
        }
        if (numLoops < 0 || numLoops > 255) {
            throw new IllegalArgumentException("Invalid numLoops: " + numLoops);
        }
        if (time < 0 || time > 255) {
            throw new IllegalArgumentException("Invalid time: " + time);
        }
        this.gifFile = gifFile;
        this.exhibitionMode = exhibitionMode;
        this.numLoops = numLoops;
        this.time = time;
        this.resetImg = false;
    }

    public Img(ExhibitionModeImg exhibitionMode) {
        this.numLoops = 0;
        this.resetImg = true;
    }

    public final File getGifFile() {
        return this.gifFile;
    }

    public final ExhibitionModeImg getExhibitionMode() {
        return this.exhibitionMode;
    }

    public int getNumLoops() {
        return this.numLoops;
    }

    public int getTime() {
        return this.time;
    }

    @Override
    public final void write(ConnectionChannel channel) throws IOException {
        int zeroByte = 48;
        File file = this.getGifFile();
        byte[] imageSize = String.format("%04X", file.length()).getBytes();
        DataBuffer dbf = new DataBuffer();
        dbf.putString("#img");
        dbf.put((byte)zeroByte);
        dbf.put(this.getModeImg());
        dbf.put((byte)zeroByte);
        dbf.put((byte)this.getNumLoops());
        dbf.put((byte)zeroByte);
        dbf.put((byte)(this.getTime() + 48));
        dbf.put((byte)zeroByte);
        dbf.put((byte)49);
        dbf.put(imageSize[3]);
        dbf.put(imageSize[2]);
        dbf.put(imageSize[1]);
        dbf.put(imageSize[0]);
        dbf.put((byte)zeroByte);
        dbf.put((byte)zeroByte);
        dbf.put((byte)zeroByte);
        dbf.put((byte)zeroByte);
        dbf.put((byte)23);
        channel.write(dbf.readBytes());
        BufferedImage originalImage = ImageIO.read(file);
        byte[] imageBytes = ((DataBufferByte)originalImage.getData().getDataBuffer()).getData();
        channel.write(imageBytes);
    }

    public String toString() {
        return String.format("%s {file: %s, mode: %s, numLoops: %s, time: %s, frames: %s, fileSize: %s}", "#img", this.getGifFile().getName(), Img.getHex(this.getExhibitionMode().getHeaderValue(), 1), Img.getHex(this.getNumLoops(), 1), Img.getHex(this.getTime(), 1), Img.getHex(1, 1), Img.getHex((int)this.getGifFile().length(), 1));
    }

    public ExhibitionModeImg getModeImg(int select) {
        switch (select) {
            case 0: {
                return ExhibitionModeImg.IMMEDIATELY;
            }
            case 1: {
                return ExhibitionModeImg.LOOP;
            }
            case 2: {
                return ExhibitionModeImg.RESET;
            }
        }
        return ExhibitionModeImg.IMMEDIATELY;
    }

    public byte getModeImg() {
        return (byte)this.exhibitionMode.getHeaderValue();
    }

    public static byte[] getBytes(File file) {
        int len = (int)file.length();
        byte[] sendBuf = new byte[len];
        FileInputStream inFile = null;
        try {
            inFile = new FileInputStream(file);
            inFile.read(sendBuf, 0, len);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sendBuf;
    }

    public static enum ExhibitionModeImg {
        IMMEDIATELY(48),
        LOOP(49),
        RESET(255);

        private final int headerVal;

        private ExhibitionModeImg(int headerVal) {
            this.headerVal = headerVal;
        }

        public int getHeaderValue() {
            return this.headerVal;
        }

        public int getHeaderFromString(String exhibitionModeName) {
            switch (J18N.tr(exhibitionModeName, new Object[0])) {
                case "IMMEDIATELY": {
                    return IMMEDIATELY.getHeaderValue();
                }
                case "LOOP": {
                    return LOOP.getHeaderValue();
                }
                case "RESET": {
                    return RESET.getHeaderValue();
                }
            }
            return IMMEDIATELY.getHeaderValue();
        }
    }
}

